/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.timer;

import rice.environment.Environment;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.tutorial.lesson3.MyMsg;

public class MyApp
implements Application {
    CancellableTask messageToSelfTask;
    protected Endpoint endpoint;
    protected Environment environment;

    public MyApp(Node node) {
        this.environment = node.getEnvironment();
        this.endpoint = node.buildEndpoint(this, "myinstance");
        this.endpoint.register();
        this.messageToSelfTask = this.endpoint.scheduleMessage(new MessageToSelf(), 3000L, 5000L);
    }

    public void cancelTask() {
        this.messageToSelfTask.cancel();
    }

    public void routeMyMsg(Id id) {
        System.out.println(this + " sending to " + id);
        MyMsg msg = new MyMsg(this.endpoint.getId(), id);
        this.endpoint.route(id, msg, null);
    }

    public void routeMyMsgDirect(NodeHandle nh) {
        System.out.println(this + " sending direct to " + nh);
        MyMsg msg = new MyMsg(this.endpoint.getId(), nh.getId());
        this.endpoint.route(null, msg, nh);
    }

    public void deliver(Id id, Message message) {
        System.out.println(this + " received " + message);
        if (message instanceof MessageToSelf) {
            System.out.println("I got the MessageToSelf at time:" + this.environment.getTimeSource().currentTimeMillis());
        }
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public String toString() {
        return "MyApp " + this.endpoint.getId();
    }

    class MessageToSelf
    implements Message {
        MessageToSelf() {
        }

        public int getPriority() {
            return -15;
        }
    }
}

