/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.sendfile;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.mpisws.p2p.filetransfer.BBReceipt;
import org.mpisws.p2p.filetransfer.FileReceipt;
import org.mpisws.p2p.filetransfer.FileTransfer;
import org.mpisws.p2p.filetransfer.FileTransferCallback;
import org.mpisws.p2p.filetransfer.FileTransferImpl;
import org.mpisws.p2p.filetransfer.FileTransferListener;
import org.mpisws.p2p.filetransfer.Receipt;
import rice.Continuation;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

public class MyApp
implements Application {
    protected Endpoint endpoint;
    protected Node node;
    protected FileTransfer fileTransfer;

    public MyApp(Node node, IdFactory factory) {
        this.endpoint = node.buildEndpoint(this, "myinstance");
        this.node = node;
        this.endpoint.accept(new AppSocketReceiver(){

            public void receiveSocket(AppSocket socket) {
                MyApp.this.fileTransfer = new FileTransferImpl(socket, new FileTransferCallback(){

                    public void messageReceived(ByteBuffer bb) {
                        System.out.println("Message received: " + bb);
                    }

                    public void fileReceived(File f, ByteBuffer metadata) {
                        try {
                            String originalFileName = new SimpleInputBuffer(metadata).readUTF();
                            File dest = new File("delme2.txt");
                            System.out.println("Moving " + f + " to " + dest + " original:" + originalFileName);
                            System.out.println(f.renameTo(dest));
                        }
                        catch (IOException ioe) {
                            System.out.println("Error deserializing file name. " + ioe);
                        }
                    }

                    public void receiveException(Exception ioe) {
                        System.out.println("FTC.receiveException() " + ioe);
                    }
                }, MyApp.this.node.getEnvironment());
                MyApp.this.fileTransfer.addListener(new MyFileListener());
                MyApp.this.endpoint.accept(this);
            }

            public void receiveSelectResult(AppSocket socket, boolean canRead, boolean canWrite) {
                throw new RuntimeException("Shouldn't be called.");
            }

            public void receiveException(AppSocket socket, Exception e) {
                e.printStackTrace();
            }
        });
        this.endpoint.register();
    }

    public Node getNode() {
        return this.node;
    }

    public void sendMyMsgDirect(NodeHandle nh) {
        System.out.println(this + " opening to " + nh);
        this.endpoint.connect(nh, new AppSocketReceiver(){

            public void receiveSocket(AppSocket socket) {
                FileTransferImpl sender = new FileTransferImpl(socket, null, MyApp.this.node.getEnvironment());
                sender.addListener(new MyFileListener());
                ByteBuffer sendMe = ByteBuffer.allocate(4);
                sendMe.put((byte)1);
                sendMe.put((byte)2);
                sendMe.put((byte)3);
                sendMe.put((byte)4);
                sendMe.flip();
                System.out.println("Sending " + sendMe);
                sender.sendMsg(sendMe, (byte)1, null);
                try {
                    final File f = new File("delme.txt");
                    if (!f.exists()) {
                        System.err.println("File " + f + " does not exist.  Please create a file called " + f + " and run the tutorial again.");
                        System.exit(1);
                    }
                    SimpleOutputBuffer sob = new SimpleOutputBuffer();
                    sob.writeUTF(f.getName());
                    sender.sendFile(f, sob.getByteBuffer(), (byte)2, new Continuation<FileReceipt, Exception>(){

                        @Override
                        public void receiveException(Exception exception) {
                            System.out.println("Error sending: " + f + " " + exception);
                        }

                        @Override
                        public void receiveResult(FileReceipt result) {
                            System.out.println("Send complete: " + result);
                        }
                    });
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }

            public void receiveException(AppSocket socket, Exception e) {
                e.printStackTrace();
            }

            public void receiveSelectResult(AppSocket socket, boolean canRead, boolean canWrite) {
                throw new RuntimeException("Shouldn't be called.");
            }
        }, 30000);
    }

    public void deliver(Id id, Message message) {
        System.out.println(this + " received " + message);
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public String toString() {
        return "MyApp " + this.endpoint.getId();
    }

    class MyFileListener
    implements FileTransferListener {
        MyFileListener() {
        }

        public void fileTransferred(FileReceipt receipt, long bytesTransferred, long total, boolean incoming) {
            String s = incoming ? " Downloaded " : " Uploaded ";
            double percent = 100.0 * (double)bytesTransferred / (double)total;
            System.out.println(MyApp.this + s + percent + "% of " + receipt);
        }

        public void msgTransferred(BBReceipt receipt, int bytesTransferred, int total, boolean incoming) {
            String s = incoming ? " Downloaded " : " Uploaded ";
            double percent = 100.0 * (double)bytesTransferred / (double)total;
            System.out.println(MyApp.this + s + percent + "% of " + receipt);
        }

        public void transferCancelled(Receipt receipt, boolean incoming) {
            String s = incoming ? "download" : "upload";
            System.out.println(MyApp.this + ": Cancelled " + s + " of " + receipt);
        }

        public void transferFailed(Receipt receipt, boolean incoming) {
            String s = incoming ? "download" : "upload";
            System.out.println(MyApp.this + ": Transfer Failed " + s + " of " + receipt);
        }
    }
}

