/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.remotesocket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Vector;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.socket.appsocket.AppSocketPastryNodeFactory;
import rice.pastry.socket.appsocket.SocketFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.standard.StandardAddress;
import rice.tutorial.remotesocket.MyApp;

public class Tutorial {
    Vector apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tutorial(int bindport, InetSocketAddress bootaddress, int numNodes, Environment env, boolean useDirect) throws Exception {
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        AppSocketPastryNodeFactory factory = new AppSocketPastryNodeFactory(nidFactory, bindport, env);
        PastryIdFactory idFactory = new PastryIdFactory(env);
        NodeHandle bootHandle = null;
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            PastryNode node = factory.newNode(bootHandle);
            if (bootHandle == null) {
                bootHandle = useDirect ? node.getLocalHandle() : factory.getNodeHandle(bootaddress);
            }
            PastryNode pastryNode = node;
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node " + node);
            MyApp app = new MyApp(node, idFactory);
            this.apps.add(app);
        }
        env.getTimeSource().sleep(1000L);
        SocketFactory sFactory = factory.getSocketFactory();
        sFactory.getAppSocket(bootaddress, StandardAddress.getAddress(MyApp.class, "myinstance", env), new Continuation<AppSocket, Exception>(){

            @Override
            public void receiveResult(AppSocket result) {
                System.out.println("Opened AppSocket " + result);
                final ByteBuffer out = ByteBuffer.wrap(Id.build().toByteArray());
                result.register(false, true, -1, new AppSocketReceiver(){

                    public void receiveSelectResult(AppSocket socket, boolean canRead, boolean canWrite) {
                        try {
                            long ret = socket.write(out);
                            System.out.println("Wrote " + ret + " bytes.");
                            if (out.hasRemaining()) {
                                socket.register(false, true, 30000, this);
                            } else {
                                socket.shutdownOutput();
                                out.clear();
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }

                    public void receiveException(AppSocket socket, Exception e) {
                        e.printStackTrace();
                    }

                    public void receiveSocket(AppSocket socket) {
                        throw new RuntimeException("Should never be called.");
                    }
                });
            }

            @Override
            public void receiveException(Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Not implemented. ");
            }
        }, null);
    }

    public static void main(String[] args) throws Exception {
        try {
            Environment env;
            boolean useDirect = args[0].equalsIgnoreCase("-direct");
            if (useDirect) {
                env = Environment.directEnvironment();
            } else {
                env = new Environment();
                env.getParameters().setString("nat_search_policy", "never");
            }
            int bindport = 0;
            InetSocketAddress bootaddress = null;
            int numNodes = Integer.parseInt(args[args.length - 1]);
            if (!useDirect) {
                bindport = Integer.parseInt(args[0]);
                InetAddress bootaddr = InetAddress.getByName(args[1]);
                int bootport = Integer.parseInt(args[2]);
                bootaddress = new InetSocketAddress(bootaddr, bootport);
            }
            Tutorial dt = new Tutorial(bindport, bootaddress, numNodes, env, useDirect);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.appsocket.Tutorial localbindport bootIP bootPort numNodes");
            System.out.println("  or");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.appsocket.Tutorial -direct numNodes");
            System.out.println();
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001 10");
            System.out.println("example java rice.tutorial.DistTutorial -direct 10");
            throw e;
        }
    }
}

