/*
 * Decompiled with CFR 0.152.
 */
package rice.selector.testing;

import java.io.IOException;
import rice.environment.Environment;
import rice.selector.SelectorManager;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class SelectorTest {
    public static boolean logAll = true;
    public static boolean logIssues = true;
    public static Environment environment;

    public static void main(String[] args) throws IOException {
        environment = new Environment();
        System.out.println("hello world <selector test>");
        SelectorManager sman = environment.getSelectorManager();
        Timer timer = sman.getTimer();
        SelectorTest.scheduleRepeated(timer, sman);
        for (int i = 0; i < 10; ++i) {
            SelectorTest.scheduleStuff(timer, sman);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public static void scheduleRepeated(Timer timer, SelectorManager sman) {
        final long t1Start = environment.getTimeSource().currentTimeMillis();
        int t1Delay = 3000;
        timer.schedule(new TimerTask(){
            long lastTime;
            {
                this.lastTime = t1Start;
            }

            public void run() {
                long curTime = environment.getTimeSource().currentTimeMillis();
                long delay = curTime - this.lastTime;
                this.lastTime = curTime;
                if (logAll || delay - 3000L > 100L) {
                    System.out.println("Scheduled many times for delay 3000 actual delay " + delay);
                }
            }
        }, 3000L, 3000L);
    }

    public static void scheduleStuff(Timer timer, SelectorManager sman) {
        final long t1Start = environment.getTimeSource().currentTimeMillis();
        int t1Delay = 5000;
        timer.schedule(new TimerTask(){

            public void run() {
                long curTime = environment.getTimeSource().currentTimeMillis();
                if (logAll || logIssues && (curTime -= t1Start) - 5000L > 100L) {
                    System.out.println("Scheduled once for delay 5000 actual delay " + curTime);
                }
            }
        }, 5000L);
        final long i1Start = environment.getTimeSource().currentTimeMillis();
        sman.invoke(new Runnable(){

            public void run() {
                long curTime = environment.getTimeSource().currentTimeMillis();
                if (logAll || logIssues && (curTime -= i1Start) > 100L) {
                    System.out.println("invoked after " + curTime + " millis.");
                }
            }
        });
    }
}

