/*
 * Decompiled with CFR 0.152.
 */
package rice.selector;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import rice.Destructable;
import rice.environment.Environment;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.environment.time.TimeSource;
import rice.selector.LoopObserver;
import rice.selector.SelectionKeyHandler;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class SelectorManager
extends Thread
implements Timer,
Destructable {
    public static int TIMEOUT = 500;
    protected Selector selector;
    protected LinkedList<Runnable> invocations;
    protected HashSet<SelectionKey> modifyKeys;
    protected HashSet<SelectionKey> cancelledKeys;
    protected Queue<TimerTask> timerQueue = new PriorityQueue<TimerTask>();
    protected long wakeupTime = 0L;
    protected TimeSource timeSource;
    long lastTime = 0L;
    protected Logger logger;
    protected String instance;
    protected boolean running = true;
    protected boolean select = true;
    protected RandomSource random;
    protected Environment environment;
    protected boolean useLoopListeners = true;
    ArrayList<LoopObserver> loopObservers = new ArrayList();
    protected Object seqLock = new Object();
    protected int seqCtr = Integer.MIN_VALUE;

    public SelectorManager(String instance, TimeSource timeSource, LogManager log, RandomSource random) {
        super(instance == null ? "Selector Thread" : "Selector Thread -- " + instance);
        this.random = random;
        this.instance = instance;
        this.logger = log.getLogger(this.getClass(), instance);
        this.invocations = new LinkedList();
        this.modifyKeys = new HashSet();
        this.cancelledKeys = new HashSet();
        this.timeSource = timeSource;
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            System.out.println("SEVERE ERROR (SelectorManager): Error creating selector " + e);
        }
        this.lastTime = timeSource.currentTimeMillis();
    }

    public SelectorManager(String instance, TimeSource timeSource, LogManager log) {
        this(instance, timeSource, log, new SimpleRandomSource(log));
    }

    public void setEnvironment(Environment env) {
        if (env == null) {
            throw new IllegalArgumentException("env is null!");
        }
        if (this.environment != null) {
            return;
        }
        this.environment = env;
        this.environment.addDestructable(this);
        this.start();
    }

    public void cancel(SelectionKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.cancelledKeys.add(key);
    }

    public SelectionKey getKey(SelectableChannel channel) {
        return channel.keyFor(this.selector);
    }

    public SelectionKey register(SelectableChannel channel, SelectionKeyHandler handler, int ops) throws IOException {
        if (channel == null || handler == null) {
            throw new NullPointerException();
        }
        SelectionKey key = channel.register(this.selector, ops, handler);
        if (this.cancelledKeys != null) {
            this.cancelledKeys.remove(key);
        }
        return key;
    }

    public synchronized void invoke(Runnable d) {
        if (d == null) {
            throw new NullPointerException();
        }
        if (this.invocations == null) {
            return;
        }
        this.invocations.add(d);
        this.wakeup();
    }

    public int getNumInvocations() {
        return this.invocations.size();
    }

    public synchronized void modifyKey(SelectionKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.modifyKeys.add(key);
        this.wakeup();
    }

    protected void onLoop() {
    }

    public void run() {
        block12: {
            if (this.logger.level <= 800) {
                this.logger.log("SelectorManager -- " + this.instance + " starting...");
            }
            this.lastTime = this.timeSource.currentTimeMillis();
            while (this.running) {
                try {
                    if (this.useLoopListeners) {
                        this.notifyLoopListeners();
                    }
                    Thread.yield();
                    this.executeDueTasks();
                    this.onLoop();
                    this.doInvocations();
                    if (!this.select) continue;
                    this.doSelections();
                    int selectTime = TIMEOUT;
                    if (this.timerQueue.size() > 0) {
                        TimerTask first = this.timerQueue.peek();
                        selectTime = (int)(first.scheduledExecutionTime() - this.timeSource.currentTimeMillis());
                    }
                    this.select(selectTime);
                    if (this.cancelledKeys.size() <= 0) continue;
                    Iterator<SelectionKey> i = this.cancelledKeys.iterator();
                    while (i.hasNext()) {
                        i.next().cancel();
                    }
                    this.cancelledKeys.clear();
                    this.selector.selectNow();
                }
                catch (Throwable t) {
                    if (this.logger.level <= 1000) {
                        this.logger.logException("ERROR (SelectorManager.run): ", t);
                    }
                    this.environment.getExceptionStrategy().handleException(this, t);
                }
            }
            this.invocations.clear();
            this.loopObservers.clear();
            this.cancelledKeys.clear();
            this.timerQueue.clear();
            this.invocations = null;
            this.loopObservers = null;
            this.cancelledKeys = null;
            this.timerQueue = null;
            try {
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block12;
                this.logger.logException("Error cancelling selector:", ioe);
            }
        }
        if (this.logger.level <= 800) {
            this.logger.log("Selector " + this.instance + " shutting down.");
        }
    }

    public void destroy() {
        if (this.logger.level <= 500) {
            this.logger.logException("destroying SelectorManager", new Exception("Stack Trace"));
        } else if (this.logger.level <= 800) {
            this.logger.log("destroying SelectorManager");
        }
        this.running = false;
    }

    public void useLoopListeners(boolean val) {
        this.useLoopListeners = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLoopListeners() {
        long now = this.timeSource.currentTimeMillis();
        long diff = now - this.lastTime;
        ArrayList<LoopObserver> arrayList = this.loopObservers;
        synchronized (arrayList) {
            for (LoopObserver lo : this.loopObservers) {
                if ((long)lo.delayInterest() > diff) continue;
                lo.loopTime((int)diff);
            }
        }
        this.lastTime = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoopObserver(LoopObserver lo) {
        ArrayList<LoopObserver> arrayList = this.loopObservers;
        synchronized (arrayList) {
            this.loopObservers.add(lo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoopObserver(LoopObserver lo) {
        ArrayList<LoopObserver> arrayList = this.loopObservers;
        synchronized (arrayList) {
            this.loopObservers.remove(lo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSelections() throws IOException {
        SelectionKey[] keys = this.selectedKeys();
        if (keys.length > 1000 && this.logger.level <= 500) {
            this.logger.log("lots of selection keys!");
            HashMap<String, Integer> histo = new HashMap<String, Integer>();
            for (int i = 0; i < keys.length; ++i) {
                String keyclass = keys[i].getClass().getName();
                if (histo.containsKey(keyclass)) {
                    histo.put(keyclass, new Integer((Integer)histo.get(keyclass) + 1));
                    continue;
                }
                histo.put(keyclass, new Integer(1));
            }
            this.logger.log("begin selection keys by class");
            for (String name : histo.keySet()) {
                this.logger.log("Selection Key: " + name + ": " + histo.get(name));
            }
            this.logger.log("end selection keys by class");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.selector.selectedKeys().remove(keys[i]);
            SelectionKey selectionKey = keys[i];
            synchronized (selectionKey) {
                SelectionKeyHandler skh = (SelectionKeyHandler)keys[i].attachment();
                if (skh != null) {
                    if (keys[i].isValid() && keys[i].isAcceptable()) {
                        skh.accept(keys[i]);
                    }
                    if (keys[i].isValid() && keys[i].isConnectable()) {
                        skh.connect(keys[i]);
                    }
                    if (keys[i].isValid() && keys[i].isReadable()) {
                        skh.read(keys[i]);
                    }
                    if (keys[i].isValid() && keys[i].isWritable()) {
                        skh.write(keys[i]);
                    }
                } else {
                    keys[i].channel().close();
                    keys[i].cancel();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvocations() {
        Iterator<SelectionKey> i2;
        Iterator<Runnable> i;
        if (this.logger.level <= 300) {
            this.logger.log("SM.doInvocations()");
        }
        SelectorManager selectorManager = this;
        synchronized (selectorManager) {
            i = new ArrayList<Runnable>(this.invocations).iterator();
            this.invocations.clear();
        }
        while (i.hasNext()) {
            Runnable run = i.next();
            try {
                run.run();
            }
            catch (RuntimeException e) {
                SelectorManager selectorManager2 = this;
                synchronized (selectorManager2) {
                    int ctr = 0;
                    while (i.hasNext()) {
                        this.invocations.add(ctr, i.next());
                        ++ctr;
                    }
                }
                throw e;
            }
        }
        SelectorManager e = this;
        synchronized (e) {
            i2 = new ArrayList<SelectionKey>(this.modifyKeys).iterator();
            this.modifyKeys.clear();
        }
        while (i2.hasNext()) {
            SelectionKey key = i2.next();
            if (!key.isValid() || key.attachment() == null) continue;
            ((SelectionKeyHandler)key.attachment()).modifyKey(key);
        }
    }

    protected synchronized Runnable getInvocation() {
        if (this.invocations.size() > 0) {
            return this.invocations.removeFirst();
        }
        return null;
    }

    protected synchronized SelectionKey getModifyKey() {
        if (this.modifyKeys.size() > 0) {
            SelectionKey result = this.modifyKeys.iterator().next();
            this.modifyKeys.remove(result);
            return result;
        }
        return null;
    }

    protected int select(int time) throws IOException {
        if (this.logger.level <= 300) {
            this.logger.log("SM.select(" + time + ")");
        }
        if (time > TIMEOUT) {
            time = TIMEOUT;
        }
        try {
            if (time <= 0 || this.invocations.size() > 0 || this.modifyKeys.size() > 0) {
                return this.selector.selectNow();
            }
            this.wakeupTime = this.timeSource.currentTimeMillis() + (long)time;
            return this.selector.select(time);
        }
        catch (CancelledKeyException cce) {
            if (this.logger.level <= 900) {
                this.logger.logException("CCE: cause:", cce.getCause());
            }
            throw cce;
        }
        catch (IOException e) {
            if (e.getMessage().indexOf("Interrupted system call") >= 0) {
                if (this.logger.level <= 900) {
                    this.logger.log("Got interrupted system call, continuing anyway...");
                }
                return 1;
            }
            throw e;
        }
    }

    protected SelectionKey[] selectedKeys() throws IOException {
        Set<SelectionKey> s = this.selector.selectedKeys();
        SelectionKey[] k = s.toArray(new SelectionKey[0]);
        for (int c = 0; c < k.length; ++c) {
            SelectionKey temp = k[c];
            int swapIndex = this.random.nextInt(k.length);
            k[c] = k[swapIndex];
            k[swapIndex] = temp;
        }
        return k;
    }

    public boolean isSelectorThread() {
        return Thread.currentThread() == this;
    }

    public TimerTask schedule(TimerTask task) {
        this.addTask(task);
        return task;
    }

    public TimerTask schedule(TimerTask task, long delay) {
        task.setNextExecutionTime(this.timeSource.currentTimeMillis() + delay);
        this.addTask(task);
        return task;
    }

    public TimerTask schedule(TimerTask task, long delay, long period) {
        task.setNextExecutionTime(this.timeSource.currentTimeMillis() + delay);
        task.period = (int)period;
        this.addTask(task);
        return task;
    }

    public TimerTask scheduleAtFixedRate(TimerTask task, long delay, long period) {
        task.setNextExecutionTime(this.timeSource.currentTimeMillis() + delay);
        task.period = (int)period;
        task.fixedRate = true;
        this.addTask(task);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addTask(TimerTask task) {
        Object object = this.seqLock;
        synchronized (object) {
            task.seq = this.seqCtr++;
        }
        if (this.logger.level <= 400) {
            this.logger.log("addTask(" + task + ") scheduled for " + task.scheduledExecutionTime());
        }
        if (!this.timerQueue.add(task)) {
            if (this.logger.level <= 900) {
                this.logger.log("ERROR: Got false while enqueueing task " + task + "!");
            }
            Thread.dumpStack();
        } else {
            task.setSelectorManager(this);
        }
        if (this.select) {
            if (this.wakeupTime >= task.scheduledExecutionTime()) {
                this.wakeup();
            }
        } else if (task.scheduledExecutionTime() == this.getNextTaskExecutionTime()) {
            this.wakeup();
        }
    }

    public synchronized void removeTask(TimerTask task) {
        if (this.logger.level <= 400) {
            this.logger.log("removeTask(" + task + ") scheduled for " + task.scheduledExecutionTime());
        }
        this.timerQueue.remove(task);
    }

    public void wakeup() {
        this.selector.wakeup();
        this.notifyAll();
    }

    public long getNextTaskExecutionTime() {
        if (this.timerQueue.size() > 0) {
            TimerTask next = this.timerQueue.peek();
            return next.scheduledExecutionTime();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDueTasks() {
        TimerTask next;
        long now = this.timeSource.currentTimeMillis();
        if (this.logger.level <= 300) {
            this.logger.log("SM.executeDueTasks() " + now);
        }
        ArrayList<TimerTask> executeNow = new ArrayList<TimerTask>();
        SelectorManager selectorManager = this;
        synchronized (selectorManager) {
            boolean done = false;
            while (!done) {
                if (this.timerQueue.size() > 0) {
                    next = this.timerQueue.peek();
                    if (next.scheduledExecutionTime() <= now) {
                        executeNow.add(next);
                        this.timerQueue.poll();
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
            }
        }
        ArrayList<TimerTask> addBack = new ArrayList<TimerTask>();
        Iterator i = executeNow.iterator();
        while (i.hasNext()) {
            next = (TimerTask)i.next();
            try {
                if (this.logger.level <= 400) {
                    this.logger.log("executing task " + next);
                }
                if (!this.executeTask(next)) continue;
                addBack.add(next);
            }
            catch (RuntimeException e) {
                while (i.hasNext()) {
                    addBack.add((TimerTask)i.next());
                }
                SelectorManager selectorManager2 = this;
                synchronized (selectorManager2) {
                    for (TimerTask tt : addBack) {
                        this.timerQueue.add(tt);
                    }
                }
                throw e;
            }
        }
        SelectorManager selectorManager3 = this;
        synchronized (selectorManager3) {
            for (TimerTask tt : addBack) {
                this.timerQueue.add(tt);
            }
        }
    }

    protected boolean executeTask(TimerTask next) {
        return next.execute(this.timeSource);
    }

    public Timer getTimer() {
        return this;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelect(boolean b) {
        this.select = b;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setLogLevel(int level) {
        this.logger.level = level;
    }

    public static void main(String[] args) {
        new Environment();
        new Environment();
    }
}

