/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing.rendezvous;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.networkinfo.ConnectivityResult;
import rice.Continuation;
import rice.environment.Environment;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.socket.nat.connectivityverifiier.ConnectivityVerifierImpl;
import rice.pastry.standard.RandomNodeIdFactory;

public class VerifyConnectivity {
    public static void main(String[] args) throws IOException {
        int bindport = Integer.parseInt(args[0]);
        final int externalPort = Integer.parseInt(args[3]);
        InetAddress bootaddr = InetAddress.getByName(args[1]);
        int bootport = Integer.parseInt(args[2]);
        final InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
        final Environment env = new Environment();
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        final SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        final ConnectivityVerifierImpl verifier = new ConnectivityVerifierImpl(factory);
        verifier.findExternalAddress(factory.getNextInetSocketAddress(), Collections.singleton(bootaddress), new Continuation<InetAddress, IOException>(){

            @Override
            public void receiveResult(final InetAddress result) {
                System.out.println("My external address is " + result);
                Runnable r = new Runnable(){

                    public void run() {
                        InetSocketAddress[] addrs = new InetSocketAddress[]{new InetSocketAddress(result, externalPort), factory.getNextInetSocketAddress()};
                        MultiInetSocketAddress local = new MultiInetSocketAddress(addrs);
                        verifier.verifyConnectivity(local, Collections.singleton(bootaddress), new ConnectivityResult(){

                            @Override
                            public void udpSuccess(InetSocketAddress from, Map<String, Object> options) {
                                System.out.println("UDP works. " + from);
                            }

                            @Override
                            public void tcpSuccess(InetSocketAddress from, Map<String, Object> options) {
                                System.out.println("TCP works. " + from);
                            }

                            @Override
                            public void receiveException(Exception exception) {
                                exception.printStackTrace();
                            }
                        });
                    }
                };
                env.getSelectorManager().invoke(r);
            }

            @Override
            public void receiveException(IOException exception) {
                exception.printStackTrace();
            }
        });
    }
}

