/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import rice.Destructable;
import rice.environment.Environment;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribeImpl;
import rice.p2p.scribe.Topic;
import rice.pastry.Id;
import rice.pastry.JoinFailedException;
import rice.pastry.NodeHandle;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.leafset.LeafSet;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.selector.TimerTask;
import rice.tutorial.direct.MyMsg;

public class RoutingTableTest {
    boolean printLiveness = false;
    boolean printLeafSets = false;
    Vector<PastryNode> nodes = new Vector();
    HashMap apps = new HashMap();
    int timeToFindFaulty = 30000;
    final Environment env;
    int numNodes;
    int meanSessionTime;
    boolean useScribe;
    int msgSendRate;
    int rtMaintTime;
    int tryNum;
    PastryNodeFactory factory;
    IdFactory idFactory;
    NodeIdFactory nidFactory;
    Topic topic;
    int reportRate = 60000;
    int testTime = 36000000;
    public static final boolean logHeavy = false;
    int thePenalty = 0;

    public RoutingTableTest(int numNodes, int meanSessionTime, boolean useScribe, int msgSendRate, int rtMaintTime, int tryNum, Environment env) throws Exception {
        System.out.println("numNodes:" + numNodes + " meanSessionTime:" + meanSessionTime + " scribe:" + useScribe + " msgSendRate:" + msgSendRate + " rtMaint:" + rtMaintTime + " try:" + tryNum);
        this.env = env;
        this.numNodes = numNodes;
        this.meanSessionTime = meanSessionTime;
        this.useScribe = useScribe;
        this.msgSendRate = msgSendRate;
        this.rtMaintTime = rtMaintTime;
        this.tryNum = tryNum;
        this.idFactory = new PastryIdFactory(env);
        this.topic = new Topic(this.idFactory.buildId("test"));
        this.nidFactory = new RandomNodeIdFactory(env);
        env.getParameters().setInt("pastry_direct_gtitm_max_overlay_size", numNodes);
        env.getParameters().setString("pastry_direct_gtitm_matrix_file", "sample_10k");
        this.factory = new DirectPastryNodeFactory(this.nidFactory, new EuclideanNetwork(env), env);
        this.createNodes();
    }

    public void startLoggerTask() {
        this.env.getSelectorManager().getTimer().schedule(new TimerTask(){
            int ctr = 0;

            public void run() {
                RoutingTableTest.this.testRoutingTables(this.ctr++);
            }
        }, this.reportRate, this.reportRate);
        this.env.getSelectorManager().getTimer().schedule(new TimerTask(){

            public void run() {
                RoutingTableTest.this.env.destroy();
            }
        }, this.testTime);
    }

    public void createNodes() throws InterruptedException {
        CreatorTimerTask ctt = new CreatorTimerTask();
        this.env.getSelectorManager().getTimer().schedule(ctt, 1000L, 1000L);
    }

    public void sendSomeMessages() {
        for (MyApp app : this.apps.values()) {
            Id randId = this.nidFactory.generateNodeId();
            app.routeMyMsg(randId);
        }
    }

    public void sendSomeScribeMessages() {
        for (Scribe app : this.apps.values()) {
            app.publish(this.topic, new TestScribeContent(this.topic, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PastryNode createNode() throws InterruptedException, IOException {
        NodeHandle bootHandle = null;
        if (this.nodes.size() > 0) {
            PastryNode bootNode = null;
            while (bootNode == null || !bootNode.isReady()) {
                bootNode = this.nodes.get(this.env.getRandomSource().nextInt(this.nodes.size()));
                bootHandle = bootNode.getLocalHandle();
            }
        }
        final PastryNode node = this.factory.newNode();
        node.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                System.out.println("Observing " + o + " " + arg);
            }
        });
        node.addDestructable(new Destructable(){

            public void destroy() {
                RoutingTableTest.this.nodes.remove(node);
                RoutingTableTest.this.apps.remove(node);
                try {
                    RoutingTableTest.this.createNode();
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
        });
        node.boot(bootHandle);
        if (this.printLiveness) {
            System.out.println("Creating " + node);
        }
        PastryNode pastryNode = node;
        synchronized (pastryNode) {
            if (node.isReady()) {
                this.finishNode(node);
            } else {
                node.addObserver(new Observer(){

                    public void update(Observable o, Object arg) {
                        if (arg instanceof Boolean) {
                            if (!((Boolean)arg).booleanValue()) {
                                return;
                            }
                            node.deleteObserver(this);
                            RoutingTableTest.this.finishNode(node);
                        } else if (arg instanceof JoinFailedException) {
                            node.destroy();
                        }
                    }
                });
            }
        }
        return node;
    }

    public void finishNode(final PastryNode node) {
        this.nodes.add(node);
        if (this.meanSessionTime > 0) {
            this.env.getSelectorManager().getTimer().schedule(new TimerTask(){
                {
                    node.addDestructable(new Destructable(){

                        public void destroy() {
                            this.cancel();
                        }
                    });
                }

                public void run() {
                    if (RoutingTableTest.this.env.getRandomSource().nextInt(RoutingTableTest.this.meanSessionTime * 2) == 0) {
                        if (RoutingTableTest.this.printLiveness) {
                            System.out.println("Destroying " + node);
                        }
                        this.cancel();
                        node.destroy();
                    }
                }
            }, 60000L, 60000L);
        }
        if (this.msgSendRate > 0) {
            if (this.useScribe) {
                ScribeImpl app = new ScribeImpl(node, "test");
                TestScribeClient client = new TestScribeClient(app, this.topic);
                app.subscribe(this.topic, client);
                this.apps.put(node, app);
            } else {
                MyApp app = new MyApp(node);
                this.apps.put(node, app);
            }
            this.env.getSelectorManager().getTimer().schedule(new TimerTask(){

                public void run() {
                    if (RoutingTableTest.this.useScribe) {
                        RoutingTableTest.this.sendSomeScribeMessages();
                    } else {
                        RoutingTableTest.this.sendSomeMessages();
                    }
                }
            }, this.msgSendRate);
        }
        if (this.rtMaintTime > 0) {
            node.scheduleMsg(new InitiateRouteSetMaintenance(), this.rtMaintTime * 1000, this.rtMaintTime * 1000);
        }
        if (this.printLiveness) {
            System.out.println("Finished creating new node(" + this.nodes.size() + ") " + node + " at " + this.env.getTimeSource().currentTimeMillis());
        }
    }

    private void testLeafSets() {
        ArrayList<PastryNode> nds = new ArrayList<PastryNode>(this.nodes);
        Collections.sort(nds, new Comparator(){

            public int compare(Object one, Object two) {
                PastryNode n1 = (PastryNode)one;
                PastryNode n2 = (PastryNode)two;
                return n1.getId().compareTo(n2.getId());
            }
        });
        for (PastryNode n : nds) {
            System.out.println(n.isReady() + " " + n.getLeafSet());
        }
    }

    private void testRoutingTables(int round) {
        int holes;
        double streatch;
        if (this.printLeafSets) {
            this.testLeafSets();
        }
        if (this.numNodes <= 1000) {
            streatch = this.testRoutingTables1();
            holes = this.testRoutingTables2();
        } else {
            streatch = this.testRoutingTables1a();
            holes = this.testRoutingTables2a();
        }
        System.out.println(round + "," + streatch + "," + holes + " numNodes:" + this.nodes.size());
        if (round % 50 == 0) {
            PastryNode pn = this.nodes.get(this.nodes.size() / 2);
            System.out.println(pn.getRoutingTable().printSelf());
            System.out.println(pn.getLeafSet());
            byte[] randomMaterial = new byte[20];
            pn.getEnvironment().getRandomSource().nextBytes(randomMaterial);
            Id key = Id.build(randomMaterial);
            System.out.println("Key " + key.toStringBare());
            Iterator<NodeHandle> i = pn.getRouter().getBestRoutingCandidates(key);
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        }
    }

    private double testRoutingTables1() {
        Iterator<PastryNode> nodeIterator = this.nodes.iterator();
        int ctr = 0;
        double acc = 0.0;
        while (nodeIterator.hasNext()) {
            PastryNode node = nodeIterator.next();
            RoutingTable rt = node.getRoutingTable();
            for (PastryNode that : this.nodes) {
                if (that == node || !that.isReady() || !node.isReady()) continue;
                NodeHandle thatHandle = that.getLocalHandle();
                int latency = this.calcLatency(node, thatHandle);
                int proximity = node.proximity(thatHandle);
                if (proximity == 0) {
                    throw new RuntimeException("proximity zero:" + node + ".proximity(" + thatHandle + ")");
                }
                if (latency < proximity) {
                    latency = proximity;
                }
                double streatch = 1.0 * (double)latency / (1.0 * (double)proximity);
                acc += streatch;
                ++ctr;
            }
        }
        return acc / (double)ctr;
    }

    private double testRoutingTables1a() {
        int ctr = 0;
        double acc = 0.0;
        RandomSource rand = this.env.getRandomSource();
        for (int i = 0; i < 1000000; ++i) {
            PastryNode node = this.nodes.get(rand.nextInt(this.nodes.size()));
            RoutingTable rt = node.getRoutingTable();
            PastryNode that = this.nodes.get(rand.nextInt(this.nodes.size()));
            if (that == node || !that.isReady() || !node.isReady()) continue;
            NodeHandle thatHandle = that.getLocalHandle();
            int latency = this.calcLatency(node, thatHandle);
            int proximity = node.proximity(thatHandle);
            if (proximity == 0) {
                throw new RuntimeException("proximity zero:" + node + ".proximity(" + thatHandle + ")");
            }
            if (latency < proximity) {
                latency = proximity;
            }
            double streatch = 1.0 * (double)latency / (1.0 * (double)proximity);
            acc += streatch;
            ++ctr;
        }
        return acc / (double)ctr;
    }

    private int testRoutingTables2() {
        Iterator<PastryNode> nodeIterator = this.nodes.iterator();
        int curNodeIndex = 0;
        int ctr = 0;
        int[] ctrs = new int[5];
        while (nodeIterator.hasNext()) {
            PastryNode node = nodeIterator.next();
            if (!node.isReady()) continue;
            PastryNode temp = DirectPastryNode.setCurrentNode(node);
            RoutingTable rt = node.getRoutingTable();
            for (PastryNode that : this.nodes) {
                NodeHandle thatHandle;
                int response;
                if (!that.isReady() || (response = rt.test(thatHandle = that.getLocalHandle())) <= 1) continue;
                int n = response;
                ctrs[n] = ctrs[n] + 1;
                ++ctr;
            }
            DirectPastryNode.setCurrentNode(temp);
            ++curNodeIndex;
        }
        return ctr;
    }

    private int testRoutingTables2a() {
        Iterator<PastryNode> nodeIterator = this.nodes.iterator();
        int curNodeIndex = 0;
        int ctr = 0;
        int[] ctrs = new int[5];
        RandomSource rand = this.env.getRandomSource();
        for (int i = 0; i < 1000000; ++i) {
            PastryNode node = this.nodes.get(rand.nextInt(this.nodes.size()));
            if (!node.isReady()) continue;
            PastryNode temp = DirectPastryNode.setCurrentNode(node);
            RoutingTable rt = node.getRoutingTable();
            Iterator<PastryNode> i2 = this.nodes.iterator();
            PastryNode that = this.nodes.get(rand.nextInt(this.nodes.size()));
            if (!that.isReady()) continue;
            NodeHandle thatHandle = that.getLocalHandle();
            int response = rt.test(thatHandle);
            if (response > 1) {
                int n = response;
                ctrs[n] = ctrs[n] + 1;
                ++ctr;
            }
            DirectPastryNode.setCurrentNode(temp);
            ++curNodeIndex;
        }
        return ctr;
    }

    private int calcLatency(PastryNode node, NodeHandle thatHandle) {
        RoutingTable rt = node.getRoutingTable();
        LeafSet ls = node.getLeafSet();
        this.thePenalty = 0;
        NodeHandle next = this.getNextHop(rt, ls, thatHandle, node);
        int penalty = this.thePenalty;
        if (next == thatHandle) {
            return node.proximity(thatHandle);
        }
        DirectNodeHandle dnh = (DirectNodeHandle)next;
        PastryNode nextNode = dnh.getRemote();
        return penalty + node.proximity(next) + this.calcLatency(nextNode, thatHandle);
    }

    private NodeHandle getNextHop(RoutingTable rt, LeafSet ls, NodeHandle thatHandle, PastryNode localNode) {
        Id target = (Id)thatHandle.getId();
        int cwSize = ls.cwSize();
        int ccwSize = ls.ccwSize();
        int lsPos = ls.mostSimilar(target);
        if (lsPos == 0) {
            throw new RuntimeException("can't happen: probably a partition");
        }
        if (lsPos > 0 && (lsPos < cwSize || !ls.get(lsPos).getNodeId().clockwise(target)) || lsPos < 0 && (-lsPos < ccwSize || ls.get(lsPos).getNodeId().clockwise(target))) {
            NodeHandle handle = ls.get(lsPos);
            if (!handle.isAlive()) {
                this.thePenalty += this.timeToFindFaulty;
                LeafSet ls2 = ls.copy();
                ls2.remove(handle);
                return this.getNextHop(rt, ls2, thatHandle, localNode);
            }
            return handle;
        }
        RouteSet rs = rt.getBestEntry(target);
        NodeHandle handle = null;
        NodeHandle notAlive = null;
        if (rs != null && (notAlive = rs.closestNode(10)) != null && notAlive != null && !notAlive.isAlive()) {
            this.thePenalty += localNode.proximity(notAlive) * 4;
        }
        if (rs == null || (handle = rs.closestNode(1)) == null) {
            NodeHandle notAlive2 = null;
            notAlive2 = rt.bestAlternateRoute(10, target);
            if (notAlive2 != notAlive && notAlive2 != null && !notAlive2.isAlive()) {
                this.thePenalty += localNode.proximity(notAlive2) * 4;
            }
            if ((handle = rt.bestAlternateRoute(1, target)) == null) {
                handle = ls.get(lsPos);
                if (!handle.isAlive()) {
                    this.thePenalty += this.timeToFindFaulty;
                    LeafSet ls2 = ls.copy();
                    ls2.remove(handle);
                    return this.getNextHop(rt, ls2, thatHandle, localNode);
                }
            } else {
                Id.Distance altDist = handle.getNodeId().distance(target);
                Id.Distance lsDist = ls.get(lsPos).getNodeId().distance(target);
                if (lsDist.compareTo(altDist) < 0 && !(handle = ls.get(lsPos)).isAlive()) {
                    this.thePenalty += this.timeToFindFaulty;
                    LeafSet ls2 = ls.copy();
                    ls2.remove(handle);
                    return this.getNextHop(rt, ls2, thatHandle, localNode);
                }
            }
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int numNodes = 100;
        int meanSessionTime = 0;
        int useScribeIndex = 1;
        int rtMaintIndex = 0;
        int msgSendRateIndex = 0;
        int numNodesIndex = -1;
        if (args.length > 0) {
            numNodes = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            meanSessionTime = Integer.parseInt(args[1]);
        }
        int[] rtMaintVals = new int[]{0, 60, 15, 1};
        int[] msgSendVals = new int[]{0, 10000, 1000, 100};
        int[] numNodesVals = new int[]{100, 200, 500, 1000, 2000, 5000, 10000};
        for (useScribeIndex = 0; useScribeIndex < 2; ++useScribeIndex) {
            int n = msgSendRateIndex = useScribeIndex == 0 ? 0 : 1;
            while (msgSendRateIndex < 4) {
                for (rtMaintIndex = 0; rtMaintIndex < 4; ++rtMaintIndex) {
                    for (int tries = 0; tries < 10; ++tries) {
                        if (numNodesIndex >= 0) {
                            numNodes = numNodesVals[numNodesIndex];
                        }
                        boolean useScribe = true;
                        if (useScribeIndex == 0) {
                            useScribe = false;
                        }
                        final Object lock = new Object();
                        Environment env = Environment.directEnvironment();
                        env.addDestructable(new Destructable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void destroy() {
                                Object object = lock;
                                synchronized (object) {
                                    lock.notify();
                                }
                            }
                        });
                        RoutingTableTest dt = new RoutingTableTest(numNodes, meanSessionTime, useScribe, msgSendVals[msgSendRateIndex], rtMaintVals[rtMaintIndex], tries, env);
                        Object object = lock;
                        synchronized (object) {
                            lock.wait();
                            continue;
                        }
                    }
                }
                ++msgSendRateIndex;
            }
        }
    }

    class TestScribeClient
    implements ScribeClient {
        protected Scribe scribe;
        protected Topic topic;
        protected boolean acceptAnycast;
        protected boolean subscribeFailed;

        public TestScribeClient(Scribe scribe, Topic topic) {
            this.scribe = scribe;
            this.topic = topic;
            this.acceptAnycast = false;
            this.subscribeFailed = false;
        }

        public void acceptAnycast(boolean value) {
            this.acceptAnycast = value;
        }

        public boolean anycast(Topic topic, ScribeContent content) {
            return this.acceptAnycast;
        }

        public void deliver(Topic topic, ScribeContent content) {
        }

        public void childAdded(Topic topic, rice.p2p.commonapi.NodeHandle child) {
        }

        public void childRemoved(Topic topic, rice.p2p.commonapi.NodeHandle child) {
        }

        public void subscribeFailed(Topic topic) {
            this.subscribeFailed = true;
        }

        public boolean getSubscribeFailed() {
            return this.subscribeFailed;
        }
    }

    public class MyApp
    implements Application {
        protected Endpoint endpoint;
        protected Node node;

        public MyApp(Node node) {
            this.endpoint = node.buildEndpoint(this, "myinstance");
            this.node = node;
            this.endpoint.register();
        }

        public Node getNode() {
            return this.node;
        }

        public void routeMyMsg(rice.p2p.commonapi.Id id) {
            MyMsg msg = new MyMsg(this.endpoint.getId(), id);
            this.endpoint.route(id, msg, null);
        }

        public void routeMyMsgDirect(NodeHandle nh) {
            MyMsg msg = new MyMsg(this.endpoint.getId(), nh.getId());
            this.endpoint.route(null, msg, (rice.p2p.commonapi.NodeHandle)nh);
        }

        public void deliver(rice.p2p.commonapi.Id id, Message message) {
        }

        public void update(rice.p2p.commonapi.NodeHandle handle, boolean joined) {
        }

        public boolean forward(RouteMessage message) {
            return true;
        }

        public String toString() {
            return "MyApp " + this.endpoint.getId();
        }
    }

    protected static class TestScribeContent
    implements ScribeContent {
        protected Topic topic;
        protected int num;

        public TestScribeContent(Topic topic, int num) {
            this.topic = topic;
            this.num = num;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TestScribeContent)) {
                return false;
            }
            return ((TestScribeContent)o).topic.equals(this.topic) && ((TestScribeContent)o).num == this.num;
        }

        public String toString() {
            return "TestScribeContent(" + this.topic + ", " + this.num + ")";
        }
    }

    class CreatorTimerTask
    extends TimerTask {
        int ctr = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                RoutingTableTest.this.createNode();
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
            CreatorTimerTask creatorTimerTask = this;
            synchronized (creatorTimerTask) {
                ++this.ctr;
                if (this.ctr % 100 == 0) {
                    System.out.println("Created " + this.ctr + " nodes.");
                }
                if (this.ctr >= RoutingTableTest.this.numNodes) {
                    RoutingTableTest.this.startLoggerTask();
                    this.cancel();
                }
            }
        }
    }
}

