/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.testing.PingMessage;

public class PingClient
extends PastryAppl {
    private static int pingAddress = PingAddress.getCode();

    public PingClient(PastryNode pn) {
        super(pn);
    }

    public int getAddress() {
        return pingAddress;
    }

    public void sendPing(Id nid) {
        this.routeMsg(nid, new PingMessage(pingAddress, this.getNodeId(), nid), new SendOptions());
    }

    public void sendTrace(Id nid) {
        System.out.println("sending a trace from " + this.getNodeId() + " to " + nid);
        this.routeMsg(nid, new PingMessage(pingAddress, this.getNodeId(), nid), new SendOptions());
    }

    public void messageForAppl(Message msg) {
        System.out.print(msg);
        System.out.println(" received");
    }

    public boolean enrouteMessage(Message msg, Id from, NodeHandle nextHop, SendOptions opt) {
        System.out.print(msg);
        System.out.println(" at " + this.getNodeId());
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
    }

    private static class PingAddress {
        private static int myCode = -1843799809;

        private PingAddress() {
        }

        public static int getCode() {
            return myCode;
        }
    }
}

