/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.SocketCountListener;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.commonapi.CommonAPITransportLayerImpl;
import org.mpisws.p2p.transport.commonapi.IdFactory;
import org.mpisws.p2p.transport.commonapi.OptionsAdder;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.identity.IdentityImpl;
import org.mpisws.p2p.transport.identity.IdentitySerializer;
import org.mpisws.p2p.transport.identity.LowerIdentity;
import org.mpisws.p2p.transport.identity.NodeChangeStrategy;
import org.mpisws.p2p.transport.identity.SanityChecker;
import org.mpisws.p2p.transport.identity.UpperIdentity;
import org.mpisws.p2p.transport.limitsockets.LimitSocketsTransportLayer;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.liveness.LivenessTransportLayerImpl;
import org.mpisws.p2p.transport.liveness.OverrideLiveness;
import org.mpisws.p2p.transport.liveness.Pinger;
import org.mpisws.p2p.transport.multiaddress.MultiInetAddressTransportLayer;
import org.mpisws.p2p.transport.multiaddress.MultiInetAddressTransportLayerImpl;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.multiaddress.SimpleAddressStrategy;
import org.mpisws.p2p.transport.networkinfo.NetworkInfoTransportLayer;
import org.mpisws.p2p.transport.networkinfo.ProbeStrategy;
import org.mpisws.p2p.transport.priority.PriorityTransportLayer;
import org.mpisws.p2p.transport.priority.PriorityTransportLayerImpl;
import org.mpisws.p2p.transport.proximity.MinRTTProximityProvider;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.SourceRouteForwardStrategy;
import org.mpisws.p2p.transport.sourceroute.SourceRouteTransportLayerImpl;
import org.mpisws.p2p.transport.sourceroute.factory.MultiAddressSourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteStrategy;
import org.mpisws.p2p.transport.sourceroute.manager.simple.NextHopStrategy;
import org.mpisws.p2p.transport.sourceroute.manager.simple.SimpleSourceRouteStrategy;
import org.mpisws.p2p.transport.util.OptionsFactory;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import org.mpisws.p2p.transport.wire.magicnumber.MagicNumberTransportLayer;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.processing.Processor;
import rice.environment.processing.simple.SimpleProcessor;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.pastry.Id;
import rice.pastry.JoinFailedException;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeHandleFetcher;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.leafset.LeafSet;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RoutingTable;
import rice.pastry.socket.LivenesSourceRouteForwardStrategy;
import rice.pastry.socket.SPNFIdentitySerializer;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketNodeHandleFactory;
import rice.pastry.socket.TransportLayerNodeHandle;
import rice.pastry.socket.nat.probe.ProbeApp;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.transport.BogusNodeHandle;
import rice.pastry.transport.LeafSetNHStrategy;
import rice.pastry.transport.NodeHandleAdapter;
import rice.pastry.transport.TLDeserializer;
import rice.pastry.transport.TransportPastryNodeFactory;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketPastryNodeFactory
extends TransportPastryNodeFactory {
    public static final String PROXY_ADDRESS = "SocketPastryNodeFactory.proxyAddress";
    public static final String IP_SERVICE = "SocketPastryNodeFactory.ip-service";
    public static final String MULTI_INET_TL = "SocketPastryNodeFactory.milti-inet-tl";
    public static final String PRIORITY_TL = "PriorityTransportLayer.PRIORITY_TL";
    public static final String MULTI_ADDRESS_STRATEGY = "SocketPastryNodeFactory.milti-inet-addressStrategy";
    public static final byte[] PASTRY_MAGIC_NUMBER = new byte[]{39, 64, 117, 58};
    private int port;
    protected NodeIdFactory nidFactory;
    protected InetAddress localAddress;
    InetAddress[] addressList;
    protected int testFireWallPolicy;
    protected int findFireWallPolicy;
    String firewallAppName;
    int firewallSearchTries;
    public static final String NODE_HANDLE_FACTORY = "SocketPastryNodeFactory.NODE_HANDLE_FACTORY";
    public static final byte NETWORK_INFO_NODE_HANDLE_INDEX = 1;
    Map<PastryNode, LivenesSourceRouteForwardStrategy<MultiInetSocketAddress>> livenesSourceRouteForwardStrategy = new HashMap<PastryNode, LivenesSourceRouteForwardStrategy<MultiInetSocketAddress>>();

    public SocketPastryNodeFactory(NodeIdFactory nf, int startPort, Environment env) throws IOException {
        this(nf, null, startPort, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketPastryNodeFactory(NodeIdFactory nf, InetAddress bindAddress, int startPort, Environment env) throws IOException {
        super(env);
        this.environment = env;
        this.nidFactory = nf;
        this.port = startPort;
        Parameters params = env.getParameters();
        this.firewallSearchTries = params.getInt("nat_find_port_max_tries");
        this.firewallAppName = params.getString("nat_app_name");
        this.localAddress = bindAddress;
        if (this.localAddress == null && params.contains("socket_bindAddress")) {
            this.localAddress = params.getInetAddress("socket_bindAddress");
        }
        if (this.localAddress == null) {
            this.localAddress = InetAddress.getLocalHost();
            Socket temp = null;
            ServerSocket test2 = null;
            if (this.localAddress.isLoopbackAddress() && !params.getBoolean("pastry_socket_allow_loopback")) {
                try {
                    temp = new Socket(params.getString("pastry_socket_known_network_address"), params.getInt("pastry_socket_known_network_address_port"));
                    if (temp.getLocalAddress().equals(this.localAddress)) {
                        throw new IllegalStateException("Cannot bind to " + this.localAddress + ":" + this.port);
                    }
                    this.localAddress = temp.getLocalAddress();
                    temp.close();
                    temp = null;
                    if (this.logger.level <= 900) {
                        this.logger.log("Error binding to default IP, using " + this.localAddress + ":" + this.port);
                    }
                    try {
                        test2 = new ServerSocket();
                        test2.bind(new InetSocketAddress(this.localAddress, this.port));
                    }
                    catch (SocketException e2) {
                        throw new IllegalStateException("Cannot bind to " + this.localAddress + ":" + this.port, e2);
                    }
                }
                finally {
                    try {
                        if (test2 != null) {
                            test2.close();
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (temp != null) {
                            temp.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public InetAddress getBindAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getNextInetSocketAddress() {
        return new InetSocketAddress(this.localAddress, this.port);
    }

    @Override
    protected void registerApps(PastryNode pn, LeafSet leafSet, RoutingTable routeTable, NodeHandleAdapter nha, NodeHandleFactory handleFactory) {
        super.registerApps(pn, leafSet, routeTable, nha, handleFactory);
        ProbeStrategy probeStrategy = this.getProbeStrategy(pn);
    }

    protected ProbeStrategy getProbeStrategy(PastryNode pn) {
        NetworkInfoTransportLayer ipService = (NetworkInfoTransportLayer)pn.getVars().get(IP_SERVICE);
        MultiInetAddressTransportLayer tl = (MultiInetAddressTransportLayer)pn.getVars().get(MULTI_INET_TL);
        ProbeApp probeApp = new ProbeApp(pn, ipService, tl.getAddressStrategy());
        probeApp.register();
        ipService.setProbeStrategy(probeApp);
        return probeApp;
    }

    @Override
    public NodeHandle getLocalHandle(PastryNode pn, NodeHandleFactory nhf) {
        SocketNodeHandleFactory pnhf = (SocketNodeHandleFactory)nhf;
        MultiInetSocketAddress proxyAddress = (MultiInetSocketAddress)pn.getVars().get(PROXY_ADDRESS);
        return pnhf.getNodeHandle(proxyAddress, pn.getEnvironment().getTimeSource().currentTimeMillis(), pn.getNodeId());
    }

    @Override
    public NodeHandleFactory getNodeHandleFactory(PastryNode pn) {
        if (pn.getVars().containsKey(NODE_HANDLE_FACTORY)) {
            return (NodeHandleFactory)pn.getVars().get(NODE_HANDLE_FACTORY);
        }
        SocketNodeHandleFactory ret = new SocketNodeHandleFactory(pn);
        pn.getVars().put(NODE_HANDLE_FACTORY, ret);
        return ret;
    }

    public TransportLayer<InetSocketAddress, ByteBuffer> getBottomLayers(PastryNode pn, MultiInetSocketAddress proxyAddress) throws IOException {
        TransportLayer<InetSocketAddress, ByteBuffer> wtl = this.getWireTransportLayer(proxyAddress.getInnermostAddress(), pn);
        TransportLayer<InetSocketAddress, ByteBuffer> mntl = this.getMagicNumberTransportLayer(wtl, pn);
        TransportLayer<InetSocketAddress, ByteBuffer> lstl = this.getLimitSocketsTransportLayer(mntl, pn);
        TransportLayer<InetSocketAddress, ByteBuffer> iptl = this.getIpServiceTransportLayer(lstl, pn);
        return iptl;
    }

    @Override
    public NodeHandleAdapter getNodeHandleAdapter(PastryNode pn, NodeHandleFactory handleFactory2, TLDeserializer deserializer) throws IOException {
        Environment environment = pn.getEnvironment();
        SocketNodeHandle localhandle = (SocketNodeHandle)pn.getLocalHandle();
        SocketNodeHandleFactory handleFactory = (SocketNodeHandleFactory)handleFactory2;
        MultiInetSocketAddress proxyAddress = localhandle.eaddress;
        MultiAddressSourceRouteFactory esrFactory = this.getMultiAddressSourceRouteFactory(pn);
        TransportLayer<InetSocketAddress, ByteBuffer> iptl = this.getBottomLayers(pn, proxyAddress);
        TransportLayer<MultiInetSocketAddress, ByteBuffer> etl = this.getMultiAddressSourceRouteTransportLayer(iptl, pn, proxyAddress);
        pn.getVars().put(MULTI_INET_TL, etl);
        TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> srl = this.getSourceRouteTransportLayer(etl, pn, esrFactory);
        IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> identity = this.getIdentityImpl(pn, handleFactory);
        TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> lowerIdentityLayer = this.getLowerIdentityLayer(srl, pn, identity);
        TransLiveness<SourceRoute<MultiInetSocketAddress>, ByteBuffer> ltl = this.getLivenessTransportLayer(lowerIdentityLayer, pn);
        this.notifyLivenessTransportLayerConstructed(pn, ltl);
        TransLivenessProximity<MultiInetSocketAddress, ByteBuffer> srm = this.getSourceRouteManagerLayer(ltl.getTransportLayer(), ltl.getLivenessProvider(), ltl.getPinger(), pn, proxyAddress, esrFactory);
        PriorityTransportLayer<MultiInetSocketAddress> priorityTL = this.getPriorityTransportLayer(srm.getTransportLayer(), srm.getLivenessProvider(), srm.getProximityProvider(), pn);
        TransLivenessProximity<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> upperIdentityLayer = this.getUpperIdentityLayer(priorityTL, pn, identity, srm.getLivenessProvider(), srm.getProximityProvider(), ltl.getOverrideLiveness());
        TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, RawMessage> commonAPItl = this.getCommonAPITransportLayer(upperIdentityLayer.getTransportLayer(), pn, deserializer);
        NodeHandleAdapter nha = new NodeHandleAdapter(commonAPItl, upperIdentityLayer.getLivenessProvider(), upperIdentityLayer.getProximityProvider());
        return nha;
    }

    protected MultiAddressSourceRouteFactory getMultiAddressSourceRouteFactory(PastryNode pn) {
        return new MultiAddressSourceRouteFactory();
    }

    protected TransportLayer<InetSocketAddress, ByteBuffer> getWireTransportLayer(InetSocketAddress innermostAddress, PastryNode pn) throws IOException {
        Environment environment = pn.getEnvironment();
        WireTransportLayerImpl wtl = new WireTransportLayerImpl(innermostAddress, environment, null);
        wtl.addSocketCountListener(this.getSocketCountListener(pn));
        return wtl;
    }

    protected SocketCountListener<InetSocketAddress> getSocketCountListener(final PastryNode pn) {
        return new SocketCountListener<InetSocketAddress>(){

            @Override
            public void socketOpened(InetSocketAddress i, Map<String, Object> options, boolean outgoing) {
                pn.broadcastChannelOpened(i, 0);
            }

            @Override
            public void socketClosed(InetSocketAddress i, Map<String, Object> options) {
                pn.broadcastChannelClosed(i);
            }
        };
    }

    protected TransportLayer<InetSocketAddress, ByteBuffer> getMagicNumberTransportLayer(TransportLayer<InetSocketAddress, ByteBuffer> wtl, PastryNode pn) {
        Environment environment = pn.getEnvironment();
        MagicNumberTransportLayer<InetSocketAddress> mntl = new MagicNumberTransportLayer<InetSocketAddress>(wtl, environment, null, PASTRY_MAGIC_NUMBER, 5000);
        return mntl;
    }

    protected TransportLayer<InetSocketAddress, ByteBuffer> getLimitSocketsTransportLayer(TransportLayer<InetSocketAddress, ByteBuffer> mntl, PastryNode pn) {
        Environment environment = pn.getEnvironment();
        LimitSocketsTransportLayer<InetSocketAddress, ByteBuffer> lstl = new LimitSocketsTransportLayer<InetSocketAddress, ByteBuffer>(environment.getParameters().getInt("pastry_socket_scm_max_open_sockets"), mntl, null, environment);
        return lstl;
    }

    protected TransportLayer<InetSocketAddress, ByteBuffer> getIpServiceTransportLayer(TransportLayer<InetSocketAddress, ByteBuffer> wtl, final PastryNode pn) throws IOException {
        Environment environment = pn.getEnvironment();
        final NetworkInfoTransportLayer ipTL = new NetworkInfoTransportLayer(wtl, environment, null);
        pn.getVars().put(IP_SERVICE, ipTL);
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        pn.getLocalHandle().serialize(sob);
        ipTL.setId((byte)1, sob.getBytes());
        pn.setNodeHandleFetcher(new NodeHandleFetcher(){

            @Override
            public Cancellable getNodeHandle(Object o, final Continuation<NodeHandle, Exception> c) {
                InetSocketAddress addr = (InetSocketAddress)o;
                return ipTL.getId(addr, (byte)1, new Continuation<byte[], IOException>(){

                    @Override
                    public void receiveResult(byte[] result) {
                        try {
                            Object nh = SocketPastryNodeFactory.this.getNodeHandleFactory(pn).readNodeHandle(new SimpleInputBuffer(result));
                            c.receiveResult(nh);
                        }
                        catch (IOException ioe) {
                            c.receiveException(ioe);
                        }
                    }

                    @Override
                    public void receiveException(IOException exception) {
                        c.receiveException(exception);
                    }
                }, null);
            }
        });
        return ipTL;
    }

    protected TransportLayer<MultiInetSocketAddress, ByteBuffer> getMultiAddressSourceRouteTransportLayer(TransportLayer<InetSocketAddress, ByteBuffer> mntl, PastryNode pn, MultiInetSocketAddress localAddress) {
        SimpleAddressStrategy adrStrat = new SimpleAddressStrategy();
        pn.getVars().put(MULTI_ADDRESS_STRATEGY, adrStrat);
        return new MultiInetAddressTransportLayerImpl(localAddress, mntl, pn.getEnvironment(), null, adrStrat);
    }

    protected TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> getSourceRouteTransportLayer(TransportLayer<MultiInetSocketAddress, ByteBuffer> etl, PastryNode pn, MultiAddressSourceRouteFactory esrFactory) {
        Environment environment = pn.getEnvironment();
        SourceRouteTransportLayerImpl<MultiInetSocketAddress> srl = new SourceRouteTransportLayerImpl<MultiInetSocketAddress>(esrFactory, etl, this.getSourceRouteForwardStrategy(pn, esrFactory), environment, null);
        return srl;
    }

    protected SourceRouteForwardStrategy<MultiInetSocketAddress> getSourceRouteForwardStrategy(PastryNode pn, MultiAddressSourceRouteFactory esrFactory) {
        LivenesSourceRouteForwardStrategy<MultiInetSocketAddress> ret = new LivenesSourceRouteForwardStrategy<MultiInetSocketAddress>(esrFactory, pn.getEnvironment());
        this.livenesSourceRouteForwardStrategy.put(pn, ret);
        return ret;
    }

    private void notifyLivenessTransportLayerConstructed(PastryNode pn, TransLiveness<SourceRoute<MultiInetSocketAddress>, ByteBuffer> ltl) {
        LivenesSourceRouteForwardStrategy<MultiInetSocketAddress> srFs = this.livenesSourceRouteForwardStrategy.remove(pn);
        if (srFs != null) {
            srFs.setLivenessProvider(ltl.getLivenessProvider());
        }
    }

    protected IdentitySerializer<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, SourceRoute<MultiInetSocketAddress>> getIdentiySerializer(PastryNode pn, SocketNodeHandleFactory handleFactory) {
        return new SPNFIdentitySerializer(pn, handleFactory);
    }

    protected IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> getIdentityImpl(PastryNode pn, SocketNodeHandleFactory handleFactory) throws IOException {
        Environment environment = pn.getEnvironment();
        SocketNodeHandle localhandle = (SocketNodeHandle)pn.getLocalHandle();
        IdentitySerializer<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, SourceRoute<MultiInetSocketAddress>> serializer = this.getIdentiySerializer(pn, handleFactory);
        SimpleOutputBuffer buf = new SimpleOutputBuffer();
        serializer.serialize(buf, localhandle);
        byte[] localHandleBytes = new byte[buf.getWritten()];
        System.arraycopy(buf.getBytes(), 0, localHandleBytes, 0, localHandleBytes.length);
        IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> identity = new IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>>(localHandleBytes, serializer, new NodeChangeStrategy<TransportLayerNodeHandle<MultiInetSocketAddress>>(){

            @Override
            public boolean canChange(TransportLayerNodeHandle<MultiInetSocketAddress> oldDest, TransportLayerNodeHandle<MultiInetSocketAddress> newDest) {
                if (newDest.getAddress().equals(oldDest.getAddress())) {
                    if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 800) {
                        SocketPastryNodeFactory.this.logger.log("canChange(" + oldDest + "," + newDest + ")");
                    }
                    if (newDest.getEpoch() > oldDest.getEpoch()) {
                        if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 800) {
                            SocketPastryNodeFactory.this.logger.log("canChange(" + oldDest + ":" + oldDest.getEpoch() + "," + newDest + ":" + newDest.getEpoch() + "):true");
                        }
                        return true;
                    }
                } else {
                    throw new RuntimeException("canChange(" + oldDest + "," + newDest + ") doesn't make any sense, these aren't comparable to eachother.");
                }
                if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 800) {
                    SocketPastryNodeFactory.this.logger.log("canChange(" + oldDest + ":" + oldDest.getEpoch() + "," + newDest + ":" + newDest.getEpoch() + "):false");
                }
                return false;
            }
        }, new SanityChecker<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress>(){

            @Override
            public boolean isSane(TransportLayerNodeHandle<MultiInetSocketAddress> upper, MultiInetSocketAddress middle) {
                return upper.getAddress().equals(middle);
            }
        }, environment);
        return identity;
    }

    protected TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> getLowerIdentityLayer(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> srl, PastryNode pn, IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> identity) {
        identity.initLowerLayer(srl, null);
        LowerIdentity<SourceRoute<MultiInetSocketAddress>, ByteBuffer> lowerIdentityLayer = identity.getLowerIdentity();
        return lowerIdentityLayer;
    }

    protected TransLiveness<SourceRoute<MultiInetSocketAddress>, ByteBuffer> getLivenessTransportLayer(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> tl, PastryNode pn) {
        Environment environment = pn.getEnvironment();
        int checkDeadThrottle = environment.getParameters().getInt("pastry_socket_srm_check_dead_throttle");
        final LivenessTransportLayerImpl<SourceRoute<MultiInetSocketAddress>> ltl = new LivenessTransportLayerImpl<SourceRoute<MultiInetSocketAddress>>(tl, environment, null, checkDeadThrottle);
        return new TransLiveness<SourceRoute<MultiInetSocketAddress>, ByteBuffer>(){

            @Override
            public TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> getTransportLayer() {
                return ltl;
            }

            @Override
            public LivenessProvider<SourceRoute<MultiInetSocketAddress>> getLivenessProvider() {
                return ltl;
            }

            @Override
            public OverrideLiveness<SourceRoute<MultiInetSocketAddress>> getOverrideLiveness() {
                return ltl;
            }

            @Override
            public Pinger<SourceRoute<MultiInetSocketAddress>> getPinger() {
                return ltl;
            }
        };
    }

    protected TransLivenessProximity<MultiInetSocketAddress, ByteBuffer> getSourceRouteManagerLayer(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> ltl, LivenessProvider<SourceRoute<MultiInetSocketAddress>> livenessProvider, Pinger<SourceRoute<MultiInetSocketAddress>> pinger, PastryNode pn, MultiInetSocketAddress proxyAddress, MultiAddressSourceRouteFactory esrFactory) throws IOException {
        Environment environment = pn.getEnvironment();
        SourceRouteStrategy<MultiInetSocketAddress> srStrategy = this.getSourceRouteStrategy(ltl, livenessProvider, pinger, pn, proxyAddress, esrFactory);
        MinRTTProximityProvider prox = new MinRTTProximityProvider(pinger, environment);
        final SourceRouteManagerImpl<MultiInetSocketAddress> srm = new SourceRouteManagerImpl<MultiInetSocketAddress>(esrFactory, ltl, livenessProvider, prox, environment, srStrategy);
        return new TransLivenessProximity<MultiInetSocketAddress, ByteBuffer>(){

            @Override
            public TransportLayer<MultiInetSocketAddress, ByteBuffer> getTransportLayer() {
                return srm;
            }

            @Override
            public ProximityProvider<MultiInetSocketAddress> getProximityProvider() {
                return srm;
            }

            @Override
            public LivenessProvider<MultiInetSocketAddress> getLivenessProvider() {
                return srm;
            }
        };
    }

    protected SourceRouteStrategy<MultiInetSocketAddress> getSourceRouteStrategy(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> ltl, LivenessProvider<SourceRoute<MultiInetSocketAddress>> livenessProvider, Pinger<SourceRoute<MultiInetSocketAddress>> pinger, PastryNode pn, MultiInetSocketAddress proxyAddress, MultiAddressSourceRouteFactory esrFactory) throws IOException {
        NextHopStrategy<MultiInetSocketAddress> nhStrategy = this.getNextHopStrategy(ltl, livenessProvider, pinger, pn, proxyAddress, esrFactory);
        return new SimpleSourceRouteStrategy<MultiInetSocketAddress>(proxyAddress, esrFactory, nhStrategy, this.environment);
    }

    protected NextHopStrategy<MultiInetSocketAddress> getNextHopStrategy(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> ltl, LivenessProvider<SourceRoute<MultiInetSocketAddress>> livenessProvider, Pinger<SourceRoute<MultiInetSocketAddress>> pinger, PastryNode pn, MultiInetSocketAddress proxyAddress, MultiAddressSourceRouteFactory esrFactory) throws IOException {
        return new LeafSetNHStrategy(pn.getLeafSet());
    }

    protected PriorityTransportLayer<MultiInetSocketAddress> getPriorityTransportLayer(TransportLayer<MultiInetSocketAddress, ByteBuffer> trans, LivenessProvider<MultiInetSocketAddress> liveness, ProximityProvider<MultiInetSocketAddress> prox, PastryNode pn) {
        Environment environment = pn.getEnvironment();
        PriorityTransportLayerImpl<MultiInetSocketAddress> priorityTL = new PriorityTransportLayerImpl<MultiInetSocketAddress>(trans, liveness, prox, environment, environment.getParameters().getInt("pastry_socket_writer_max_msg_size"), environment.getParameters().getInt("pastry_socket_writer_max_queue_length"), null);
        pn.getVars().put(PRIORITY_TL, priorityTL);
        return priorityTL;
    }

    protected TransLivenessProximity<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> getUpperIdentityLayer(TransportLayer<MultiInetSocketAddress, ByteBuffer> priorityTL, PastryNode pn, IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> identity, LivenessProvider<MultiInetSocketAddress> live, ProximityProvider<MultiInetSocketAddress> prox, OverrideLiveness<SourceRoute<MultiInetSocketAddress>> overrideLiveness) {
        SocketNodeHandle localhandle = (SocketNodeHandle)pn.getLocalHandle();
        identity.initUpperLayer(localhandle, priorityTL, live, prox, overrideLiveness);
        final UpperIdentity<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> upperIdentityLayer = identity.getUpperIdentity();
        return new TransLivenessProximity<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer>(){

            @Override
            public TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> getTransportLayer() {
                return upperIdentityLayer;
            }

            @Override
            public ProximityProvider<TransportLayerNodeHandle<MultiInetSocketAddress>> getProximityProvider() {
                return upperIdentityLayer;
            }

            @Override
            public LivenessProvider<TransportLayerNodeHandle<MultiInetSocketAddress>> getLivenessProvider() {
                return upperIdentityLayer;
            }
        };
    }

    protected TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, RawMessage> getCommonAPITransportLayer(TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> upperIdentity, PastryNode pn, TLDeserializer deserializer) {
        final Environment environment = pn.getEnvironment();
        IdFactory idFactory = new IdFactory(){

            public rice.p2p.commonapi.Id build(InputBuffer buf) throws IOException {
                return Id.build(buf);
            }
        };
        CommonAPITransportLayerImpl<TransportLayerNodeHandle<MultiInetSocketAddress>> commonAPItl = new CommonAPITransportLayerImpl<TransportLayerNodeHandle<MultiInetSocketAddress>>(upperIdentity, idFactory, deserializer, new OptionsAdder(){

            @Override
            public Map<String, Object> addOptions(Map<String, Object> options, RawMessage m1) {
                Message rm;
                Message m = m1;
                if (m instanceof RouteMessage) {
                    rm = (RouteMessage)m;
                    m = ((RouteMessage)rm).internalMsg;
                    if (m == null) {
                        m = rm;
                    }
                }
                if (m instanceof PastryEndpointMessage) {
                    PastryEndpointMessage pem = (PastryEndpointMessage)m;
                    m = pem.getMessage();
                    options = OptionsFactory.addOption(options, "commonapi_msg_addr", pem.getDestination());
                }
                if (m instanceof rice.pastry.messaging.Message) {
                    rice.pastry.messaging.Message pm = (rice.pastry.messaging.Message)m;
                    options = OptionsFactory.addOption(options, "commonapi_msg_addr", pm.getDestination());
                }
                if (m instanceof RawMessage) {
                    rm = m;
                    options = OptionsFactory.addOption(options, "commonapi_msg_type", rm.getType());
                }
                return OptionsFactory.addOption(options, "commonapi_msg_string", m.toString(), "commonapi_msg_class", m.getClass().getName());
            }
        }, new ErrorHandler<TransportLayerNodeHandle<MultiInetSocketAddress>>(){
            Logger logger;
            {
                this.logger = environment.getLogManager().getLogger(SocketPastryNodeFactory.class, null);
            }

            @Override
            public void receivedUnexpectedData(TransportLayerNodeHandle<MultiInetSocketAddress> id, byte[] bytes, int location, Map<String, Object> options) {
                if (this.logger.level <= 900) {
                    String s = "";
                    int numBytes = 8;
                    if (bytes.length < numBytes) {
                        numBytes = bytes.length;
                    }
                    for (int i = 0; i < numBytes; ++i) {
                        s = s + bytes[i] + ",";
                    }
                    this.logger.log("Unexpected data from " + id + " " + s);
                }
            }

            @Override
            public void receivedException(TransportLayerNodeHandle<MultiInetSocketAddress> i, Throwable error) {
                if (this.logger.level <= 800 && error instanceof NodeIsFaultyException) {
                    NodeIsFaultyException nife = (NodeIsFaultyException)error;
                    this.logger.log("Dropping message " + nife.getAttemptedMessage() + " to " + nife.getIdentifier() + " because it is faulty.");
                    if (i.isAlive()) {
                        TransportLayerNodeHandle<MultiInetSocketAddress> nh = i;
                        this.logger.logException("NodeIsFaultyException thrown for non-dead node. " + i + " " + nh.getLiveness(), nife);
                    }
                }
            }
        }, environment);
        return commonAPItl;
    }

    @Override
    protected Bootstrapper getBootstrapper(PastryNode pn, NodeHandleAdapter tl, NodeHandleFactory handleFactory, ProximityNeighborSelector pns) {
        TLBootstrapper bootstrapper = new TLBootstrapper(pn, tl.getTL(), (SocketNodeHandleFactory)handleFactory, pns);
        return bootstrapper;
    }

    public NodeHandle getNodeHandle(InetSocketAddress bootstrap, int i) {
        return this.getNodeHandle(bootstrap);
    }

    public NodeHandle getNodeHandle(InetSocketAddress bootstrap) {
        return new BogusNodeHandle(bootstrap);
    }

    public void getNodeHandle(InetSocketAddress[] bootstraps, Continuation c) {
        c.receiveResult(this.getNodeHandle(bootstraps, 0));
    }

    public NodeHandle getNodeHandle(InetSocketAddress[] bootstraps, int int1) {
        return new BogusNodeHandle(bootstraps);
    }

    @Override
    public PastryNode newNode(NodeHandle bootstrap) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle bootstrap, InetSocketAddress proxy) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId(), proxy);
    }

    @Override
    public PastryNode newNode(NodeHandle bootstrap, Id nodeId) {
        return this.newNode(bootstrap, nodeId, null);
    }

    @Override
    public PastryNode newNode() {
        return this.newNode(this.nidFactory.generateNodeId(), (InetSocketAddress)null);
    }

    @Override
    public PastryNode newNode(Id id) {
        return this.newNode(id, (InetSocketAddress)null);
    }

    public PastryNode newNode(InetSocketAddress proxyAddress) {
        return this.newNode(this.nidFactory.generateNodeId(), proxyAddress);
    }

    public PastryNode newNode(NodeHandle nodeHandle, Id id, InetSocketAddress proxyAddress) {
        PastryNode n = this.newNode(id, proxyAddress);
        if (nodeHandle == null) {
            n.getBootstrapper().boot(null);
        } else {
            BogusNodeHandle bnh = (BogusNodeHandle)nodeHandle;
            n.getBootstrapper().boot(bnh.addresses);
        }
        return n;
    }

    public synchronized PastryNode newNode(Id nodeId, InetSocketAddress pAddress) {
        try {
            MultiInetSocketAddress multiAddress = pAddress == null ? new MultiInetSocketAddress(new InetSocketAddress(this.localAddress, this.port)) : new MultiInetSocketAddress(pAddress, new InetSocketAddress(this.localAddress, this.port));
            PastryNode ret = this.newNode(nodeId, multiAddress);
            if (this.environment.getParameters().getBoolean("pastry_socket_increment_port_after_construction")) {
                ++this.port;
            }
            return ret;
        }
        catch (BindException e) {
            if (this.logger.level <= 900) {
                this.logger.logException("Warning: ", e);
            }
            if (this.environment.getParameters().getBoolean("pastry_socket_increment_port_after_construction")) {
                ++this.port;
                try {
                    return this.newNode(nodeId, pAddress);
                }
                catch (StackOverflowError soe) {
                    if (this.logger.level <= 1000) {
                        this.logger.log("SEVERE: SocketPastryNodeFactory: Could not bind on any ports!" + soe);
                    }
                    throw soe;
                }
            }
            if (this.environment.getParameters().getBoolean("pastry_factory_multipleNodes")) {
                this.environment.destroy();
            }
            throw new RuntimeException(e);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PastryNode newNode(final Id nodeId, final MultiInetSocketAddress pAddress) throws IOException {
        final ArrayList pn = new ArrayList(1);
        final ArrayList re = new ArrayList(1);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList arrayList = pn;
                synchronized (arrayList) {
                    SocketPastryNodeFactory.this.newNodeSelector(nodeId, pAddress, new Continuation<PastryNode, IOException>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void receiveResult(PastryNode node) {
                            ArrayList arrayList = pn;
                            synchronized (arrayList) {
                                pn.add(node);
                                pn.notify();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void receiveException(IOException exception) {
                            ArrayList arrayList = pn;
                            synchronized (arrayList) {
                                re.add(exception);
                                pn.notify();
                            }
                        }
                    }, null);
                }
            }
        };
        if (this.environment.getSelectorManager().isSelectorThread()) {
            r.run();
        } else {
            this.environment.getSelectorManager().invoke(r);
        }
        ArrayList arrayList = pn;
        synchronized (arrayList) {
            if (pn.isEmpty() && re.isEmpty()) {
                try {
                    pn.wait();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
        }
        if (pn.isEmpty()) {
            throw (IOException)re.get(0);
        }
        return (PastryNode)pn.get(0);
    }

    protected void newNodeSelector(Id nodeId, MultiInetSocketAddress proxyAddress, Continuation<PastryNode, IOException> deliverResultToMe, Map<String, Object> initialVars) {
        try {
            Environment environment = this.cloneEnvironment(this.environment, nodeId);
            Parameters params = environment.getParameters();
            PastryNode pn = new PastryNode(nodeId, environment);
            if (initialVars != null) {
                pn.getVars().putAll(initialVars);
            }
            pn.getVars().put(PROXY_ADDRESS, proxyAddress);
            this.nodeHandleHelper(pn);
            deliverResultToMe.receiveResult(pn);
        }
        catch (IOException ioe) {
            deliverResultToMe.receiveException(ioe);
        }
    }

    protected Environment cloneEnvironment(Environment rootEnvironment, Id nodeId) {
        Environment ret = rootEnvironment;
        if (rootEnvironment.getParameters().getBoolean("pastry_factory_multipleNodes")) {
            LogManager lman = this.cloneLogManager(rootEnvironment, nodeId);
            SelectorManager sman = this.cloneSelectorManager(rootEnvironment, nodeId, lman);
            Processor proc = this.cloneProcessor(rootEnvironment, nodeId, lman);
            RandomSource rand = this.cloneRandomSource(rootEnvironment, nodeId, lman);
            ret = new Environment(sman, proc, rand, rootEnvironment.getTimeSource(), lman, rootEnvironment.getParameters(), rootEnvironment.getExceptionStrategy());
            rootEnvironment.addDestructable(ret);
        }
        return ret;
    }

    protected LogManager cloneLogManager(Environment rootEnvironment, Id nodeId) {
        LogManager lman = rootEnvironment.getLogManager();
        if (lman instanceof CloneableLogManager) {
            lman = ((CloneableLogManager)rootEnvironment.getLogManager()).clone("0x" + nodeId.toStringBare());
        }
        return lman;
    }

    protected SelectorManager cloneSelectorManager(Environment rootEnvironment, Id nodeId, LogManager lman) {
        SelectorManager sman = rootEnvironment.getSelectorManager();
        if (rootEnvironment.getParameters().getBoolean("pastry_factory_selectorPerNode")) {
            sman = new SelectorManager(nodeId.toString() + " Selector", rootEnvironment.getTimeSource(), lman, rootEnvironment.getRandomSource());
        }
        return sman;
    }

    protected Processor cloneProcessor(Environment rootEnvironment, Id nodeId, LogManager lman) {
        Processor proc = rootEnvironment.getProcessor();
        if (rootEnvironment.getParameters().getBoolean("pastry_factory_processorPerNode")) {
            proc = new SimpleProcessor(nodeId.toString() + " Processor");
        }
        return proc;
    }

    protected RandomSource cloneRandomSource(Environment rootEnvironment, Id nodeId, LogManager lman) {
        long randSeed = rootEnvironment.getRandomSource().nextLong();
        return new SimpleRandomSource(randSeed, lman);
    }

    private MultiInetSocketAddress getEpochAddress(int portNumber) {
        MultiInetSocketAddress result = null;
        result = new MultiInetSocketAddress(new InetSocketAddress(this.localAddress, portNumber));
        return result;
    }

    public static InetSocketAddress verifyConnection(int i, InetSocketAddress addr, InetSocketAddress[] addr2, Environment env, Logger l) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TLBootstrapper
    implements Bootstrapper<InetSocketAddress> {
        protected PastryNode pn;
        protected TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, RawMessage> tl;
        protected SocketNodeHandleFactory handleFactory;
        protected ProximityNeighborSelector pns;
        protected Logger logger;
        final List<LivenessListener<NodeHandle>> listener = new ArrayList<LivenessListener<NodeHandle>>();

        public TLBootstrapper(PastryNode pn, TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, RawMessage> tl, SocketNodeHandleFactory handleFactory, ProximityNeighborSelector pns) {
            this.logger = pn.getEnvironment().getLogManager().getLogger(TLBootstrapper.class, null);
            this.pn = pn;
            this.tl = tl;
            this.handleFactory = handleFactory;
            this.pns = pns;
        }

        protected void bootAsBootstrap() {
            this.pn.doneNode(Collections.EMPTY_LIST);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void boot(Collection<InetSocketAddress> bootaddresses_temp) {
            boolean seed;
            if (this.logger.level <= 500) {
                this.logger.log("boot(" + bootaddresses_temp + ")");
            }
            final Collection<Object> bootaddresses = bootaddresses_temp == null ? Collections.EMPTY_LIST : bootaddresses_temp;
            boolean bl = seed = SocketPastryNodeFactory.this.environment.getParameters().getBoolean("rice_socket_seed") || bootaddresses.isEmpty() || bootaddresses.contains(((SocketNodeHandle)this.pn.getLocalHandle()).getAddress().getInnermostAddress());
            if (bootaddresses.isEmpty() || bootaddresses.size() == 1 && seed) {
                if (this.logger.level <= 800) {
                    this.logger.log("boot() calling pn.doneNode(empty)");
                }
                this.bootAsBootstrap();
                return;
            }
            final ArrayList<SocketNodeHandle> tempBootHandles = new ArrayList<SocketNodeHandle>(bootaddresses.size());
            final HashSet bootHandles = new HashSet();
            TransportLayerNodeHandle<MultiInetSocketAddress> local = this.tl.getLocalIdentifier();
            InetSocketAddress localAddr = local.getAddress().getInnermostAddress();
            for (InetSocketAddress hashSet : bootaddresses) {
                if (this.logger.level <= 400) {
                    this.logger.log("addr:" + hashSet + " local:" + localAddr);
                }
                if (hashSet.equals(localAddr)) continue;
                tempBootHandles.add(this.getTempNodeHandle(hashSet));
            }
            final Continuation<Collection<NodeHandle>, Exception> beginPns = new Continuation<Collection<NodeHandle>, Exception>(){
                boolean done = false;

                @Override
                public void receiveResult(Collection<NodeHandle> initialSet) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    if (TLBootstrapper.this.logger.level <= 500) {
                        TLBootstrapper.this.logger.log("boot() beginning pns with " + initialSet);
                    }
                    TLBootstrapper.this.pn.getLivenessProvider().removeLivenessListener(TLBootstrapper.this.listener.get(0));
                    TLBootstrapper.this.pns.getNearHandles(initialSet, new Continuation<Collection<NodeHandle>, Exception>(){

                        @Override
                        public void receiveResult(Collection<NodeHandle> result) {
                            if (!seed && result.isEmpty()) {
                                TLBootstrapper.this.pn.joinFailed(new JoinFailedException("Cannot join ring.  All bootstraps are faulty." + bootaddresses));
                                return;
                            }
                            if (TLBootstrapper.this.logger.level <= 800) {
                                TLBootstrapper.this.logger.log("boot() calling pn.doneNode(" + result + ")");
                            }
                            TLBootstrapper.this.pn.doneNode(result);
                        }

                        @Override
                        public void receiveException(Exception exception) {
                        }
                    });
                }

                @Override
                public void receiveException(Exception exception) {
                }
            };
            this.listener.add(new LivenessListener<NodeHandle>(){
                Logger logger;
                {
                    this.logger = TLBootstrapper.this.pn.getEnvironment().getLogManager().getLogger(SocketPastryNodeFactory.class, null);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void livenessChanged(NodeHandle i2, int val, Map<String, Object> options) {
                    SocketNodeHandle i = (SocketNodeHandle)i2;
                    if (this.logger.level <= 500) {
                        this.logger.log("livenessChanged(" + i + "," + val + ")");
                    }
                    if (val <= 2 && i.getEpoch() != -1L) {
                        boolean complete = false;
                        Collection collection = bootHandles;
                        synchronized (collection) {
                            bootHandles.add(i);
                            if (bootHandles.size() == tempBootHandles.size()) {
                                complete = true;
                            }
                        }
                        if (complete) {
                            beginPns.receiveResult(bootHandles);
                        }
                    }
                }
            });
            if (this.logger.level <= 500) {
                this.logger.log("boot() adding liveness listener");
            }
            this.pn.getLivenessProvider().addLivenessListener(this.listener.get(0));
            if (this.logger.level <= 500) {
                this.logger.log("boot() checking liveness");
            }
            for (SocketNodeHandle h : tempBootHandles) {
                this.checkLiveness(h, null);
            }
            HashSet hashSet = bootHandles;
            synchronized (hashSet) {
                if (bootHandles.size() < tempBootHandles.size()) {
                    SocketPastryNodeFactory.this.environment.getSelectorManager().schedule(new TimerTask(){

                        public void run() {
                            if (TLBootstrapper.this.logger.level <= 500) {
                                TLBootstrapper.this.logger.log("boot() timer expiring, attempting to start pns (it may have already started)");
                            }
                            beginPns.receiveResult(bootHandles);
                        }
                    }, 20000L);
                }
            }
            if (tempBootHandles.isEmpty()) {
                if (this.logger.level <= 500) {
                    this.logger.log("invoking receiveResult (this is probably the first node in the ring)");
                }
                SocketPastryNodeFactory.this.environment.getSelectorManager().invoke(new Runnable(){

                    public void run() {
                        beginPns.receiveResult(bootHandles);
                    }
                });
            }
            if (this.logger.level <= 500) {
                this.logger.log("boot() returning");
            }
        }

        protected SocketNodeHandle getTempNodeHandle(InetSocketAddress addr) {
            return this.handleFactory.getNodeHandle(new MultiInetSocketAddress(addr), -1L, Id.build());
        }

        protected void checkLiveness(SocketNodeHandle h, Map<String, Object> options) {
            this.pn.getLivenessProvider().checkLiveness(h, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface TransLivenessProximity<Identifier, MessageType> {
        public TransportLayer<Identifier, ByteBuffer> getTransportLayer();

        public LivenessProvider<Identifier> getLivenessProvider();

        public ProximityProvider<Identifier> getProximityProvider();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface TransLiveness<Identifier, MessageType> {
        public TransportLayer<Identifier, MessageType> getTransportLayer();

        public LivenessProvider<Identifier> getLivenessProvider();

        public OverrideLiveness<Identifier> getOverrideLiveness();

        public Pinger<Identifier> getPinger();
    }
}

