/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.leafset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeSet;
import rice.pastry.NodeSetListener;
import rice.pastry.leafset.LSRangeCannotBeDeterminedException;
import rice.pastry.leafset.SimilarSet;
import rice.pastry.routing.RoutingTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafSet
extends Observable
implements Serializable,
Iterable<NodeHandle> {
    private static final long serialVersionUID = 3960030608598552977L;
    private Id baseId;
    private NodeHandle baseHandle;
    private SimilarSet cwSet;
    private SimilarSet ccwSet;
    transient boolean observe = true;
    private int theSize;
    transient RoutingTable routingTable;

    private LeafSet(LeafSet that) {
        this(that, true);
    }

    private LeafSet(LeafSet that, boolean observe) {
        this.observe = observe;
        this.baseId = that.baseId;
        this.baseHandle = that.baseHandle;
        this.ccwSet = that.ccwSet.copy(this);
        this.cwSet = that.cwSet.copy(this);
        this.theSize = that.theSize;
    }

    public LeafSet(NodeHandle localNode, int size, RoutingTable rt) {
        this(localNode, size, true);
        this.routingTable = rt;
    }

    public LeafSet(NodeHandle localNode, int size, boolean observe) {
        this.observe = observe;
        this.baseHandle = localNode;
        this.baseId = localNode.getNodeId();
        this.theSize = size;
        this.cwSet = new SimilarSet(this, localNode, size / 2, true);
        this.ccwSet = new SimilarSet(this, localNode, size / 2, false);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.observe = true;
    }

    public boolean put(NodeHandle handle) {
        return this.put(handle, false);
    }

    public boolean put(NodeHandle handle, boolean suppressNotification) {
        Id nid = handle.getNodeId();
        if (nid.equals(this.baseId)) {
            return false;
        }
        if (this.member(handle)) {
            return false;
        }
        boolean res = this.cwSet.put(handle, suppressNotification) | this.ccwSet.put(handle, suppressNotification);
        return res;
    }

    public boolean test(NodeHandle handle) {
        Id nid = handle.getNodeId();
        if (nid.equals(this.baseId)) {
            return false;
        }
        if (this.member(handle)) {
            return false;
        }
        return this.cwSet.test(handle) | this.ccwSet.test(handle);
    }

    public boolean overlaps() {
        return this.size() > 0 && (this.ccwSet.member(this.cwSet.get(this.cwSet.size() - 1)) || this.cwSet.member(this.ccwSet.get(this.ccwSet.size() - 1)));
    }

    public boolean isComplete() {
        if (this.size() == this.maxSize()) {
            return true;
        }
        return this.overlaps();
    }

    public int getIndex(NodeHandle nh) throws NoSuchElementException {
        if (this.baseId.equals(nh.getId())) {
            return 0;
        }
        int cwIndex = this.cwSet.getIndex(nh);
        int ccwIndex = this.ccwSet.getIndex(nh);
        if (cwIndex >= 0 && ccwIndex >= 0) {
            if (cwIndex <= ccwIndex) {
                return cwIndex + 1;
            }
            return -ccwIndex - 1;
        }
        if (cwIndex >= 0) {
            return cwIndex + 1;
        }
        if (ccwIndex >= 0) {
            return -ccwIndex - 1;
        }
        throw new NoSuchElementException();
    }

    public NodeHandle get(int index) {
        if (index == 0) {
            return this.baseHandle;
        }
        if (index >= 0) {
            return this.cwSet.get(index - 1);
        }
        return this.ccwSet.get(-index - 1);
    }

    public boolean member(NodeHandle nid) {
        return this.cwSet.member(nid) || this.ccwSet.member(nid);
    }

    public boolean contains(NodeHandle nh) {
        return this.member(nh);
    }

    public boolean member(Id nid) {
        return this.cwSet.member(nid) || this.ccwSet.member(nid);
    }

    public void remove(NodeHandle nh) {
        this.cwSet.remove(nh);
        this.ccwSet.remove(nh);
        this.cwSet.findMoreEntriesFromRoutingTable();
        this.ccwSet.findMoreEntriesFromRoutingTable();
    }

    public int maxSize() {
        return this.theSize;
    }

    public int size() {
        return this.cwSize() + this.ccwSize();
    }

    public int cwSize() {
        return this.cwSet.size();
    }

    public int ccwSize() {
        return this.ccwSet.size();
    }

    private int complement(int inx) {
        int res;
        if (inx == 0) {
            return 0;
        }
        if (inx < 0) {
            if (inx < -this.ccwSize()) {
                return inx;
            }
            res = this.cwSet.getIndex(this.ccwSet.get(-inx - 1)) + 1;
        } else {
            if (inx > this.cwSize()) {
                return inx;
            }
            res = -this.ccwSet.getIndex(this.cwSet.get(inx - 1)) - 1;
        }
        if (res == 0) {
            res = inx;
        }
        return res;
    }

    public int mostSimilar(Id nid) {
        int ccwMS;
        int cwMS;
        if (this.baseId.clockwise(nid)) {
            cwMS = this.cwSet.mostSimilar(nid);
            if (cwMS < this.cwSet.size() - 1) {
                return cwMS + 1;
            }
            ccwMS = this.ccwSet.mostSimilar(nid);
        } else {
            ccwMS = this.ccwSet.mostSimilar(nid);
            if (ccwMS < this.ccwSet.size() - 1) {
                return -ccwMS - 1;
            }
            cwMS = this.cwSet.mostSimilar(nid);
        }
        Id.Distance cwMinDist = this.cwSet.get(cwMS).getNodeId().distance(nid);
        Id.Distance ccwMinDist = this.ccwSet.get(ccwMS).getNodeId().distance(nid);
        int cmp = cwMinDist.compareTo(ccwMinDist);
        if (cmp < 0 || cmp == 0 && nid.clockwise(this.cwSet.get(cwMS).getNodeId())) {
            return cwMS + 1;
        }
        return -ccwMS - 1;
    }

    public NodeSet neighborSet(int max) {
        int i;
        int cwSize = this.cwSize();
        int ccwSize = this.ccwSize();
        NodeHandle cwExtreme = this.get(cwSize);
        NodeHandle ccwExtreme = this.get(-ccwSize);
        NodeSet set = this.replicaSet(this.baseId, max);
        if (!set.member(cwExtreme) && !set.member(ccwExtreme)) {
            return set;
        }
        if (!set.member(cwExtreme)) {
            for (i = 1; i <= cwSize; ++i) {
                set.put(this.get(i));
            }
        }
        if (!set.member(ccwExtreme)) {
            for (i = 1; i <= ccwSize; ++i) {
                set.put(this.get(-i));
            }
        }
        return set;
    }

    public NodeSet replicaSet(Id key, int max) {
        NodeSet set = new NodeSet();
        if (max < 1) {
            return set;
        }
        if (!(this.overlaps() || this.size() <= 0 || key.isBetween(this.get(-this.ccwSet.size()).getNodeId(), this.get(this.cwSet.size()).getNodeId()) || key.equals(this.get(this.cwSet.size()).getNodeId()))) {
            return set;
        }
        int nearest = this.mostSimilar(key);
        set.put(this.get(nearest));
        int cw = nearest;
        int ccw = nearest;
        int wrapped = 0;
        while (set.size() < max && wrapped < 3) {
            int tmp;
            Id.Distance ccwDist;
            NodeHandle cwNode = this.get(cw);
            NodeHandle ccwNode = this.get(ccw);
            Id.Distance cwDist = cwNode.getNodeId().distance(key);
            if (cwDist.compareTo(ccwDist = ccwNode.getNodeId().distance(key)) <= 0) {
                set.put(cwNode);
                tmp = cw;
                if (cw == this.cwSet.size()) {
                    if ((cw = this.complement(cw)) == tmp) {
                        return set;
                    }
                    ++wrapped;
                }
                ++cw;
                continue;
            }
            set.put(ccwNode);
            tmp = ccw;
            if (-ccw == this.ccwSet.size()) {
                if ((ccw = this.complement(ccw)) == tmp) {
                    return set;
                }
                ++wrapped;
            }
            --ccw;
        }
        return set;
    }

    public int getUniqueCount() {
        HashSet superset = new HashSet();
        superset.addAll(this.cwSet.getCollection());
        superset.addAll(this.ccwSet.getCollection());
        return superset.size() + 1;
    }

    @Override
    public Iterator<NodeHandle> iterator() {
        HashSet superset = new HashSet();
        superset.addAll(this.cwSet.getCollection());
        superset.addAll(this.ccwSet.getCollection());
        return superset.iterator();
    }

    private int mod(int x, int y) {
        if (x < 0 ^ y < 0) {
            return y + x % y;
        }
        return x % y;
    }

    public IdRange range(NodeHandle n, int r) {
        NodeHandle cw;
        NodeHandle ccw;
        if (r < 0) {
            throw new IllegalArgumentException("Range must be greater than or equal to zero. Attempted " + r);
        }
        if (!this.member(n) && !this.baseHandle.equals(n)) {
            throw new LSRangeCannotBeDeterminedException("Node " + n + " is not in this leafset.", r, Integer.MIN_VALUE, this.getUniqueCount(), n, this);
        }
        int pos = this.getIndex(n);
        int num = this.getUniqueCount();
        if (this.overlaps() || num == 1) {
            if (r + 1 >= num) {
                return new IdRange(n.getNodeId(), n.getNodeId());
            }
            ccw = this.get(this.mod(pos - r - 1 + this.ccwSet.size(), num) - this.ccwSet.size());
            cw = this.get(this.mod(pos + r + 1 + this.ccwSet.size(), num) - this.ccwSet.size());
        } else {
            ccw = this.get(pos - r - 1);
            cw = this.get(pos + r + 1);
        }
        if (ccw == null || cw == null) {
            throw new LSRangeCannotBeDeterminedException("This leafset doesn't have enough information to provide the correct range.", r, pos, this.getUniqueCount(), n, this);
        }
        IdRange cwRange = new IdRange(n.getNodeId(), cw.getNodeId()).ccwHalf();
        IdRange ccwRange = new IdRange(ccw.getNodeId(), n.getNodeId()).cwHalf();
        return ccwRange.merge(cwRange);
    }

    public IdRange range(NodeHandle n, int r, boolean cw) {
        IdRange rr = this.range(n, r);
        if (r == 0) {
            return rr;
        }
        IdRange rprev = null;
        try {
            rprev = this.range(n, r - 1);
        }
        catch (LSRangeCannotBeDeterminedException rcbde) {
            // empty catch block
        }
        if (rr == null || rprev == null) {
            return rr;
        }
        IdRange res = !cw ? rr.diff(rprev) : rprev.diff(rr);
        return res;
    }

    public boolean merge(LeafSet remotels, NodeHandle from, RoutingTable routeTable, boolean testOnly, Set insertedHandles) {
        boolean changed;
        NodeHandle nh;
        int i;
        boolean result = false;
        int cwSize = remotels.cwSize();
        int ccwSize = remotels.ccwSize();
        HashSet<NodeHandle> myInsertedHandles = new HashSet<NodeHandle>();
        int cw = remotels.cwSet.getIndex(this.baseId);
        int ccw = remotels.ccwSet.getIndex(this.baseId);
        if (cw < 0) {
            if (ccw < 0) {
                if (remotels.size() < 2) {
                    ccw = 0;
                    cw = 0;
                } else {
                    int closest = remotels.mostSimilar(this.baseId);
                    Id closestId = remotels.get(closest).getNodeId();
                    if (closest == -remotels.ccwSize() || closest == remotels.cwSize()) {
                        // empty if block
                    }
                    if (closest == 0) {
                        if (this.baseId.clockwise(closestId)) {
                            cw = closest;
                            ccw = remotels.complement(closest - 1);
                        } else {
                            cw = remotels.complement(closest + 1);
                            ccw = closest;
                        }
                    } else if (closest < 0) {
                        if (this.baseId.clockwise(closestId)) {
                            cw = closest;
                            ccw = remotels.complement(closest - 1);
                        } else {
                            cw = closest + 1;
                            ccw = remotels.complement(closest);
                        }
                    } else if (this.baseId.clockwise(closestId)) {
                        cw = remotels.complement(closest);
                        ccw = closest - 1;
                    } else {
                        ccw = closest;
                        cw = remotels.complement(closest + 1);
                    }
                }
            } else {
                ccw = -ccw - 2;
                cw = ccw + 2;
            }
        } else if (ccw < 0) {
            ccw = (cw += 2) - 2;
        } else {
            int tmp = ccw;
            ccw = cw;
            cw = -tmp;
        }
        for (i = cw; i <= cwSize; ++i) {
            nh = i == 0 ? from : remotels.get(i);
            if (!nh.isAlive()) continue;
            if (testOnly) {
                changed = this.cwSet.test(nh);
            } else {
                changed = this.cwSet.put(nh, true);
                if (changed) {
                    myInsertedHandles.add(nh);
                }
                routeTable.put(nh);
            }
            result |= changed;
            if (insertedHandles == null || !changed) continue;
            insertedHandles.add(nh);
        }
        for (i = ccw; i >= -ccwSize; --i) {
            nh = i == 0 ? from : remotels.get(i);
            if (!nh.isAlive()) continue;
            if (testOnly) {
                changed = this.ccwSet.test(nh);
            } else {
                changed = this.ccwSet.put(nh, true);
                if (changed) {
                    myInsertedHandles.add(nh);
                }
                routeTable.put(nh);
            }
            result |= changed;
            if (insertedHandles == null || !changed) continue;
            insertedHandles.add(nh);
        }
        if (this.overlaps()) {
            for (i = -ccwSize; i <= cwSize; ++i) {
                nh = i == 0 ? from : remotels.get(i);
                if (!nh.isAlive()) continue;
                if (testOnly) {
                    changed = this.test(nh);
                } else {
                    changed = this.put(nh);
                    if (changed) {
                        myInsertedHandles.add(nh);
                    }
                    routeTable.put(nh);
                }
                result |= changed;
                if (insertedHandles == null || !changed) continue;
                insertedHandles.add(nh);
            }
        }
        Iterator i2 = myInsertedHandles.iterator();
        while (i2.hasNext()) {
            this.cwSet.notifyListeners((NodeHandle)i2.next(), true);
        }
        return result;
    }

    @Override
    public void addObserver(Observer o) {
        this.cwSet.addObserver(o);
        this.ccwSet.addObserver(o);
    }

    @Override
    public void deleteObserver(Observer o) {
        this.cwSet.deleteObserver(o);
        this.ccwSet.deleteObserver(o);
    }

    public void addNodeSetListener(NodeSetListener listener) {
        this.cwSet.addNodeSetListener(listener);
        this.ccwSet.addNodeSetListener(listener);
    }

    public void deleteNodeSetListener(NodeSetListener listener) {
        this.cwSet.removeNodeSetListener(listener);
        this.ccwSet.removeNodeSetListener(listener);
    }

    public String toString() {
        int i;
        String s = "leafset: ";
        for (i = -this.ccwSet.size(); i < 0; ++i) {
            s = s + this.get(i).getNodeId();
        }
        s = s + " [ " + this.baseId + " ] ";
        for (i = 1; i <= this.cwSet.size(); ++i) {
            s = s + this.get(i).getNodeId();
        }
        s = s + " complete:" + this.isComplete();
        s = s + " size:" + this.size();
        if (this.size() > 0) {
            s = s + " s1:" + this.ccwSet.member(this.cwSet.get(this.cwSet.size() - 1));
        }
        s = s + " s2:" + this.cwSet.member(this.ccwSet.get(this.ccwSet.size() - 1));
        return s;
    }

    protected boolean isProperlyRemoved(NodeHandle handle) {
        return !this.member(handle);
    }

    protected boolean testOtherSet(SimilarSet set, NodeHandle handle) {
        SimilarSet otherSet = this.ccwSet;
        if (otherSet == set) {
            otherSet = this.cwSet;
        }
        return otherSet.test(handle);
    }

    public boolean directTest(NodeHandle handle) {
        return this.cwSet.test(handle) || this.ccwSet.test(handle);
    }

    public LeafSet copy() {
        return new LeafSet(this);
    }

    public static LeafSet build(InputBuffer buf, NodeHandleFactory nhf) throws IOException {
        int i;
        byte theSize = buf.readByte();
        int numUniqueHandles = buf.readByte();
        int cwSize = buf.readByte();
        int ccwSize = buf.readByte();
        Object baseHandle = nhf.readNodeHandle(buf);
        NodeHandle[] nhTable = new NodeHandle[numUniqueHandles];
        for (int i2 = 0; i2 < numUniqueHandles; ++i2) {
            nhTable[i2] = nhf.readNodeHandle(buf);
        }
        NodeHandle[] cwTable = new NodeHandle[cwSize];
        NodeHandle[] ccwTable = new NodeHandle[ccwSize];
        for (i = 0; i < cwSize; ++i) {
            cwTable[i] = nhTable[buf.readByte()];
        }
        for (i = 0; i < ccwSize; ++i) {
            ccwTable[i] = nhTable[buf.readByte()];
        }
        return new LeafSet((NodeHandle)baseHandle, theSize, true, cwTable, ccwTable);
    }

    public LeafSet(NodeHandle localNode, int size, boolean observe, NodeHandle[] cwTable, NodeHandle[] ccwTable) {
        this.observe = observe;
        this.baseHandle = localNode;
        this.baseId = localNode.getNodeId();
        this.theSize = size;
        this.cwSet = new SimilarSet(this, localNode, size / 2, true, cwTable);
        this.ccwSet = new SimilarSet(this, localNode, size / 2, false, ccwTable);
    }

    public synchronized void serialize(OutputBuffer buf) throws IOException {
        int i;
        HashSet superset = new HashSet();
        superset.addAll(this.cwSet.getCollection());
        superset.addAll(this.ccwSet.getCollection());
        ArrayList list = new ArrayList(superset);
        buf.writeByte((byte)this.theSize);
        buf.writeByte((byte)list.size());
        buf.writeByte((byte)this.cwSize());
        buf.writeByte((byte)this.ccwSize());
        this.baseHandle.serialize(buf);
        for (NodeHandle nh : list) {
            nh.serialize(buf);
        }
        for (i = 0; i < this.cwSet.size(); ++i) {
            buf.writeByte((byte)list.indexOf(this.cwSet.get(i)));
        }
        for (i = 0; i < this.ccwSet.size(); ++i) {
            buf.writeByte((byte)list.indexOf(this.ccwSet.get(i)));
        }
    }

    public synchronized List<NodeHandle> asList() {
        ArrayList<NodeHandle> l = new ArrayList<NodeHandle>();
        for (int i = -this.ccwSize(); i <= this.cwSize(); ++i) {
            if (i == 0) continue;
            l.add(this.get(i));
        }
        return l;
    }

    public void destroy() {
        this.cwSet.destroy();
        this.ccwSet.destroy();
    }
}

