/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.direct.DirectTransportLayer;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeHandleFactoryListener;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocol;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.standard.StandardLeafSetProtocol;
import rice.pastry.transport.NodeHandleAdapter;
import rice.pastry.transport.TLDeserializer;
import rice.pastry.transport.TransportPastryNodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectPastryNodeFactory
extends TransportPastryNodeFactory {
    protected NodeIdFactory nidFactory;
    protected NetworkSimulator simulator;
    protected Collection<NodeHandleFactoryListener<NodeHandle>> listeners = new ArrayList<NodeHandleFactoryListener<NodeHandle>>();
    HashMap<Id, NodeRecord> recordTable = new HashMap();

    public DirectPastryNodeFactory(NodeIdFactory nf, NetworkSimulator sim, Environment env) {
        super(env);
        env.getParameters().setInt("pastry_protocol_consistentJoin_max_time_to_be_scheduled", 120000);
        this.nidFactory = nf;
        this.simulator = sim;
    }

    @Override
    protected LeafSetProtocol getLeafSetProtocol(PastryNode pn, LeafSet leafSet, RoutingTable routeTable) {
        if (pn.getEnvironment().getParameters().getBoolean("pastry_direct_guarantee_consistency")) {
            return super.getLeafSetProtocol(pn, leafSet, routeTable);
        }
        StandardLeafSetProtocol ret = new StandardLeafSetProtocol(pn, pn.getLocalHandle(), leafSet, routeTable);
        ret.register();
        return ret;
    }

    public NetworkSimulator getNetworkSimulator() {
        return this.simulator;
    }

    @Override
    public PastryNode newNode(NodeHandle bootstrap) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId());
    }

    @Override
    public PastryNode newNode() throws IOException {
        return this.newNode(this.nidFactory.generateNodeId());
    }

    @Override
    public PastryNode newNode(NodeHandle bootstrap, Id nodeId) {
        try {
            if (bootstrap == null && this.logger.level <= 900) {
                this.logger.log("No bootstrap node provided, starting a new ring...");
            }
            PastryNode pn = this.newNode(nodeId);
            if (bootstrap == null) {
                pn.getBootstrapper().boot(Collections.EMPTY_LIST);
            } else {
                pn.getBootstrapper().boot(Collections.singleton(bootstrap));
            }
            return pn;
        }
        catch (IOException ioe) {
            this.logger.logException("Couldn't construct node.", ioe);
            return null;
        }
    }

    @Override
    public PastryNode newNode(Id nodeId) throws IOException {
        Environment environment = this.environment;
        if (this.environment.getParameters().getBoolean("pastry_factory_multipleNodes") && this.environment.getLogManager() instanceof CloneableLogManager) {
            environment = new Environment(this.environment.getSelectorManager(), this.environment.getProcessor(), this.environment.getRandomSource(), this.environment.getTimeSource(), ((CloneableLogManager)this.environment.getLogManager()).clone("0x" + nodeId.toStringBare()), this.environment.getParameters(), this.environment.getExceptionStrategy());
        }
        PastryNode pn = new PastryNode(nodeId, environment);
        this.nodeHandleHelper(pn);
        return pn;
    }

    public LeafSet getLeafSet(NodeHandle handle) throws IOException {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        return dHandle.getRemote().getLeafSet();
    }

    public CancellableTask getLeafSet(NodeHandle handle, Continuation c) {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        c.receiveResult(dHandle.getRemote().getLeafSet());
        return new NullCancellableTask();
    }

    public RouteSet[] getRouteRow(NodeHandle handle, int row) throws IOException {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        return dHandle.getRemote().getRoutingTable().getRow(row);
    }

    public CancellableTask getRouteRow(NodeHandle handle, int row, Continuation c) {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        c.receiveResult(dHandle.getRemote().getRoutingTable().getRow(row));
        return new NullCancellableTask();
    }

    public int getProximity(NodeHandle local, NodeHandle remote) {
        return (int)this.simulator.proximity((DirectNodeHandle)local, (DirectNodeHandle)remote);
    }

    @Override
    protected NodeHandle getLocalHandle(PastryNode pn, NodeHandleFactory handleFactory) throws IOException {
        DirectNodeHandle localhandle = new DirectNodeHandle(pn, this.simulator);
        return localhandle;
    }

    @Override
    protected NodeHandleFactory getNodeHandleFactory(PastryNode pn) throws IOException {
        return new NodeHandleFactory<NodeHandle>(){

            @Override
            public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
                return null;
            }

            @Override
            public NodeHandle coalesce(NodeHandle handle) {
                this.notifyListeners(handle);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void notifyListeners(NodeHandle nh) {
                Collection<NodeHandleFactoryListener<NodeHandle>> temp = DirectPastryNodeFactory.this.listeners;
                Collection<NodeHandleFactoryListener<NodeHandle>> collection = DirectPastryNodeFactory.this.listeners;
                synchronized (collection) {
                    temp = new ArrayList<NodeHandleFactoryListener<NodeHandle>>(DirectPastryNodeFactory.this.listeners);
                }
                for (NodeHandleFactoryListener<NodeHandle> foo : temp) {
                    foo.nodeHandleFound(nh);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addNodeHandleFactoryListener(NodeHandleFactoryListener<NodeHandle> listener) {
                Collection<NodeHandleFactoryListener<NodeHandle>> collection = DirectPastryNodeFactory.this.listeners;
                synchronized (collection) {
                    DirectPastryNodeFactory.this.listeners.add(listener);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeNodeHandleFactoryListener(NodeHandleFactoryListener<NodeHandle> listener) {
                Collection<NodeHandleFactoryListener<NodeHandle>> collection = DirectPastryNodeFactory.this.listeners;
                synchronized (collection) {
                    DirectPastryNodeFactory.this.listeners.remove(listener);
                }
            }
        };
    }

    @Override
    protected NodeHandleAdapter getNodeHandleAdapter(final PastryNode pn, NodeHandleFactory handleFactory, TLDeserializer deserializer) throws IOException {
        NodeRecord nr = this.recordTable.get(pn.getId());
        if (nr == null) {
            nr = this.simulator.generateNodeRecord();
            this.recordTable.put(pn.getNodeId(), nr);
        }
        TransportLayer<NodeHandle, RawMessage> tl = this.getDirectTransportLayer(pn, nr);
        NodeHandleAdapter nha = new NodeHandleAdapter(tl, this.simulator.getLivenessProvider(), new ProximityProvider<NodeHandle>(){
            List<ProximityListener<NodeHandle>> proxListeners = new ArrayList<ProximityListener<NodeHandle>>();

            @Override
            public int proximity(NodeHandle i, Map<String, Object> options) {
                return (int)DirectPastryNodeFactory.this.simulator.proximity((DirectNodeHandle)pn.getLocalHandle(), (DirectNodeHandle)i);
            }

            @Override
            public void addProximityListener(ProximityListener<NodeHandle> name) {
                this.proxListeners.add(name);
            }

            @Override
            public boolean removeProximityListener(ProximityListener<NodeHandle> name) {
                return this.proxListeners.remove(name);
            }

            @Override
            public void clearState(NodeHandle i) {
            }
        });
        return nha;
    }

    protected TransportLayer<NodeHandle, RawMessage> getDirectTransportLayer(PastryNode pn, NodeRecord nr) {
        DirectTransportLayer<NodeHandle, RawMessage> tl = new DirectTransportLayer<NodeHandle, RawMessage>(pn.getLocalHandle(), this.simulator, nr, pn.getEnvironment());
        return tl;
    }

    @Override
    protected Bootstrapper getBootstrapper(final PastryNode pn, NodeHandleAdapter tl, NodeHandleFactory handleFactory, final ProximityNeighborSelector pns) {
        return new Bootstrapper<NodeHandle>(){

            @Override
            public void boot(Collection<NodeHandle> bootaddresses) {
                pns.getNearHandles(bootaddresses, new Continuation<Collection<NodeHandle>, Exception>(){

                    @Override
                    public void receiveResult(Collection<NodeHandle> result) {
                        if (((DirectPastryNodeFactory)DirectPastryNodeFactory.this).logger.level <= 800) {
                            DirectPastryNodeFactory.this.logger.log("boot() calling pn.doneNode(" + result + ")");
                        }
                        pn.doneNode(result);
                    }

                    @Override
                    public void receiveException(Exception exception) {
                    }
                });
            }
        };
    }

    static class NullCancellableTask
    implements CancellableTask {
        NullCancellableTask() {
        }

        public void run() {
        }

        public boolean cancel() {
            return false;
        }

        public long scheduledExecutionTime() {
            return 0L;
        }
    }
}

