/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.commonapi;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.util.OptionsFactory;
import rice.Continuation;
import rice.Destructable;
import rice.Executable;
import rice.environment.Environment;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.DeliveryNotification;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.MessageReceipt;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteMessageNotification;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.SendOptions;
import rice.pastry.standard.StandardAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PastryEndpoint
extends PastryAppl
implements Endpoint {
    protected Application application;
    MessageDeserializer appDeserializer = this.deserializer;
    boolean consistentRouting = true;

    public PastryEndpoint(PastryNode pn, Application application, String instance, boolean register) {
        this(pn, application, instance, 0, register);
    }

    public PastryEndpoint(PastryNode pn, Application application, String instance, int address, boolean register) {
        super(pn, instance, address == 0 ? StandardAddress.getAddress(application.getClass(), instance, pn.getEnvironment()) : address, null, pn.getEnvironment().getLogManager().getLogger(application.getClass(), instance == null ? "-endpoint" : instance + "-endpoint"));
        this.deserializer = new PEDeserializer();
        this.application = application;
        if (register) {
            this.register();
        }
    }

    @Override
    public rice.p2p.commonapi.Id getId() {
        return this.thePastryNode.getNodeId();
    }

    @Override
    public MessageReceipt route(rice.p2p.commonapi.Id key, rice.p2p.commonapi.Message msg, rice.p2p.commonapi.NodeHandle hint) {
        return this.route(key, msg, hint, null);
    }

    @Override
    public MessageReceipt route(rice.p2p.commonapi.Id key, rice.p2p.commonapi.Message msg, rice.p2p.commonapi.NodeHandle hint, DeliveryNotification deliverAckToMe) {
        return this.route(key, msg, hint, deliverAckToMe, null);
    }

    @Override
    public MessageReceipt route(rice.p2p.commonapi.Id key, rice.p2p.commonapi.Message msg, rice.p2p.commonapi.NodeHandle hint, DeliveryNotification deliverAckToMe, Map<String, Object> options) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] route " + msg + " to " + key);
        }
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), msg, this.thePastryNode.getLocalHandle());
        return this.routeHelper(key, pm, hint, deliverAckToMe, options);
    }

    @Override
    public MessageReceipt route(rice.p2p.commonapi.Id key, RawMessage msg, rice.p2p.commonapi.NodeHandle hint) {
        return this.route(key, msg, hint, null);
    }

    @Override
    public MessageReceipt route(rice.p2p.commonapi.Id key, RawMessage msg, rice.p2p.commonapi.NodeHandle hint, DeliveryNotification deliverAckToMe) {
        return this.route(key, msg, hint, deliverAckToMe, null);
    }

    @Override
    public MessageReceipt route(rice.p2p.commonapi.Id key, RawMessage msg, rice.p2p.commonapi.NodeHandle hint, DeliveryNotification deliverAckToMe, Map<String, Object> options) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] route " + msg + " to " + key);
        }
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), msg, this.thePastryNode.getLocalHandle());
        return this.routeHelper(key, pm, hint, deliverAckToMe, options);
    }

    private MessageReceipt routeHelper(rice.p2p.commonapi.Id key, final PastryEndpointMessage pm, final rice.p2p.commonapi.NodeHandle hint, final DeliveryNotification deliverAckToMe, Map<String, Object> options) {
        if (options == null) {
            options = this.options;
        }
        if (this.logger.level <= 500) {
            this.logger.log("routeHelper(" + key + "," + pm + "," + hint + "," + deliverAckToMe + ").init()");
        }
        if (key == null && hint == null) {
            throw new IllegalArgumentException("key and hint are null!");
        }
        boolean noKey = false;
        if (key == null) {
            noKey = true;
            key = hint.getId();
        }
        final RouteMessage rm = new RouteMessage((Id)key, (Message)pm, (NodeHandle)hint, (byte)this.thePastryNode.getEnvironment().getParameters().getInt("pastry_protocol_router_routeMsgVersion"));
        rm.setPrevNode(this.thePastryNode.getLocalHandle());
        if (noKey) {
            rm.getOptions().setMultipleHopsAllowed(false);
            rm.setDestinationHandle((NodeHandle)hint);
        }
        final rice.p2p.commonapi.Id final_key = key;
        final MessageReceipt ret = new MessageReceipt(){

            public boolean cancel() {
                if (((PastryEndpoint)PastryEndpoint.this).logger.level <= 500) {
                    PastryEndpoint.this.logger.log("routeHelper(" + final_key + "," + pm + "," + hint + "," + deliverAckToMe + ").cancel()");
                }
                return rm.cancel();
            }

            public rice.p2p.commonapi.Message getMessage() {
                return pm.getMessage();
            }

            public rice.p2p.commonapi.Id getId() {
                return final_key;
            }

            public rice.p2p.commonapi.NodeHandle getHint() {
                return hint;
            }
        };
        if (deliverAckToMe != null || this.logger.level <= 500) {
            rm.setRouteMessageNotification(new RouteMessageNotification(){

                public void sendSuccess(RouteMessage message, NodeHandle nextHop) {
                    if (((PastryEndpoint)PastryEndpoint.this).logger.level <= 500) {
                        PastryEndpoint.this.logger.log("routeHelper(" + final_key + "," + pm + "," + hint + "," + deliverAckToMe + ").sendSuccess():" + nextHop);
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.sent(ret);
                    }
                }

                public void sendFailed(RouteMessage message, Exception e) {
                    if (((PastryEndpoint)PastryEndpoint.this).logger.level <= 500) {
                        PastryEndpoint.this.logger.log("routeHelper(" + final_key + "," + pm + "," + hint + "," + deliverAckToMe + ").sendFailed(" + e + ")");
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.sendFailed(ret, e);
                    }
                }
            });
        }
        rm.setTLOptions(OptionsFactory.addOption(options, "OPTION_PRIORITY", pm.getPriority()));
        this.thePastryNode.getRouter().route(rm);
        return ret;
    }

    @Override
    public CancellableTask scheduleMessage(rice.p2p.commonapi.Message message, long delay) {
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), message, this.thePastryNode.getLocalHandle());
        return this.thePastryNode.scheduleMsg(pm, delay);
    }

    @Override
    public CancellableTask scheduleMessage(rice.p2p.commonapi.Message message, long delay, long period) {
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), message, this.thePastryNode.getLocalHandle());
        return this.thePastryNode.scheduleMsg(pm, delay, period);
    }

    @Override
    public CancellableTask scheduleMessageAtFixedRate(rice.p2p.commonapi.Message msg, long delay, long period) {
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), msg, this.thePastryNode.getLocalHandle());
        return this.thePastryNode.scheduleMsgAtFixedRate(pm, delay, period);
    }

    @Override
    public NodeHandleSet localLookup(rice.p2p.commonapi.Id key, int num, boolean safe) {
        NodeSet ret = this.getRoutingTable().alternateRoutes((Id)key, num);
        if (ret.size() == 0) {
            int index = this.getLeafSet().mostSimilar((Id)key);
            NodeHandle nh = this.getLeafSet().get(index);
            NodeSet set = new NodeSet();
            set.put(nh);
            ret = set;
        }
        return ret;
    }

    @Override
    public NodeHandleSet neighborSet(int num) {
        return this.getLeafSet().neighborSet(num);
    }

    @Override
    public NodeHandleSet replicaSet(rice.p2p.commonapi.Id id, int maxRank) {
        LeafSet leafset = this.getLeafSet();
        if (maxRank > leafset.maxSize() / 2 + 1) {
            throw new IllegalArgumentException("maximum replicaSet size for this configuration exceeded; asked for " + maxRank + " but max is " + (leafset.maxSize() / 2 + 1));
        }
        if (maxRank > leafset.size() && this.logger.level <= 400) {
            this.logger.log("trying to get a replica set of size " + maxRank + " but only " + leafset.size() + " nodes in leafset");
        }
        return leafset.replicaSet((Id)id, maxRank);
    }

    @Override
    public NodeHandleSet replicaSet(rice.p2p.commonapi.Id id, int maxRank, rice.p2p.commonapi.NodeHandle root, NodeHandleSet set) {
        LeafSet leaf = new LeafSet((NodeHandle)root, this.getLeafSet().maxSize(), false);
        for (int i = 0; i < set.size(); ++i) {
            leaf.put((NodeHandle)set.getHandle(i));
        }
        return leaf.replicaSet((Id)id, maxRank);
    }

    @Override
    public rice.p2p.commonapi.IdRange range(rice.p2p.commonapi.NodeHandle n, int r, rice.p2p.commonapi.Id key, boolean cumulative) {
        Id pKey = (Id)key;
        if (cumulative) {
            return this.getLeafSet().range((NodeHandle)n, r);
        }
        IdRange ccw = this.getLeafSet().range((NodeHandle)n, r, false);
        IdRange cw = this.getLeafSet().range((NodeHandle)n, r, true);
        if (cw == null || ccw.contains(pKey) || pKey.isBetween(cw.getCW(), ccw.getCCW())) {
            return ccw;
        }
        return cw;
    }

    @Override
    public rice.p2p.commonapi.IdRange range(rice.p2p.commonapi.NodeHandle n, int r, rice.p2p.commonapi.Id key) {
        return this.range(n, r, key, false);
    }

    @Override
    public rice.p2p.commonapi.NodeHandle getLocalNodeHandle() {
        return this.thePastryNode.getLocalHandle();
    }

    @Override
    public final void messageForAppl(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] deliver " + msg + " from " + msg.getSenderId());
        }
        if (msg instanceof PastryEndpointMessage) {
            this.application.deliver(null, ((PastryEndpointMessage)msg).getMessage());
        } else if (this.logger.level <= 900) {
            this.logger.log("Received unknown message " + msg + " - dropping on floor");
        }
    }

    @Override
    public final boolean enrouteMessage(Message msg, Id key, NodeHandle nextHop, SendOptions opt) {
        throw new RuntimeException("Should not be called, should only be handled by PastryEndpoint.receiveMessage()");
    }

    @Override
    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
        this.application.update(nh, wasAdded);
    }

    @Override
    public void receiveMessage(Message msg) {
        block15: {
            if (this.logger.level <= 400) {
                this.logger.log("[" + this.thePastryNode + "] recv " + msg);
            }
            if (msg instanceof RouteMessage) {
                try {
                    RouteMessage rm = (RouteMessage)msg;
                    NodeHandle destinationHandle = rm.getDestinationHandle();
                    if (!(this.deliverWhenNotReady() || this.thePastryNode.isReady() || rm.getPrevNode() == this.thePastryNode.getLocalHandle() || destinationHandle != null && destinationHandle == this.thePastryNode.getLocalHandle())) {
                        if (this.logger.level <= 800) {
                            this.logger.log("Dropping " + msg + " because node is not ready.");
                        }
                        return;
                    }
                    if (this.logger.level <= 400) {
                        this.logger.log("[" + this.thePastryNode + "] forward " + msg);
                    }
                    if (this.application.forward(rm)) {
                        if (rm.getNextHop() != null) {
                            NodeHandle nextHop = rm.getNextHop();
                            if (this.getNodeId().equals(nextHop.getNodeId())) {
                                PastryEndpointMessage pMsg = (PastryEndpointMessage)rm.unwrap(this.deserializer);
                                if (this.logger.level <= 400) {
                                    this.logger.log("[" + this.thePastryNode + "] deliver " + pMsg + " from " + pMsg.getSenderId());
                                }
                                this.application.deliver(rm.getTarget(), pMsg.getMessage());
                                rm.sendSuccess(this.thePastryNode.getLocalHandle());
                            } else {
                                if (rm.getDestinationHandle() == this.thePastryNode.getLocalHandle()) {
                                    if (this.logger.level <= 900) {
                                        this.logger.log("Warning, removing destNodeHandle: " + rm.getDestinationHandle() + " from " + rm);
                                    }
                                    rm.setDestinationHandle(null);
                                }
                                this.thePastryNode.getRouter().route(rm);
                            }
                        }
                        break block15;
                    }
                    rm.sendSuccess(this.thePastryNode.getLocalHandle());
                }
                catch (IOException ioe) {
                    if (this.logger.level <= 1000) {
                        this.logger.logException(this.toString(), ioe);
                    }
                    break block15;
                }
            }
            this.messageForAppl(msg);
        }
    }

    @Override
    public void process(Executable task, Continuation command) {
        this.thePastryNode.process(task, command);
    }

    @Override
    public String getInstance() {
        return this.instance;
    }

    @Override
    public Environment getEnvironment() {
        return this.thePastryNode.getEnvironment();
    }

    public String toString() {
        return "PastryEndpoint " + this.application + " " + this.instance + " " + this.getAddress();
    }

    @Override
    public void setDeserializer(MessageDeserializer md) {
        this.appDeserializer = md;
    }

    @Override
    public MessageDeserializer getDeserializer() {
        return this.appDeserializer;
    }

    @Override
    public rice.p2p.commonapi.Id readId(InputBuffer buf, short type) throws IOException {
        if (type != 1) {
            throw new IllegalArgumentException("Invalid type:" + type);
        }
        return Id.build(buf);
    }

    @Override
    public rice.p2p.commonapi.NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return this.thePastryNode.readNodeHandle(buf);
    }

    @Override
    public rice.p2p.commonapi.IdRange readIdRange(InputBuffer buf) throws IOException {
        return new IdRange(buf);
    }

    @Override
    public rice.p2p.commonapi.NodeHandle coalesce(rice.p2p.commonapi.NodeHandle newHandle) {
        return this.thePastryNode.coalesce((NodeHandle)newHandle);
    }

    @Override
    public NodeHandleSet readNodeHandleSet(InputBuffer buf, short type) throws IOException {
        switch (type) {
            case 1: {
                return new NodeSet(buf, this.thePastryNode);
            }
            case 2: {
                return new RouteSet(buf, this.thePastryNode, this.thePastryNode);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    @Override
    public List networkNeighbors(int num) {
        HashSet<Object> handles = new HashSet<Object>();
        List<NodeHandle> l = this.thePastryNode.getRoutingTable().asList();
        Iterator<Object> i = l.iterator();
        while (i.hasNext()) {
            handles.add(i.next());
        }
        l = this.thePastryNode.getLeafSet().asList();
        i = l.iterator();
        while (i.hasNext()) {
            handles.add(i.next());
        }
        rice.p2p.commonapi.NodeHandle[] array = handles.toArray(new rice.p2p.commonapi.NodeHandle[0]);
        Arrays.sort(array, new Comparator<rice.p2p.commonapi.NodeHandle>(){

            @Override
            public int compare(rice.p2p.commonapi.NodeHandle a, rice.p2p.commonapi.NodeHandle b) {
                return PastryEndpoint.this.thePastryNode.proximity((NodeHandle)a) - PastryEndpoint.this.thePastryNode.proximity((NodeHandle)b);
            }
        });
        if (array.length <= num) {
            return Arrays.asList(array);
        }
        rice.p2p.commonapi.NodeHandle[] ret = new rice.p2p.commonapi.NodeHandle[num];
        System.arraycopy(array, 0, ret, 0, num);
        return Arrays.asList(ret);
    }

    @Override
    public void destroy() {
        if (this.application != null && this.application instanceof Destructable) {
            ((Destructable)((Object)this.application)).destroy();
        }
        super.destroy();
    }

    @Override
    public int proximity(rice.p2p.commonapi.NodeHandle nh) {
        return this.thePastryNode.proximity((NodeHandle)nh);
    }

    @Override
    public boolean isAlive(rice.p2p.commonapi.NodeHandle nh) {
        return this.thePastryNode.isAlive((NodeHandle)nh);
    }

    public int getAppId() {
        return this.getAddress();
    }

    @Override
    public void setConsistentRouting(boolean val) {
        this.consistentRouting = val;
    }

    @Override
    public boolean deliverWhenNotReady() {
        return !this.consistentRouting;
    }

    @Override
    public boolean routingConsistentFor(rice.p2p.commonapi.Id id) {
        if (!this.thePastryNode.isReady()) {
            return false;
        }
        NodeHandleSet set = this.replicaSet(id, 1);
        if (set.size() == 0) {
            return false;
        }
        return set.getHandle(0).equals(this.thePastryNode.getLocalHandle());
    }

    @Override
    public void setSendOptions(Map<String, Object> options) {
        this.options = options;
    }

    class PEDeserializer
    implements MessageDeserializer {
        PEDeserializer() {
        }

        public rice.p2p.commonapi.Message deserialize(InputBuffer buf, short type, int priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
            try {
                return new PastryEndpointMessage(PastryEndpoint.this.getAddress(), buf, PastryEndpoint.this.appDeserializer, type, priority, (NodeHandle)sender);
            }
            catch (IllegalArgumentException iae) {
                PastryEndpoint.this.logger.log("Unable to deserialize message of type " + type + " " + PastryEndpoint.this + " " + PastryEndpoint.this.appDeserializer);
                throw iae;
            }
        }
    }
}

