/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.client;

import java.io.IOException;
import java.util.Map;
import org.mpisws.p2p.transport.util.OptionsFactory;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.DeliveryNotification;
import rice.p2p.commonapi.MessageReceipt;
import rice.p2p.commonapi.appsocket.AppSocket;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.client.NodeIsNotReadyException;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.JavaSerializedDeserializer;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.RawMessageDelivery;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteMessageNotification;
import rice.pastry.routing.RoutingTable;
import rice.pastry.routing.SendOptions;
import rice.pastry.standard.StandardAddress;

public abstract class PastryAppl {
    protected MessageDeserializer deserializer;
    protected String instance;
    protected PastryNode thePastryNode;
    protected int address;
    protected Logger logger;
    protected Map<String, Object> options;
    protected AppSocketReceiver receiver;

    public PastryAppl(PastryNode pn) {
        this(pn, null);
    }

    public PastryAppl(PastryNode pn, String instance) {
        this(pn, instance, 0, null);
        this.register();
    }

    public PastryAppl(PastryNode pn, String instance, int address, MessageDeserializer md) {
        this(pn, instance, address, md, null);
    }

    public PastryAppl(PastryNode pn, String instance, int address, MessageDeserializer md, Logger logger) {
        this.address = address;
        if (instance != null) {
            this.instance = instance;
        }
        if (address == 0) {
            this.address = StandardAddress.getAddress(this.getClass(), instance, pn.getEnvironment());
        }
        this.thePastryNode = pn;
        this.logger = logger;
        if (this.logger == null) {
            this.logger = pn.getEnvironment().getLogManager().getLogger(this.getClass(), instance);
        }
        this.deserializer = md;
        if (this.deserializer == null) {
            this.deserializer = new JavaSerializedDeserializer(pn);
        }
    }

    public PastryAppl(PastryNode pn, int port) {
        this(pn, null, port, null);
    }

    public void register() {
        this.thePastryNode.registerReceiver(this.getAddress(), this);
        this.thePastryNode.addLeafSetListener(new LeafSetObserver());
        this.thePastryNode.addRouteSetListener(new RouteSetObserver());
        this.thePastryNode.registerApp(this);
    }

    public int getAddress() {
        return this.address;
    }

    public void receiveMessageInternal(RawMessageDelivery msg) {
        Message m;
        try {
            m = msg.deserialize(this.deserializer);
        }
        catch (IOException ioe) {
            if (this.logger.level <= 1000) {
                this.logger.logException("Error deserializing " + msg + " in " + this + ".  Message will be dropped.", ioe);
            }
            return;
        }
        catch (RuntimeException re) {
            if (this.logger.level <= 1000) {
                this.logger.logException("Error deserializing " + msg + " in " + this + ".  Message will be dropped.", re);
            }
            throw re;
        }
        this.receiveMessage(m);
    }

    protected void setDeserializer(MessageDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    public MessageDeserializer getDeserializer() {
        return this.deserializer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receiveMessage(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] recv " + msg);
        }
        if (msg instanceof RouteMessage) {
            RouteMessage rm = (RouteMessage)msg;
            NodeHandle destinationHandle = rm.getDestinationHandle();
            if (!(this.deliverWhenNotReady() || this.thePastryNode.isReady() || rm.getPrevNode() == this.thePastryNode.getLocalHandle() || destinationHandle != null && destinationHandle == this.thePastryNode.getLocalHandle())) {
                if (rm.sendFailed(new NodeIsNotReadyException(this.thePastryNode.getLocalHandle()))) {
                    if (this.logger.level > 700) return;
                    this.logger.log("Dropping " + msg + " because node is not ready.");
                    return;
                } else {
                    if (this.logger.level > 900) return;
                    this.logger.log("Dropping " + msg + " because node is not ready.");
                }
                return;
            }
            try {
                Message innerMessage = rm.unwrap(this.deserializer);
                if (!this.enrouteMessage(innerMessage, rm.getTarget(), rm.getNextHop(), rm.getOptions())) return;
                if (rm.getDestinationHandle() == this.thePastryNode.getLocalHandle()) {
                    this.messageForAppl(innerMessage);
                    return;
                }
                this.thePastryNode.getRouter().route(rm);
                return;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error deserializing message " + rm, ioe);
            }
        } else {
            this.messageForAppl(msg);
        }
    }

    public final Id getNodeId() {
        return this.thePastryNode.getNodeId();
    }

    public NodeHandle getNodeHandle() {
        return this.thePastryNode.getLocalHandle();
    }

    public boolean routeMsgDirect(NodeHandle dest, Message msg, SendOptions opt) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] routemsgdirect " + msg + " to " + dest);
        }
        if (!dest.isAlive()) {
            return false;
        }
        this.thePastryNode.send(dest, msg, null, this.options);
        return dest.isAlive();
    }

    public void routeMsg(Id key, Message msg, SendOptions opt) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] routemsg " + msg + " to " + key);
        }
        RouteMessage rm = new RouteMessage(key, msg, opt, (byte)this.thePastryNode.getEnvironment().getParameters().getInt("pastry_protocol_router_routeMsgVersion"));
        rm.setTLOptions(this.options);
        this.thePastryNode.getRouter().route(rm);
    }

    public MessageReceipt routeMsg(final Id key, final Message msg, SendOptions opt, final DeliveryNotification deliverAckToMe) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] routemsg " + msg + " to " + key);
        }
        final RouteMessage rm = new RouteMessage(key, msg, opt, (byte)this.thePastryNode.getEnvironment().getParameters().getInt("pastry_protocol_router_routeMsgVersion"));
        final MessageReceipt ret = new MessageReceipt(){

            public boolean cancel() {
                if (PastryAppl.this.logger.level <= 500) {
                    PastryAppl.this.logger.log("routeMsg(" + key + "," + msg + "," + deliverAckToMe + ").cancel()");
                }
                return rm.cancel();
            }

            public Message getMessage() {
                return msg;
            }

            public Id getId() {
                return key;
            }

            public NodeHandle getHint() {
                return null;
            }
        };
        if (deliverAckToMe != null || this.logger.level <= 500) {
            rm.setRouteMessageNotification(new RouteMessageNotification(){

                public void sendSuccess(RouteMessage message, NodeHandle nextHop) {
                    if (PastryAppl.this.logger.level <= 500) {
                        PastryAppl.this.logger.log("routeMsg(" + key + "," + msg + "," + deliverAckToMe + ").sendSuccess():" + nextHop);
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.sent(ret);
                    }
                }

                public void sendFailed(RouteMessage message, Exception e) {
                    if (PastryAppl.this.logger.level <= 500) {
                        PastryAppl.this.logger.log("routeMsg(" + key + "," + msg + "," + deliverAckToMe + ").sendFailed(" + e + ")");
                    }
                    if (deliverAckToMe != null) {
                        deliverAckToMe.sendFailed(ret, e);
                    }
                }
            });
        }
        rm.setTLOptions(OptionsFactory.addOption(this.options, "OPTION_PRIORITY", msg.getPriority()));
        this.thePastryNode.getRouter().route(rm);
        return ret;
    }

    public LeafSet getLeafSet() {
        return this.thePastryNode.getLeafSet().copy();
    }

    public RoutingTable getRoutingTable() {
        return this.thePastryNode.getRoutingTable();
    }

    public boolean isClosest(Id key) {
        return this.thePastryNode.isClosest(key);
    }

    public abstract void messageForAppl(Message var1);

    public boolean enrouteMessage(Message msg, Id key, NodeHandle nextHop, SendOptions opt) {
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void notifyReady() {
    }

    public boolean deliverWhenNotReady() {
        return false;
    }

    public void destroy() {
    }

    public void connect(rice.p2p.commonapi.NodeHandle handle, AppSocketReceiver receiver, int timeout) {
        this.thePastryNode.connect((NodeHandle)handle, receiver, this, timeout);
    }

    public void accept(AppSocketReceiver receiver) {
        this.receiver = receiver;
    }

    public boolean canReceiveSocket() {
        return this.receiver != null;
    }

    public void finishReceiveSocket(AppSocket socket) throws IOException {
        AppSocketReceiver theReceiver = this.receiver;
        this.receiver = null;
        theReceiver.receiveSocket(socket);
    }

    private class RouteSetObserver
    implements NodeSetListener {
        private RouteSetObserver() {
        }

        public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
            PastryAppl.this.routeSetChange(handle, added);
        }
    }

    private class LeafSetObserver
    implements NodeSetListener {
        private LeafSetObserver() {
        }

        public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
            PastryAppl.this.leafSetChange(handle, added);
        }
    }
}

