/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

public class StringCache {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table = new Entry[16];
    transient int size;
    int threshold = 12;
    final float loadFactor;
    volatile transient int modCount;
    private static final long serialVersionUID = 362498820763181265L;

    public StringCache() {
        this.loadFactor = 0.75f;
    }

    static int hash(char[] chars, int off, int len) {
        int h = 0;
        for (int i = 0; i < len; ++i) {
            h = 31 * h + chars[off++];
        }
        return h;
    }

    static boolean eq(char[] chars, int off, int len, String s) {
        if (len != s.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (chars[i + off] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String get(char[] chars) {
        return this.get(chars, 0, chars.length);
    }

    public String get(char[] chars, int offset, int length) {
        int hash = StringCache.hash(chars, offset, length);
        int i = StringCache.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (true) {
            if (e == null) {
                String s = new String(chars, offset, length);
                this.addEntry(hash, s, i);
                return s;
            }
            if (e.hash == hash && StringCache.eq(chars, offset, length, e.value)) {
                return e.value;
            }
            e = e.next;
        }
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = StringCache.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    void addEntry(int hash, String value, int bucketIndex) {
        this.table[bucketIndex] = new Entry(hash, value, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    static class Entry {
        String value;
        final int hash;
        Entry next;

        Entry(int h, String v, Entry n) {
            this.value = v;
            this.next = n;
            this.hash = h;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            String v2;
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            String v1 = this.getValue();
            return v1 == (v2 = e.getValue()) || v1 != null && v1.equals(v2);
        }

        public int hashCode() {
            return 0x1B ^ this.value.hashCode();
        }

        public String toString() {
            return this.getValue();
        }
    }
}

