/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe.maintenance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.maintenance.MaintainableScribe;
import rice.p2p.scribe.messaging.SubscribeMessage;
import rice.p2p.scribe.rawserialization.RawScribeContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ScribeMaintenancePolicy {
    public void doMaintenance(MaintainableScribe var1);

    public void noLongerRoot(MaintainableScribe var1, List<Topic> var2);

    public void nodeFaulty(MaintainableScribe var1, NodeHandle var2, List<Topic> var3, List<Topic> var4);

    public void subscribeFailed(MaintainableScribe var1, List<Topic> var2);

    public RawScribeContent implicitSubscribe(List<Topic> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultScribeMaintenancePolicy
    implements ScribeMaintenancePolicy {
        Logger logger;

        public DefaultScribeMaintenancePolicy(Environment environment) {
            this.logger = environment.getLogManager().getLogger(DefaultScribeMaintenancePolicy.class, null);
        }

        @Override
        public void doMaintenance(MaintainableScribe scribe) {
            HashMap<NodeHandle, ArrayList<Topic>> manifest = new HashMap<NodeHandle, ArrayList<Topic>>();
            for (Topic topic : scribe.getTopics()) {
                NodeHandle parent = scribe.getParent(topic);
                if (parent == null) continue;
                ArrayList<Topic> topics = (ArrayList<Topic>)manifest.get(parent);
                if (topics == null) {
                    topics = new ArrayList<Topic>();
                    manifest.put(parent, topics);
                }
                topics.add(topic);
            }
            for (NodeHandle parent : manifest.keySet()) {
                List topics = (List)manifest.get(parent);
                scribe.getEndpoint().route(((Topic)topics.get(0)).getId(), new SubscribeMessage(scribe.getEndpoint().getLocalNodeHandle(), topics, Integer.MAX_VALUE, this.implicitSubscribe(topics)), parent);
                parent.checkLiveness();
            }
        }

        @Override
        public void noLongerRoot(MaintainableScribe scribe, List<Topic> topics) {
            scribe.subscribe(topics, null, this.implicitSubscribe(Collections.unmodifiableList(topics)), null);
        }

        @Override
        public void nodeFaulty(MaintainableScribe scribe, NodeHandle handle, List<Topic> nodeWasParent, List<Topic> nodeWasChild) {
            scribe.subscribe(nodeWasParent, null, this.implicitSubscribe(Collections.unmodifiableList(nodeWasParent)), null);
        }

        @Override
        public void subscribeFailed(MaintainableScribe scribe, List<Topic> failedTopics) {
            scribe.subscribe(failedTopics, null, this.implicitSubscribe(Collections.unmodifiableList(failedTopics)), null);
        }

        @Override
        public RawScribeContent implicitSubscribe(List<Topic> topics) {
            return null;
        }
    }
}

