/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.scribe;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribeMultiClient;
import rice.p2p.scribe.ScribePolicy;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.javaserialized.JavaScribeContentDeserializer;
import rice.p2p.scribe.maintenance.MaintainableScribe;
import rice.p2p.scribe.maintenance.ScribeMaintenancePolicy;
import rice.p2p.scribe.messaging.AnycastFailureMessage;
import rice.p2p.scribe.messaging.AnycastMessage;
import rice.p2p.scribe.messaging.DropMessage;
import rice.p2p.scribe.messaging.MaintenanceMessage;
import rice.p2p.scribe.messaging.PublishMessage;
import rice.p2p.scribe.messaging.PublishRequestMessage;
import rice.p2p.scribe.messaging.ScribeMessage;
import rice.p2p.scribe.messaging.SubscribeAckMessage;
import rice.p2p.scribe.messaging.SubscribeFailedMessage;
import rice.p2p.scribe.messaging.SubscribeLostMessage;
import rice.p2p.scribe.messaging.SubscribeMessage;
import rice.p2p.scribe.messaging.UnsubscribeMessage;
import rice.p2p.scribe.rawserialization.JavaSerializedScribeContent;
import rice.p2p.scribe.rawserialization.RawScribeContent;
import rice.p2p.scribe.rawserialization.ScribeContentDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScribeImpl
implements Scribe,
MaintainableScribe,
Application,
Observer {
    public static final int INFO_2 = 850;
    public final int MAINTENANCE_INTERVAL;
    public final int MESSAGE_TIMEOUT;
    public Hashtable<Topic, TopicManager> topicManagers;
    protected ScribePolicy policy;
    private ScribeMaintenancePolicy maintenancePolicy;
    protected Endpoint endpoint;
    protected NodeHandle localHandle;
    private HashMap<Integer, SubscribeLostMessage> subscribeLostMessages;
    private int id;
    Environment environment;
    Logger logger;
    private String instance;
    protected Node node;
    public HashMap<NodeHandle, Collection<Topic>> allChildren;
    public HashMap<NodeHandle, Collection<Topic>> allParents;
    public Set<Topic> roots = new HashSet<Topic>();
    public Set<Topic> pending = new HashSet<Topic>();
    ScribeContentDeserializer contentDeserializer;
    private Map<ScribeClient, ScribeClientConverter> clientConverters = new WeakHashMap<ScribeClient, ScribeClientConverter>();

    public ScribeImpl(Node node, String instance) {
        this(node, new ScribePolicy.DefaultScribePolicy(node.getEnvironment()), instance);
    }

    public ScribeImpl(Node node, ScribePolicy policy, String instance) {
        this(node, policy, instance, new ScribeMaintenancePolicy.DefaultScribeMaintenancePolicy(node.getEnvironment()));
    }

    public ScribeImpl(Node node, ScribePolicy policy, String instance, ScribeMaintenancePolicy maintenancePolicy) {
        this.environment = node.getEnvironment();
        this.node = node;
        this.logger = this.environment.getLogManager().getLogger(ScribeImpl.class, instance);
        Parameters p = this.environment.getParameters();
        this.MAINTENANCE_INTERVAL = p.getInt("p2p_scribe_maintenance_interval");
        this.MESSAGE_TIMEOUT = p.getInt("p2p_scribe_message_timeout");
        this.allChildren = new HashMap();
        this.allParents = new HashMap();
        this.instance = instance;
        this.endpoint = node.buildEndpoint(this, instance);
        this.contentDeserializer = new JavaScribeContentDeserializer();
        this.endpoint.setDeserializer(new MessageDeserializer(){

            public Message deserialize(InputBuffer buf, short type, int priority, NodeHandle sender) throws IOException {
                try {
                    switch (type) {
                        case 1: {
                            return AnycastMessage.build(buf, ScribeImpl.this.endpoint, ScribeImpl.this.contentDeserializer);
                        }
                        case 2: {
                            return SubscribeMessage.buildSM(buf, ScribeImpl.this.endpoint, ScribeImpl.this.contentDeserializer);
                        }
                        case 3: {
                            return SubscribeAckMessage.build(buf, ScribeImpl.this.endpoint);
                        }
                        case 4: {
                            return SubscribeFailedMessage.build(buf, ScribeImpl.this.endpoint);
                        }
                        case 6: {
                            return DropMessage.build(buf, ScribeImpl.this.endpoint);
                        }
                        case 8: {
                            return PublishMessage.build(buf, ScribeImpl.this.endpoint, ScribeImpl.this.contentDeserializer);
                        }
                        case 9: {
                            return PublishRequestMessage.build(buf, ScribeImpl.this.endpoint, ScribeImpl.this.contentDeserializer);
                        }
                        case 10: {
                            return UnsubscribeMessage.build(buf, ScribeImpl.this.endpoint);
                        }
                        case 11: {
                            return AnycastFailureMessage.build(buf, ScribeImpl.this.endpoint, ScribeImpl.this.contentDeserializer);
                        }
                    }
                }
                catch (IOException e) {
                    if (ScribeImpl.this.logger.level <= 1000) {
                        ScribeImpl.this.logger.log("Exception in deserializer in " + ScribeImpl.this.endpoint.toString() + ":" + ScribeImpl.this.instance + " " + ScribeImpl.this.contentDeserializer + " " + e);
                    }
                    throw e;
                }
                throw new IllegalArgumentException("Unknown type:" + type);
            }
        });
        this.topicManagers = new Hashtable();
        this.subscribeLostMessages = new HashMap();
        this.policy = policy;
        this.maintenancePolicy = maintenancePolicy;
        this.localHandle = this.endpoint.getLocalNodeHandle();
        this.id = Integer.MIN_VALUE;
        this.endpoint.register();
        this.endpoint.scheduleMessage(new MaintenanceMessage(), this.environment.getRandomSource().nextInt(this.MAINTENANCE_INTERVAL), this.MAINTENANCE_INTERVAL);
        if (this.logger.level <= 400) {
            this.logger.log("Starting up Scribe");
        }
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public ScribePolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void setPolicy(ScribePolicy policy) {
        this.policy = policy;
    }

    public Id getId() {
        return this.endpoint.getId();
    }

    @Override
    public int numChildren(Topic topic) {
        if (this.topicManagers.get(topic) != null) {
            return this.topicManagers.get(topic).numChildren();
        }
        return 0;
    }

    @Override
    public boolean containsTopic(Topic topic) {
        return this.topicManagers.get(topic) != null;
    }

    @Override
    public Collection<ScribeClient> getClients(Topic topic) {
        TopicManager manager = this.topicManagers.get(topic);
        if (manager != null) {
            return this.getSimpleClients(manager.getClients());
        }
        return new ArrayList<ScribeClient>();
    }

    @Override
    public Collection<ScribeMultiClient> getClientsByTopic(Topic topic) {
        TopicManager manager = this.topicManagers.get(topic);
        if (manager != null) {
            return manager.getClients();
        }
        return new ArrayList<ScribeMultiClient>();
    }

    protected Collection<ScribeClient> getSimpleClients(Collection<ScribeMultiClient> multi) {
        ArrayList<ScribeClient> ret = new ArrayList<ScribeClient>(multi.size());
        for (ScribeMultiClient client : multi) {
            if (client instanceof ScribeClientConverter) {
                ScribeClient theClient = (ScribeClient)((ScribeClientConverter)client).client.get();
                if (theClient == null) continue;
                ret.add(theClient);
                continue;
            }
            ret.add(client);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScribeMultiClient getMultiClient(ScribeClient client) {
        if (client instanceof ScribeMultiClient) {
            return (ScribeMultiClient)client;
        }
        Map<ScribeClient, ScribeClientConverter> map = this.clientConverters;
        synchronized (map) {
            ScribeClientConverter scc = this.clientConverters.get(client);
            if (scc == null || scc.client.get() == null) {
                scc = new ScribeClientConverter(client);
                this.clientConverters.put(client, scc);
            }
            return scc;
        }
    }

    @Override
    public NodeHandle[] getChildren(Topic topic) {
        if (this.topicManagers.get(topic) != null) {
            return this.topicManagers.get(topic).getChildren().toArray(new NodeHandle[0]);
        }
        return new NodeHandle[0];
    }

    @Override
    public Collection<NodeHandle> getChildrenOfTopic(Topic topic) {
        TopicManager manager = this.topicManagers.get(topic);
        if (manager != null) {
            return manager.getChildren();
        }
        return new ArrayList<NodeHandle>(0);
    }

    @Override
    public NodeHandle getParent(Topic topic) {
        if (this.topicManagers.get(topic) != null) {
            return this.topicManagers.get(topic).getParent();
        }
        return null;
    }

    @Override
    public boolean isRoot(Topic topic) {
        NodeHandleSet set = this.endpoint.replicaSet(topic.getId(), 1);
        if (set.size() == 0) {
            return false;
        }
        return set.getHandle(0).getId().equals(this.endpoint.getId());
    }

    @Override
    public NodeHandle getRoot(Topic topic) {
        NodeHandleSet set = this.endpoint.replicaSet(topic.getId(), 1);
        if (set.size() == 0) {
            return null;
        }
        return set.getHandle(0);
    }

    private void sendSubscribe(Topic topic, ScribeMultiClient client, RawScribeContent content, NodeHandle hint) {
        this.sendSubscribe(Collections.singletonList(topic), client, content, hint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSubscribe(List<Topic> topics, ScribeMultiClient client, RawScribeContent content, NodeHandle hint) {
        int theId;
        this.pending.addAll(topics);
        ScribeImpl scribeImpl = this;
        synchronized (scribeImpl) {
            ++this.id;
            if (this.id == Integer.MAX_VALUE) {
                ++this.id;
            }
            theId = this.id;
        }
        if (topics.size() > 1) {
            Collections.sort(topics);
        }
        if (this.logger.level <= 300) {
            this.logger.log("sendSubscribe(" + topics + "," + client + "," + content + "," + hint + ") theId:" + theId);
        }
        SubscribeLostMessage slm = new SubscribeLostMessage(this.localHandle, topics, theId, client);
        CancellableTask task = this.endpoint.scheduleMessage(slm, this.MESSAGE_TIMEOUT);
        slm.putTask(task);
        this.subscribeLostMessages.put(theId, slm);
        if (hint == null) {
            HashMap<NodeHandle, List<Topic>> manifest = this.buildManifests(topics);
            for (NodeHandle nextHop : manifest.keySet()) {
                List<Topic> theTopics = manifest.get(nextHop);
                SubscribeMessage msg = new SubscribeMessage(this.localHandle, theTopics, theId, this.convert(this.policy.divideContent(theTopics, content)));
                NodeHandleSet set = this.endpoint.replicaSet(msg.getTopic().getId(), 2);
                if (set.size() > 1 && set.getHandle(1) == this.localHandle) {
                    this.endpoint.route(null, msg, nextHop);
                    continue;
                }
                this.endpoint.route(msg.getTopic().getId(), msg, nextHop);
            }
        } else {
            SubscribeMessage msg = new SubscribeMessage(this.localHandle, topics, theId, content);
            NodeHandleSet set = this.endpoint.replicaSet(msg.getTopic().getId(), 2);
            if (set.size() > 1 && set.getHandle(1) == this.localHandle) {
                this.endpoint.route(null, msg, hint);
            } else {
                this.endpoint.route(msg.getTopic().getId(), msg, hint);
            }
        }
    }

    private HashMap<NodeHandle, List<Topic>> buildManifests(List<Topic> topics) {
        HashMap<NodeHandle, List<Topic>> manifest = new HashMap<NodeHandle, List<Topic>>();
        for (Topic topic : topics) {
            List<Topic> theTopics;
            NodeHandleSet handleSet = this.endpoint.replicaSet(topic.getId(), 1);
            if (handleSet.size() == 0) {
                handleSet = this.endpoint.localLookup(topic.getId(), 1, false);
            }
            NodeHandle handle = null;
            if (handleSet.size() > 0) {
                handle = handleSet.getHandle(0);
            }
            if (handle == null) {
                handle = this.localHandle;
                if (!this.isRoot(topic) && this.logger.level <= 900) {
                    this.logger.log("buildManifests(" + topics + ") did not receive a next hop for topic " + topic + " but we are not the root of the topic. isRoot = " + this.isRoot(topic));
                    this.logger.log("handle set:" + handleSet);
                    this.logger.log(this.node.printRouteState());
                }
            }
            if ((theTopics = manifest.get(handle)) == null) {
                theTopics = new ArrayList<Topic>();
                manifest.put(handle, theTopics);
            }
            theTopics.add(topic);
        }
        if (this.logger.level <= 300) {
            this.logger.log("buildManifest()");
            for (NodeHandle node : manifest.keySet()) {
                this.logger.log("  " + node + " " + manifest.get(node));
            }
        }
        return manifest;
    }

    protected void ackMessageReceived(SubscribeAckMessage message) {
        SubscribeLostMessage slm;
        if (this.logger.level <= 300) {
            this.logger.log("ackMessageReceived(" + message + ")");
        }
        if ((slm = this.subscribeLostMessages.get(message.getId())) == null) {
            if (this.logger.level <= 500) {
                this.logger.log("ackMessageReceived(" + message + ") for unknown id");
            }
        } else {
            ScribeMultiClient multiClient = slm.getClient();
            if (multiClient != null) {
                multiClient.subscribeSuccess(message.getTopics());
            }
            if (slm.topicsAcked(message.getTopics())) {
                if (this.logger.level <= 400) {
                    this.logger.log("Removing client " + slm.getClient() + " from list of outstanding for ack " + message.getId());
                }
                this.subscribeLostMessages.remove(message.getId()).cancel();
            } else if (this.logger.level <= 400) {
                Collection<Topic> topics = slm.getTopics();
                int numTopics = topics.size();
                this.logger.log("Still waiting for SubscribeAck from " + (numTopics == 1 ? " topic " + topics.iterator().next() + "." : numTopics + " topics."));
            }
        }
    }

    private void failedMessageReceived(SubscribeFailedMessage message) {
        SubscribeLostMessage slm = this.subscribeLostMessages.get(message.getId());
        if (slm == null) {
            if (this.logger.level <= 900) {
                this.logger.log("received unexpected subscribe failed message, ignoring:" + message);
            }
            return;
        }
        if (slm.topicsAcked(message.getTopics())) {
            this.subscribeLostMessages.remove(message.getId()).cancel();
        }
        ScribeMultiClient client = slm.getClient();
        if (this.logger.level <= 400) {
            this.logger.log("Telling client " + client + " about FAILURE for outstanding ack " + message.getId());
        }
        if (client != null) {
            client.subscribeFailed(message.getTopics());
        } else {
            this.maintenancePolicy.subscribeFailed(this, message.getTopics());
        }
    }

    private void lostMessageReceived(SubscribeLostMessage message) {
        SubscribeLostMessage slm = this.subscribeLostMessages.remove(message.getId());
        ScribeMultiClient client = slm.getClient();
        if (this.logger.level <= 400) {
            this.logger.log("Telling client " + client + " about LOSS for outstanding ack " + message.getId());
        }
        ArrayList<Topic> failedTopics = new ArrayList<Topic>();
        for (Topic topic : message.getTopics()) {
            NodeHandle parent = this.getParent(topic);
            if (this.isRoot(topic) || parent != null) continue;
            failedTopics.add(topic);
        }
        if (!failedTopics.isEmpty()) {
            if (client != null) {
                client.subscribeFailed(failedTopics);
            } else {
                this.maintenancePolicy.subscribeFailed(this, failedTopics);
            }
        }
    }

    @Override
    public boolean containsChild(Topic topic, NodeHandle child) {
        TopicManager manager = this.topicManagers.get(topic);
        if (manager == null) {
            return false;
        }
        return manager.containsChild(child);
    }

    public void subscribe(Collection<Topic> topics) {
        this.doSubscribe(topics, null, null, null);
    }

    public void subscribe(Topic topic, ScribeMultiClient client) {
        this.doSubscribe(Collections.singletonList(topic), client, null, null);
    }

    @Override
    public void subscribe(Topic topic, ScribeClient client) {
        this.doSubscribe(Collections.singletonList(topic), this.getMultiClient(client), null, null);
    }

    @Override
    public void subscribe(Topic topic, ScribeClient client, ScribeContent content) {
        this.doSubscribe(Collections.singletonList(topic), this.getMultiClient(client), this.toRawScribeContent(content), null);
    }

    @Override
    public void subscribe(Topic topic, ScribeClient client, ScribeContent content, NodeHandle hint) {
        this.doSubscribe(Collections.singletonList(topic), this.getMultiClient(client), this.toRawScribeContent(content), hint);
    }

    @Override
    public void subscribe(Topic topic, ScribeClient client, RawScribeContent content) {
        this.doSubscribe(Collections.singletonList(topic), this.getMultiClient(client), content, null);
    }

    @Override
    public void subscribe(Topic topic, ScribeClient client, RawScribeContent content, NodeHandle hint) {
        this.doSubscribe(Collections.singletonList(topic), this.getMultiClient(client), content, hint);
    }

    @Override
    public void subscribe(Collection<Topic> theTopics, ScribeClient client, RawScribeContent content, NodeHandle hint) {
        this.doSubscribe(theTopics, this.getMultiClient(client), content, hint);
    }

    @Override
    public void subscribe(Collection<Topic> theTopics, ScribeClient client, ScribeContent content, NodeHandle hint) {
        this.doSubscribe(theTopics, this.getMultiClient(client), this.toRawScribeContent(content), hint);
    }

    @Override
    public void subscribe(Topic topic, ScribeMultiClient client, ScribeContent content, NodeHandle hint) {
        this.doSubscribe(Collections.singletonList(topic), client, this.toRawScribeContent(content), hint);
    }

    @Override
    public void subscribe(Topic topic, ScribeMultiClient client, RawScribeContent content, NodeHandle hint) {
        this.doSubscribe(Collections.singletonList(topic), client, content, hint);
    }

    @Override
    public void subscribe(Collection<Topic> theTopics, ScribeMultiClient client, ScribeContent content, NodeHandle hint) {
        this.doSubscribe(theTopics, client, this.toRawScribeContent(content), hint);
    }

    @Override
    public void subscribe(Collection<Topic> theTopics, ScribeMultiClient client, RawScribeContent content, NodeHandle hint) {
        this.doSubscribe(theTopics, client, content, hint);
    }

    protected RawScribeContent toRawScribeContent(ScribeContent content) {
        return content instanceof RawScribeContent ? (RawScribeContent)content : new JavaSerializedScribeContent(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSubscribe(Collection<Topic> theTopics, ScribeMultiClient client, RawScribeContent content, NodeHandle hint) {
        if (this.logger.level <= 400) {
            this.logger.log("Subscribing client " + client + " to " + theTopics + ".");
        }
        ArrayList<Topic> toSubscribe = new ArrayList<Topic>();
        ArrayList<Topic> alreadySubscribed = new ArrayList<Topic>();
        Hashtable<Topic, TopicManager> hashtable = this.topicManagers;
        synchronized (hashtable) {
            for (Topic topic : theTopics) {
                TopicManager manager = this.topicManagers.get(topic);
                if (manager == null) {
                    manager = new TopicManager(topic);
                    this.topicManagers.put(topic, manager);
                    toSubscribe.add(topic);
                } else if (manager.getParent() == null && !this.isRoot(topic)) {
                    toSubscribe.add(topic);
                } else {
                    alreadySubscribed.add(topic);
                }
                manager.addClient(client);
            }
        }
        if (client != null && !alreadySubscribed.isEmpty()) {
            client.subscribeSuccess(alreadySubscribed);
        }
        if (toSubscribe.isEmpty()) {
            return;
        }
        this.sendSubscribe(toSubscribe, client, content, hint);
    }

    @Override
    public void unsubscribe(Topic topic, ScribeClient client) {
        this.unsubscribe(Collections.singletonList(topic), this.getMultiClient(client));
    }

    @Override
    public void unsubscribe(Topic topic, ScribeMultiClient client) {
        this.unsubscribe(Collections.singletonList(topic), client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(Collection<Topic> topicsToUnsubscribe, ScribeMultiClient client) {
        if (this.logger.level <= 400) {
            this.logger.log("Unsubscribing client " + client + " from topic " + this.topicManagers);
        }
        HashMap<NodeHandle, ArrayList<Topic>> needToUnsubscribe = new HashMap<NodeHandle, ArrayList<Topic>>();
        Hashtable<Topic, TopicManager> hashtable = this.topicManagers;
        synchronized (hashtable) {
            for (Topic topic : topicsToUnsubscribe) {
                TopicManager manager = this.topicManagers.get(topic);
                if (manager != null) {
                    NodeHandle parent = manager.getParent();
                    if (!manager.removeClient(this.getMultiClient(client))) continue;
                    if (this.logger.level <= 800) {
                        this.logger.log("Removing TopicManager for topic: " + topic);
                    }
                    this.topicManagers.remove(topic);
                    this.removeFromAllParents(topic, parent);
                    if (parent == null) continue;
                    ArrayList<Topic> theTopics = (ArrayList<Topic>)needToUnsubscribe.get(parent);
                    if (theTopics == null) {
                        theTopics = new ArrayList<Topic>();
                        needToUnsubscribe.put(parent, theTopics);
                    }
                    theTopics.add(topic);
                    continue;
                }
                if (this.logger.level > 900) continue;
                this.logger.log("Attempt to unsubscribe client " + client + " from unknown topic " + topic);
            }
        }
        for (NodeHandle parent : needToUnsubscribe.keySet()) {
            this.endpoint.route(null, new UnsubscribeMessage(this.localHandle, (List)needToUnsubscribe.get(parent)), parent);
        }
    }

    @Override
    public void publish(Topic topic, ScribeContent content) {
        this.publish(topic, content instanceof RawScribeContent ? (RawScribeContent)content : new JavaSerializedScribeContent(content));
    }

    @Override
    public void publish(Topic topic, RawScribeContent content) {
        if (this.logger.level <= 400) {
            this.logger.log("Publishing content " + content + " to topic " + topic);
        }
        this.endpoint.route(topic.getId(), new PublishRequestMessage(this.localHandle, topic, content), null);
    }

    @Override
    public void anycast(Topic topic, ScribeContent content) {
        this.anycast(topic, content, null);
    }

    @Override
    public void anycast(Topic topic, ScribeContent content, NodeHandle hint) {
        if (content instanceof RawScribeContent) {
            this.anycast(topic, (RawScribeContent)content, hint);
        } else {
            this.anycast(topic, new JavaSerializedScribeContent(content), hint);
        }
    }

    @Override
    public void anycast(Topic topic, RawScribeContent content) {
        this.anycast(topic, content, null);
    }

    @Override
    public void anycast(Topic topic, RawScribeContent content, NodeHandle hint) {
        if (this.logger.level <= 400) {
            this.logger.log("Anycasting content " + content + " to topic " + topic + " with hint " + hint);
        }
        AnycastMessage aMsg = new AnycastMessage(this.localHandle, topic, content);
        this.policy.directAnycast(aMsg, this.getParent(topic), this.getChildrenOfTopic(topic));
        if (hint == null || this.localHandle.equals(hint)) {
            this.endpoint.route(topic.getId(), aMsg, null);
        } else {
            this.endpoint.route(topic.getId(), aMsg, hint);
        }
    }

    @Override
    public void addChild(Topic topic, NodeHandle child) {
        if (this.addChildHelper(topic, child)) {
            this.subscribe((Collection<Topic>)Collections.singletonList(topic), (ScribeMultiClient)null, this.maintenancePolicy.implicitSubscribe(Collections.singletonList(topic)), (NodeHandle)null);
        }
        TopicManager manager = this.getTopicManager(topic);
        this.endpoint.route(null, new SubscribeAckMessage(this.localHandle, Collections.singletonList(topic), Collections.singletonList(manager.getPathToRoot()), Integer.MAX_VALUE), child);
    }

    @Override
    public void setParent(Topic topic, NodeHandle parent, List<Id> pathToRoot) {
        TopicManager manager = this.getTopicManager(topic);
        manager.setParent(parent, pathToRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicManager getTopicManager(Topic topic) {
        Hashtable<Topic, TopicManager> hashtable = this.topicManagers;
        synchronized (hashtable) {
            TopicManager manager = this.topicManagers.get(topic);
            if (manager == null) {
                manager = new TopicManager(topic);
                this.topicManagers.put(topic, manager);
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addChildHelper(Topic topic, NodeHandle child) {
        ArrayList<ScribeMultiClient> clientList;
        if (this.logger.level <= 400) {
            this.logger.log("addChild(" + topic + "," + child + "," + this.id + ")");
        }
        boolean ret = false;
        Hashtable<Topic, TopicManager> hashtable = this.topicManagers;
        synchronized (hashtable) {
            TopicManager manager = this.topicManagers.get(topic);
            if (manager == null) {
                manager = new TopicManager(topic);
                this.topicManagers.put(topic, manager);
                if (this.logger.level <= 400) {
                    this.logger.log("Implicitly subscribing to topic " + topic);
                }
                ret = true;
            }
            manager.addChild(child);
            clientList = new ArrayList<ScribeMultiClient>(manager.getClients());
        }
        this.policy.childAdded(topic, child);
        for (ScribeMultiClient client : clientList) {
            client.childAdded(topic, child);
        }
        return ret;
    }

    @Override
    public void removeChild(Topic topic, NodeHandle child) {
        this.removeChild(topic, child, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChild(Topic topic, NodeHandle child, boolean sendDrop) {
        TopicManager manager;
        if (this.logger.level <= 500) {
            this.logger.log("Removing child " + child + " from topic " + topic);
        }
        boolean sendUnsubscribe = false;
        Hashtable<Topic, TopicManager> hashtable = this.topicManagers;
        synchronized (hashtable) {
            manager = this.topicManagers.get(topic);
            if (manager != null) {
                NodeHandle parent = manager.getParent();
                sendUnsubscribe = manager.removeChild(child);
                if (sendUnsubscribe) {
                    if (this.logger.level <= 800) {
                        this.logger.log("Removing TopicManager for topic: " + topic);
                    }
                    this.topicManagers.remove(topic);
                    this.removeFromAllParents(topic, parent);
                }
            }
        }
        if (manager != null) {
            ArrayList<ScribeMultiClient> clientList;
            NodeHandle parent = manager.getParent();
            if (sendUnsubscribe) {
                if (this.logger.level <= 500) {
                    this.logger.log("We no longer need topic " + topic + " - unsubscribing from parent " + parent);
                }
                if (parent != null) {
                    this.endpoint.route(null, new UnsubscribeMessage(this.localHandle, Collections.singletonList(topic)), parent);
                }
            }
            if (sendDrop && child.isAlive()) {
                if (this.logger.level <= 500) {
                    this.logger.log("Informing child " + child + " that he has been dropped from topic " + topic);
                }
                this.endpoint.route(null, new DropMessage(this.localHandle, topic), child);
            }
            this.policy.childRemoved(topic, child);
            Hashtable<Topic, TopicManager> hashtable2 = this.topicManagers;
            synchronized (hashtable2) {
                clientList = new ArrayList<ScribeMultiClient>(manager.getClients());
            }
            for (ScribeMultiClient client : clientList) {
                client.childRemoved(topic, child);
            }
        } else if (this.logger.level <= 900) {
            this.logger.log("Unexpected attempt to remove child " + child + " from unknown topic " + topic);
        }
    }

    @Override
    public Collection<Topic> getTopicsByClient(ScribeClient client) {
        ArrayList<Topic> result = new ArrayList<Topic>();
        for (TopicManager topicManager : this.topicManagers.values()) {
            if (!topicManager.containsClient(this.getMultiClient(client))) continue;
            result.add(topicManager.getTopic());
        }
        return result;
    }

    @Override
    public Collection<Topic> getTopicsByClient(ScribeMultiClient client) {
        ArrayList<Topic> result = new ArrayList<Topic>();
        for (TopicManager topicManager : this.topicManagers.values()) {
            if (!topicManager.containsClient(client)) continue;
            result.add(topicManager.getTopic());
        }
        return result;
    }

    @Override
    public Topic[] getTopics(ScribeClient client) {
        return (Topic[])this.getTopicsByClient(client).toArray();
    }

    protected void recvAnycastFail(Topic topic, NodeHandle failedAtNode, ScribeContent content) {
        if (this.logger.level <= 500) {
            this.logger.log("received anycast failure message from " + failedAtNode + " for topic " + topic);
        }
        this.policy.recvAnycastFail(topic, failedAtNode, content);
    }

    protected void addToAllChildren(Topic t, NodeHandle child) {
        Collection<Topic> topics;
        if (this.logger.level <= 800) {
            this.logger.log("addToAllChildren(" + t + "," + child + ")");
        }
        if ((topics = this.allChildren.get(child)) == null) {
            if (child.isAlive()) {
                if (!this.allParents.containsKey(child)) {
                    child.addObserver(this);
                }
            } else if (this.logger.level <= 900) {
                this.logger.logException("addToAllChildren(" + t + "," + child + ") child.isAlive() == false", new Exception("Stack Trace"));
            }
            topics = new ArrayList<Topic>();
            this.allChildren.put(child, topics);
        }
        if (!topics.contains(t)) {
            topics.add(t);
        }
    }

    protected void removeFromAllChildren(Topic t, NodeHandle child) {
        Collection<Topic> topics;
        if (this.logger.level <= 800) {
            this.logger.log("removeFromAllChildren(" + t + "," + child + ")");
        }
        if ((topics = this.allChildren.get(child)) == null) {
            return;
        }
        topics.remove(t);
        if (topics.isEmpty()) {
            this.allChildren.remove(child);
            if (!this.allParents.containsKey(child)) {
                child.deleteObserver(this);
            }
        }
    }

    protected void addToAllParents(Topic t, NodeHandle parent) {
        if (this.logger.level <= 800) {
            this.logger.log("addToAllParents(" + t + "," + parent + ")");
        }
        if (parent == null || parent.equals(this.localHandle)) {
            if (this.isRoot(t)) {
                this.roots.add(t);
            }
            return;
        }
        Collection<Topic> topics = this.allParents.get(parent);
        if (topics == null) {
            if (parent.isAlive()) {
                if (!this.allChildren.containsKey(parent)) {
                    parent.addObserver(this);
                }
            } else if (this.logger.level <= 900) {
                this.logger.logException("addToAllParents(" + t + "," + parent + ") parent.isAlive() == false", new Exception("Stack Trace"));
            }
            topics = new ArrayList<Topic>();
            this.allParents.put(parent, topics);
        }
        if (!topics.contains(t)) {
            topics.add(t);
        }
    }

    protected void removeFromAllParents(Topic t, NodeHandle parent) {
        if (this.logger.level <= 800) {
            this.logger.log("removeFromAllParents(" + t + "," + parent + ")");
        }
        if (parent == null || parent.equals(this.localHandle)) {
            this.roots.remove(t);
            this.pending.remove(t);
            return;
        }
        Collection<Topic> topics = this.allParents.get(parent);
        if (topics == null) {
            return;
        }
        topics.remove(t);
        if (topics.isEmpty()) {
            this.allParents.remove(parent);
            if (!this.allChildren.containsKey(parent)) {
                parent.deleteObserver(this);
            }
        }
    }

    public boolean allParentsContains(Topic t, NodeHandle parent) {
        if (parent == null) {
            return false;
        }
        if (this.allParents.containsKey(parent)) {
            Vector topics = (Vector)this.allParents.get(parent);
            return topics.contains(t);
        }
        return false;
    }

    public boolean allParentsContainsParent(NodeHandle parent) {
        if (parent == null) {
            return false;
        }
        return this.allParents.containsKey(parent);
    }

    public void printAllParentsDataStructure() {
        String s = "printAllParentsDataStructure()";
        for (NodeHandle parent : this.allParents.keySet()) {
            s = s + "\n  parent: " + parent + " (Topics,TopicExists,ActualParent) are as follows: ";
            for (Topic t : this.allParents.get(parent)) {
                boolean topicExists = this.containsTopic(t);
                NodeHandle actualParent = this.getParent(t);
                s = s + "\n    (" + t + ", " + topicExists + ", " + actualParent + ")";
            }
        }
    }

    public void printAllChildrenDataStructure() {
        String s = "printAllChildrenDataStructure()";
        for (NodeHandle child : this.allChildren.keySet()) {
            s = s + "\n  child: " + child + " (Topics,TopicExists, containsChild) are as follows: ";
            for (Topic t : this.allChildren.get(child)) {
                boolean topicExists = this.containsTopic(t);
                boolean containsChild = this.containsChild(t, child);
                s = s + "\n    (" + t + ", " + topicExists + ", " + containsChild + ")";
            }
        }
    }

    @Override
    public Collection<Topic> getTopicsByParent(NodeHandle parent) {
        if (parent == null) {
            parent = this.localHandle;
        }
        if (parent.equals(this.localHandle)) {
            return this.roots;
        }
        Collection<Topic> topic = this.allParents.get(parent);
        if (topic == null) {
            return Collections.emptyList();
        }
        return topic;
    }

    @Override
    public Collection<Topic> getTopicsByChild(NodeHandle child) {
        Collection<Topic> topic;
        if (child.equals(this.localHandle) && this.logger.level <= 900) {
            this.logger.log("ScribeImpl.getTopicsByChild() called with localHandle! Why would you do that?");
        }
        if ((topic = this.allChildren.get(child)) == null) {
            return Collections.emptyList();
        }
        return topic;
    }

    @Override
    public boolean forward(RouteMessage message) {
        Message internalMessage;
        try {
            internalMessage = message.getMessage(this.endpoint.getDeserializer());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (this.logger.level <= 300) {
            this.logger.log("Forward called with " + internalMessage + " " + internalMessage.getClass().getName());
        }
        if (internalMessage instanceof ScribeMessage) {
            this.policy.intermediateNode((ScribeMessage)internalMessage);
        }
        if (internalMessage instanceof AnycastMessage) {
            AnycastMessage aMessage = (AnycastMessage)internalMessage;
            if (aMessage.getTopic() == null) {
                throw new RuntimeException("topic is null!");
            }
            TopicManager manager = this.topicManagers.get(aMessage.getTopic());
            if (internalMessage instanceof SubscribeMessage) {
                SubscribeMessage sMessage = (SubscribeMessage)internalMessage;
                return this.handleForwardSubscribeMessage(sMessage);
            }
            if (this.logger.level <= 400) {
                this.logger.log("DEBUG: Anycast message.forward(1)");
            }
            if (this.endpoint.getLocalNodeHandle().equals(aMessage.getLastVisited()) && !this.endpoint.getLocalNodeHandle().equals(aMessage.getInitialRequestor())) {
                if (this.logger.level <= 400) {
                    this.logger.log("Bypassing forward logic of anycast message becuase local node is the last visited node " + aMessage.getLastVisited() + " of in the anycast message ");
                    if (this.isRoot(aMessage.getTopic())) {
                        this.logger.log("Local node is the root of anycast group " + aMessage.getTopic());
                    }
                }
                return true;
            }
            if (manager == null) {
                if (this.logger.level <= 400) {
                    this.logger.log("Manager of anycast group is null");
                }
                return true;
            }
            Collection<ScribeMultiClient> clients = manager.getClients();
            for (ScribeMultiClient client : clients) {
                if (!client.anycast(aMessage.getTopic(), aMessage.getContent())) continue;
                if (this.logger.level <= 400) {
                    this.logger.log("Accepting anycast message from " + aMessage.getSource() + " for topic " + aMessage.getTopic());
                }
                return false;
            }
            if (aMessage.getSource().getId().equals(this.endpoint.getId()) && message.getNextHopHandle() != null && !this.localHandle.equals(message.getNextHopHandle())) {
                if (this.logger.level <= 400) {
                    this.logger.log("DEBUG: Anycast message.forward(2), before returning true");
                }
                return true;
            }
            if (this.logger.level <= 400) {
                this.logger.log("Rejecting anycast message from " + aMessage.getSource() + " for topic " + aMessage.getTopic());
            }
            aMessage.addVisited(this.endpoint.getLocalNodeHandle());
            this.policy.directAnycast(aMessage, manager.getParent(), manager.getChildren());
            aMessage.setSource(this.endpoint.getLocalNodeHandle());
            NodeHandle handle = aMessage.getNext();
            while (handle != null && !handle.isAlive()) {
                handle = aMessage.getNext();
            }
            if (this.logger.level <= 400) {
                this.logger.log("Forwarding anycast message for topic " + aMessage.getTopic() + "on to " + handle);
            }
            if (handle == null) {
                if (this.logger.level <= 500) {
                    this.logger.log("Anycast " + aMessage + " failed.");
                }
                if (this.logger.level <= 850) {
                    this.logger.log("Anycast failed at this intermediate node:" + aMessage + "\nAnycastMessage ANYCASTFAILEDHOPS " + aMessage.getVisitedSize() + " " + aMessage.getContent());
                }
                AnycastFailureMessage aFailMsg = new AnycastFailureMessage(this.endpoint.getLocalNodeHandle(), aMessage.getTopic(), aMessage.getContent());
                this.endpoint.route(null, aFailMsg, aMessage.getInitialRequestor());
            } else {
                if (this.logger.level <= 300) {
                    this.logger.log("forward() routing " + aMessage + " to " + handle);
                }
                this.endpoint.route(null, aMessage, handle);
            }
            return false;
        }
        return true;
    }

    protected boolean handleForwardSubscribeMessage(SubscribeMessage sMessage) {
        HashMap<NodeHandle, List<Topic>> manifest;
        List<Object> accepted;
        if (this.logger.level <= 300) {
            this.logger.log("handleForwardScribeMessage(" + sMessage + ")");
        }
        if (sMessage.getSource().getId().equals(this.endpoint.getId())) {
            if (this.logger.level <= 800) {
                this.logger.log("Bypassing forward logic of subscribemessage " + sMessage + " becuase local node is the subscriber source.");
            }
            return true;
        }
        if (this.logger.level <= 300) {
            this.logger.log("handleForwardSubscribeMessage() here 1 " + sMessage);
        }
        ArrayList<Topic> forward = new ArrayList<Topic>();
        ArrayList<Topic> dontForward = new ArrayList<Topic>();
        ArrayList<Topic> askPolicy = new ArrayList<Topic>();
        for (Topic topic : sMessage.getTopics()) {
            TopicManager tmanager = this.topicManagers.get(topic);
            if (tmanager != null) {
                List<Id> list = tmanager.getPathToRoot();
                if (list.contains(sMessage.getSubscriber().getId())) {
                    if (this.logger.level <= 800) {
                        String s = "Rejecting subscribe message from " + sMessage.getSubscriber() + " for topic " + sMessage.getTopic() + " because we are on the subscriber's path to the root:";
                        for (Id id : list) {
                            s = s + id + ",";
                        }
                        this.logger.log(s);
                    }
                    forward.add(topic);
                    continue;
                }
                if (tmanager.getChildren().contains(sMessage.getSubscriber())) {
                    dontForward.add(topic);
                    continue;
                }
            }
            askPolicy.add(topic);
        }
        if (this.logger.level <= 300) {
            this.logger.log("handleForwardSubscribeMessage() here 2 " + sMessage);
        }
        if (!askPolicy.isEmpty()) {
            accepted = this.policy.allowSubscribe(this, sMessage.getSubscriber(), new ArrayList<Topic>(askPolicy), sMessage.getContent());
            askPolicy.removeAll(accepted);
            dontForward.addAll(accepted);
            ArrayList<Topic> newTopics = new ArrayList<Topic>();
            if (sMessage.getSubscriber().isAlive()) {
                for (Topic topic : accepted) {
                    if (this.logger.level <= 400) {
                        this.logger.log("Hijacking subscribe message from " + sMessage.getSubscriber() + " for topic " + topic);
                    }
                    if (!this.addChildHelper(topic, sMessage.getSubscriber())) continue;
                    newTopics.add(topic);
                }
                this.subscribe((Collection<Topic>)newTopics, (ScribeMultiClient)null, this.maintenancePolicy.implicitSubscribe(newTopics), (NodeHandle)null);
            } else {
                if (this.logger.level <= 900) {
                    this.logger.log("Dropping subscribe message for dead " + sMessage.getSubscriber() + " " + accepted);
                }
                accepted.clear();
            }
        } else {
            accepted = askPolicy;
        }
        ArrayList<Topic> rejected = askPolicy;
        forward.addAll(rejected);
        List<Object> toReturn = sMessage.getId() == Integer.MAX_VALUE ? accepted : dontForward;
        if (this.logger.level <= 300) {
            this.logger.log("handleForwardSubscribeMessage() here 3 " + sMessage);
        }
        if (!toReturn.isEmpty() && sMessage.getSubscriber().isAlive()) {
            ArrayList<List<Id>> arrayList = new ArrayList<List<Id>>(toReturn.size());
            for (Topic topic : toReturn) {
                TopicManager tmanager = this.topicManagers.get(topic);
                arrayList.add(tmanager.getPathToRoot());
            }
            this.endpoint.route(null, new SubscribeAckMessage(this.localHandle, toReturn, arrayList, sMessage.getId()), sMessage.getSubscriber());
        }
        sMessage.removeTopics(dontForward);
        if (this.logger.level <= 400) {
            this.logger.log("Rejecting subscribe message from " + sMessage.getSubscriber() + " for topic(s) " + sMessage.getTopics());
        }
        if (sMessage.isEmpty()) {
            if (this.logger.level <= 300) {
                this.logger.log("handleForwardSubscribeMessage() returning false here 85");
            }
            return false;
        }
        sMessage.addVisited(this.endpoint.getLocalNodeHandle());
        if (this.logger.level <= 300) {
            this.logger.log("handleForwardSubscribeMessage() here 4 " + sMessage);
        }
        ArrayList<Topic> arrayList = new ArrayList<Topic>();
        ArrayList<Topic> failed = new ArrayList<Topic>();
        Iterator<Topic> iterator = sMessage.getTopics().iterator();
        while (iterator.hasNext()) {
            Topic topic = iterator.next();
            TopicManager manager = this.topicManagers.get(topic);
            if (manager == null) {
                arrayList.add(topic);
                continue;
            }
            iterator.remove();
            SubscribeMessage aMessage = sMessage.copy(Collections.singletonList(topic), sMessage.getRawContent());
            this.policy.directAnycast(aMessage, manager.getParent(), manager.getChildren());
            aMessage.setSource(this.endpoint.getLocalNodeHandle());
            NodeHandle handle = aMessage.getNext();
            while (handle != null && !handle.isAlive()) {
                handle = aMessage.getNext();
            }
            if (handle == null || !handle.isAlive()) {
                handle = null;
            }
            if (this.logger.level <= 400) {
                this.logger.log("Forwarding anycast message for topic " + aMessage.getTopic() + "on to " + handle);
            }
            if (handle == null) {
                if (this.logger.level <= 500) {
                    this.logger.log("Anycast " + aMessage + " failed.");
                }
                if (this.logger.level <= 400) {
                    this.logger.log("Sending SubscribeFailedMessage to " + sMessage.getSubscriber() + " for topic " + topic);
                }
                failed.add(topic);
                continue;
            }
            if (this.logger.level <= 300) {
                this.logger.log("handleForwardSubscribeMessage() routing " + aMessage + " to " + handle);
            }
            this.endpoint.route(aMessage.getTopic().getId(), aMessage, handle);
        }
        if (this.logger.level <= 300) {
            this.logger.log("handleForwardSubscribeMessage() here 5 " + sMessage);
        }
        if ((manifest = this.buildManifests(arrayList)).containsKey(this.localHandle)) {
            List<Topic> theTopics = manifest.remove(this.localHandle);
            sMessage.removeTopics(theTopics);
            for (Topic topic : theTopics) {
                failed.add(topic);
            }
        }
        if (this.logger.level <= 300) {
            this.logger.log("handleForwardSubscribeMessage() here 6 " + sMessage);
        }
        this.endpoint.route(null, new SubscribeFailedMessage(this.localHandle, failed, sMessage.getId()), sMessage.getSubscriber());
        if (manifest.keySet().size() == 1) {
            if (this.logger.level <= 300) {
                this.logger.log("handleForwardSubscribeMessage() returning true at this location!!! " + sMessage);
            }
            return true;
        }
        for (NodeHandle nextHop : manifest.keySet()) {
            List<Topic> theTopics = manifest.get(nextHop);
            if (theTopics == null) continue;
            SubscribeMessage aMessage = sMessage.copy(theTopics, this.convert(this.policy.divideContent(theTopics, sMessage.getContent())));
            this.endpoint.route(aMessage.getTopic().getId(), aMessage, nextHop);
        }
        return false;
    }

    @Override
    public void deliver(Id id, Message message) {
        if (this.logger.level <= 300) {
            this.logger.log("Deliver called with " + id + " " + message);
        }
        if (message instanceof AnycastMessage) {
            AnycastMessage aMessage = (AnycastMessage)message;
            if (aMessage.getSource().equals(this.localHandle)) {
                if (aMessage instanceof SubscribeMessage) {
                    SubscribeMessage sMessage = (SubscribeMessage)message;
                    if (sMessage.isEmpty()) {
                        return;
                    }
                    SubscribeLostMessage slm = this.subscribeLostMessages.get(sMessage.getId());
                    if (slm != null) {
                        ScribeMultiClient multiClient = slm.getClient();
                        if (multiClient != null) {
                            multiClient.subscribeSuccess(sMessage.getTopics());
                        }
                        if (slm.topicsAcked(sMessage.getTopics())) {
                            if (this.logger.level <= 400) {
                                this.logger.log("Removing client " + slm.getClient() + " from list of outstanding for ack " + sMessage.getId());
                            }
                            this.subscribeLostMessages.remove(sMessage.getId()).cancel();
                        }
                    }
                    for (Topic topic : sMessage.getTopics()) {
                        if (this.isRoot(topic) || this.logger.level > 900) continue;
                        this.logger.log("Received our own subscribe message " + aMessage + " for topic " + aMessage.getTopic() + " - we are not the root.");
                    }
                    if (this.logger.level <= 500) {
                        this.logger.log("Received our own subscribe message " + aMessage + " for topic " + aMessage.getTopic() + " - we are the root.");
                    }
                } else {
                    if (this.logger.level <= 900) {
                        this.logger.log("WARNING : Anycast failed at Root for Topic " + aMessage.getTopic() + " was generated by us " + " msg= " + aMessage);
                    }
                    if (this.logger.level <= 850) {
                        this.logger.log(this.endpoint.getId() + ": AnycastMessage ANYCASTFAILEDHOPS " + aMessage.getVisitedSize() + " " + aMessage.getContent());
                    }
                    AnycastFailureMessage aFailMsg = new AnycastFailureMessage(this.endpoint.getLocalNodeHandle(), aMessage.getTopic(), aMessage.getContent());
                    this.endpoint.route(null, aFailMsg, aMessage.getInitialRequestor());
                }
            } else if (aMessage instanceof SubscribeMessage) {
                SubscribeMessage sMessage = (SubscribeMessage)aMessage;
                if (this.logger.level <= 500) {
                    this.logger.log("Sending SubscribeFailedMessage (at root) to " + sMessage.getSubscriber());
                }
                this.endpoint.route(null, new SubscribeFailedMessage(this.localHandle, sMessage.getTopics(), sMessage.getId()), sMessage.getSubscriber());
            } else {
                if (this.logger.level <= 900) {
                    this.logger.log("WARNING : Anycast failed at Root for Topic " + aMessage.getTopic() + " not generated by us " + " msg= " + aMessage);
                }
                if (this.logger.level <= 850) {
                    this.logger.log(this.endpoint.getId() + ": AnycastMessage ANYCASTFAILEDHOPS " + aMessage.getVisitedSize() + " " + aMessage.getContent());
                }
                AnycastFailureMessage aFailMsg = new AnycastFailureMessage(this.endpoint.getLocalNodeHandle(), aMessage.getTopic(), aMessage.getContent());
                this.endpoint.route(null, aFailMsg, aMessage.getInitialRequestor());
            }
        } else if (message instanceof SubscribeAckMessage) {
            HashMap<NodeHandle, ArrayList<Topic>> needToUnsubscribe = new HashMap<NodeHandle, ArrayList<Topic>>();
            SubscribeAckMessage saMessage = (SubscribeAckMessage)message;
            if (!saMessage.getSource().isAlive()) {
                if (this.logger.level <= 900) {
                    this.logger.log("Dropping subscribe ack message from dead node:" + saMessage.getSource() + " for topics " + saMessage.getTopics());
                }
                return;
            }
            Iterator<List<Id>> i = saMessage.getPathsToRoot().iterator();
            for (Topic topic : saMessage.getTopics()) {
                ArrayList<Topic> topics;
                List<Id> pathToRoot = i.next();
                TopicManager manager = this.topicManagers.get(topic);
                if (this.logger.level <= 500) {
                    this.logger.log("Received subscribe ack message from " + saMessage.getSource() + " for topic " + topic);
                }
                this.ackMessageReceived(saMessage);
                if (this.isRoot(topic)) {
                    if (this.logger.level <= 500) {
                        this.logger.log("Received unexpected subscribe ack message (we are the root) from " + saMessage.getSource() + " for topic " + topic);
                    }
                    if ((topics = (ArrayList<Topic>)needToUnsubscribe.get(saMessage.getSource())) == null) {
                        topics = new ArrayList<Topic>();
                    }
                    topics.add(topic);
                } else if (manager == null) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Received unexpected subscribe ack message from " + saMessage.getSource() + " for unknown topic " + topic);
                    }
                    if ((topics = (List)needToUnsubscribe.get(saMessage.getSource())) == null) {
                        topics = new ArrayList();
                    }
                    topics.add(topic);
                } else {
                    if (manager.getParent() == null) {
                        this.setParent(topic, saMessage.getSource(), pathToRoot);
                    }
                    if (!manager.getParent().equals(saMessage.getSource())) {
                        if (this.logger.level <= 900) {
                            this.logger.log("Received somewhat unexpected subscribe ack message (already have parent " + manager.getParent() + ") from " + saMessage.getSource() + " for topic " + topic + " - the new policy is now to accept the message");
                        }
                        NodeHandle parent = manager.getParent();
                        this.setParent(topic, saMessage.getSource(), pathToRoot);
                        ArrayList<Topic> topics2 = (ArrayList<Topic>)needToUnsubscribe.get(parent);
                        if (topics2 == null) {
                            topics2 = new ArrayList<Topic>();
                            needToUnsubscribe.put(parent, topics2);
                        }
                        topics2.add(topic);
                    }
                }
                for (NodeHandle source : needToUnsubscribe.keySet()) {
                    this.endpoint.route(null, new UnsubscribeMessage(this.localHandle, (List)needToUnsubscribe.get(source)), source);
                }
            }
        } else if (message instanceof SubscribeLostMessage) {
            SubscribeLostMessage slMessage = (SubscribeLostMessage)message;
            this.lostMessageReceived(slMessage);
        } else if (message instanceof SubscribeFailedMessage) {
            SubscribeFailedMessage sfMessage = (SubscribeFailedMessage)message;
            this.failedMessageReceived(sfMessage);
        } else if (message instanceof PublishRequestMessage) {
            PublishRequestMessage prMessage = (PublishRequestMessage)message;
            TopicManager manager = this.topicManagers.get(prMessage.getTopic());
            if (this.logger.level <= 400) {
                this.logger.log("Received publish request message with data " + prMessage.getContent() + " for topic " + prMessage.getTopic());
            }
            if (manager == null) {
                if (this.logger.level <= 500) {
                    this.logger.log("Received publish request message for non-existent topic " + prMessage.getTopic() + " - dropping on floor.");
                }
            } else {
                this.deliver(prMessage.getTopic().getId(), new PublishMessage(prMessage.getSource(), prMessage.getTopic(), prMessage.getContent()));
            }
        } else if (message instanceof PublishMessage) {
            PublishMessage pMessage = (PublishMessage)message;
            TopicManager manager = this.topicManagers.get(pMessage.getTopic());
            if (this.logger.level <= 400) {
                this.logger.log("Received publish message with data " + pMessage.getContent() + " for topic " + pMessage.getTopic());
            }
            if (manager != null && (manager.getParent() == null || manager.getParent().equals(pMessage.getSource()))) {
                pMessage.setSource(this.localHandle);
                Collection<ScribeMultiClient> clients = manager.getClients();
                this.policy.intermediateNode(pMessage);
                for (ScribeMultiClient client : clients) {
                    if (this.logger.level <= 400) {
                        this.logger.log("Delivering publish message with data " + pMessage.getContent() + " for topic " + pMessage.getTopic() + " to client " + client);
                    }
                    client.deliver(pMessage.getTopic(), pMessage.getContent());
                }
                ArrayList<NodeHandle> handles = new ArrayList<NodeHandle>(manager.getChildren());
                for (NodeHandle handle : handles) {
                    if (this.logger.level <= 400) {
                        this.logger.log("Forwarding publish message with data " + pMessage.getContent() + " for topic " + pMessage.getTopic() + " to child " + handle);
                    }
                    this.endpoint.route(null, new PublishMessage(this.endpoint.getLocalNodeHandle(), pMessage.getTopic(), pMessage.getContent()), handle);
                }
            } else {
                if (this.logger.level <= 900) {
                    this.logger.log("Received unexpected publish message from " + pMessage.getSource() + " for unknown topic " + pMessage.getTopic());
                }
                this.endpoint.route(null, new UnsubscribeMessage(this.localHandle, Collections.singletonList(pMessage.getTopic())), pMessage.getSource());
            }
        } else if (message instanceof UnsubscribeMessage) {
            UnsubscribeMessage uMessage = (UnsubscribeMessage)message;
            List<Topic> topics = uMessage.getTopics();
            NodeHandle source = uMessage.getSource();
            if (this.logger.level <= 500) {
                String s = topics.size() == 1 ? " for topic " + topics.get(0).toString() : " for " + topics.size() + " topics.";
                this.logger.log("Received unsubscribe message from " + source + s);
            }
            for (Topic topic : topics) {
                this.removeChild(topic, source, false);
            }
        } else if (message instanceof DropMessage) {
            TopicManager manager;
            DropMessage dMessage = (DropMessage)message;
            if (this.logger.level <= 500) {
                this.logger.log("Received drop message from " + dMessage.getSource() + " for topic " + dMessage.getTopic());
            }
            if ((manager = this.topicManagers.get(dMessage.getTopic())) != null) {
                if (manager.getParent() != null && manager.getParent().equals(dMessage.getSource())) {
                    this.setParent(dMessage.getTopic(), null, null);
                    Collection<ScribeMultiClient> clients = manager.getClients();
                    this.sendSubscribe(dMessage.getTopic(), null, this.maintenancePolicy.implicitSubscribe(Collections.singletonList(dMessage.getTopic())), null);
                } else if (this.logger.level <= 900) {
                    this.logger.log("Received unexpected drop message from non-parent " + dMessage.getSource() + " for topic " + dMessage.getTopic() + " - ignoring");
                }
            } else if (this.logger.level <= 900) {
                this.logger.log("Received unexpected drop message from " + dMessage.getSource() + " for unknown topic " + dMessage.getTopic() + " - ignoring");
            }
        } else if (message instanceof MaintenanceMessage) {
            if (this.logger.level <= 500) {
                this.logger.log("Received maintenance message");
            }
            this.maintenancePolicy.doMaintenance(this);
        } else if (message instanceof AnycastFailureMessage) {
            AnycastFailureMessage aFailMsg = (AnycastFailureMessage)message;
            if (this.logger.level <= 500) {
                this.logger.log("Received anycast failure message from " + aFailMsg.getSource() + " for topic " + aFailMsg.getTopic());
            }
            this.recvAnycastFail(aFailMsg.getTopic(), aFailMsg.getSource(), aFailMsg.getContent());
        } else if (this.logger.level <= 900) {
            this.logger.log("Received unknown message " + message + " - dropping on floor.");
        }
    }

    protected RawScribeContent convert(ScribeContent content) {
        if (content == null) {
            return null;
        }
        if (content instanceof RawScribeContent) {
            return (RawScribeContent)content;
        }
        return new JavaSerializedScribeContent(content);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg.equals(NodeHandle.DECLARED_DEAD)) {
            NodeHandle handle = (NodeHandle)o;
            ArrayList<Topic> wasChildOfTopics = new ArrayList<Topic>(this.getTopicsByChild(handle));
            for (Topic topic : wasChildOfTopics) {
                this.removeChild(topic, handle);
                if (this.logger.level > 500) continue;
                this.logger.log("Child " + o + " for topic " + topic + " has died - removing.");
            }
            ArrayList<Topic> wasParentOfTopics = new ArrayList<Topic>(this.getTopicsByParent(handle));
            for (Topic topic : wasParentOfTopics) {
                if (this.logger.level <= 500) {
                    this.logger.log("Parent " + handle + " for topic " + topic + " has died - removing.");
                }
                this.setParent(topic, null, null);
            }
            this.maintenancePolicy.nodeFaulty(this, handle, wasParentOfTopics, wasChildOfTopics);
        }
    }

    @Override
    public void update(NodeHandle handle, boolean joined) {
        if (this.logger.level <= 800) {
            this.logger.log("update(" + handle + ", " + joined + ")");
        }
        if (joined) {
            ArrayList<Topic> notRoot = new ArrayList<Topic>();
            for (TopicManager manager : new ArrayList<TopicManager>(this.topicManagers.values())) {
                Topic topic = manager.topic;
                if (this.isRoot(topic) || manager.getParent() != null) continue;
                notRoot.add(topic);
            }
            if (!notRoot.isEmpty()) {
                this.maintenancePolicy.noLongerRoot(this, notRoot);
            }
        }
    }

    public String toString() {
        return "ScribeImpl[" + this.localHandle + "]";
    }

    @Override
    public void destroy() {
        if (this.environment.getSelectorManager().isSelectorThread()) {
            if (this.logger.level <= 800) {
                this.logger.log("Destroying " + this);
            }
            ArrayList<TopicManager> managers = new ArrayList<TopicManager>(this.topicManagers.values());
            this.topicManagers.clear();
            for (NodeHandle handle : this.allChildren.keySet()) {
                handle.deleteObserver(this);
            }
            for (NodeHandle handle : this.allParents.keySet()) {
                handle.deleteObserver(this);
            }
        } else {
            this.environment.getSelectorManager().invoke(new Runnable(){

                public void run() {
                    ScribeImpl.this.destroy();
                }
            });
        }
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setContentDeserializer(ScribeContentDeserializer deserializer) {
        this.contentDeserializer = deserializer;
    }

    @Override
    public ScribeContentDeserializer getContentDeserializer() {
        return this.contentDeserializer;
    }

    @Override
    public Collection<Topic> getTopics() {
        return this.topicManagers.keySet();
    }

    @Override
    public List<Id> getPathToRoot(Topic topic) {
        TopicManager manager = this.topicManagers.get(topic);
        if (manager == null) {
            return null;
        }
        return manager.getPathToRoot();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TopicManager {
        protected Topic topic;
        protected List<Id> pathToRoot;
        protected ArrayList<ScribeMultiClient> clients;
        protected ArrayList<NodeHandle> children;
        protected NodeHandle parent;

        private TopicManager(Topic topic) {
            this.topic = topic;
            this.clients = new ArrayList();
            this.children = new ArrayList();
            this.setPathToRoot(null);
        }

        public Topic getTopic() {
            return this.topic;
        }

        public NodeHandle getParent() {
            return this.parent;
        }

        public Collection<ScribeMultiClient> getClients() {
            return Collections.unmodifiableCollection(this.clients);
        }

        public boolean containsClient(ScribeMultiClient client) {
            return this.clients.contains(client);
        }

        public Collection<NodeHandle> getChildren() {
            return Collections.unmodifiableCollection(this.children);
        }

        public int numChildren() {
            return this.children.size();
        }

        public List<Id> getPathToRoot() {
            return this.pathToRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPathToRoot(List<Id> pathToRoot) {
            this.pathToRoot = pathToRoot == null ? new ArrayList<Id>() : new ArrayList<Id>(pathToRoot);
            this.pathToRoot.add(ScribeImpl.this.endpoint.getId());
            if (!this.children.isEmpty()) {
                ArrayList<NodeHandle> sendDrop = new ArrayList<NodeHandle>();
                ArrayList<NodeHandle> sendUpdate = new ArrayList<NodeHandle>();
                Hashtable<Topic, TopicManager> hashtable = ScribeImpl.this.topicManagers;
                synchronized (hashtable) {
                    Collection<NodeHandle> children = this.getChildren();
                    for (NodeHandle child : children) {
                        if (this.pathToRoot.contains(child.getId())) {
                            sendDrop.add(child);
                            continue;
                        }
                        sendUpdate.add(child);
                    }
                    for (NodeHandle child : sendDrop) {
                        this.removeChild(child);
                    }
                }
                for (NodeHandle child : sendDrop) {
                    ScribeImpl.this.endpoint.route(null, new DropMessage(ScribeImpl.this.localHandle, this.topic), child);
                }
                for (NodeHandle child : sendUpdate) {
                    ScribeImpl.this.endpoint.route(null, new SubscribeAckMessage(ScribeImpl.this.localHandle, Collections.singletonList(this.topic), Collections.singletonList(this.getPathToRoot()), Integer.MAX_VALUE), child);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setParent(NodeHandle handle, List<Id> pathToRoot) {
            if (ScribeImpl.this.logger.level <= 800) {
                ScribeImpl.this.logger.log(this + "setParent(" + handle + "," + pathToRoot + ") prev:" + this.parent);
            }
            if (handle != null && !handle.isAlive() && ScribeImpl.this.logger.level <= 900) {
                ScribeImpl.this.logger.log("Setting dead parent " + handle + " for " + this.topic);
            }
            if (handle != null && this.parent != null) {
                if (handle.equals(this.parent)) {
                    this.setPathToRoot(pathToRoot);
                    return;
                }
                if (ScribeImpl.this.logger.level <= 500) {
                    ScribeImpl.this.logger.log("Unexpectedly changing parents for topic " + this.topic + ":" + this.parent + "=>" + handle);
                }
            }
            NodeHandle prevParent = this.parent;
            this.parent = handle;
            this.setPathToRoot(pathToRoot);
            Hashtable<Topic, TopicManager> hashtable = ScribeImpl.this.topicManagers;
            synchronized (hashtable) {
                ScribeImpl.this.removeFromAllParents(this.topic, prevParent);
                ScribeImpl.this.addToAllParents(this.topic, this.parent);
            }
        }

        public String toString() {
            return this.topic.toString();
        }

        public void addClient(ScribeMultiClient client) {
            if (client == null) {
                return;
            }
            if (!this.clients.contains(client)) {
                this.clients.add(client);
            }
        }

        public boolean removeClient(ScribeMultiClient client) {
            this.clients.remove(client);
            boolean unsub = this.clients.size() == 0 && this.children.size() == 0;
            return unsub;
        }

        public boolean containsChild(NodeHandle child) {
            return this.children.contains(child);
        }

        public void addChild(NodeHandle child) {
            if (ScribeImpl.this.logger.level <= 800) {
                ScribeImpl.this.logger.log("addChild( " + this.topic + ", " + child + ")");
            }
            if (!this.children.contains(child)) {
                if (child.isAlive()) {
                    this.children.add(child);
                    ScribeImpl.this.addToAllChildren(this.topic, child);
                } else if (ScribeImpl.this.logger.level <= 900) {
                    ScribeImpl.this.logger.logException("WARNING: addChild(" + this.topic + ", " + child + ") did not add child since the child.isAlive() failed", new Exception("Stack Trace"));
                }
            }
        }

        public boolean removeChild(NodeHandle child) {
            if (ScribeImpl.this.logger.level <= 800) {
                ScribeImpl.this.logger.log("removeChild( " + this.topic + ", " + child + ")");
            }
            this.children.remove(child);
            boolean unsub = this.clients.size() == 0 && this.children.size() == 0;
            ScribeImpl.this.removeFromAllChildren(this.topic, child);
            return unsub;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScribeClientConverter
    implements ScribeMultiClient {
        WeakReference<ScribeClient> client;

        public ScribeClientConverter(ScribeClient client) {
            this.client = new WeakReference<ScribeClient>(client);
        }

        @Override
        public void subscribeFailed(Collection<Topic> topics) {
            ScribeClient theClient = (ScribeClient)this.client.get();
            if (theClient == null) {
                return;
            }
            for (Topic topic : topics) {
                theClient.subscribeFailed(topic);
            }
        }

        @Override
        public void subscribeSuccess(Collection<Topic> topics) {
        }

        @Override
        public boolean anycast(Topic topic, ScribeContent content) {
            ScribeClient theClient = (ScribeClient)this.client.get();
            if (theClient == null) {
                return false;
            }
            return theClient.anycast(topic, content);
        }

        @Override
        public void childAdded(Topic topic, NodeHandle child) {
            ScribeClient theClient = (ScribeClient)this.client.get();
            if (theClient == null) {
                return;
            }
            theClient.childAdded(topic, child);
        }

        @Override
        public void childRemoved(Topic topic, NodeHandle child) {
            ScribeClient theClient = (ScribeClient)this.client.get();
            if (theClient == null) {
                return;
            }
            theClient.childRemoved(topic, child);
        }

        @Override
        public void deliver(Topic topic, ScribeContent content) {
            ScribeClient theClient = (ScribeClient)this.client.get();
            if (theClient == null) {
                return;
            }
            theClient.deliver(topic, content);
        }

        @Override
        public void subscribeFailed(Topic topic) {
            ScribeClient theClient = (ScribeClient)this.client.get();
            if (theClient == null) {
                return;
            }
            theClient.subscribeFailed(topic);
        }
    }
}

