/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.replication.manager.testing;

import java.io.IOException;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.testing.CommonAPITest;
import rice.p2p.replication.manager.ReplicationManagerClient;
import rice.p2p.replication.manager.ReplicationManagerImpl;

public class ReplicationManagerRegrTest
extends CommonAPITest {
    public static final int REPLICATION_FACTOR = 3;
    public static String INSTANCE = "ReplicationRegrTest";
    protected ReplicationManagerImpl[] replications;
    protected TestReplicationManagerClient[] clients;

    public ReplicationManagerRegrTest(Environment env) throws IOException {
        super(env);
        this.replications = new ReplicationManagerImpl[this.NUM_NODES];
        this.clients = new TestReplicationManagerClient[this.NUM_NODES];
    }

    public static void main(String[] args) throws IOException {
        Environment env = ReplicationManagerRegrTest.parseArgs(args);
        Parameters param = env.getParameters();
        param.setString("fileLogManager_filePrefix", "retest_");
        param.setString("fileLogManager_fileSuffix", ".log");
        ReplicationManagerRegrTest test = new ReplicationManagerRegrTest(env);
        test.start();
        env.destroy();
    }

    protected void processNode(int num, Node node) {
        this.clients[num] = new TestReplicationManagerClient(node);
        this.replications[num] = new ReplicationManagerImpl(node, this.clients[num], 3, INSTANCE);
    }

    protected void runTest() {
        for (int i = 0; i < this.NUM_NODES; ++i) {
            this.simulate();
        }
        this.testBasic();
        this.testOverload();
        this.testStress();
        this.testMaintenance();
    }

    public void testBasic() {
        int num = this.environment.getRandomSource().nextInt(this.NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = this.FACTORY.buildIdRange(this.FACTORY.buildId(new byte[20]), this.FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Basic Functionality");
        this.stepStart("Inserting Object");
        this.clients[num].insert(id);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        for (int i = 0; i < this.NUM_NODES; ++i) {
            this.simulate();
        }
        int count = 0;
        for (int i = 0; i < this.NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be 4 was " + count, count == 4);
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void testMaintenance() {
        int i;
        int num = this.environment.getRandomSource().nextInt(this.NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = this.FACTORY.buildIdRange(this.FACTORY.buildId(new byte[20]), this.FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Maintenance Functionality");
        this.stepStart("Inserting Object");
        this.clients[num].insert(id);
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        int count = 0;
        for (i = 0; i < this.NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be 4 was " + count, count == 4);
        this.stepDone("SUCCESS");
        this.stepStart("Killing Primary Replica");
        this.kill(num);
        this.stepDone("SUCCESS");
        this.waitToRecoverFromKilling(5000);
        this.waitToRecoverFromKilling(5000);
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        count = 0;
        for (i = 0; i < this.NUM_NODES; ++i) {
            if (!this.clients[i].scan(all).isMemberId(id)) continue;
            ++count;
        }
        this.assertTrue("Correct number of replicas should be 5 was " + count, count == 5);
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void testOverload() {
        int i;
        int NUM_TO_INSERT = 16;
        int num = this.environment.getRandomSource().nextInt(this.NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = this.FACTORY.buildIdRange(this.FACTORY.buildId(new byte[20]), this.FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Overload Functionality");
        this.stepStart("Inserting " + NUM_TO_INSERT + " Objects");
        for (i = 0; i < NUM_TO_INSERT; ++i) {
            this.clients[num].insert(this.addToId(id, i));
            this.simulate();
        }
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        for (i = 0; i < NUM_TO_INSERT + 1; ++i) {
            try {
                Thread.sleep(this.replications[0].FETCH_DELAY);
            }
            catch (InterruptedException e) {
                System.out.println(e.toString());
            }
            this.simulate();
        }
        for (int j = 0; j < NUM_TO_INSERT; ++j) {
            int count = 0;
            Id thisId = this.addToId(id, j);
            for (int i2 = 0; i2 < this.NUM_NODES; ++i2) {
                if (!this.clients[i2].scan(all).isMemberId(thisId)) continue;
                ++count;
            }
            this.assertTrue("Correct number of replicas for " + j + ":" + thisId + " should be " + 4 + " was " + count, count == 4);
        }
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void testStress() {
        int NUM_TO_INSERT = 45;
        Id[] ids = new Id[NUM_TO_INSERT];
        int num = this.environment.getRandomSource().nextInt(this.NUM_NODES);
        Id id = this.nodes[num].getId();
        IdRange all = this.FACTORY.buildIdRange(this.FACTORY.buildId(new byte[20]), this.FACTORY.buildId(new byte[20]));
        this.sectionStart("Testing Stressed Functionality");
        this.stepStart("Inserting " + NUM_TO_INSERT + " Objects");
        for (int i = 0; i < NUM_TO_INSERT; ++i) {
            ids[i] = this.addToId(id, i);
            this.clients[num].insert(ids[i]);
        }
        this.stepDone("SUCCESS");
        this.stepStart("Initiating Maintenance");
        this.runMaintenance();
        this.simulate();
        try {
            Thread.sleep(25000L);
        }
        catch (InterruptedException e) {
            System.out.println(e.toString());
        }
        this.simulate();
        for (int j = 0; j < NUM_TO_INSERT; ++j) {
            int count = 0;
            Id thisId = ids[j];
            for (int i = 0; i < this.NUM_NODES; ++i) {
                if (!this.clients[i].scan(all).isMemberId(thisId)) continue;
                ++count;
            }
            this.assertTrue("Correct number of replicas for " + j + " " + thisId + " should be " + 4 + " was " + count, count == 4);
        }
        this.stepDone("SUCCESS");
        this.sectionDone();
    }

    public void printValsForRange(IdRange range) {
        for (int i = 0; i < this.NUM_NODES; ++i) {
            System.out.println(i + " " + this.clients[i] + ":" + this.clients[i].scan(range));
        }
    }

    public void runMaintenance() {
        int i = 0;
        while (i < this.NUM_NODES) {
            final int j = i++;
            this.environment.getSelectorManager().invoke(new Runnable(){

                public void run() {
                    ReplicationManagerRegrTest.this.replications[j].getReplication().replicate();
                }
            });
        }
        this.simulate();
    }

    private Id generateId() {
        byte[] data = new byte[20];
        this.environment.getRandomSource().nextBytes(data);
        return this.FACTORY.buildId(data);
    }

    private Id addToId(Id id, int num) {
        byte[] bytes = id.toByteArray();
        bytes[0] = (byte)(bytes[0] + num);
        return this.FACTORY.buildId(bytes);
    }

    protected class TestReplicationManagerClient
    implements ReplicationManagerClient {
        public Node node;
        public IdSet set;

        public TestReplicationManagerClient(Node node) {
            this.set = node.getIdFactory().buildIdSet();
            this.node = node;
        }

        public void fetch(Id id, NodeHandle hint, Continuation command) {
            this.set.addId(id);
            command.receiveResult(new Boolean(true));
        }

        public void remove(Id id, Continuation command) {
            this.set.removeId(id);
            command.receiveResult(new Boolean(true));
        }

        public IdSet scan(IdRange range) {
            return this.set.subSet(range);
        }

        public void insert(Id id) {
            this.set.addId(id);
        }

        public boolean exists(Id id) {
            return this.set.isMemberId(id);
        }

        public void existsInOverlay(Id id, Continuation command) {
            command.receiveResult(Boolean.TRUE);
        }

        public void reInsert(Id id, Continuation command) {
            command.receiveResult(Boolean.TRUE);
        }

        public String toString() {
            String s = "TRMC:" + this.node;
            return s;
        }
    }
}

