/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class RingId
implements Id {
    public static short TYPE = (short)2;
    private static final long serialVersionUID = -4390496639871320200L;
    private static WeakHashMap RINGID_MAP = new WeakHashMap();
    protected Id id;
    protected Id ringId;

    private RingId(Id ringId, Id id) {
        this.id = id;
        this.ringId = ringId;
        if (id == null || ringId == null) {
            throw new IllegalArgumentException("RingId created with args " + ringId + " " + id);
        }
        if (id instanceof RingId) {
            throw new IllegalArgumentException("RingId created with id as a RingId!" + ringId + " " + id);
        }
        if (ringId instanceof RingId) {
            throw new IllegalArgumentException("RingId created with ringId as a RingId!" + ringId + " " + id);
        }
    }

    public static RingId build(Id ringId, Id id) {
        return RingId.resolve(new RingId(ringId, id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RingId resolve(RingId id) {
        WeakHashMap weakHashMap = RINGID_MAP;
        synchronized (weakHashMap) {
            WeakReference ref = (WeakReference)RINGID_MAP.get(id);
            RingId result = null;
            if (ref != null && (result = (RingId)ref.get()) != null) {
                return result;
            }
            RINGID_MAP.put(id, new WeakReference<RingId>(id));
            return id;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this;
    }

    public static RingId build(String s) {
        String[] sArray = s.split("\\(|\\)| |,");
        return RingId.build(rice.pastry.Id.build(sArray[1]), rice.pastry.Id.build(sArray[3]));
    }

    public Id getId() {
        return this.id;
    }

    public Id getRingId() {
        return this.ringId;
    }

    public boolean isBetween(Id ccw, Id cw) {
        if (!(ccw instanceof RingId && ((RingId)ccw).getRingId().equals(this.ringId) && cw instanceof RingId && ((RingId)cw).getRingId().equals(this.ringId))) {
            throw new IllegalArgumentException("Defined only for RingIds from the same ring!");
        }
        return this.id.isBetween(((RingId)ccw).getId(), ((RingId)cw).getId());
    }

    public boolean clockwise(Id nid) {
        if (!(nid instanceof RingId) || !((RingId)nid).getRingId().equals(this.ringId)) {
            throw new IllegalArgumentException("Defined only for RingIds from the same ring!");
        }
        return this.id.clockwise(((RingId)nid).getId());
    }

    public Id addToId(Id.Distance offset) {
        return RingId.build(this.ringId, this.id.addToId(offset));
    }

    public Id.Distance distanceFromId(Id nid) {
        if (!(nid instanceof RingId) || !((RingId)nid).getRingId().equals(this.ringId)) {
            throw new IllegalArgumentException("Defined only for RingIds from the same ring!");
        }
        return this.id.distanceFromId(((RingId)nid).getId());
    }

    public Id.Distance longDistanceFromId(Id nid) {
        if (!(nid instanceof RingId) || !((RingId)nid).getRingId().equals(this.ringId)) {
            throw new IllegalArgumentException("Defined only for RingIds from the same ring!");
        }
        return this.id.longDistanceFromId(((RingId)nid).getId());
    }

    public byte[] toByteArray() {
        return this.id.toByteArray();
    }

    public void toByteArray(byte[] array, int offset) {
        this.id.toByteArray(array, offset);
    }

    public int getByteArrayLength() {
        return this.id.getByteArrayLength();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RingId)) {
            return false;
        }
        return ((RingId)o).id.equals(this.id) && ((RingId)o).ringId.equals(this.ringId);
    }

    public int hashCode() {
        return this.id.hashCode() * this.ringId.hashCode();
    }

    public String toString() {
        return "(" + this.ringId + ", " + this.id + ")";
    }

    public String toStringFull() {
        return "(" + this.ringId.toStringFull() + ", " + this.id.toStringFull() + ")";
    }

    public int compareTo(Object o) {
        return this.id.compareTo(((RingId)o).id);
    }

    public short getType() {
        return TYPE;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort(this.ringId.getType());
        this.ringId.serialize(buf);
        buf.writeShort(this.id.getType());
        this.id.serialize(buf);
    }

    public RingId(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.ringId = endpoint.readId(buf, buf.readShort());
        this.id = endpoint.readId(buf, buf.readShort());
    }
}

