/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.multiring;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.DeliveryNotification;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.MessageReceipt;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.multiring.MultiringApplication;
import rice.p2p.multiring.MultiringEndpoint;
import rice.p2p.multiring.MultiringIdFactory;
import rice.p2p.multiring.MultiringNodeCollection;
import rice.p2p.multiring.MultiringNodeHandle;
import rice.p2p.multiring.RingId;
import rice.p2p.multiring.messaging.RingMessage;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribeImpl;
import rice.p2p.scribe.Topic;
import rice.p2p.scribe.rawserialization.ScribeContentDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiringNode
implements Node,
ScribeClient {
    protected Node node;
    protected Id ringId;
    protected Scribe scribe;
    protected MultiringNodeCollection collection;
    protected Hashtable endpoints;
    protected MultiringIdFactory factory;
    protected Environment environment;
    protected Logger logger;

    public MultiringNode(Id ringId, Node node) {
        this.node = node;
        this.environment = node.getEnvironment();
        this.logger = this.environment.getLogManager().getLogger(MultiringNode.class, null);
        this.ringId = ringId;
        this.endpoints = new Hashtable();
        this.scribe = new ScribeImpl(this, "Multiring");
        this.scribe.setContentDeserializer(new ScribeContentDeserializer(){

            public ScribeContent deserializeScribeContent(InputBuffer buf, Endpoint endpoint, short type) throws IOException {
                switch (type) {
                    case 1: {
                        return new RingMessage(buf, endpoint, MultiringNode.this.endpoints);
                    }
                }
                throw new IllegalArgumentException("Invalid type:" + type);
            }
        });
        this.collection = new MultiringNodeCollection(this, this.environment.getParameters().getInt("p2p_multiring_base"));
        this.factory = (MultiringIdFactory)this.getIdFactory();
    }

    public MultiringNode(Id ringId, Node node, MultiringNode existing) {
        this(ringId, node);
        this.collection = existing.getCollection();
        this.collection.addNode(this);
    }

    @Override
    public NodeHandle getLocalNodeHandle() {
        return new MultiringNodeHandle(this.getRingId(), this.node.getLocalNodeHandle());
    }

    @Override
    public Endpoint registerApplication(Application application, String instance) {
        MultiringEndpoint endpoint = new MultiringEndpoint(this, this.node.buildEndpoint(new MultiringApplication(this.getRingId(), application), application.getClass() + "-" + instance), application);
        this.endpoints.put(endpoint.getInstance(), endpoint);
        endpoint.register();
        return endpoint;
    }

    @Override
    public Endpoint buildEndpoint(Application application, String instance) {
        MultiringEndpoint endpoint = new MultiringEndpoint(this, this.node.buildEndpoint(new MultiringApplication(this.getRingId(), application), application.getClass() + "-" + instance), application);
        this.endpoints.put(endpoint.getInstance(), endpoint);
        return endpoint;
    }

    @Override
    public Id getId() {
        return RingId.build(this.ringId, this.node.getId());
    }

    public Id getRingId() {
        return this.ringId;
    }

    public Id getNodeId() {
        return this.node.getId();
    }

    public Node getNode() {
        return this.node;
    }

    public MultiringNodeCollection getCollection() {
        return this.collection;
    }

    @Override
    public IdFactory getIdFactory() {
        return new MultiringIdFactory(this.ringId, this.node.getIdFactory());
    }

    protected void nodeAdded(Id otherRingId) {
        this.scribe.subscribe(new Topic(RingId.build(this.ringId, otherRingId)), this);
    }

    MessageReceipt route(final RingId id, final RawMessage message, String application, DeliveryNotification deliverAckToMe, Map<String, Object> options) {
        if (id.getRingId().equals(this.ringId)) {
            MultiringEndpoint endpoint = (MultiringEndpoint)this.endpoints.get(application);
            return endpoint.route((Id)id, message, null, deliverAckToMe, options);
        }
        this.scribe.anycast(new Topic(RingId.build(this.ringId, this.getTarget(id))), new RingMessage(id, message, application));
        MessageReceipt ret = new MessageReceipt(){

            public boolean cancel() {
                return false;
            }

            public Message getMessage() {
                return message;
            }

            public Id getId() {
                return id;
            }

            public NodeHandle getHint() {
                return null;
            }
        };
        if (deliverAckToMe != null) {
            deliverAckToMe.sent(ret);
        }
        return ret;
    }

    private Id getTarget(RingId id) {
        int shared = this.collection.getLengthOfSharedPrefix((RingId)this.getId(), id);
        int thisLength = this.collection.getLength((RingId)this.getId());
        int targetLength = this.collection.getLength(id);
        if (shared == thisLength) {
            return this.makeTarget(id, thisLength + 1);
        }
        return this.makeTarget((RingId)this.getId(), thisLength - 1);
    }

    private Id makeTarget(RingId id, int length) {
        byte[] current = id.getRingId().toByteArray();
        byte[] bytes = new byte[current.length];
        for (int j = 0; j < this.collection.BASE * length; ++j) {
            bytes[bytes.length - 1 - j] = current[bytes.length - 1 - j];
        }
        return this.factory.buildNormalId(bytes);
    }

    @Override
    public boolean anycast(Topic topic, ScribeContent content) {
        if (content instanceof RingMessage) {
            RingMessage rm = (RingMessage)content;
            this.collection.route(rm.getId(), rm.getRawMessage(), rm.getApplication(), null, null);
        } else if (this.logger.level <= 900) {
            this.logger.log("Received unrecognized message " + content);
        }
        return true;
    }

    @Override
    public void deliver(Topic topic, ScribeContent content) {
        if (this.logger.level <= 400) {
            this.logger.log("Received unexpected delivery on topic " + topic + " of " + content);
        }
    }

    @Override
    public void childAdded(Topic topic, NodeHandle child) {
    }

    @Override
    public void childRemoved(Topic topic, NodeHandle child) {
    }

    @Override
    public void subscribeFailed(Topic topic) {
        if (this.logger.level <= 900) {
            this.logger.log(this.getId() + ": Received error joining ringId topic " + topic + " - trying again.");
        }
        this.nodeAdded(((RingId)topic.getId()).getId());
    }

    public String toString() {
        return "{MultiringNode " + this.getId() + "}";
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String printRouteState() {
        return this.node.printRouteState();
    }
}

