/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2;

import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.IdRange;

public class GlacierStatistics {
    public int[] messagesSentByTag;
    public int pendingRequests;
    public int numNeighbors;
    public int numFragments;
    public int numContinuations;
    public int numObjectsInTrash;
    public int activeFetches;
    public IdRange responsibleRange;
    public long fragmentStorageSize;
    public long trashStorageSize;
    public long tbegin;
    public long bucketMin;
    public long bucketMax;
    public long bucketConsumed;
    public long bucketTokensPerSecond;
    public long bucketMaxBurstSize;
    public Environment environment;

    public GlacierStatistics(int numTags, Environment env) {
        this.environment = env;
        this.messagesSentByTag = new int[numTags];
        this.pendingRequests = 0;
        this.numNeighbors = 0;
        this.numFragments = 0;
        this.numContinuations = 0;
        this.numObjectsInTrash = 0;
        this.fragmentStorageSize = 0L;
        this.trashStorageSize = 0L;
        this.activeFetches = 0;
        this.tbegin = env.getTimeSource().currentTimeMillis();
        this.bucketMin = 0L;
        this.bucketMax = 0L;
        this.bucketConsumed = 0L;
    }

    public void dump(Logger logger) {
        String s = "";
        s = s + "@L.ME free=" + Runtime.getRuntime().freeMemory() + " max=" + Runtime.getRuntime().maxMemory() + " total=" + Runtime.getRuntime().totalMemory() + "\n";
        s = s + "@L.GL interval=" + this.tbegin + "-" + this.environment.getTimeSource().currentTimeMillis() + " range=" + this.responsibleRange + "\n";
        s = s + "@L.GL   neighbors=" + this.numNeighbors + " fragments=" + this.numFragments + " trash=" + this.numObjectsInTrash + "\n";
        s = s + "@L.GL   continuations=" + this.numContinuations + " pending=" + this.pendingRequests + "\n";
        s = s + "@L.GL   fragSizeBytes=" + this.fragmentStorageSize + " trashSizeBytes=" + this.trashStorageSize + "\n";
        s = s + "@L.GL   activeFetches=" + this.activeFetches + " bucketMin=" + this.bucketMin + " bucketMax=" + this.bucketMax + "\n";
        s = s + "@L.GL   bucketConsumed=" + this.bucketConsumed + "\n";
        s = s + "@L.GL   byTag=";
        for (int i = 0; i < this.messagesSentByTag.length; ++i) {
            s = s + this.messagesSentByTag[i] + " ";
        }
        s = s + "\n";
        if (logger.level <= 800) {
            logger.log(s);
        }
    }
}

