/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier.v2;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import rice.p2p.commonapi.Id;
import rice.p2p.glacier.v2.DebugContentHandle;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.gc.GCPastContentHandle;
import rice.p2p.past.gc.GCPastMetadata;

public class DebugContent
implements GCPastContent {
    protected Id myId;
    protected boolean isMutable;
    protected long version;
    protected transient byte[] payload;

    public DebugContent(Id id, boolean isMutable, long version, byte[] payload) {
        this.myId = id;
        this.isMutable = isMutable;
        this.version = version;
        this.payload = payload;
    }

    public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
        if (!this.isMutable || !(existingContent instanceof DebugContent)) {
            return this;
        }
        DebugContent dc = (DebugContent)existingContent;
        return this.version > dc.version ? this : dc;
    }

    public long getVersion() {
        return this.version;
    }

    public PastContentHandle getHandle(Past local) {
        return new DebugContentHandle(this.myId, this.version, Long.MAX_VALUE, local.getLocalNodeHandle());
    }

    public GCPastContentHandle getHandle(GCPast local, long expiration) {
        return new DebugContentHandle(this.myId, this.version, expiration, local.getLocalNodeHandle());
    }

    public Id getId() {
        return this.myId;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.payload.length);
        oos.write(this.payload);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.payload = new byte[ois.readInt()];
        ois.readFully(this.payload, 0, this.payload.length);
    }

    public GCPastMetadata getMetadata(long expiration) {
        return new GCPastMetadata(expiration);
    }
}

