/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.past.gc.rawserialization.RawGCPastContentHandle;

public class AggregateHandle
implements RawGCPastContentHandle {
    public static final short TYPE = 1;
    protected Id id;
    protected NodeHandle handle;
    protected long version;
    protected long expiration;

    public AggregateHandle(NodeHandle handle, Id id, long version, long expiration) {
        this.id = id;
        this.handle = handle;
        this.version = version;
        this.expiration = expiration;
    }

    public Id getId() {
        return this.id;
    }

    public NodeHandle getNodeHandle() {
        return this.handle;
    }

    public long getVersion() {
        return this.version;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public short getType() {
        return 1;
    }

    public AggregateHandle(InputBuffer buf, Endpoint endpoint) throws IOException {
        this.version = buf.readLong();
        this.expiration = buf.readLong();
        this.id = endpoint.readId(buf, buf.readShort());
        this.handle = endpoint.readNodeHandle(buf);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeLong(this.version);
        buf.writeLong(this.expiration);
        buf.writeShort(this.id.getType());
        this.id.serialize(buf);
        this.handle.serialize(buf);
    }
}

