/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import rice.p2p.aggregation.AggregateHandle;
import rice.p2p.commonapi.Id;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastException;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.gc.GCPastContentHandle;
import rice.p2p.past.gc.GCPastMetadata;

public class Aggregate
implements GCPastContent {
    protected GCPastContent[] components;
    protected Id[] pointers;
    protected Id myId;
    private static final long serialVersionUID = -4891386773008082L;

    public Aggregate(GCPastContent[] components, Id[] pointers) {
        this.components = components;
        this.myId = null;
        this.pointers = pointers;
    }

    public void setId(Id myId) {
        this.myId = myId;
    }

    public Id getId() {
        return this.myId;
    }

    public Id[] getPointers() {
        return this.pointers;
    }

    public int numComponents() {
        return this.components.length;
    }

    public GCPastContent getComponent(int index) {
        return this.components[index];
    }

    public long getVersion() {
        return 0L;
    }

    public boolean isMutable() {
        return false;
    }

    public PastContent checkInsert(Id id, PastContent existingContent) throws PastException {
        if (existingContent == null) {
            return this;
        }
        return existingContent;
    }

    public byte[] getContentHash() {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(this.components);
            objectStream.writeObject(this.pointers);
            objectStream.flush();
            bytes = byteStream.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.reset();
        md.update(bytes);
        return md.digest();
    }

    public PastContentHandle getHandle(Past local) {
        return new AggregateHandle(local.getLocalNodeHandle(), this.myId, this.getVersion(), Long.MAX_VALUE);
    }

    public GCPastContentHandle getHandle(GCPast local, long expiration) {
        return new AggregateHandle(local.getLocalNodeHandle(), this.myId, this.getVersion(), expiration);
    }

    public GCPastMetadata getMetadata(long expiration) {
        return new GCPastMetadata(expiration);
    }
}

