/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.params.simple;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import rice.environment.params.ParameterChangeListener;
import rice.environment.params.Parameters;
import rice.environment.params.simple.ParamsNotPresentException;

public class SimpleParameters
implements Parameters {
    private MyProperties properties;
    private MyProperties defaults;
    private Set changeListeners;
    private String configFileName;
    public static final String FILENAME_EXTENSION = ".params";
    public static final String ARRAY_SPACER = ",";
    public static final String defaultParamsFile = "user.params";

    public SimpleParameters(String[] orderedDefaults, String mutableConfigFileName) {
        if (mutableConfigFileName != null) {
            this.configFileName = mutableConfigFileName + FILENAME_EXTENSION;
        } else {
            try {
                File f = new File(defaultParamsFile);
                if (f.exists()) {
                    this.configFileName = defaultParamsFile;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.properties = new MyProperties();
        this.defaults = new MyProperties();
        this.changeListeners = new HashSet();
        for (int ctr = 0; ctr < orderedDefaults.length; ++ctr) {
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                this.defaults.load(loader.getResource(orderedDefaults[ctr] + FILENAME_EXTENSION).openStream());
                continue;
            }
            catch (Exception ioe) {
                String errorString = "Warning, couldn't load param file:" + orderedDefaults[ctr] + FILENAME_EXTENSION;
                throw new ParamsNotPresentException(errorString, ioe);
            }
        }
        if (this.configFileName != null) {
            File f = new File(this.configFileName);
            if (f.exists()) {
                try {
                    this.properties.load(new FileInputStream(this.configFileName));
                }
                catch (Exception e) {
                    throw new ParamsNotPresentException("Error loading " + f, e);
                }
            } else {
                System.err.println("Configuration file " + f.getAbsolutePath() + " not present.  Using defaults.");
            }
        }
    }

    public Enumeration enumerateDefaults() {
        return this.defaults.keys();
    }

    public Enumeration enumerateNonDefaults() {
        return this.properties.keys();
    }

    protected InetSocketAddress parseInetSocketAddress(String name) throws UnknownHostException {
        String host = name.substring(0, name.indexOf(":"));
        String port = name.substring(name.indexOf(":") + 1);
        try {
            return new InetSocketAddress(InetAddress.getByName(host), Integer.parseInt(port));
        }
        catch (UnknownHostException uhe) {
            System.err.println("ERROR: Unable to find IP for ISA " + name + " - returning null.");
            return null;
        }
    }

    protected String getProperty(String name) {
        String result = this.properties.getProperty(name);
        if (result == null) {
            result = this.defaults.getProperty(name);
        }
        if (result == null) {
            System.err.println("WARNING: The parameter '" + name + "' was not found - this is likely going to cause an error.");
        } else {
            result = result.trim();
        }
        return result;
    }

    protected void setProperty(String name, String value) {
        if (this.defaults.getProperty(name) != null && this.defaults.getProperty(name).equals(value)) {
            if (this.properties.getProperty(name) != null) {
                this.properties.remove(name);
                this.fireChangeEvent(name, value);
            }
        } else if (this.properties.getProperty(name) == null || !this.properties.getProperty(name).equals(value)) {
            this.properties.setProperty(name, value);
            this.fireChangeEvent(name, value);
        }
    }

    public void remove(String name) {
        this.properties.remove(name);
        this.fireChangeEvent(name, null);
    }

    public boolean contains(String name) {
        if (this.defaults.containsKey(name)) {
            return true;
        }
        return this.properties.containsKey(name);
    }

    public int getInt(String name) {
        try {
            return Integer.parseInt(this.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(nfe.getMessage() + " for parameter " + name);
        }
    }

    public double getDouble(String name) {
        try {
            return Double.parseDouble(this.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(nfe.getMessage() + " for parameter " + name);
        }
    }

    public float getFloat(String name) {
        try {
            return Float.parseFloat(this.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(nfe.getMessage() + " for parameter " + name);
        }
    }

    public long getLong(String name) {
        try {
            return Long.parseLong(this.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(nfe.getMessage() + " for parameter " + name);
        }
    }

    public boolean getBoolean(String name) {
        return new Boolean(this.getProperty(name));
    }

    public InetAddress getInetAddress(String name) throws UnknownHostException {
        return InetAddress.getByName(this.getString(name));
    }

    public InetSocketAddress getInetSocketAddress(String name) throws UnknownHostException {
        return this.parseInetSocketAddress(this.getString(name));
    }

    public InetSocketAddress[] getInetSocketAddressArray(String name) throws UnknownHostException {
        if (this.getString(name).length() == 0) {
            return new InetSocketAddress[0];
        }
        String[] addresses = this.getString(name).split(ARRAY_SPACER);
        LinkedList<InetSocketAddress> result = new LinkedList<InetSocketAddress>();
        for (int i = 0; i < addresses.length; ++i) {
            InetSocketAddress address = this.parseInetSocketAddress(addresses[i]);
            if (address == null) continue;
            result.add(address);
        }
        return result.toArray(new InetSocketAddress[0]);
    }

    public String getString(String name) {
        return this.getProperty(name);
    }

    public String[] getStringArray(String name) {
        String list = this.getProperty(name);
        if (list != null) {
            return list.equals("") ? new String[]{} : list.split(ARRAY_SPACER);
        }
        return null;
    }

    public void setInt(String name, int value) {
        this.setProperty(name, Integer.toString(value));
    }

    public void setDouble(String name, double value) {
        this.setProperty(name, Double.toString(value));
    }

    public void setFloat(String name, float value) {
        this.setProperty(name, Float.toString(value));
    }

    public void setLong(String name, long value) {
        this.setProperty(name, Long.toString(value));
    }

    public void setBoolean(String name, boolean value) {
        this.setProperty(name, "" + value);
    }

    public void setInetAddress(String name, InetAddress value) {
        this.setProperty(name, value.getHostAddress());
    }

    public void setInetSocketAddress(String name, InetSocketAddress value) {
        this.setProperty(name, value.getAddress().getHostAddress() + ":" + value.getPort());
    }

    public void setInetSocketAddressArray(String name, InetSocketAddress[] value) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            buffer.append(value[i].getAddress().getHostAddress() + ":" + value[i].getPort());
            if (i >= value.length - 1) continue;
            buffer.append(ARRAY_SPACER);
        }
        this.setProperty(name, buffer.toString());
    }

    public void setString(String name, String value) {
        this.setProperty(name, value);
    }

    public void setStringArray(String name, String[] value) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            buffer.append(value[i]);
            if (i >= value.length - 1) continue;
            buffer.append(ARRAY_SPACER);
        }
        this.setProperty(name, buffer.toString());
    }

    public void store() throws IOException {
        if (this.configFileName == null) {
            return;
        }
        try {
            File current = new File(this.configFileName);
            File next = new File(this.configFileName + ".new");
            File old = new File(this.configFileName + ".old");
            this.properties.store(new FileOutputStream(next), null);
            current.renameTo(old);
            next.renameTo(current);
            old.delete();
        }
        catch (IOException ioe) {
            System.err.println("[Loader       ]: Unable to store properties file " + this.configFileName + ", got error " + ioe);
            throw ioe;
        }
    }

    public void addChangeListener(ParameterChangeListener p) {
        this.changeListeners.add(p);
    }

    public void removeChangeListener(ParameterChangeListener p) {
        this.changeListeners.remove(p);
    }

    private void fireChangeEvent(String name, String val) {
        for (ParameterChangeListener p : this.changeListeners) {
            p.parameterChange(name, val);
        }
    }

    protected class MyProperties
    extends Properties {
        protected MyProperties() {
        }

        public Enumeration keys() {
            Object[] keys = this.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            return new Enumeration((String[])keys){
                int pos = 0;
                final /* synthetic */ String[] val$keys;
                {
                    this.val$keys = stringArray;
                }

                public boolean hasMoreElements() {
                    return this.pos < this.val$keys.length;
                }

                public Object nextElement() {
                    return this.val$keys[this.pos++];
                }
            };
        }
    }
}

