/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.wire.magicnumber;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.ListenableTransportLayer;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.TransportLayerListener;
import org.mpisws.p2p.transport.util.DefaultCallback;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.wire.exception.StalledSocketException;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Cancellable;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagicNumberTransportLayer<Identifier>
implements TransportLayer<Identifier, ByteBuffer>,
TransportLayerCallback<Identifier, ByteBuffer>,
ListenableTransportLayer<Identifier> {
    protected Logger logger;
    protected Environment environment;
    protected TransportLayerCallback<Identifier, ByteBuffer> callback;
    protected ErrorHandler<Identifier> errorHandler;
    protected TransportLayer<Identifier, ByteBuffer> wire;
    public byte[] HEADER;
    public int SOCKET_TIMEOUT;
    ArrayList<TransportLayerListener<Identifier>> listeners = new ArrayList();

    public MagicNumberTransportLayer(TransportLayer<Identifier, ByteBuffer> wtl, Environment env, ErrorHandler<Identifier> errorHandler, byte[] header, int timeOut) {
        this.logger = env.getLogManager().getLogger(MagicNumberTransportLayer.class, null);
        this.environment = env;
        this.wire = wtl;
        this.HEADER = header;
        this.SOCKET_TIMEOUT = timeOut;
        this.errorHandler = errorHandler;
        this.callback = new DefaultCallback<Identifier, ByteBuffer>(this.logger);
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler(this.logger);
        }
        this.wire.setCallback(this);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.wire.setErrorHandler(handler);
        if (handler == null) {
            this.errorHandler = new DefaultErrorHandler(this.logger);
            return;
        }
        this.errorHandler = handler;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.wire.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.wire.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.wire.getLocalIdentifier();
    }

    @Override
    public SocketRequestHandle openSocket(Identifier i, final SocketCallback<Identifier> deliverSocketToMe, Map<String, Object> options) {
        if (deliverSocketToMe == null) {
            throw new IllegalArgumentException("deliverSocketToMe must be non-null!");
        }
        final SocketRequestHandleImpl<Identifier> cancellable = new SocketRequestHandleImpl<Identifier>(i, options, this.logger);
        cancellable.setSubCancellable(this.wire.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> c, final P2PSocket<Identifier> result) {
                if (cancellable.getSubCancellable() != null && c != cancellable.getSubCancellable()) {
                    throw new RuntimeException("c != cancellable.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + cancellable.getSubCancellable());
                }
                cancellable.setSubCancellable(new Cancellable(){

                    public boolean cancel() {
                        result.close();
                        return true;
                    }
                });
                result.register(false, true, new P2PSocketReceiver<Identifier>(){
                    ByteBuffer buf;
                    {
                        this.buf = ByteBuffer.wrap(MagicNumberTransportLayer.this.HEADER);
                    }

                    @Override
                    public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                        if (canRead) {
                            throw new IOException("Never asked to read!");
                        }
                        if (!canWrite) {
                            throw new IOException("Can't write!");
                        }
                        long ret = socket.write(this.buf);
                        if (ret < 0L) {
                            socket.close();
                            return;
                        }
                        MagicNumberTransportLayer.this.notifyListenersWrite((int)ret, socket.getIdentifier(), socket.getOptions(), false, true);
                        if (this.buf.hasRemaining()) {
                            socket.register(false, true, this);
                        } else {
                            deliverSocketToMe.receiveResult(cancellable, socket);
                        }
                    }

                    @Override
                    public void receiveException(P2PSocket<Identifier> socket, Exception e) {
                        deliverSocketToMe.receiveException(cancellable, e);
                    }
                });
            }

            @Override
            public void receiveException(SocketRequestHandle<Identifier> c, Exception exception) {
                if (cancellable.getSubCancellable() != null && c != cancellable.getSubCancellable()) {
                    throw new RuntimeException("c != cancellable.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + cancellable.getSubCancellable());
                }
                deliverSocketToMe.receiveException(cancellable, exception);
            }
        }, options));
        return cancellable;
    }

    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(final Identifier i, ByteBuffer m, final MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        byte[] msgWithHeader = new byte[this.HEADER.length + m.remaining()];
        System.arraycopy(this.HEADER, 0, msgWithHeader, 0, this.HEADER.length);
        m.get(msgWithHeader, this.HEADER.length, m.remaining());
        if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + i + "," + m + ")");
        }
        final MessageRequestHandleImpl<Identifier, ByteBuffer> cancellable = new MessageRequestHandleImpl<Identifier, ByteBuffer>(i, m, options);
        final ByteBuffer buf = ByteBuffer.wrap(msgWithHeader);
        cancellable.setSubCancellable(this.wire.sendMessage(i, buf, new MessageCallback<Identifier, ByteBuffer>(){

            @Override
            public void ack(MessageRequestHandle<Identifier, ByteBuffer> msg) {
                if (cancellable.getSubCancellable() != null && msg != cancellable.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + cancellable.getSubCancellable());
                }
                if (deliverAckToMe != null) {
                    deliverAckToMe.ack(cancellable);
                }
                MagicNumberTransportLayer.this.notifyListenersWrite(MagicNumberTransportLayer.this.HEADER.length, i, cancellable.getOptions(), false, false);
                MagicNumberTransportLayer.this.notifyListenersWrite(buf.limit() - MagicNumberTransportLayer.this.HEADER.length, i, cancellable.getOptions(), true, false);
            }

            @Override
            public void sendFailed(MessageRequestHandle<Identifier, ByteBuffer> msg, Exception ex) {
                if (cancellable.getSubCancellable() != null && msg != cancellable.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + cancellable.getSubCancellable());
                }
                if (deliverAckToMe == null) {
                    MagicNumberTransportLayer.this.errorHandler.receivedException(i, ex);
                } else {
                    deliverAckToMe.sendFailed(cancellable, ex);
                }
            }
        }, options));
        return cancellable;
    }

    @Override
    public void destroy() {
        this.wire.destroy();
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        s.register(true, false, new VerifyHeaderReceiver(s));
    }

    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Object> options) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("messageReceived(" + i + "," + m + ")");
        }
        if (m.remaining() < this.HEADER.length) {
            this.errorHandler.receivedUnexpectedData(i, m.array(), 0, null);
            return;
        }
        byte[] hdr = new byte[this.HEADER.length];
        m.get(hdr);
        if (Arrays.equals(this.HEADER, hdr)) {
            this.callback.messageReceived(i, m, options);
            this.notifyListenersRead(this.HEADER.length, i, options, false, false);
            this.notifyListenersRead(m.remaining(), i, options, true, false);
            return;
        }
        this.notifyListenersRead(this.HEADER.length, i, options, false, false);
        this.notifyListenersRead(m.remaining(), i, options, true, false);
        this.errorHandler.receivedUnexpectedData(i, m.array(), 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransportLayerListener(TransportLayerListener<Identifier> listener) {
        ArrayList<TransportLayerListener<Identifier>> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransportLayerListener(TransportLayerListener<Identifier> listener) {
        ArrayList<TransportLayerListener<Identifier>> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersRead(int bytesRead, Identifier identifier, Map<String, Object> options, boolean passthrough, boolean socket) {
        ArrayList<TransportLayerListener<Identifier>> i;
        ArrayList<TransportLayerListener<Identifier>> arrayList = this.listeners;
        synchronized (arrayList) {
            i = new ArrayList<TransportLayerListener<Identifier>>(this.listeners);
        }
        for (TransportLayerListener transportLayerListener : i) {
            transportLayerListener.read(bytesRead, identifier, options, passthrough, socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersWrite(int bytesRead, Identifier identifier, Map<String, Object> options, boolean passthrough, boolean socket) {
        ArrayList<TransportLayerListener<Identifier>> i;
        ArrayList<TransportLayerListener<Identifier>> arrayList = this.listeners;
        synchronized (arrayList) {
            i = new ArrayList<TransportLayerListener<Identifier>>(this.listeners);
        }
        for (TransportLayerListener transportLayerListener : i) {
            transportLayerListener.wrote(bytesRead, identifier, options, passthrough, socket);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VerifyHeaderReceiver
    extends TimerTask
    implements P2PSocketReceiver<Identifier> {
        ByteBuffer buf;
        P2PSocket<Identifier> socket;

        public VerifyHeaderReceiver(P2PSocket<Identifier> s) {
            this.buf = ByteBuffer.allocate(MagicNumberTransportLayer.this.HEADER.length);
            this.socket = s;
            MagicNumberTransportLayer.this.environment.getSelectorManager().getTimer().schedule(this, MagicNumberTransportLayer.this.SOCKET_TIMEOUT);
        }

        @Override
        public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
            MagicNumberTransportLayer.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
        }

        @Override
        public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
            if (canWrite) {
                throw new IOException("Never asked to write!");
            }
            if (!canRead) {
                throw new IOException("Can't read!");
            }
            long bytesRead = socket.read(this.buf);
            if (bytesRead < 0L) {
                socket.close();
                return;
            }
            MagicNumberTransportLayer.this.notifyListenersRead((int)bytesRead, socket.getIdentifier(), socket.getOptions(), false, true);
            if (this.buf.hasRemaining()) {
                socket.register(true, false, this);
            } else if (Arrays.equals(MagicNumberTransportLayer.this.HEADER, this.buf.array())) {
                this.cancel();
                MagicNumberTransportLayer.this.callback.incomingSocket(socket);
            } else {
                this.cancel();
                MagicNumberTransportLayer.this.errorHandler.receivedUnexpectedData(socket.getIdentifier(), this.buf.array(), 0, null);
            }
        }

        @Override
        public void run() {
            this.socket.close();
            MagicNumberTransportLayer.this.errorHandler.receivedException(this.socket.getIdentifier(), new StalledSocketException(this.socket.getIdentifier(), "Timeout on incoming socket expired."));
        }

        public String toString() {
            return MagicNumberTransportLayer.this + " VHR";
        }
    }
}

