/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.wire;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketCountListener;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.TransportLayerListener;
import org.mpisws.p2p.transport.util.DefaultCallback;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.wire.BogusUDPLayerImpl;
import org.mpisws.p2p.transport.wire.SocketOpeningTransportLayer;
import org.mpisws.p2p.transport.wire.TCPLayer;
import org.mpisws.p2p.transport.wire.UDPLayer;
import org.mpisws.p2p.transport.wire.UDPLayerImpl;
import org.mpisws.p2p.transport.wire.WireTransportLayer;
import rice.environment.Environment;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireTransportLayerImpl
implements WireTransportLayer,
SocketOpeningTransportLayer<InetSocketAddress> {
    protected InetSocketAddress bindAddress;
    protected UDPLayer udp;
    protected TCPLayer tcp;
    protected Logger logger;
    protected Environment environment;
    private TransportLayerCallback<InetSocketAddress, ByteBuffer> callback;
    protected ErrorHandler<InetSocketAddress> errorHandler;
    boolean destroyed = false;
    Collection<TransportLayerListener<InetSocketAddress>> listeners = new ArrayList<TransportLayerListener<InetSocketAddress>>();
    Collection<SocketCountListener<InetSocketAddress>> slisteners = new ArrayList<SocketCountListener<InetSocketAddress>>();

    public WireTransportLayerImpl(InetSocketAddress bindAddress, Environment env, ErrorHandler<InetSocketAddress> errorHandler) throws IOException {
        this(bindAddress, env, errorHandler, true);
    }

    public WireTransportLayerImpl(InetSocketAddress bindAddress, Environment env, ErrorHandler<InetSocketAddress> errorHandler, boolean enableServer) throws IOException {
        this(bindAddress, env, errorHandler, enableServer, enableServer);
    }

    public WireTransportLayerImpl(InetSocketAddress bindAddress, Environment env, ErrorHandler<InetSocketAddress> errorHandler, boolean enableTCPServer, boolean enableUDPServer) throws IOException {
        this.logger = env.getLogManager().getLogger(WireTransportLayer.class, null);
        this.bindAddress = bindAddress;
        this.environment = env;
        this.callback = new DefaultCallback<InetSocketAddress, ByteBuffer>(this.logger);
        this.errorHandler = errorHandler;
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler<InetSocketAddress>(this.logger);
        }
        this.udp = enableUDPServer ? new UDPLayerImpl(this) : new BogusUDPLayerImpl();
        try {
            this.tcp = new TCPLayer(this, enableTCPServer);
        }
        catch (IOException ioe) {
            this.udp.destroy();
            throw ioe;
        }
    }

    @Override
    public void setCallback(TransportLayerCallback<InetSocketAddress, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public SocketRequestHandle<InetSocketAddress> openSocket(InetSocketAddress destination, SocketCallback<InetSocketAddress> deliverSocketToMe, Map<String, Object> options) {
        return this.tcp.openSocket(destination, deliverSocketToMe, options);
    }

    @Override
    public MessageRequestHandle<InetSocketAddress, ByteBuffer> sendMessage(InetSocketAddress destination, ByteBuffer m, MessageCallback<InetSocketAddress, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + destination + "," + m + ")");
        }
        return this.udp.sendMessage(destination, m, deliverAckToMe, options);
    }

    @Override
    public InetSocketAddress getLocalIdentifier() {
        return this.bindAddress;
    }

    @Override
    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("destroy()");
        }
        this.destroyed = true;
        this.udp.destroy();
        this.tcp.destroy();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void setErrorHandler(ErrorHandler<InetSocketAddress> handler) {
        if (handler == null) {
            this.errorHandler = new DefaultErrorHandler<InetSocketAddress>(this.logger);
            return;
        }
        this.errorHandler = handler;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.udp.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tcp.acceptSockets(b);
    }

    protected void messageReceived(InetSocketAddress address, ByteBuffer buffer, Map<String, Object> options) throws IOException {
        this.callback.messageReceived(address, buffer, options);
    }

    protected void incomingSocket(P2PSocket<InetSocketAddress> sm) throws IOException {
        this.broadcastChannelOpened(sm.getIdentifier(), sm.getOptions(), false);
        this.callback.incomingSocket(sm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransportLayerListener(TransportLayerListener<InetSocketAddress> listener) {
        Collection<TransportLayerListener<InetSocketAddress>> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransportLayerListener(TransportLayerListener<InetSocketAddress> listener) {
        Collection<TransportLayerListener<InetSocketAddress>> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<TransportLayerListener<InetSocketAddress>> getTLlisteners() {
        Collection<TransportLayerListener<InetSocketAddress>> collection = this.listeners;
        synchronized (collection) {
            return new ArrayList<TransportLayerListener<InetSocketAddress>>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSocketCountListener(SocketCountListener<InetSocketAddress> listener) {
        Collection<SocketCountListener<InetSocketAddress>> collection = this.slisteners;
        synchronized (collection) {
            this.slisteners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSocketCountListener(SocketCountListener<InetSocketAddress> listener) {
        Collection<SocketCountListener<InetSocketAddress>> collection = this.slisteners;
        synchronized (collection) {
            this.slisteners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<SocketCountListener<InetSocketAddress>> getSlisteners() {
        Collection<SocketCountListener<InetSocketAddress>> collection = this.slisteners;
        synchronized (collection) {
            return new ArrayList<SocketCountListener<InetSocketAddress>>(this.slisteners);
        }
    }

    public void broadcastChannelOpened(InetSocketAddress addr, Map<String, Object> options, boolean outgoing) {
        for (SocketCountListener<InetSocketAddress> listener : this.getSlisteners()) {
            listener.socketOpened(addr, options, outgoing);
        }
    }

    public void broadcastChannelClosed(InetSocketAddress addr, Map<String, Object> options) {
        for (SocketCountListener<InetSocketAddress> listener : this.getSlisteners()) {
            listener.socketClosed(addr, options);
        }
    }
}

