/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import rice.Continuation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferWriter<Identifier>
implements P2PSocketReceiver<Identifier> {
    ByteBuffer sizeBuf = null;
    ByteBuffer writeMe;
    Continuation<P2PSocket<Identifier>, Exception> continuation;

    public BufferWriter(ByteBuffer writeMe, P2PSocket<Identifier> socket, Continuation<P2PSocket<Identifier>, Exception> continuation, boolean includeSizeHeader) {
        this.writeMe = writeMe;
        this.continuation = continuation;
        if (includeSizeHeader) {
            this.sizeBuf = ByteBuffer.allocate(4);
            this.sizeBuf.asIntBuffer().put(writeMe.remaining());
            this.sizeBuf.clear();
        }
        try {
            this.receiveSelectResult(socket, false, true);
        }
        catch (IOException ioe) {
            this.receiveException(socket, ioe);
        }
    }

    public BufferWriter(ByteBuffer writeMe, P2PSocket<Identifier> socket, Continuation<P2PSocket<Identifier>, Exception> continuation) {
        this(writeMe, socket, continuation, true);
    }

    @Override
    public void receiveException(P2PSocket<Identifier> socket, Exception ioe) {
        if (this.continuation == null) {
            socket.close();
        } else {
            this.continuation.receiveException(ioe);
        }
    }

    @Override
    public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
        if (this.sizeBuf != null && this.sizeBuf.hasRemaining() && socket.write(this.sizeBuf) < 0L) {
            this.receiveException(socket, new ClosedChannelException("Unexpected closure of channel to " + socket.getIdentifier()));
            return;
        }
        if (socket.write(this.writeMe) < 0L) {
            this.receiveException(socket, new ClosedChannelException("Unexpected closure of channel to " + socket.getIdentifier()));
            return;
        }
        if (this.writeMe.hasRemaining()) {
            socket.register(false, true, this);
            return;
        }
        if (this.continuation == null) {
            socket.close();
        } else {
            this.continuation.receiveResult(socket);
        }
    }
}

