/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.sourceroute.factory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.SourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.factory.WireSourceRoute;
import rice.p2p.commonapi.rawserialization.InputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireSourceRouteFactory
implements SourceRouteFactory<InetSocketAddress> {
    @Override
    public SourceRoute<InetSocketAddress> build(InputBuffer buf, InetSocketAddress localAddr, InetSocketAddress lastHop) throws IOException {
        int numInPath = buf.readByte();
        ArrayList<InetSocketAddress> path = new ArrayList<InetSocketAddress>(numInPath);
        for (int i = 0; i < numInPath; ++i) {
            byte[] addrBytes = new byte[4];
            buf.read(addrBytes);
            InetAddress addr = InetAddress.getByAddress(addrBytes);
            short port = buf.readShort();
            path.add(new InetSocketAddress(addr, 0xFFFF & port));
        }
        return new WireSourceRoute((List<InetSocketAddress>)path);
    }

    @Override
    public SourceRoute<InetSocketAddress> getSourceRoute(List<InetSocketAddress> route) {
        return new WireSourceRoute(route);
    }

    @Override
    public SourceRoute<InetSocketAddress> reverse(SourceRoute<InetSocketAddress> route) {
        WireSourceRoute temp = (WireSourceRoute)route;
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>(temp.getPath());
        Collections.reverse(result);
        return new WireSourceRoute((List<InetSocketAddress>)result);
    }

    @Override
    public SourceRoute<InetSocketAddress> getSourceRoute(InetSocketAddress local, InetSocketAddress dest) {
        return new WireSourceRoute(local, dest);
    }

    @Override
    public SourceRoute<InetSocketAddress> getSourceRoute(InetSocketAddress local) {
        return new WireSourceRoute(local);
    }
}

