/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.statement;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.PeerReviewCallback;
import org.mpisws.p2p.transport.peerreview.audit.LogSnippet;
import org.mpisws.p2p.transport.peerreview.challenge.ChallengeResponseProtocol;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.evidence.AuditResponse;
import org.mpisws.p2p.transport.peerreview.evidence.ChallengeAudit;
import org.mpisws.p2p.transport.peerreview.evidence.ProofInconsistent;
import org.mpisws.p2p.transport.peerreview.evidence.ProofNonconformant;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStore;
import org.mpisws.p2p.transport.peerreview.message.AckMessage;
import org.mpisws.p2p.transport.peerreview.message.UserDataMessage;
import org.mpisws.p2p.transport.peerreview.replay.Verifier;
import org.mpisws.p2p.transport.peerreview.statement.IncompleteStatementInfo;
import org.mpisws.p2p.transport.peerreview.statement.Statement;
import org.mpisws.p2p.transport.peerreview.statement.StatementProtocol;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.MathUtils;
import rice.p2p.util.tuples.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementProtocolImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements StatementProtocol<Handle, Identifier> {
    protected Logger logger;
    protected Map<Identifier, LinkedList<IncompleteStatementInfo<Handle, Identifier>>> incompleteStatement = new HashMap<Identifier, LinkedList<IncompleteStatementInfo<Handle, Identifier>>>();
    protected ChallengeResponseProtocol<Handle, Identifier> challengeProtocol;
    protected IdentityTransport<Handle, Identifier> transport;
    protected PeerReview<Handle, Identifier> peerreview;
    protected PeerInfoStore<Handle, Identifier> infoStore;
    protected boolean progressTimerActive;

    public StatementProtocolImpl(PeerReview<Handle, Identifier> peerreview, ChallengeResponseProtocol<Handle, Identifier> challengeProtocol, PeerInfoStore<Handle, Identifier> infoStore, IdentityTransport<Handle, Identifier> transport) {
        this.peerreview = peerreview;
        this.challengeProtocol = challengeProtocol;
        this.infoStore = infoStore;
        this.transport = transport;
        this.logger = peerreview.getEnvironment().getLogManager().getLogger(StatementProtocolImpl.class, null);
    }

    public void notifyCertificateAvailable(Identifier id) {
        Collection foo = this.incompleteStatement.get(id);
        if (foo != null) {
            for (IncompleteStatementInfo is : foo) {
                if (is.isFinished() || !is.isMissingCertificate()) continue;
                this.makeProgressOnStatement(is);
            }
        }
    }

    public void cleanupIncompleteStatements() {
        long now = this.peerreview.getTime();
        Iterator<LinkedList<IncompleteStatementInfo<Handle, Identifier>>> fooIter = this.incompleteStatement.values().iterator();
        while (fooIter.hasNext()) {
            LinkedList<IncompleteStatementInfo<Handle, Identifier>> foo = fooIter.next();
            Iterator barIter = foo.iterator();
            while (barIter.hasNext()) {
                IncompleteStatementInfo bar = (IncompleteStatementInfo)barIter.next();
                if (!bar.isFinished() && bar.getCurrentTimeout() >= now) continue;
                if (!bar.isFinished() && this.logger.level <= 900) {
                    this.logger.log("Statement by " + bar.sender + " is incomplete after the timeout; discarding " + bar);
                }
                barIter.remove();
            }
            if (!foo.isEmpty()) continue;
            fooIter.remove();
        }
    }

    void timerExpired(int timerID) {
        throw new RuntimeException("todo: implement");
    }

    @Override
    public void handleIncomingStatement(Handle source, Statement<Identifier> statement, Map<String, Object> options) {
        assert (statement.getType() == 18 || statement.getType() == 20);
        if (this.logger.level <= 800) {
            this.logger.log("Incoming " + (statement.getType() == 18 ? "accusation" : "response") + " from " + source);
        }
        IncompleteStatementInfo<Handle, Object> idx = new IncompleteStatementInfo<Handle, Object>(false, source, this.peerreview.getTime() + 1000L, statement, false, null, options);
        LinkedList<IncompleteStatementInfo<Handle, Identifier>> foo = this.incompleteStatement.get(statement.subject);
        if (foo == null) {
            foo = new LinkedList();
            this.incompleteStatement.put(statement.subject, foo);
        }
        foo.add(idx);
        this.makeProgressOnStatement(idx);
        this.cleanupIncompleteStatements();
    }

    int checkSnippetAndRequestCertificates(LogSnippet snippet, IncompleteStatementInfo<Handle, Identifier> idx) {
        Tuple<Integer, Identifier> ret = this.peerreview.getEvidenceTool().checkSnippet(snippet);
        int code = ret.a();
        RawSerializable missingCertID = (RawSerializable)ret.b();
        if (code == 3) {
            assert (missingCertID != null);
            idx.isMissingCertificate = true;
            idx.missingCertificateID = missingCertID;
            if (this.logger.level <= 500) {
                this.logger.log("AUDIT RESPONSE requires certificate for " + missingCertID + "; requesting");
            }
            this.peerreview.requestCertificate((RawSerializable)idx.sender, missingCertID);
        }
        return code;
    }

    public void makeProgressOnStatement(IncompleteStatementInfo<Handle, Identifier> idx) {
        Statement statement;
        block63: {
            Evidence payload;
            block64: {
                assert (!idx.finished);
                statement = idx.statement;
                idx.isMissingCertificate = false;
                Object originator = statement.originator;
                Object subject = statement.subject;
                long timestamp = statement.evidenceSeq;
                payload = statement.evidence;
                if (!this.transport.hasCertificate(subject)) {
                    if (this.logger.level <= 500) {
                        this.logger.log("Need subject's certificate to verify statement; asking source for it");
                    }
                    idx.isMissingCertificate = true;
                    idx.missingCertificateID = subject;
                    this.peerreview.requestCertificate((RawSerializable)idx.sender, subject);
                    return;
                }
                if (statement.getType() != 18) break block64;
                switch (payload.getEvidenceType()) {
                    case 1: {
                        ChallengeAudit auditEvidence = (ChallengeAudit)payload;
                        if (!this.peerreview.verify(subject, auditEvidence.from)) {
                            if (this.logger.level <= 900) {
                                this.logger.log("AUDIT challenge's first authenticator has an invalid signature");
                            }
                            idx.finished = true;
                            return;
                        }
                        if (!this.peerreview.verify(subject, auditEvidence.to)) {
                            if (this.logger.level <= 900) {
                                this.logger.log("AUDIT challenge's second authenticator has an invalid signature");
                            }
                            idx.finished = true;
                            return;
                        }
                        break block63;
                    }
                    case 2: {
                        UserDataMessage udm = (UserDataMessage)payload;
                        byte[] innerHash = udm.getInnerHash((RawSerializable)subject, (HashProvider)this.transport);
                        Authenticator authenticator = this.peerreview.extractAuthenticator((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(udm.getSenderHandle()), udm.getTopSeq(), (short)0, innerHash, udm.getHTopMinusOne(), udm.getSignature());
                        if (authenticator == null) {
                            if (this.logger.level <= 900) {
                                this.logger.log("Message in SEND challenge is not properly signed; discarding");
                            }
                            idx.finished = true;
                            return;
                        }
                        break block63;
                    }
                    case 3: {
                        ProofInconsistent pi = (ProofInconsistent)payload;
                        if (!this.peerreview.verify(subject, pi.auth1)) {
                            if (this.logger.level <= 900) {
                                this.logger.log("INCONSISTENT proof's first authenticator has an invalid signature");
                            }
                            idx.finished = true;
                            return;
                        }
                        if (!this.peerreview.verify(subject, pi.auth2)) {
                            if (this.logger.level <= 900) {
                                this.logger.log("INCONSISTENT proof's second authenticator has an invalid signature");
                            }
                            idx.finished = true;
                            return;
                        }
                        long seq1 = pi.auth1.getSeq();
                        long seq2 = pi.auth2.getSeq();
                        byte[] hash1 = pi.auth1.getHash();
                        byte[] hash2 = pi.auth2.getHash();
                        if (pi.snippet == null) {
                            if (seq1 != seq2) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("INCONSISTENT-0 proof's authenticators don't have matching sequence numbers (seq1=" + seq1 + ", seq2=" + seq2 + ") -- discarding");
                                }
                                idx.finished = true;
                                return;
                            }
                            if (Arrays.equals(hash1, hash2)) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("INCONSISTENT-0 proof's authenticators have the same hash (seq1=" + seq1 + ", seq2=" + seq2 + ") hash: " + MathUtils.toBase64(hash1) + " -- discarding");
                                }
                                idx.finished = true;
                                return;
                            }
                        } else {
                            long firstSeq = pi.snippet.getFirstSeq();
                            if (firstSeq >= seq2 || seq2 >= seq1) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("INCONSISTENT-1 proof's sequence numbers do not make sense (first=" + firstSeq + ", seq2=" + seq2 + ", seq1=" + seq1 + ") -- discarding");
                                }
                                idx.finished = true;
                                return;
                            }
                            if (!pi.snippet.checkHashChainContains(hash1, seq1, this.transport, this.logger)) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("Snippet in INCONSISTENT-1 proof cannot be authenticated using first authenticator (#" + seq1 + ") -- discarding");
                                }
                                idx.finished = true;
                                return;
                            }
                            if (pi.snippet.checkHashChainContains(hash2, seq2, this.transport, this.logger)) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("INCONSISTENT-1 proof claims that authenticator 2 (#" + seq2 + ") is not in the snippet, but it is -- discarding");
                                }
                                idx.finished = true;
                                return;
                            }
                        }
                        break block63;
                    }
                    case 4: {
                        ProofNonconformant pn = (ProofNonconformant)payload;
                        if (!this.peerreview.verify(subject, pn.to)) {
                            if (this.logger.level <= 900) {
                                this.logger.log("NONCONFORMANT proof's authenticator has an invalid signature");
                            }
                            idx.finished = true;
                            return;
                        }
                        switch (this.checkSnippetAndRequestCertificates(pn.snippet, idx)) {
                            case 2: {
                                if (this.logger.level <= 900) {
                                    this.logger.log("PROOF NONCONFORMANT is not well-formed; discarding");
                                }
                                idx.finished = true;
                                return;
                            }
                            case 3: {
                                return;
                            }
                        }
                        if (!this.peerreview.getEvidenceTool().checkSnippetSignatures(pn.snippet, pn.myHandle, null, (byte)1, null, pn.to.getHash(), pn.to.getSeq())) {
                            if (this.logger.level <= 900) {
                                this.logger.log("PROOF NONCONFORMANT cannot be validated (signatures or authenticator)");
                            }
                            return;
                        }
                        try {
                            SecureHistory subjectHistory = this.peerreview.getHistoryFactory().createTemp(pn.snippet.getFirstSeq() - 1L, pn.snippet.getBaseHash());
                            subjectHistory.appendSnippetToHistory(pn.snippet);
                            Verifier<Handle> verifier = this.peerreview.getVerifierFactory().getVerifier(subjectHistory, pn.myHandle, 1L, pn.snippet.getFirstSeq() / 1000000L, null);
                            PeerReviewCallback<Handle, Identifier> replayApp = this.peerreview.getApp().getReplayInstance(verifier);
                            verifier.setApplication(replayApp);
                            if (this.logger.level <= 800) {
                                this.logger.log("REPLAY ============================================");
                            }
                            if (this.logger.level <= 500) {
                                this.logger.log("Node being replayed: " + pn.myHandle);
                            }
                            if (this.logger.level <= 500) {
                                this.logger.log("Range in log       : " + pn.snippet.getFirstSeq() + "-?");
                            }
                            while (verifier.makeProgress()) {
                            }
                            boolean verifiedOK = verifier.verifiedOK();
                            if (verifiedOK) {
                                if (this.logger.level <= 900) {
                                    this.logger.log("PROOF NONCONFORMANT contains a log snippet that actually is conformant; discarding");
                                }
                                return;
                            }
                            break block63;
                        }
                        catch (IOException ioe) {
                            if (this.logger.level <= 900) {
                                this.logger.logException("Couldn't replay!!! " + pn, ioe);
                            }
                            break block63;
                        }
                    }
                    default: {
                        if (this.logger.level <= 900) {
                            this.logger.log("Unknown payload type #" + payload.getEvidenceType() + " in accusation; discarding");
                        }
                        idx.finished = true;
                        return;
                    }
                }
            }
            switch (payload.getEvidenceType()) {
                case 1: {
                    if (this.logger.level <= 500) {
                        this.logger.log("Checking AUDIT RESPONSE statement");
                    }
                    AuditResponse auditResponse = (AuditResponse)payload;
                    switch (this.checkSnippetAndRequestCertificates(auditResponse.getLogSnippet(), idx)) {
                        case 2: {
                            if (this.logger.level <= 900) {
                                this.logger.log("AUDIT RESPONSE is not well-formed; discarding");
                            }
                            idx.finished = true;
                            return;
                        }
                        case 3: {
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    AckMessage ackMessage = (AckMessage)payload;
                    break;
                }
                default: {
                    if (this.logger.level <= 900) {
                        this.logger.log("Unknown payload type #" + payload.getEvidenceType() + " in response; discarding");
                    }
                    idx.finished = true;
                    return;
                }
            }
        }
        try {
            this.challengeProtocol.handleStatement((RawSerializable)idx.sender, statement, idx.options);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        idx.finished = true;
    }
}

