/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.message;

import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.infostore.EvidenceSerializer;
import org.mpisws.p2p.transport.peerreview.message.PeerReviewMessage;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChallengeMessage<Identifier extends RawSerializable>
implements PeerReviewMessage {
    public static short TYPE = (short)19;
    public Identifier originator;
    public long evidenceSeq;
    public Evidence challenge;

    public ChallengeMessage(Identifier originator, long evidenceSeq, Evidence challenge) {
        this.originator = originator;
        this.evidenceSeq = evidenceSeq;
        this.challenge = challenge;
    }

    @Override
    public short getType() {
        return TYPE;
    }

    public short getChallengeType() {
        return this.challenge.getEvidenceType();
    }

    public ChallengeMessage(InputBuffer buf, Serializer<Identifier> idSerializer, EvidenceSerializer evidenceSerializer) throws IOException {
        this.originator = (RawSerializable)idSerializer.deserialize(buf);
        this.evidenceSeq = buf.readLong();
        byte chalType = buf.readByte();
        this.challenge = evidenceSerializer.deserialize(buf, chalType, false);
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        this.originator.serialize(buf);
        buf.writeLong(this.evidenceSeq);
        buf.writeByte((byte)this.challenge.getEvidenceType());
        this.challenge.serialize(buf);
    }

    public Evidence getChallenge() {
        return this.challenge;
    }
}

