/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.infostore;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorSerializer;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.infostore.EvidenceRecord;
import org.mpisws.p2p.transport.peerreview.infostore.EvidenceSerializer;
import org.mpisws.p2p.transport.peerreview.infostore.IdStrTranslator;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoRecord;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStore;
import org.mpisws.p2p.transport.peerreview.infostore.StatusChangeListener;
import org.mpisws.p2p.transport.util.FileInputBuffer;
import org.mpisws.p2p.transport.util.FileOutputBuffer;
import rice.environment.Environment;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerInfoStoreImpl<Handle, Identifier>
implements PeerInfoStore<Handle, Identifier> {
    IdentityTransport<Handle, Identifier> transport;
    File directory = null;
    Map<Identifier, PeerInfoRecord<Handle, Identifier>> peerInfoRecords = new HashMap<Identifier, PeerInfoRecord<Handle, Identifier>>();
    StatusChangeListener<Identifier> listener;
    boolean notificationEnabled = true;
    protected Environment environment;
    protected Logger logger;
    IdStrTranslator<Identifier> stringTranslator;
    AuthenticatorSerializer authSerializer;
    EvidenceSerializer evidenceSerializer;

    public PeerInfoStoreImpl(IdentityTransport<Handle, Identifier> transport, IdStrTranslator<Identifier> stringTranslator, AuthenticatorSerializer authSerializer, EvidenceSerializer evidenceSerializer, Environment env) {
        this.transport = transport;
        this.listener = null;
        this.stringTranslator = stringTranslator;
        this.authSerializer = authSerializer;
        this.environment = env;
        this.evidenceSerializer = evidenceSerializer;
        this.logger = env.getLogManager().getLogger(PeerInfoStoreImpl.class, null);
    }

    public static boolean isProof(Evidence e) {
        switch (e.getEvidenceType()) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        throw new IllegalArgumentException("Cannot evaluate isProof(" + e + "):" + e.getEvidenceType());
    }

    @Override
    public void setStatusChangeListener(StatusChangeListener<Identifier> listener) {
        this.listener = listener;
    }

    @Override
    public EvidenceRecord<Handle, Identifier> findEvidence(Identifier originator, Identifier subject, long timestamp) {
        return this.findEvidence(originator, subject, timestamp, false);
    }

    @Override
    public EvidenceRecord<Handle, Identifier> findEvidence(Identifier originator, Identifier subject, long timestamp, boolean create) {
        PeerInfoRecord<Handle, Identifier> rec = this.find(subject, create);
        if (rec == null) {
            return null;
        }
        return rec.findEvidence(originator, timestamp, create);
    }

    public void markEvidenceAvailable(Identifier originator, Identifier subject, long timestamp, boolean isProof, Handle interestedParty) {
        PeerInfoRecord<Handle, Identifier> rec = this.find(subject, true);
        PeerInfoRecord.EvidenceRecordImpl evi = rec.findEvidence(originator, timestamp, true);
        assert (rec != null && evi != null);
        if (interestedParty != null) {
            evi.setInterestedParty(interestedParty);
        }
        evi.setIsProof(isProof);
    }

    public void markResponseAvailable(Identifier originator, Identifier subject, long timestamp) {
        PeerInfoRecord<Handle, Identifier> rec = this.find(subject, true);
        PeerInfoRecord.EvidenceRecordImpl evi = rec.findEvidence(originator, timestamp, true);
        evi.setHasResponse();
    }

    @Override
    public void addEvidence(Identifier originator, Identifier subject, long timestamp, Evidence evidence) throws IOException {
        this.addEvidence(originator, subject, timestamp, evidence, null);
    }

    @Override
    public void addEvidence(Identifier originator, Identifier subject, long timestamp, Evidence evidence, Handle interestedParty) throws IOException {
        boolean proof;
        if (this.logger.level <= 500) {
            this.logger.log("addEvidence(orig=" + originator + ", subj=" + subject + ", seq=" + timestamp + ")");
        }
        File outFile = this.getFile(subject, originator, timestamp, (proof = PeerInfoStoreImpl.isProof(evidence)) ? "proof" : "challenge");
        FileOutputBuffer buf = new FileOutputBuffer(outFile);
        buf.writeByte((byte)evidence.getEvidenceType());
        evidence.serialize(buf);
        buf.close();
        this.markEvidenceAvailable(originator, subject, timestamp, proof, interestedParty);
    }

    protected File getFile(Identifier subject, Identifier originator, long timestamp, String suffix) {
        File outFile = new File(this.directory, this.stringTranslator.toString(subject) + "-" + this.stringTranslator.toString(originator) + "-" + timestamp + "." + suffix);
        return outFile;
    }

    @Override
    public int getStatus(Identifier id) {
        PeerInfoRecord<Handle, Identifier> rec = this.find(id, false);
        return rec != null ? rec.getStatus() : 0;
    }

    @Override
    public boolean setStorageDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        } else if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory.");
        }
        this.directory = directory;
        boolean notificationWasEnabled = this.notificationEnabled;
        this.notificationEnabled = false;
        File[] bar = directory.listFiles();
        if (bar != null) {
            for (File ent : bar) {
                String d_name;
                String[] foo;
                if (ent.isDirectory() || (foo = (d_name = ent.getName()).split("\\.")).length != 2) continue;
                String first = foo[0];
                String suffix = foo[1];
                if (suffix.equals("info")) {
                    Identifier id = this.stringTranslator.readIdentifierFromString(first);
                    FileInputBuffer buf = new FileInputBuffer(ent, this.logger);
                    Authenticator lastAuth = this.authSerializer.deserialize(buf);
                    buf.close();
                    this.setLastCheckedAuth(id, lastAuth);
                    continue;
                }
                if (!suffix.equals("challenge") && !suffix.equals("response") && !suffix.equals("proof")) continue;
                Object[] parts = first.split("-");
                if (parts.length != 3) {
                    throw new IOException("Error reading filename :" + ent + " did not split into 3 parts:" + Arrays.toString(parts));
                }
                Identifier subject = this.stringTranslator.readIdentifierFromString(parts[0]);
                Identifier originator = this.stringTranslator.readIdentifierFromString(parts[1]);
                long seq = Long.parseLong((String)parts[2]);
                if (suffix.equals("challenge")) {
                    this.markEvidenceAvailable(originator, subject, seq, false, null);
                    continue;
                }
                if (suffix.equals("proof")) {
                    this.markEvidenceAvailable(originator, subject, seq, true, null);
                    continue;
                }
                if (!suffix.equals("response")) continue;
                this.markResponseAvailable(originator, subject, seq);
            }
        }
        this.notificationEnabled = notificationWasEnabled;
        return true;
    }

    public PeerInfoRecord<Handle, Identifier> find(Identifier id) {
        return this.find(id, false);
    }

    public PeerInfoRecord<Handle, Identifier> find(Identifier id, boolean create) {
        PeerInfoRecord<Handle, Identifier> ret = this.peerInfoRecords.get(id);
        if (ret == null && create) {
            ret = new PeerInfoRecord(id, this);
            this.peerInfoRecords.put(id, ret);
        }
        return ret;
    }

    @Override
    public Authenticator getLastCheckedAuth(Identifier id) {
        PeerInfoRecord<Handle, Identifier> rec = this.find(id, false);
        if (rec == null) {
            return null;
        }
        return rec.getLastCheckedAuth();
    }

    @Override
    public void setLastCheckedAuth(Identifier id, Authenticator auth) {
        PeerInfoRecord<Handle, Identifier> rec = this.find(id, true);
        try {
            rec.setLastCheckedAuth(auth, this.directory, this.stringTranslator);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public Evidence getEvidence(Identifier originator, Identifier subject, long timestamp) throws IOException {
        EvidenceRecord<Handle, Identifier> evi = this.findEvidence(originator, subject, timestamp, false);
        if (evi == null) {
            return null;
        }
        File infile = this.getFile(subject, originator, timestamp, evi.isProof() ? "proof" : "challenge");
        FileInputBuffer buf = new FileInputBuffer(infile, this.logger);
        byte type = buf.readByte();
        Evidence e = this.evidenceSerializer.deserialize(buf, type, false);
        buf.close();
        return e;
    }

    @Override
    public void addResponse(Identifier originator, Identifier subject, long timestamp, Evidence response) throws IOException {
        EvidenceRecord<Handle, Identifier> evi = this.findEvidence(originator, subject, timestamp);
        assert (evi != null && !evi.isProof() && !evi.hasResponse());
        FileOutputBuffer outfile = new FileOutputBuffer(this.getFile(subject, originator, timestamp, "response"));
        outfile.writeByte((byte)response.getEvidenceType());
        response.serialize(outfile);
        outfile.close();
        this.markResponseAvailable(originator, subject, timestamp);
    }

    @Override
    public String getHistoryName(Identifier subject) {
        return new File(this.directory, this.stringTranslator.toString(subject) + "-log").toString();
    }

    @Override
    public void notifyStatusChanged(Identifier subject, int newStatus) {
        if (!this.notificationEnabled || this.listener == null) {
            return;
        }
        this.listener.notifyStatusChange(subject, newStatus);
    }

    @Override
    public EvidenceRecord<Handle, Identifier> statFirstUnansweredChallenge(Identifier subject) {
        PeerInfoRecord<Handle, Identifier> rec = this.find(subject);
        if (rec == null) {
            return null;
        }
        return rec.getFirstUnansweredChallenge();
    }

    @Override
    public EvidenceRecord<Handle, Identifier> statProof(Identifier subject) {
        PeerInfoRecord<Handle, Identifier> rec = this.find(subject);
        if (rec == null) {
            return null;
        }
        return rec.getFirstProof();
    }
}

