/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.infostore;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.infostore.EvidenceRecord;
import org.mpisws.p2p.transport.peerreview.infostore.IdStrTranslator;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStore;
import org.mpisws.p2p.transport.util.FileOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerInfoRecord<Handle, Identifier>
implements PeerReviewConstants {
    private Identifier subject;
    private Authenticator lastCheckedAuth;
    private int status;
    private PeerInfoStore<Handle, Identifier> store;
    Map<Identifier, Map<Long, EvidenceRecordImpl>> answeredEvidence;
    Map<Identifier, Map<Long, EvidenceRecordImpl>> unansweredEvidence;

    public PeerInfoRecord(Identifier id, PeerInfoStore<Handle, Identifier> store) {
        this.subject = id;
        this.store = store;
        this.unansweredEvidence = new HashMap<Identifier, Map<Long, EvidenceRecordImpl>>();
        this.answeredEvidence = new HashMap<Identifier, Map<Long, EvidenceRecordImpl>>();
        this.status = 0;
    }

    public EvidenceRecordImpl findEvidence(Identifier originator, long timestamp, boolean create) {
        EvidenceRecordImpl bar;
        Map<Long, EvidenceRecordImpl> foo = this.answeredEvidence.get(originator);
        if (foo != null && (bar = foo.get(timestamp)) != null) {
            return bar;
        }
        foo = this.unansweredEvidence.get(originator);
        if (foo == null) {
            if (create) {
                foo = new HashMap<Long, EvidenceRecordImpl>();
                this.unansweredEvidence.put(originator, foo);
                bar = new EvidenceRecordImpl(originator, timestamp);
                foo.put(timestamp, bar);
                return bar;
            }
            return null;
        }
        bar = foo.get(timestamp);
        if (bar == null && create) {
            bar = new EvidenceRecordImpl(originator, timestamp);
        }
        return bar;
    }

    public int getStatus() {
        return this.status;
    }

    public Authenticator getLastCheckedAuth() {
        return this.lastCheckedAuth;
    }

    public void setLastCheckedAuth(Authenticator auth, File dir, IdStrTranslator<Identifier> translator) throws IOException {
        FileOutputBuffer buf = new FileOutputBuffer(new File(dir, translator.toString(this.subject) + ".info"));
        auth.serialize(buf);
        buf.close();
        this.lastCheckedAuth = auth;
    }

    public EvidenceRecord<Handle, Identifier> getFirstUnansweredChallenge() {
        return this.getFirstUnansweredChallenge(false);
    }

    protected EvidenceRecord<Handle, Identifier> getFirstUnansweredChallenge(boolean proof) {
        for (Map<Long, EvidenceRecordImpl> foo : this.unansweredEvidence.values()) {
            for (EvidenceRecordImpl bar : foo.values()) {
                if (proof) {
                    if (!bar.isProof) continue;
                    return bar;
                }
                return bar;
            }
        }
        return null;
    }

    public EvidenceRecord<Handle, Identifier> getFirstProof() {
        return this.getFirstUnansweredChallenge(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EvidenceRecordImpl
    implements EvidenceRecord<Handle, Identifier> {
        public Identifier originator;
        public long timestamp;
        Handle interestedParty;
        boolean isProof;

        public EvidenceRecordImpl(Identifier originator, long timestamp) {
            this(originator, timestamp, false, null);
        }

        public EvidenceRecordImpl(Identifier originator, long timestamp, boolean isProof, Handle interestedParty) {
            this.originator = originator;
            this.timestamp = timestamp;
            this.isProof = isProof;
            this.interestedParty = interestedParty;
        }

        @Override
        public boolean hasResponse() {
            Map<Long, EvidenceRecordImpl> foo = PeerInfoRecord.this.answeredEvidence.get(this.originator);
            if (foo == null) {
                return false;
            }
            return foo.containsKey(this.timestamp);
        }

        @Override
        public void setIsProof(boolean isProof) {
            this.isProof = isProof;
            if (isProof && PeerInfoRecord.this.status != 2) {
                PeerInfoRecord.this.status = 2;
                PeerInfoRecord.this.store.notifyStatusChanged(PeerInfoRecord.this.subject, 2);
            } else if (!isProof && PeerInfoRecord.this.status == 0) {
                PeerInfoRecord.this.status = 1;
                PeerInfoRecord.this.store.notifyStatusChanged(PeerInfoRecord.this.subject, 1);
            }
        }

        @Override
        public void setInterestedParty(Handle interestedParty) {
            this.interestedParty = interestedParty;
        }

        @Override
        public void setHasResponse() {
            assert (!this.isProof());
            Map<Long, EvidenceRecordImpl> foo = PeerInfoRecord.this.unansweredEvidence.get(this.originator);
            if (foo != null) {
                foo.remove(this.timestamp);
                if (foo.isEmpty()) {
                    PeerInfoRecord.this.unansweredEvidence.remove(this.originator);
                }
            }
            if ((foo = PeerInfoRecord.this.answeredEvidence.get(this.originator)) == null) {
                foo = new HashMap<Long, EvidenceRecordImpl>();
                PeerInfoRecord.this.answeredEvidence.put(this.originator, foo);
            }
            foo.put(this.timestamp, this);
            if (PeerInfoRecord.this.status == 1 && PeerInfoRecord.this.unansweredEvidence.isEmpty()) {
                PeerInfoRecord.this.status = 0;
                PeerInfoRecord.this.store.notifyStatusChanged(PeerInfoRecord.this.subject, 0);
            }
        }

        @Override
        public boolean isProof() {
            return this.isProof;
        }

        @Override
        public long getTimeStamp() {
            return this.timestamp;
        }

        @Override
        public Identifier getOriginator() {
            return this.originator;
        }

        @Override
        public Handle getInterestedParty() {
            return this.interestedParty;
        }
    }
}

