/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.identity;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.pki.x509.X509Serializer;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransportCallback;
import org.mpisws.p2p.transport.table.TableStore;
import org.mpisws.p2p.transport.table.TableTransprotLayerImpl;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.Serializer;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityTransprotLayerImpl<Identifier, I>
extends TableTransprotLayerImpl<Identifier, I, X509Certificate>
implements IdentityTransport<Identifier, I> {
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA1withRSA";
    public static final short DEFAULT_SIGNATURE_SIZE = 96;
    String signatureAlgorithm = "SHA1withRSA";
    String signatureImpl = "BC";
    Signature signer;
    Map<I, Signature> verifiers = new HashMap<I, Signature>();
    HashProvider hasher;
    private Environment environment;

    static <H, I> TableStore<I, X509Certificate> getTableStore(I localId, X509Certificate localCert, Serializer<I> iSerializer, X509Serializer cSerializer, InputBuffer buf) {
        MyStore ret = new MyStore();
        ret.put(localId, localCert);
        if (buf != null) {
            throw new RuntimeException("Persistent version not implemented.");
        }
        return ret;
    }

    public IdentityTransprotLayerImpl(Serializer<I> iSerializer, X509Serializer cSerializer, I localId, X509Certificate localCert, PrivateKey localPrivate, TransportLayer<Identifier, ByteBuffer> tl, HashProvider hasher, Environment env) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        super(iSerializer, cSerializer, IdentityTransprotLayerImpl.getTableStore(localId, localCert, iSerializer, cSerializer, null), tl, env);
        this.tl = tl;
        tl.setCallback(this);
        this.hasher = hasher;
        this.environment = env;
        this.logger = env.getLogManager().getLogger(IdentityTransprotLayerImpl.class, null);
        this.errorHandler = new DefaultErrorHandler(this.logger);
        this.signer = Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM, "BC");
        this.signer.initSign(localPrivate);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        ((MyStore)this.knownValues).callback = (IdentityTransportCallback)callback;
        super.setCallback(callback);
    }

    @Override
    public Cancellable requestCertificate(Identifier source, I principal, Continuation<X509Certificate, Exception> c, Map<String, Object> options) {
        return super.requestValue(source, principal, c, options);
    }

    @Override
    public boolean hasCertificate(I i) {
        return super.hasKey(i);
    }

    @Override
    public byte[] sign(byte[] bytes) {
        try {
            this.signer.update(bytes);
            byte[] ret = this.signer.sign();
            if (this.logger.level <= 300) {
                this.logger.log("Signature of " + MathUtils.toBase64(bytes) + " was " + MathUtils.toBase64(ret));
            }
            return ret;
        }
        catch (SignatureException se) {
            RuntimeException throwMe = new RuntimeException("Couldn't sign " + bytes);
            throwMe.initCause(se);
            throw throwMe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int verify(I id, byte[] msg, byte[] signature) {
        Signature verifier;
        if (this.logger.level <= 300) {
            this.logger.log("Verify:" + id + " " + msg.length + " " + MathUtils.toBase64(msg) + " == " + signature.length + " " + MathUtils.toBase64(signature));
        }
        if ((verifier = this.getVerifier(id)) == null) {
            return -1;
        }
        try {
            Signature signature2 = verifier;
            synchronized (signature2) {
                verifier.update(msg);
                if (verifier.verify(signature)) {
                    return 1;
                }
            }
        }
        catch (SignatureException se) {
            throw new RuntimeException(se);
        }
        return 0;
    }

    public Signature getVerifier(I i) {
        Signature ret = this.verifiers.get(i);
        try {
            if (ret == null && this.knownValues.containsKey(i)) {
                X509Certificate cert = (X509Certificate)this.knownValues.get(i);
                ret = Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM, "BC");
                ret.initVerify(cert);
                this.verifiers.put(i, ret);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public short getSignatureSizeBytes() {
        return 96;
    }

    @Override
    public byte[] getEmptyHash() {
        return this.hasher.getEmptyHash();
    }

    @Override
    public short getHashSizeBytes() {
        return this.hasher.getHashSizeBytes();
    }

    @Override
    public byte[] hash(long seq, short type, byte[] nodeHash, byte[] contentHash) {
        return this.hasher.hash(seq, type, nodeHash, contentHash);
    }

    @Override
    public byte[] hash(ByteBuffer ... hashMe) {
        return this.hasher.hash(hashMe);
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyStore<H, I>
    extends HashMap<I, X509Certificate>
    implements TableStore<I, X509Certificate> {
        IdentityTransportCallback<H, I> callback;

        MyStore() {
        }

        @Override
        public X509Certificate put(I key, X509Certificate value) {
            X509Certificate ret = super.put(key, value);
            if (ret == null && this.callback != null) {
                this.callback.notifyCertificateAvailable(key);
            }
            return ret;
        }
    }
}

