/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.evidence;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.evidence.EvidenceTransferProtocol;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.infostore.EvidenceRecord;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStore;
import org.mpisws.p2p.transport.peerreview.message.AccusationMessage;
import org.mpisws.p2p.transport.peerreview.message.PeerReviewMessage;
import rice.Continuation;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvidenceTransferProtocolImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements EvidenceTransferProtocol<Handle, Identifier>,
PeerReviewConstants {
    static final int MAX_CACHE_ENTRIES = 500;
    static final int MAX_PENDING_MESSAGES = 100;
    static final int MAX_PENDING_QUERIES = 100;
    static final int WITNESS_SET_VALID_MICROS = 300000000;
    PeerReview<Handle, Identifier> peerreview;
    IdentityTransport<Handle, Identifier> transport;
    PeerInfoStore<Handle, Identifier> infoStore;
    Map<Identifier, CacheInfo> witnessCache = new HashMap<Identifier, CacheInfo>();
    Map<Identifier, LinkedList<MessageInfo>> pendingMessage = new HashMap<Identifier, LinkedList<MessageInfo>>();
    Collection<QueryInfo> pendingQuery = new HashSet<QueryInfo>();
    Logger logger;

    public EvidenceTransferProtocolImpl(PeerReview<Handle, Identifier> peerreview, IdentityTransport<Handle, Identifier> transport, PeerInfoStore<Handle, Identifier> infoStore) {
        this.peerreview = peerreview;
        this.transport = transport;
        this.infoStore = infoStore;
        this.logger = peerreview.getEnvironment().getLogManager().getLogger(EvidenceTransferProtocolImpl.class, null);
    }

    @Override
    public void notifyWitnessSet(Identifier subject, Collection<Handle> witnesses) {
        CacheInfo idx = this.witnessCache.get(subject);
        if (idx == null) {
            idx = new CacheInfo(this, subject);
            this.witnessCache.put(subject, idx);
        }
        idx.updateWitnesses(witnesses);
        Collection sendMe = this.pendingMessage.remove(subject);
        if (sendMe != null) {
            for (MessageInfo m : sendMe) {
                this.doSendMessageToWitnesses(idx.witness, m);
            }
        }
        for (QueryInfo qi : this.pendingQuery) {
            qi.updateWitnesses(idx);
        }
    }

    void doSendMessageToWitnesses(Collection<Handle> witnesses, MessageInfo m) {
        for (RawSerializable h : witnesses) {
            this.peerreview.transmit(h, m.message, m.deliverAckToMe, m.options);
        }
    }

    @Override
    public void sendMessageToWitnesses(Identifier subject, PeerReviewMessage message, MessageCallback<Handle, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        MessageInfo m = new MessageInfo(this, subject, message, deliverAckToMe, options);
        Collection<Handle> witnesses = this.getWitnesses(subject);
        if (witnesses == null) {
            LinkedList<MessageInfo> foo = this.pendingMessage.get(subject);
            if (foo == null) {
                foo = new LinkedList();
                this.pendingMessage.put(subject, foo);
            }
            foo.addLast(m);
            this.requestWitnesses(subject);
        } else {
            this.doSendMessageToWitnesses(witnesses, m);
        }
    }

    @Override
    public void requestWitnesses(Collection<Identifier> subjectList, Continuation<Map<Identifier, Collection<Handle>>, Exception> c) {
        new QueryInfo(subjectList, c);
    }

    protected Collection<Handle> getWitnesses(Identifier subject) {
        CacheInfo foo = this.witnessCache.get(subject);
        if (foo == null || foo.witness.isEmpty() || !foo.isValid()) {
            return null;
        }
        return foo.witness;
    }

    protected void requestWitnesses(Identifier subject) {
        CacheInfo foo = this.witnessCache.get(subject);
        if (foo != null && foo.witnessesRequested) {
            return;
        }
        foo = new CacheInfo(this, subject);
        this.witnessCache.put(subject, foo);
        this.peerreview.getApp().getWitnesses(subject, this);
    }

    @Override
    public void sendEvidence(Handle target, Identifier subject) {
        block6: {
            if (this.logger.level <= 400) {
                this.logger.log("sendEvidence(" + target + ", subject=" + subject + ")");
            }
            int status = this.infoStore.getStatus(subject);
            assert (status != 0);
            EvidenceRecord<Handle, Identifier> evidenceRecord = null;
            evidenceRecord = status == 2 ? this.infoStore.statProof(subject) : this.infoStore.statFirstUnansweredChallenge(subject);
            assert (evidenceRecord != null);
            try {
                Evidence evidence = this.infoStore.getEvidence(evidenceRecord.getOriginator(), subject, evidenceRecord.getTimeStamp());
                AccusationMessage<Identifier> accusation = new AccusationMessage<Identifier>(subject, evidenceRecord, evidence);
                if (this.logger.level <= 400) {
                    this.logger.log("Sending " + accusation + " " + (status == 2 ? "proof" : "challenge") + " to " + target);
                }
                this.peerreview.transmit(target, accusation, null, null);
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block6;
                this.logger.log("Error sending evidence.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QueryInfo {
        Map<Identifier, Collection<Handle>> subjectList = new HashMap();
        Continuation<Map<Identifier, Collection<Handle>>, Exception> c;
        int numWitnessesWaitingFor = 0;
        boolean done = false;

        public QueryInfo(Collection<Identifier> subjects, Continuation<Map<Identifier, Collection<Handle>>, Exception> c) {
            this.numWitnessesWaitingFor = subjects.size();
            this.c = c;
            EvidenceTransferProtocolImpl.this.pendingQuery.add(this);
            for (RawSerializable s : subjects) {
                Collection foo = EvidenceTransferProtocolImpl.this.getWitnesses(s);
                this.subjectList.put(s, foo);
                if (foo == null) {
                    EvidenceTransferProtocolImpl.this.requestWitnesses(s);
                    continue;
                }
                --this.numWitnessesWaitingFor;
            }
            if (this.numWitnessesWaitingFor == 0) {
                this.done();
            }
        }

        public void updateWitnesses(CacheInfo idx) {
            Collection ret;
            if (this.subjectList.containsKey(idx.subject) && ((ret = this.subjectList.put(idx.subject, idx.witness)) == null || ret.isEmpty())) {
                --this.numWitnessesWaitingFor;
                if (this.numWitnessesWaitingFor == 0) {
                    this.done();
                }
            }
        }

        public void done() {
            if (this.done) {
                return;
            }
            this.done = true;
            EvidenceTransferProtocolImpl.this.pendingQuery.remove(this);
            this.c.receiveResult(this.subjectList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MessageInfo {
        public Identifier subject;
        public PeerReviewMessage message;
        public MessageCallback<Handle, ByteBuffer> deliverAckToMe;
        public Map<String, Object> options;
        final /* synthetic */ EvidenceTransferProtocolImpl this$0;

        public MessageInfo(Identifier subject, PeerReviewMessage message, MessageCallback<Handle, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
            this.this$0 = var1_1;
            this.subject = subject;
            this.message = message;
            this.deliverAckToMe = deliverAckToMe;
            this.options = options;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheInfo {
        Identifier subject;
        boolean witnessesRequested;
        Collection<Handle> witness;
        private long validUntil;
        final /* synthetic */ EvidenceTransferProtocolImpl this$0;

        public CacheInfo(Identifier subject) {
            this.this$0 = var1_1;
            this.subject = subject;
            this.validUntil = 0L;
            this.witnessesRequested = true;
        }

        public void updateWitnesses(Collection<Handle> witnesses) {
            this.witnessesRequested = false;
            this.witness = witnesses;
            this.validUntil = this.this$0.peerreview.getTime() + 300000000L;
        }

        public boolean isValid() {
            return this.validUntil > this.this$0.peerreview.getTime();
        }
    }
}

