/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.evidence;

import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorSerializerImpl;
import org.mpisws.p2p.transport.peerreview.evidence.AuditResponse;
import org.mpisws.p2p.transport.peerreview.evidence.ChallengeAudit;
import org.mpisws.p2p.transport.peerreview.evidence.ProofInconsistent;
import org.mpisws.p2p.transport.peerreview.evidence.ProofNonconformant;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.infostore.EvidenceSerializer;
import org.mpisws.p2p.transport.peerreview.message.AckMessage;
import org.mpisws.p2p.transport.peerreview.message.UserDataMessage;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvidenceSerializerImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements EvidenceSerializer,
PeerReviewConstants {
    protected int hashSize;
    protected int signatureSize;
    protected Serializer<Handle> handleSerializer;
    protected Serializer<Identifier> idSerializer;
    protected AuthenticatorSerializerImpl authSerializer;

    public EvidenceSerializerImpl(Serializer<Handle> handleSerializer, Serializer<Identifier> idSerializer, int hashSize, int signatureSize) {
        this.handleSerializer = handleSerializer;
        this.idSerializer = idSerializer;
        this.hashSize = hashSize;
        this.signatureSize = signatureSize;
        this.authSerializer = new AuthenticatorSerializerImpl(hashSize, signatureSize);
    }

    @Override
    public Evidence deserialize(InputBuffer buf, byte type, boolean response) throws IOException {
        switch (type) {
            case 1: {
                if (response) {
                    return new AuditResponse<Handle>(buf, this.handleSerializer, this.hashSize);
                }
                return new ChallengeAudit(buf, this.hashSize, this.signatureSize);
            }
            case 2: 
            case 16: {
                if (response) {
                    return AckMessage.build(buf, this.idSerializer, this.hashSize, this.signatureSize);
                }
                return UserDataMessage.build(buf, this.handleSerializer, this.hashSize, this.signatureSize);
            }
            case 3: {
                return new ProofInconsistent(buf, this.authSerializer, this.hashSize);
            }
            case 4: {
                return new ProofNonconformant<Handle>(buf, this.handleSerializer, this.hashSize, this.signatureSize);
            }
        }
        throw new IllegalArgumentException("Unknown type:" + type);
    }
}

