/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.commitment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorStore;
import org.mpisws.p2p.transport.peerreview.commitment.CommitmentProtocol;
import org.mpisws.p2p.transport.peerreview.commitment.PeerInfo;
import org.mpisws.p2p.transport.peerreview.commitment.ReceiveInfo;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.HashSeq;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtAck;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtRecv;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtSend;
import org.mpisws.p2p.transport.peerreview.history.logentry.EvtSign;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStore;
import org.mpisws.p2p.transport.peerreview.message.AckMessage;
import org.mpisws.p2p.transport.peerreview.message.OutgoingUserDataMessage;
import org.mpisws.p2p.transport.peerreview.message.UserDataMessage;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.MathUtils;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.tuples.Tuple;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitmentProtocolImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements CommitmentProtocol<Handle, Identifier>,
PeerReviewConstants {
    public int MAX_PEERS = 250;
    public int INITIAL_TIMEOUT_MILLIS = 1000;
    public int RETRANSMIT_TIMEOUT_MILLIS = 1000;
    public int RECEIVE_CACHE_SIZE = 100;
    public int MAX_RETRANSMISSIONS = 2;
    public int TI_PROGRESS = 1;
    public int PROGRESS_INTERVAL_MILLIS = 1000;
    public int MAX_ENTRIES_PER_MS = 1000000;
    Map<Identifier, PeerInfo<Handle>> peer = new HashMap<Identifier, PeerInfo<Handle>>();
    Map<Tuple<Identifier, Long>, ReceiveInfo<Identifier>> receiveCache;
    AuthenticatorStore<Identifier> authStore;
    SecureHistory history;
    PeerReview<Handle, Identifier> peerreview;
    PeerInfoStore<Handle, Identifier> infoStore;
    IdentityTransport<Handle, Identifier> transport;
    long timeToleranceMillis;
    int nextReceiveCacheEntry;
    int signatureSizeBytes;
    int hashSizeBytes;
    TimerTask makeProgressTask;
    Logger logger;

    public CommitmentProtocolImpl(PeerReview<Handle, Identifier> peerreview, IdentityTransport<Handle, Identifier> transport, PeerInfoStore<Handle, Identifier> infoStore, AuthenticatorStore<Identifier> authStore, SecureHistory history, long timeToleranceMillis) throws IOException {
        this.peerreview = peerreview;
        this.transport = transport;
        this.infoStore = infoStore;
        this.authStore = authStore;
        this.history = history;
        this.nextReceiveCacheEntry = 0;
        this.timeToleranceMillis = timeToleranceMillis;
        this.logger = peerreview.getEnvironment().getLogManager().getLogger(CommitmentProtocolImpl.class, null);
        this.initReceiveCache();
        this.makeProgressTask = new TimerTask(){

            public void run() {
                CommitmentProtocolImpl.this.makeProgressAllPeers();
            }
        };
        peerreview.getEnvironment().getSelectorManager().schedule(this.makeProgressTask, this.PROGRESS_INTERVAL_MILLIS, this.PROGRESS_INTERVAL_MILLIS);
    }

    protected void initReceiveCache() throws IOException {
        this.receiveCache = new LinkedHashMap<Tuple<Identifier, Long>, ReceiveInfo<Identifier>>(this.RECEIVE_CACHE_SIZE, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > CommitmentProtocolImpl.this.RECEIVE_CACHE_SIZE;
            }
        };
        for (long i = this.history.getNumEntries() - 1L; i >= 1L && this.receiveCache.size() < this.RECEIVE_CACHE_SIZE; --i) {
            IndexEntry hIndex = this.history.statEntry(i);
            if (hIndex.getType() != 1) continue;
            SimpleInputBuffer sib = new SimpleInputBuffer(this.history.getEntry(hIndex, hIndex.getSizeInFile()));
            RawSerializable thisSender = (RawSerializable)this.peerreview.getIdSerializer().deserialize(sib);
            this.addToReceiveCache(thisSender, sib.readLong(), i);
        }
    }

    protected void addToReceiveCache(Identifier id, long senderSeq, long indexInLocalHistory) {
        this.receiveCache.put(new Tuple<Identifier, Long>(id, senderSeq), new ReceiveInfo<Identifier>(id, senderSeq, indexInLocalHistory));
    }

    protected PeerInfo<Handle> lookupPeer(Handle handle) {
        PeerInfo<Handle> ret = this.peer.get(this.peerreview.getIdentifierExtractor().extractIdentifier(handle));
        if (ret != null) {
            return ret;
        }
        ret = new PeerInfo<Handle>(handle);
        this.peer.put(this.peerreview.getIdentifierExtractor().extractIdentifier(handle), ret);
        return ret;
    }

    @Override
    public void notifyCertificateAvailable(Identifier id) {
        this.makeProgress(id);
    }

    @Override
    public Tuple<AckMessage<Identifier>, Boolean> logMessageIfNew(UserDataMessage<Handle> udm) {
        try {
            boolean loggedPreviously;
            long seqOfRecvEntry;
            byte[] myHashTop;
            byte[] myHashTopMinusOne;
            long indexOfRecvEntry = this.findRecvEntry((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(udm.getSenderHandle()), udm.getTopSeq());
            if (indexOfRecvEntry < 0L) {
                myHashTopMinusOne = this.history.getTopLevelEntry().getHash();
                EvtRecv<Handle> recv = udm.getReceiveEvent(this.transport);
                this.history.appendEntry((short)1, true, recv.serialize());
                HashSeq foo = this.history.getTopLevelEntry();
                myHashTop = foo.getHash();
                seqOfRecvEntry = foo.getSeq();
                this.addToReceiveCache((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(udm.getSenderHandle()), udm.getTopSeq(), this.history.getNumEntries() - 1L);
                if (this.logger.level < 500) {
                    this.logger.log("New message logged as seq#" + seqOfRecvEntry);
                }
                this.history.appendEntry((short)2, true, new EvtSign(udm.getHTopMinusOne(), udm.getSignature()).serialize());
                loggedPreviously = false;
            } else {
                loggedPreviously = true;
                IndexEntry i2 = this.history.statEntry(indexOfRecvEntry);
                IndexEntry i1 = this.history.statEntry(indexOfRecvEntry - 1L);
                assert (i1 != null && i2 != null && i2.getType() == 1) : "i1:" + i1 + " i2:" + i2;
                seqOfRecvEntry = i2.getSeq();
                myHashTop = i2.getNodeHash();
                myHashTopMinusOne = i1.getNodeHash();
                if (this.logger.level < 500) {
                    this.logger.log("This message has already been logged as seq#" + seqOfRecvEntry);
                }
            }
            byte[] hToSign = this.transport.hash(ByteBuffer.wrap(MathUtils.longToByteArray(seqOfRecvEntry)), ByteBuffer.wrap(myHashTop));
            AckMessage<Identifier> ack = new AckMessage<Identifier>(this.peerreview.getLocalId(), udm.getTopSeq(), seqOfRecvEntry, myHashTopMinusOne, this.transport.sign(hToSign));
            return new Tuple<AckMessage<Identifier>, Boolean>(ack, loggedPreviously);
        }
        catch (IOException ioe) {
            RuntimeException throwMe = new RuntimeException("Unexpect error logging message :" + udm);
            throwMe.initCause(ioe);
            throw throwMe;
        }
    }

    @Override
    public void notifyStatusChange(Identifier id, int newStatus) {
        this.makeProgressAllPeers();
    }

    protected void makeProgressAllPeers() {
        for (RawSerializable i : this.peer.keySet()) {
            this.makeProgress(i);
        }
    }

    protected void makeProgress(Identifier idx) {
        PeerInfo<Handle> info = this.peer.get(idx);
        if (info == null || info.xmitQueue.isEmpty() && info.recvQueue.isEmpty()) {
            return;
        }
        if (!this.transport.hasCertificate(idx)) {
            this.peerreview.requestCertificate(info.handle, idx);
            return;
        }
        if (!info.xmitQueue.isEmpty()) {
            OutgoingUserDataMessage oudm;
            int status = this.infoStore.getStatus(idx);
            switch (status) {
                case 2: {
                    if (this.logger.level <= 900) {
                        this.logger.log("Releasing messages sent to exposed node " + idx);
                    }
                    info.clearXmitQueue();
                    return;
                }
                case 1: {
                    if (info.lastChallenge < this.peerreview.getTime() - info.currentChallengeInterval) {
                        if (this.logger.level <= 900) {
                            this.logger.log("Pending message for SUSPECTED node " + info.getHandle() + "; challenging node (interval=" + info.currentChallengeInterval + ")");
                        }
                        info.lastChallenge = this.peerreview.getTime();
                        info.currentChallengeInterval *= 2L;
                        this.peerreview.challengeSuspectedNode(info.handle);
                    }
                    return;
                }
                case 0: {
                    info.lastChallenge = -1L;
                    info.currentChallengeInterval = 30000000L;
                }
            }
            if (info.numOutstandingPackets == 0) {
                ++info.numOutstandingPackets;
                info.lastTransmit = this.peerreview.getTime();
                info.currentTimeout = this.INITIAL_TIMEOUT_MILLIS;
                info.retransmitsSoFar = 0;
                oudm = info.xmitQueue.getFirst();
                this.peerreview.transmit(info.getHandle(), oudm, null, oudm.getOptions());
            } else if (this.peerreview.getTime() > info.lastTransmit + info.currentTimeout) {
                if (info.retransmitsSoFar < this.MAX_RETRANSMISSIONS) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Retransmitting a " + info.xmitQueue.getFirst().getPayload().remaining() + "-byte message to " + info.getHandle() + " (lastxmit=" + info.lastTransmit + ", timeout=" + info.currentTimeout + ", type=" + info.xmitQueue.getFirst().getType() + ")");
                    }
                    ++info.retransmitsSoFar;
                    info.currentTimeout = this.RETRANSMIT_TIMEOUT_MILLIS;
                    info.lastTransmit = this.peerreview.getTime();
                    oudm = info.xmitQueue.getFirst();
                    this.peerreview.transmit(info.handle, oudm, null, oudm.getOptions());
                } else {
                    if (this.logger.level <= 900) {
                        this.logger.log(info.handle + " has not acknowledged our message after " + info.retransmitsSoFar + " retransmissions; filing as evidence");
                    }
                    OutgoingUserDataMessage challenge = info.xmitQueue.removeFirst();
                    challenge.sendFailed(new IOException("Peer Review Giving Up sending message to " + idx));
                    long evidenceSeq = this.peerreview.getEvidenceSeq();
                    try {
                        this.infoStore.addEvidence(this.peerreview.getLocalId(), this.peerreview.getIdentifierExtractor().extractIdentifier(info.handle), evidenceSeq, challenge, null);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                    this.peerreview.sendEvidenceToWitnesses((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(info.handle), evidenceSeq, challenge);
                    --info.numOutstandingPackets;
                }
            }
        }
        if (!info.recvQueue.isEmpty() && !info.isReceiving) {
            info.isReceiving = true;
            Tuple t = info.recvQueue.removeFirst();
            UserDataMessage udm = t.a();
            byte[] innerHash = udm.getInnerHash((RawSerializable)this.peerreview.getLocalId(), (HashProvider)this.transport);
            Authenticator authenticator = this.peerreview.extractAuthenticator((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(udm.getSenderHandle()), udm.getTopSeq(), (short)0, innerHash, udm.getHTopMinusOne(), udm.getSignature());
            if (authenticator != null) {
                Tuple<AckMessage<Identifier>, Boolean> ret = this.logMessageIfNew(udm);
                if (!ret.b().booleanValue()) {
                    if (this.logger.level <= 500) {
                        this.logger.log("Delivering message from " + udm.getSenderHandle() + " via " + info.handle + " (" + udm.getPayloadLen() + " bytes; " + udm.getRelevantLen() + "/" + udm.getPayloadLen() + " relevant)");
                    }
                    try {
                        this.peerreview.getApp().messageReceived(udm.getSenderHandle(), udm.getPayload(), t.b());
                    }
                    catch (IOException ioe) {
                        this.logger.logException("Error handling " + udm, ioe);
                    }
                } else if (this.logger.level <= 500) {
                    this.logger.log("Message from " + udm.getSenderHandle() + " via " + info.getHandle() + " was previously logged; not delivered");
                }
                if (this.logger.level <= 500) {
                    this.logger.log("Returning ACK to" + info.getHandle());
                }
                this.peerreview.transmit(info.handle, ret.a(), null, t.b());
            } else if (this.logger.level <= 900) {
                this.logger.log("Cannot verify signature on message " + udm.getTopSeq() + " from " + info.getHandle() + "; discarding");
            }
            info.isReceiving = false;
            this.makeProgress(idx);
        }
    }

    protected long findRecvEntry(Identifier id, long seq) {
        ReceiveInfo<Identifier> ret = this.receiveCache.get(new Tuple<Identifier, Long>(id, seq));
        if (ret == null) {
            return -1L;
        }
        return ret.indexInLocalHistory;
    }

    protected long findAckEntry(Identifier id, long seq) {
        return -1L;
    }

    @Override
    public void handleIncomingMessage(Handle source, UserDataMessage<Handle> msg, Map<String, Object> options) throws IOException {
        long txmit = msg.getTopSeq() / (long)this.MAX_ENTRIES_PER_MS;
        if (txmit < this.peerreview.getTime() - this.timeToleranceMillis || txmit > this.peerreview.getTime() + this.timeToleranceMillis) {
            if (this.logger.level <= 900) {
                this.logger.log("Invalid sequence no #" + msg.getTopSeq() + " on incoming message (dt=" + (txmit - this.peerreview.getTime()) + "); discarding");
            }
            return;
        }
        this.lookupPeer(source).recvQueue.addLast(new Tuple<UserDataMessage<Handle>, Map<String, Object>>(msg, options));
        this.makeProgress((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(source));
    }

    @Override
    public MessageRequestHandle<Handle, ByteBuffer> handleOutgoingMessage(Handle target, ByteBuffer message, MessageCallback<Handle, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        int relevantlen = message.remaining();
        if (options != null && options.containsKey("PeerReview_Relevant_length")) {
            Number n = (Number)options.get("PeerReview_Relevant_length");
            relevantlen = n.intValue();
        }
        assert (relevantlen >= 0);
        byte[] hTopMinusOne = this.history.getTopLevelEntry().getHash();
        EvtSend<RawSerializable> evtSend = relevantlen < message.remaining() ? new EvtSend<RawSerializable>((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(target), message, relevantlen, this.transport) : new EvtSend<RawSerializable>((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(target), message);
        try {
            this.history.appendEntry(evtSend.getType(), true, evtSend.serialize());
        }
        catch (IOException ioe) {
            MessageRequestHandleImpl<Handle, ByteBuffer> ret = new MessageRequestHandleImpl<Handle, ByteBuffer>(target, message, options);
            if (deliverAckToMe != null) {
                deliverAckToMe.sendFailed(ret, ioe);
            }
            return ret;
        }
        HashSeq top = this.history.getTopLevelEntry();
        byte[] hToSign = this.transport.hash(ByteBuffer.wrap(MathUtils.longToByteArray(top.getSeq())), ByteBuffer.wrap(top.getHash()));
        byte[] signature = this.transport.sign(hToSign);
        ByteBuffer relevantMsg = message;
        relevantMsg = relevantlen < message.remaining() ? ByteBuffer.wrap(message.array(), message.position(), relevantlen) : ByteBuffer.wrap(message.array(), message.position(), message.remaining());
        try {
            this.history.appendEntry((short)6, true, relevantMsg, ByteBuffer.wrap(signature));
        }
        catch (IOException ioe) {
            MessageRequestHandleImpl<Handle, ByteBuffer> ret = new MessageRequestHandleImpl<Handle, ByteBuffer>(target, message, options);
            if (deliverAckToMe != null) {
                deliverAckToMe.sendFailed(ret, ioe);
            }
            return ret;
        }
        assert (relevantlen == message.remaining() || relevantlen < 255);
        PeerInfo<Handle> pi = this.lookupPeer(target);
        OutgoingUserDataMessage<Handle> udm = new OutgoingUserDataMessage<Handle>(top.getSeq(), this.peerreview.getLocalHandle(), hTopMinusOne, signature, message, relevantlen, options, pi, deliverAckToMe);
        pi.xmitQueue.addLast(udm);
        this.makeProgress((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(target));
        return udm;
    }

    @Override
    public void handleIncomingAck(Handle source, AckMessage<Identifier> ackMessage, Map<String, Object> options) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("Received an ACK from " + source);
        }
        if (this.transport.hasCertificate(ackMessage.getNodeId())) {
            PeerInfo<Handle> p = this.lookupPeer(source);
            OutgoingUserDataMessage udm = p.xmitQueue.getFirst();
            if (ackMessage.getSendEntrySeq() == udm.getTopSeq()) {
                byte[] innerHash = udm.getInnerHash(this.transport);
                Authenticator authenticator = this.peerreview.extractAuthenticator(ackMessage.getNodeId(), ackMessage.getRecvEntrySeq(), (short)1, innerHash, ackMessage.getHashTopMinusOne(), ackMessage.getSignature());
                if (authenticator != null) {
                    if (this.logger.level <= 500) {
                        this.logger.log("ACK is okay; logging " + ackMessage);
                    }
                    EvtAck<Identifier> evtAck = new EvtAck<Identifier>(ackMessage.getNodeId(), ackMessage.getSendEntrySeq(), ackMessage.getRecvEntrySeq(), ackMessage.getHashTopMinusOne(), ackMessage.getSignature());
                    this.history.appendEntry((short)3, true, evtAck.serialize());
                    udm.sendComplete();
                    p.xmitQueue.removeFirst();
                    --p.numOutstandingPackets;
                    this.makeProgress((RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(p.getHandle()));
                } else if (this.logger.level <= 900) {
                    this.logger.log("Invalid ACK from <" + ackMessage.getNodeId() + ">; discarding");
                }
            } else if (this.findAckEntry(ackMessage.getNodeId(), ackMessage.getSendEntrySeq()) < 0L) {
                if (this.logger.level <= 900) {
                    this.logger.log("<" + ackMessage.getNodeId() + "> has ACKed something we haven't sent (" + ackMessage.getSendEntrySeq() + "); discarding");
                }
            } else if (this.logger.level <= 900) {
                this.logger.log("Duplicate ACK from <" + ackMessage.getNodeId() + ">; discarding");
            }
        } else if (this.logger.level <= 900) {
            this.logger.log("We got an ACK from <" + ackMessage.getNodeId() + ">, but we don't have the certificate; discarding");
        }
    }

    @Override
    public void setTimeToleranceMillis(long timeToleranceMillis) {
        this.timeToleranceMillis = timeToleranceMillis;
    }
}

