/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.commitment;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.MathUtils;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Authenticator
implements Comparable<Authenticator> {
    private long seq;
    private byte[] hash;
    private byte[] signature;
    int hashCode = 0;

    public Authenticator(long seq, byte[] hash, byte[] signature) {
        this.seq = seq;
        this.hash = hash;
        this.signature = signature;
        this.hashCode = (int)(seq ^ seq >>> 32) ^ Arrays.hashCode(hash) ^ Arrays.hashCode(signature);
    }

    public ByteBuffer getPartToHashThenSign() {
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        try {
            sob.writeLong(this.seq);
            sob.write(this.hash);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return sob.getByteBuffer();
    }

    public Authenticator(InputBuffer buf, int hashSize, int signatureSize) throws IOException {
        this.seq = buf.readLong();
        this.hash = new byte[hashSize];
        buf.read(this.hash);
        this.signature = new byte[signatureSize];
        buf.read(this.signature);
        this.hashCode = (int)(this.seq ^ this.seq >>> 32) ^ Arrays.hashCode(this.hash) ^ Arrays.hashCode(this.signature);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeLong(this.seq);
        buf.write(this.hash, 0, this.hash.length);
        buf.write(this.signature, 0, this.signature.length);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        Authenticator that = (Authenticator)o;
        return this.seq == that.seq && Arrays.equals(this.hash, that.hash) && Arrays.equals(this.signature, that.signature);
    }

    @Override
    public int compareTo(Authenticator that) {
        if (this.seq > that.seq) {
            return -1;
        }
        if (this.seq < that.seq) {
            return 1;
        }
        if (this.hash == null) {
            return 1;
        }
        if (that.hash == null) {
            return -1;
        }
        if (this.hashCode == that.hashCode && this.equals(that)) {
            return 0;
        }
        int ret = ByteBuffer.wrap(this.hash).compareTo(ByteBuffer.wrap(that.hash));
        if (ret == 0) {
            return ByteBuffer.wrap(this.signature).compareTo(ByteBuffer.wrap(that.signature));
        }
        return ret;
    }

    public long getSeq() {
        return this.seq;
    }

    public String toString() {
        return this.seq + " " + MathUtils.toHex(this.hash) + " " + MathUtils.toHex(this.signature);
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

