/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.challenge;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.PeerReviewImpl;
import org.mpisws.p2p.transport.peerreview.audit.AuditProtocol;
import org.mpisws.p2p.transport.peerreview.audit.LogSnippet;
import org.mpisws.p2p.transport.peerreview.challenge.ChallengeHashPolicy;
import org.mpisws.p2p.transport.peerreview.challenge.ChallengeResponseProtocol;
import org.mpisws.p2p.transport.peerreview.challenge.PacketInfo;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorStore;
import org.mpisws.p2p.transport.peerreview.commitment.CommitmentProtocol;
import org.mpisws.p2p.transport.peerreview.evidence.AuditResponse;
import org.mpisws.p2p.transport.peerreview.evidence.ChallengeAudit;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransport;
import org.mpisws.p2p.transport.peerreview.infostore.Evidence;
import org.mpisws.p2p.transport.peerreview.infostore.EvidenceRecord;
import org.mpisws.p2p.transport.peerreview.infostore.PeerInfoStore;
import org.mpisws.p2p.transport.peerreview.message.AccusationMessage;
import org.mpisws.p2p.transport.peerreview.message.AckMessage;
import org.mpisws.p2p.transport.peerreview.message.ChallengeMessage;
import org.mpisws.p2p.transport.peerreview.message.PeerReviewMessage;
import org.mpisws.p2p.transport.peerreview.message.ResponseMessage;
import org.mpisws.p2p.transport.peerreview.message.UserDataMessage;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.tuples.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChallengeResponseProtocolImpl<Handle extends RawSerializable, Identifier extends RawSerializable>
implements PeerReviewConstants,
ChallengeResponseProtocol<Handle, Identifier> {
    PeerReviewImpl<Handle, Identifier> peerreview;
    IdentityTransport<Handle, Identifier> transport;
    PeerInfoStore<Handle, Identifier> infoStore;
    SecureHistory history;
    AuthenticatorStore<Identifier> authOutStore;
    AuditProtocol<Handle, Identifier> auditProtocol;
    CommitmentProtocol<Handle, Identifier> commitmentProtocol;
    protected Logger logger;
    Map<Handle, LinkedList<PacketInfo<Handle, Identifier>>> queue = new HashMap<Handle, LinkedList<PacketInfo<Handle, Identifier>>>();

    public ChallengeResponseProtocolImpl(PeerReviewImpl<Handle, Identifier> peerReviewImpl, IdentityTransport<Handle, Identifier> transport, PeerInfoStore<Handle, Identifier> infoStore, SecureHistory history, AuthenticatorStore<Identifier> authOutStore, AuditProtocol<Handle, Identifier> auditProtocol, CommitmentProtocol<Handle, Identifier> commitmentProtocol) {
        this.peerreview = peerReviewImpl;
        this.transport = transport;
        this.infoStore = infoStore;
        this.history = history;
        this.authOutStore = authOutStore;
        this.auditProtocol = auditProtocol;
        this.commitmentProtocol = commitmentProtocol;
        this.logger = this.peerreview.getEnvironment().getLogManager().getLogger(ChallengeResponseProtocolImpl.class, null);
    }

    protected void copyAndEnqueueTail(Handle source, Evidence evidence, boolean isAccusation, Identifier subject, Identifier originator, long evidenceSeq, Map<String, Object> options) {
        LinkedList<PacketInfo<Handle, Identifier>> list = this.queue.get(source);
        if (list == null) {
            list = new LinkedList();
            this.queue.put(source, list);
        }
        list.addLast(new PacketInfo<Handle, Identifier>(source, evidence, isAccusation, subject, originator, evidenceSeq, options));
    }

    protected void deliver(PacketInfo<Handle, Identifier> pi) {
        try {
            if (pi.isAccusation) {
                this.infoStore.addEvidence(pi.originator, pi.subject, pi.evidenceSeq, pi.message, pi.source);
            } else {
                this.commitmentProtocol.handleIncomingMessage((RawSerializable)pi.source, (UserDataMessage)pi.message, pi.options);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void notifyStatusChange(Identifier id, int newStatus) {
        switch (newStatus) {
            case 0: {
                LinkedList<PacketInfo<Handle, Identifier>> list = this.queue.remove(id);
                if (list == null) break;
                for (PacketInfo packetInfo : list) {
                    this.deliver(packetInfo);
                }
                break;
            }
            case 2: {
                this.queue.remove(id);
                break;
            }
        }
    }

    @Override
    public void handleChallenge(Handle source, ChallengeMessage<Identifier> challenge, Map<String, Object> options) throws IOException {
        short type = challenge.getChallengeType();
        switch (type) {
            case 1: {
                ChallengeAudit audit = (ChallengeAudit)challenge.getChallenge();
                byte flags = audit.flags;
                long seqFrom = audit.from.getSeq();
                long seqTo = audit.to.getSeq();
                if (this.logger.level <= 400) {
                    this.logger.log("Received an AUDIT challenge for [" + seqFrom + "," + seqTo + "] from " + source + " (eseq=" + challenge.evidenceSeq + ", flags=" + audit.flags + ")");
                }
                if (seqTo < seqFrom) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Received an AUDIT challenge with seqTo<seqFrom:" + seqTo + "<" + seqFrom);
                    }
                    return;
                }
                if (seqFrom < this.history.getBaseSeq() || seqTo > this.history.getLastSeq()) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Received an AUDIT whose range [" + seqFrom + "-" + seqTo + "] is outside our history range [" + this.history.getBaseSeq() + "-" + this.history.getLastSeq() + "]");
                    }
                    return;
                }
                short[] chkpointTypes = new short[]{4, 5};
                long idxFrom = (flags & 1) == 1 ? this.history.findLastEntry(chkpointTypes, seqFrom) : this.history.findSeq(seqFrom);
                long idxTo = this.history.findSeq(seqTo);
                if (idxFrom >= 0L && idxTo >= 0L) {
                    ChallengeHashPolicy hashPolicy;
                    LogSnippet snippit;
                    long followingSeq;
                    IndexEntry toEntry;
                    IndexEntry fromEntry = this.history.statEntry(idxFrom);
                    if (fromEntry == null) {
                        throw new RuntimeException("Cannot get beginSeq during AUDIT challenge");
                    }
                    short beginType = fromEntry.getType();
                    long beginSeq = fromEntry.getSeq();
                    if (beginSeq % 1000000L > 0L && (flags & 1) != 1) {
                        beginSeq -= beginSeq % 1000000L;
                        idxFrom = this.history.findSeq(beginSeq);
                        if (this.logger.level <= 300) {
                            this.logger.log("Moving beginSeq to " + beginSeq + " (idx=" + idxFrom + ")");
                        }
                        assert (idxFrom >= 0L);
                    }
                    while ((toEntry = this.history.statEntry(idxTo + 1L)) != null && (followingSeq = toEntry.getSeq()) % 1000000L != 0L) {
                        ++idxTo;
                        if (this.logger.level > 300) continue;
                        this.logger.log("Advancing endSeq past " + followingSeq + " (idx=" + idxTo + ")");
                    }
                    toEntry = this.history.statEntry(idxTo);
                    if (toEntry == null) {
                        throw new RuntimeException("Cannot get endType during AUDIT challenge " + idxTo);
                    }
                    short endType = toEntry.getType();
                    if (endType == 1) {
                        ++idxTo;
                    }
                    if ((snippit = this.history.serializeRange(idxFrom, idxTo, hashPolicy = new ChallengeHashPolicy(flags, challenge.originator, this.peerreview.getIdSerializer()))) != null) {
                        ResponseMessage response = new ResponseMessage(challenge.originator, this.peerreview.getLocalId(), challenge.evidenceSeq, new AuditResponse<Handle>(this.peerreview.getLocalHandle(), snippit));
                        if (this.logger.level <= 400) {
                            this.logger.log("Answering AUDIT challenge with " + snippit.entries.size() + "-entry log snippet");
                        }
                        this.peerreview.transmit(source, response, null, options);
                        break;
                    }
                    if (this.logger.level > 900) break;
                    this.logger.log("Error accessing history in handleChallenge(" + source + "," + challenge + ")");
                    break;
                }
                if (this.logger.level > 900) break;
                this.logger.log("Cannot respond to AUDIT challenge [" + seqFrom + "-" + seqTo + ",flags=" + flags + "]; entries not found (iF=" + idxFrom + "/iT=" + idxTo + ")");
                break;
            }
            case 2: {
                UserDataMessage udm = (UserDataMessage)challenge.getChallenge();
                if (this.logger.level <= 800) {
                    this.logger.log("Received a SEND challenge");
                }
                Tuple<AckMessage<Identifier>, Boolean> ret = this.commitmentProtocol.logMessageIfNew(udm);
                AckMessage<Identifier> response = ret.a();
                boolean loggedPreviously = ret.b();
                if (!loggedPreviously) {
                    if (this.logger.level <= 400) {
                        this.logger.log("Delivering message in CHAL_SEND " + udm);
                    }
                    this.peerreview.getApp().messageReceived(udm.getSenderHandle(), udm.getPayload(), options);
                }
                ResponseMessage rMsg = new ResponseMessage(challenge.originator, this.peerreview.getLocalId(), challenge.evidenceSeq, ret.a());
                if (this.logger.level <= 400) {
                    this.logger.log("Returning a  response");
                }
                this.peerreview.transmit(source, rMsg, null, options);
                break;
            }
            default: {
                if (this.logger.level > 900) break;
                this.logger.log("Unknown challenge #" + type + " from " + source);
            }
        }
    }

    protected void handleResponse(ResponseMessage<Identifier> message, Map<String, Object> options) throws IOException {
        Evidence auditEvidence;
        if (message.originator.equals(this.peerreview.getLocalId()) && (auditEvidence = this.auditProtocol.statOngoingAudit(message.subject, message.evidenceSeq)) != null) {
            if (this.isValidResponse(message.subject, auditEvidence, message.evidence, true)) {
                if (this.logger.level <= 500) {
                    this.logger.log("Received response to ongoing AUDIT from " + message.subject);
                }
                this.auditProtocol.processAuditResponse(message.subject, message.evidenceSeq, (AuditResponse)message.evidence);
            } else if (this.logger.level <= 900) {
                this.logger.log("Invalid response to ongoing audit of " + message.subject);
            }
            return;
        }
        RawSerializable interestedParty = null;
        EvidenceRecord<Handle, RawSerializable> record = this.infoStore.findEvidence(message.originator, message.subject, message.evidenceSeq);
        interestedParty = (RawSerializable)record.getInterestedParty();
        if (record == null) {
            if (this.logger.level <= 900) {
                this.logger.log("Received response, but matching request is missing; discarding");
            }
            return;
        }
        if (record.isProof()) {
            if (this.logger.level <= 900) {
                this.logger.log("Received an alleged response to a proof; discarding");
            }
            return;
        }
        if (record.hasResponse()) {
            if (this.logger.level <= 900) {
                this.logger.log("Received duplicate response; discarding");
            }
            return;
        }
        try {
            Evidence evidence = this.infoStore.getEvidence(message.originator, message.subject, message.evidenceSeq);
            if (this.isValidResponse(message.subject, evidence, message.evidence)) {
                if (this.logger.level <= 500) {
                    this.logger.log("Received valid response (orig=" + message.originator + ", subject=" + message.subject + ", t=" + message.evidenceSeq + "); adding");
                }
                this.infoStore.addResponse(message.originator, message.subject, message.evidenceSeq, message.evidence);
                if (interestedParty != null) {
                    if (this.logger.level <= 500) {
                        this.logger.log("Relaying response to interested party " + interestedParty);
                    }
                    this.peerreview.transmit(interestedParty, message, null, options);
                }
            } else if (this.logger.level <= 900) {
                this.logger.log("Invalid response; discarding");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    boolean isValidResponse(Identifier subject, Evidence evidence, Evidence response) throws IOException {
        return this.isValidResponse(subject, evidence, response, false);
    }

    boolean isValidResponse(Identifier subject, Evidence evidence, Evidence response, boolean extractAuthsFromResponse) {
        if (evidence.getEvidenceType() != response.getEvidenceType()) {
            return false;
        }
        switch (evidence.getEvidenceType()) {
            case 1: {
                ChallengeAudit evidenceAudit = (ChallengeAudit)evidence;
                AuditResponse responseAudit = (AuditResponse)response;
                long requestedBeginSeq = evidenceAudit.from.getSeq();
                long finalSeq = evidenceAudit.to.getSeq();
                boolean includePrevCheckpoint = evidenceAudit.isIncludePrevCheckpoint();
                long firstSeq = responseAudit.getFirstSeq();
                if (requestedBeginSeq % 1000000L > 0L) {
                    requestedBeginSeq -= requestedBeginSeq % 1000000L;
                }
                long fromNodeMaxSeq = requestedBeginSeq + 999999L;
                if (firstSeq > requestedBeginSeq || !includePrevCheckpoint && firstSeq < requestedBeginSeq) {
                    if (this.logger.level <= 900) {
                        this.logger.log("Log snippet starts at " + firstSeq + ", but we asked for " + requestedBeginSeq + " (ilc=" + (includePrevCheckpoint ? "yes" : "no") + "); flagging invalid");
                    }
                    return false;
                }
                boolean snippetOK = this.peerreview.getEvidenceTool().checkSnippetSignatures(responseAudit.getLogSnippet(), responseAudit.getLogOwner(), extractAuthsFromResponse ? this.authOutStore : null, evidenceAudit.flags, this.commitmentProtocol, evidenceAudit.from.getHash(), fromNodeMaxSeq);
                if (snippetOK) break;
                return false;
            }
            case 2: {
                UserDataMessage evidenceUDM = (UserDataMessage)evidence;
                long senderSeq = evidenceUDM.getTopSeq();
                Object senderHandle = evidenceUDM.getSenderHandle();
                byte[] senderHtopMinusOne = evidenceUDM.getHTopMinusOne();
                byte[] senderSignature = evidenceUDM.getSignature();
                int relevantLen = evidenceUDM.getRelevantLen();
                AckMessage responseAck = (AckMessage)response;
                Object receiverID = responseAck.getNodeId();
                long ackSenderSeq = responseAck.getSendEntrySeq();
                long ackReceiverSeq = responseAck.getRecvEntrySeq();
                byte[] receiverHtopMinusOne = responseAck.getHashTopMinusOne();
                byte[] receiverSignature = responseAck.getSignature();
                boolean okay = true;
                if (ackSenderSeq != senderSeq) {
                    if (this.logger.level <= 900) {
                        this.logger.log("RESP.SEND: ACK contains sender seq " + ackSenderSeq + ", but challenge contains " + senderSeq + "; flagging invalid");
                    }
                    okay = false;
                }
                if (okay) {
                    byte[] innerHash = evidenceUDM.getInnerHash(this.transport);
                    Authenticator authenticator = this.peerreview.extractAuthenticator(receiverID, ackReceiverSeq, (short)1, innerHash, receiverHtopMinusOne, receiverSignature);
                    if (authenticator != null) {
                        if (this.logger.level <= 500) {
                            this.logger.log("Auth OK");
                        }
                    } else {
                        if (this.logger.level <= 900) {
                            this.logger.log("RESP.SEND: Signature on ACK is invalid");
                        }
                        okay = false;
                    }
                }
                if (okay) break;
                return false;
            }
            default: {
                if (this.logger.level <= 900) {
                    this.logger.log("Cannot check whether response type #" + evidence.getEvidenceType() + " is valid; answering no");
                }
                throw new RuntimeException("Cannot check whether response type #" + evidence.getEvidenceType() + " is valid; answering no");
            }
        }
        return true;
    }

    @Override
    public void handleStatement(Handle source, PeerReviewMessage m, Map<String, Object> options) throws IOException {
        assert (m.getType() == 18 || m.getType() == 20);
        block1 : switch (m.getType()) {
            case 20: {
                ResponseMessage message = (ResponseMessage)m;
                if (this.logger.level <= 500) {
                    this.logger.log("Statement completed: RESPONSE  (orig=" + message.originator + ", subject=" + message.subject + ", ts=" + message.evidenceSeq + ")");
                }
                this.handleResponse(message, options);
                if (this.infoStore.getStatus(this.peerreview.getIdentifierExtractor().extractIdentifier(source)) == 1) {
                    if (this.logger.level <= 500) {
                        this.logger.log("RECHALLENGE " + source);
                    }
                    this.challengeSuspectedNode(source);
                }
                return;
            }
            case 18: {
                AccusationMessage message = (AccusationMessage)m;
                if (this.logger.level <= 500) {
                    this.logger.log("Statement completed: ACCUSATION  (orig=" + message.originator + ", subject=" + message.subject + ", ts=" + message.evidenceSeq + ")");
                }
                int status = this.infoStore.getStatus(this.peerreview.getIdentifierExtractor().extractIdentifier(source));
                switch (status) {
                    case 2: {
                        if (this.logger.level > 500) break block1;
                        this.logger.log("Got an accusation from exposed node " + source + "; discarding");
                        break block1;
                    }
                    case 0: {
                        try {
                            Evidence foo = this.infoStore.getEvidence(message.originator, message.subject, message.evidenceSeq);
                            if (foo == null) {
                                this.infoStore.addEvidence(message.originator, message.subject, message.evidenceSeq, message.evidence, source);
                                break block1;
                            }
                            if (this.logger.level > 500) break block1;
                            this.logger.log("We already have a copy of that challenge; discarding");
                            break block1;
                        }
                        catch (IOException ioe) {
                            throw new RuntimeException(ioe);
                        }
                    }
                    case 1: {
                        if (this.logger.level <= 900) {
                            this.logger.log("Incoming accusation from SUSPECTED node " + source + "; queueing and challenging the node");
                        }
                        this.copyAndEnqueueTail(source, message.evidence, true, message.subject, message.originator, message.evidenceSeq, options);
                        this.challengeSuspectedNode(source);
                        break block1;
                    }
                    default: {
                        throw new RuntimeException("Unknown status: #" + status);
                    }
                }
            }
        }
    }

    @Override
    public void challengeSuspectedNode(Handle target) {
        RawSerializable tIdentifier = (RawSerializable)this.peerreview.getIdentifierExtractor().extractIdentifier(target);
        EvidenceRecord<Handle, RawSerializable> record = this.infoStore.statFirstUnansweredChallenge(tIdentifier);
        if (record == null) {
            throw new RuntimeException("Node " + target + " is SUSPECTED, but I cannot retrieve an unanswered challenge?!?");
        }
        try {
            ChallengeMessage<RawSerializable> challenge = new ChallengeMessage<RawSerializable>(record.getOriginator(), record.getTimeStamp(), this.infoStore.getEvidence(record.getOriginator(), tIdentifier, record.getTimeStamp()));
            this.peerreview.transmit(target, challenge, null, null);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void handleIncomingMessage(Handle source, UserDataMessage<Handle> message, Map<String, Object> options) throws IOException {
        int status = this.infoStore.getStatus(this.peerreview.getIdentifierExtractor().extractIdentifier(source));
        switch (status) {
            case 2: {
                if (this.logger.level <= 500) {
                    this.logger.log("Got a user message from exposed node " + source + "; discarding");
                }
                return;
            }
            case 0: {
                this.commitmentProtocol.handleIncomingMessage(source, message, options);
                return;
            }
        }
        assert (status == 1);
        if (this.logger.level <= 900) {
            this.logger.log("Incoming message from SUSPECTED node " + source + "; queueing and challenging the node");
        }
        this.copyAndEnqueueTail(source, message, false, null, null, 0L, options);
        this.challengeSuspectedNode(source);
    }
}

