/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.challenge;

import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.PeerReviewConstants;
import org.mpisws.p2p.transport.peerreview.history.HashPolicy;
import org.mpisws.p2p.transport.util.Serializer;
import rice.p2p.util.rawserialization.SimpleInputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChallengeHashPolicy<Identifier>
implements HashPolicy,
PeerReviewConstants {
    byte flags;
    Identifier originator;
    boolean includeNextCheckpoint;
    boolean includeNextSendSign;
    private Serializer<Identifier> idSerializer;

    public ChallengeHashPolicy(byte flags, Identifier originator, Serializer<Identifier> idSerializer) {
        this.includeNextCheckpoint = (flags & 1) == 1;
        this.flags = flags;
        this.idSerializer = idSerializer;
        if ((flags & 2) == 2) {
            assert (originator != null);
            this.originator = originator;
        } else {
            this.originator = null;
        }
    }

    @Override
    public boolean hashEntry(short type, byte[] content) {
        switch (type) {
            case 4: {
                if (this.includeNextCheckpoint) {
                    this.includeNextCheckpoint = false;
                    return false;
                }
                return true;
            }
            case 0: {
                if ((this.flags & 4) == 4) {
                    return false;
                }
                if (this.originator != null) {
                    try {
                        Identifier otherOriginator = this.idSerializer.deserialize(new SimpleInputBuffer(content));
                        if (otherOriginator.equals(this.originator)) {
                            this.includeNextSendSign = true;
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    return false;
                }
                return true;
            }
            case 6: {
                if ((this.flags & 4) == 4) {
                    return false;
                }
                if (this.includeNextSendSign) {
                    this.includeNextSendSign = false;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

