/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.audit;

import java.io.IOException;
import java.util.Arrays;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.MathUtils;

public class SnippetEntry {
    public byte type;
    public long seq;
    public boolean isHash = false;
    public byte[] content;
    public static final int NUM_INDEXES = 1000000;

    public SnippetEntry(byte type, long seq, boolean isHash, byte[] content) {
        if (content.length == 0) {
            throw new IllegalArgumentException("Content can't be zero-length");
        }
        this.type = type;
        this.seq = seq;
        this.isHash = isHash;
        this.content = content;
    }

    public SnippetEntry(InputBuffer buf, int hashSize, SnippetEntry prev) throws IOException {
        this(buf, SnippetEntry.decodeSeq(buf, prev.seq), hashSize);
    }

    public boolean equals(Object o) {
        SnippetEntry that = (SnippetEntry)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.seq != that.seq) {
            return false;
        }
        if (this.isHash != that.isHash) {
            return false;
        }
        return Arrays.equals(this.content, this.content);
    }

    public SnippetEntry(InputBuffer buf, long seq, int hashSize) throws IOException {
        this.type = buf.readByte();
        this.seq = seq;
        int size = this.decodeSize(buf);
        this.isHash = false;
        if (size == 0) {
            this.isHash = true;
            size = hashSize;
        }
        this.content = new byte[size];
        buf.read(this.content);
    }

    public String toString() {
        return "SEntry type:" + this.type + " seq:" + this.seq + " " + (this.isHash ? "hash" : "not hash") + " len:" + this.content.length;
    }

    public void serialize(OutputBuffer buf, SnippetEntry prev) throws IOException {
        if (prev != null) {
            this.encodeSeq(buf, prev.seq);
        }
        buf.writeByte(this.type);
        this.encodeSize(buf);
        buf.write(this.content, 0, this.content.length);
    }

    protected static long decodeSeq(InputBuffer buf, long prevSeq) throws IOException {
        byte b = buf.readByte();
        if (b == 0) {
            return prevSeq + 1L;
        }
        if (b == -1) {
            return buf.readLong();
        }
        long howMuchBigger = MathUtils.uByteToInt(b) * 1000000;
        long prevSeqMS = prevSeq / 1000000L * 1000000L;
        return prevSeqMS + howMuchBigger;
    }

    protected void encodeSeq(OutputBuffer buf, long prevSeq) throws IOException {
        long foo;
        if (this.seq == prevSeq + 1L) {
            buf.writeByte((byte)0);
            return;
        }
        if (this.seq % 1000000L == 0L && (foo = this.seq / 1000000L - prevSeq / 1000000L) < 255L) {
            if (foo < 0L) {
                throw new IOException("bug in encodeSeq.  foo:" + foo + " seq:" + this.seq + " prevSeq:" + prevSeq);
            }
            buf.writeByte((byte)foo);
            return;
        }
        buf.writeByte((byte)-1);
        buf.writeLong(this.seq);
    }

    public byte getSizeCode() {
        if (this.isHash) {
            return 0;
        }
        if (this.content.length < 254) {
            return (byte)this.content.length;
        }
        if (this.content.length < 65535) {
            return -1;
        }
        if (this.content.length > Integer.MAX_VALUE) {
            throw new RuntimeException("content is too long:" + this.content.length);
        }
        return -2;
    }

    public void encodeSize(OutputBuffer buf) throws IOException {
        if (this.isHash) {
            buf.writeByte((byte)0);
            return;
        }
        if (this.content.length < 254) {
            buf.writeByte((byte)this.content.length);
            return;
        }
        if (this.content.length < 65535) {
            buf.writeByte((byte)-1);
            buf.writeShort((short)this.content.length);
            return;
        }
        if (this.content.length > Integer.MAX_VALUE) {
            throw new RuntimeException("content is too long:" + this.content.length);
        }
        buf.writeByte((byte)-2);
        buf.writeInt(this.content.length);
    }

    public int decodeSize(InputBuffer buf) throws IOException {
        byte b = buf.readByte();
        if (b == -1) {
            return MathUtils.uShortToInt(buf.readShort());
        }
        if (b == -2) {
            return buf.readInt();
        }
        return MathUtils.uByteToInt(b);
    }
}

