/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.direct;

import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.random.RandomSource;
import rice.environment.time.TimeSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.selector.SelectorManager;

public class EventSimulator {
    protected Environment environment;
    protected RandomSource random;
    protected SelectorManager manager;
    private boolean isDirectTimeSource = false;
    protected TimeSource timeSource;
    protected Logger logger;
    long maxSpeedRequestSystemTime = 0L;
    long maxSpeedRequestSimTime = 0L;
    float maxSpeed = 0.0f;
    boolean printedDirectTimeSourceWarning = false;
    boolean running = false;

    public EventSimulator(Environment env, RandomSource random, Logger logger) {
        this.environment = env;
        this.random = random;
        this.logger = logger;
        this.manager = this.environment.getSelectorManager();
        this.timeSource = env.getTimeSource();
        if (this.timeSource instanceof DirectTimeSource) {
            this.isDirectTimeSource = true;
        }
        this.manager.setSelect(false);
    }

    public void setMaxSpeed(float speed) {
        if (!this.isDirectTimeSource && !this.printedDirectTimeSourceWarning) {
            if (this.logger.level <= 900) {
                this.logger.log("Invalid TimeSource for setMaxSpeed()/setFullSpeed().  Use Environment.directEnvironment() to construct your Environment.");
            }
            this.printedDirectTimeSourceWarning = true;
        }
        this.maxSpeedRequestSystemTime = System.currentTimeMillis();
        this.maxSpeedRequestSimTime = this.timeSource.currentTimeMillis();
        this.maxSpeed = speed;
    }

    public void setFullSpeed() {
        this.setMaxSpeed(-1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean simulate() throws InterruptedException {
        if (!this.isDirectTimeSource) {
            return true;
        }
        if (!this.environment.getSelectorManager().isSelectorThread()) {
            throw new RuntimeException("Must be on selector thread");
        }
        SelectorManager selectorManager = this.manager;
        synchronized (selectorManager) {
            long scheduledExecutionTime = this.manager.getNextTaskExecutionTime();
            if (scheduledExecutionTime < 0L) {
                if (this.logger.level <= 500) {
                    this.logger.log("taskQueue is empty");
                }
                return false;
            }
            if (scheduledExecutionTime > this.timeSource.currentTimeMillis()) {
                long neededSysDelay;
                long sysTime;
                long sysTimeDiff;
                long maxSimTime;
                long newSimTime = scheduledExecutionTime;
                if (this.maxSpeed > 0.0f && (maxSimTime = (long)((float)this.maxSpeedRequestSimTime + (float)(sysTimeDiff = (sysTime = System.currentTimeMillis()) - this.maxSpeedRequestSystemTime) * this.maxSpeed)) < newSimTime && (neededSysDelay = (long)((float)(newSimTime - maxSimTime) / this.maxSpeed)) >= 1L) {
                    this.manager.wait(neededSysDelay);
                    long now = System.currentTimeMillis();
                    long delay = now - sysTime;
                    if (delay < neededSysDelay) {
                        return true;
                    }
                }
                if (this.logger.level <= 400) {
                    this.logger.log("the time is now " + newSimTime);
                }
                ((DirectTimeSource)this.timeSource).setTime(newSimTime);
            }
        }
        return true;
    }

    public void start() {
        this.manager.invoke(new Runnable(){

            public void run() {
                if (EventSimulator.this.running) {
                    return;
                }
                EventSimulator.this.running = true;
                EventSimulator.this.manager.invoke(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (!EventSimulator.this.running) {
                            return;
                        }
                        try {
                            if (!EventSimulator.this.simulate()) {
                                SelectorManager selectorManager = EventSimulator.this.manager;
                                synchronized (selectorManager) {
                                    try {
                                        EventSimulator.this.manager.wait(100L);
                                    }
                                    catch (InterruptedException ie) {
                                        EventSimulator.this.logger.logException("BasicNetworkSimulator interrupted.", ie);
                                    }
                                }
                            }
                            EventSimulator.this.manager.invoke(this);
                        }
                        catch (InterruptedException ie) {
                            if (EventSimulator.this.logger.level <= 1000) {
                                EventSimulator.this.logger.logException("BasicNetworkSimulator.start()", ie);
                            }
                            EventSimulator.this.stop();
                        }
                    }
                });
            }
        });
    }

    public void stop() {
        this.manager.invoke(new Runnable(){

            public void run() {
                EventSimulator.this.running = false;
            }
        });
    }
}

