/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.peerreview;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.mpisws.p2p.pki.x509.CATool;
import org.mpisws.p2p.pki.x509.CAToolImpl;
import org.mpisws.p2p.pki.x509.X509Serializer;
import org.mpisws.p2p.pki.x509.X509SerializerImpl;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.peerreview.IdentifierExtractor;
import org.mpisws.p2p.transport.peerreview.PeerReview;
import org.mpisws.p2p.transport.peerreview.PeerReviewCallback;
import org.mpisws.p2p.transport.peerreview.PeerReviewImpl;
import org.mpisws.p2p.transport.peerreview.WitnessListener;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorSerializerImpl;
import org.mpisws.p2p.transport.peerreview.evidence.EvidenceSerializerImpl;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactoryImpl;
import org.mpisws.p2p.transport.peerreview.history.hasher.SHA1HashProvider;
import org.mpisws.p2p.transport.peerreview.identity.IdentityTransprotLayerImpl;
import org.mpisws.p2p.transport.peerreview.infostore.IdStrTranslator;
import org.mpisws.p2p.transport.peerreview.replay.Verifier;
import org.mpisws.p2p.transport.peerreview.replay.record.RecordLayer;
import org.mpisws.p2p.transport.util.Serializer;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawSerializable;
import rice.p2p.util.MathUtils;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PRRegressionTest {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    static Map<HandleImpl, IdentityTransprotLayerImpl<HandleImpl, IdImpl>> idTLTable = new HashMap<HandleImpl, IdentityTransprotLayerImpl<HandleImpl, IdImpl>>();
    CATool caTool;
    KeyPairGenerator keyPairGen;
    Map<HandleImpl, Player> playerTable = new HashMap<HandleImpl, Player>();
    private HashProvider hasher;
    private SecureHistoryFactory historyFactory;
    Player alice;
    Player bob;
    Player carol;
    HandleImpl aliceHandle = new HandleImpl("alice", new IdImpl(1));
    HandleImpl bobHandle = new HandleImpl("bob", new IdImpl(2));
    HandleImpl carolHandle = new HandleImpl("carol", new IdImpl(3));
    protected Map<HandleImpl, Map<IdImpl, Integer>> recordedStatus = new HashMap<HandleImpl, Map<IdImpl, Integer>>();
    Environment env = RecordLayer.generateEnvironment();
    Logger logger;

    protected PeerReviewImpl<HandleImpl, IdImpl> getPeerReview(Player player, MyIdTL transport, Environment env) {
        return new PeerReviewImpl<HandleImpl, IdImpl>(transport, env, new HandleSerializer(), new IdSerializer(), new IdExtractor(), this.getIdStrTranslator(), new AuthenticatorSerializerImpl(20, 96), new EvidenceSerializerImpl<HandleImpl, IdImpl>(new HandleSerializer(), new IdSerializer(), transport.getHashSizeBytes(), transport.getSignatureSizeBytes()));
    }

    public IdStrTranslator<IdImpl> getIdStrTranslator() {
        return new IdStrTranslator<IdImpl>(){

            @Override
            public IdImpl readIdentifierFromString(String s) {
                return new IdImpl(Integer.parseInt(s));
            }

            @Override
            public String toString(IdImpl id) {
                return Integer.toString(id.id);
            }
        };
    }

    public void setLoggingParams(Environment env) {
        env.getParameters().setInt("org.mpisws.p2p.testing.transportlayer.peerreview_loglevel", 800);
    }

    protected BogusApp getBogusApp(Player player, PeerReview<HandleImpl, IdImpl> pr, Environment env) {
        return new BogusApp(player, pr, env);
    }

    public void buildCryptoMaterial(Environment env) throws Exception {
        SecureRandom random = new SecureRandom();
        this.caTool = CAToolImpl.getCATool("CommitmentTest", "foo".toCharArray());
        this.keyPairGen = KeyPairGenerator.getInstance("RSA", "BC");
        this.keyPairGen.initialize(new RSAKeyGenParameterSpec(768, RSAKeyGenParameterSpec.F4), random);
        this.hasher = new SHA1HashProvider();
        this.historyFactory = new SecureHistoryFactoryImpl(this.hasher, env);
    }

    public void buildPlayers(Environment env) throws Exception {
        this.alice = new Player(this.aliceHandle, this.bobHandle, env);
        this.bob = new Player(this.bobHandle, this.aliceHandle, env);
        this.carol = new Player(this.carolHandle, null, env);
    }

    public void setupWitnesses() {
        this.carol.witnessed.add(this.alice.localHandle);
        this.carol.witnessed.add(this.bob.localHandle);
    }

    protected void addStatusNotification(HandleImpl localHandle, IdImpl id, int newStatus) {
        Map<IdImpl, Integer> foo = this.recordedStatus.get(localHandle);
        if (foo == null) {
            foo = new HashMap<IdImpl, Integer>();
            this.recordedStatus.put(localHandle, foo);
        }
        foo.put(id, newStatus);
    }

    public void finish() {
        for (Map.Entry<HandleImpl, Map<IdImpl, Integer>> foo : this.recordedStatus.entrySet()) {
            for (Map.Entry<IdImpl, Integer> i : foo.getValue().entrySet()) {
                if (i.getValue() == 0) continue;
                this.logger.log("Fail: " + foo.getKey() + " found " + i.getKey() + " " + i.getValue());
                System.exit(1);
            }
        }
        this.logger.log("Success");
        System.exit(1);
    }

    public PRRegressionTest(int millisToFinish) throws Exception {
        this.env.getSelectorManager().schedule(new TimerTask(){

            public void run() {
                PRRegressionTest.this.finish();
            }
        }, millisToFinish);
        this.logger = this.env.getLogManager().getLogger(PRRegressionTest.class, null);
        this.setLoggingParams(this.env);
        this.buildCryptoMaterial(this.env);
        this.env.getSelectorManager().invoke(new Runnable(){

            public void run() {
                try {
                    PRRegressionTest.this.buildPlayers(PRRegressionTest.this.env);
                    PRRegressionTest.this.setupWitnesses();
                }
                catch (Exception ioe) {
                    PRRegressionTest.this.env.destroy();
                    throw new RuntimeException(ioe);
                }
            }
        });
    }

    public static void main(String[] agrs) throws Exception {
        new PRRegressionTest(45000);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyIdTL
    extends IdentityTransprotLayerImpl<HandleImpl, IdImpl> {
        public MyIdTL(Serializer<IdImpl> serializer, X509Serializer serializer2, IdImpl localId, X509Certificate localCert, PrivateKey localPrivate, TransportLayer<HandleImpl, ByteBuffer> tl, HashProvider hasher, Environment env) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            super(serializer, serializer2, localId, localCert, localPrivate, tl, hasher, env);
        }

        @Override
        public Cancellable requestCertificate(HandleImpl source, final IdImpl certHolder, final Continuation<X509Certificate, Exception> c, Map<String, Object> options) {
            return idTLTable.get(source).requestValue(source, certHolder, new Continuation<X509Certificate, Exception>(){

                @Override
                public void receiveResult(X509Certificate result) {
                    MyIdTL.this.knownValues.put(certHolder, result);
                    if (c != null) {
                        c.receiveResult(result);
                    }
                }

                @Override
                public void receiveException(Exception exception) {
                    if (c != null) {
                        c.receiveException(exception);
                    }
                }
            }, options);
        }
    }

    class Player {
        Logger logger;
        HandleImpl localHandle;
        PeerReview<HandleImpl, IdImpl> pr;
        MyIdTL transport;
        public Collection<HandleImpl> witnessed = new ArrayList<HandleImpl>();
        KeyPair pair;
        X509Certificate cert;
        BogusTransport t1;
        Environment env;
        BogusApp app;
        HandleImpl destHandle;

        public Player(HandleImpl localHandle, HandleImpl dstHandle, final Environment env2) throws Exception {
            this.destHandle = dstHandle;
            this.env = this.cloneEnvironment(env2, localHandle.name, localHandle.id.id);
            this.logger = this.env.getLogManager().getLogger(Player.class, null);
            File f = new File(localHandle.name);
            if (f.exists()) {
                int c;
                File f2 = new File(f, "peers");
                File[] foo = f2.listFiles();
                if (foo != null) {
                    for (c = 0; c < foo.length; ++c) {
                        foo[c].delete();
                    }
                }
                if ((foo = f.listFiles()) != null) {
                    for (c = 0; c < foo.length; ++c) {
                        foo[c].delete();
                    }
                }
            }
            this.localHandle = localHandle;
            PRRegressionTest.this.playerTable.put(localHandle, this);
            this.pair = PRRegressionTest.this.keyPairGen.generateKeyPair();
            this.cert = PRRegressionTest.this.caTool.sign(localHandle.name, this.pair.getPublic());
            this.t1 = this.getTL();
            this.transport = this.getIdTransport();
            idTLTable.put(localHandle, this.transport);
            this.pr = PRRegressionTest.this.getPeerReview(this, this.transport, this.env);
            this.app = this.getApp();
            this.pr.setApp(this.app);
            this.env.getSelectorManager().invoke(new Runnable(){

                public void run() {
                    try {
                        Player.this.pr.init(Player.this.localHandle.name);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        env2.destroy();
                    }
                }
            });
        }

        public BogusApp getApp() {
            return PRRegressionTest.this.getBogusApp(this, this.pr, this.env);
        }

        public Environment cloneEnvironment(Environment env2, String name, int id) {
            return env2.cloneEnvironment(name);
        }

        public void buildPlayerCryptoStuff() {
        }

        public BogusTransport getTL() throws Exception {
            return new BogusTransport(this.localHandle, this.cert, this.env);
        }

        public MyIdTL getIdTransport() throws Exception {
            return new MyIdTL((Serializer)new IdSerializer(), (X509Serializer)new X509SerializerImpl(), this.localHandle.id, this.cert, this.pair.getPrivate(), (TransportLayer)this.t1, (HashProvider)new SHA1HashProvider(), this.env){};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BogusApp
    implements PeerReviewCallback<HandleImpl, IdImpl> {
        Logger logger;
        Player player;
        Environment env;
        Random rand;
        long nextSendTime = 0L;
        private HandleImpl dest;
        private TransportLayer<HandleImpl, ByteBuffer> tl;

        public BogusApp(Player player, TransportLayer<HandleImpl, ByteBuffer> tl, Environment env) {
            this.player = player;
            this.tl = tl;
            this.env = env;
            this.logger = env.getLogManager().getLogger(BogusApp.class, null);
            this.logger.log("new bogus app " + player);
            this.dest = player.destHandle;
            tl.setCallback(this);
        }

        @Override
        public void init() {
            this.rand = new Random();
            if (this.player.localHandle.id.id == 1) {
                this.scheduleMessageToBeSent(this.env.getTimeSource().currentTimeMillis() + 1000L, true);
            }
        }

        public void scheduleMessageToBeSent() {
            this.scheduleMessageToBeSent(this.env.getTimeSource().currentTimeMillis() + (long)this.rand.nextInt(1999) + 1L, true);
        }

        public void scheduleMessageToBeSent(long time, final boolean reschedule) {
            this.nextSendTime = time;
            if (this.logger.level <= 500) {
                this.logger.log("scheduling message to be sent at:" + time);
            }
            this.env.getSelectorManager().schedule(new TimerTask(){

                public String toString() {
                    return "SendMessageTask " + this.scheduledExecutionTime();
                }

                public void run() {
                    BogusApp.this.sendMessage();
                    if (reschedule) {
                        BogusApp.this.scheduleMessageToBeSent();
                    }
                }
            }, this.nextSendTime - this.env.getTimeSource().currentTimeMillis());
        }

        public void sendMessage() {
            byte[] msg = this.generateMessage();
            this.logger.log("sending message " + msg.length + " " + MathUtils.toBase64(msg));
            if (this.logger.level <= 800) {
                this.logger.log("sending message " + msg.length + " " + MathUtils.toBase64(msg));
            }
            try {
                this.tl.sendMessage(this.dest, ByteBuffer.wrap(msg), new MessageCallback<HandleImpl, ByteBuffer>(){

                    @Override
                    public void sendFailed(MessageRequestHandle<HandleImpl, ByteBuffer> msg, Exception reason) {
                        BogusApp.this.logger.log("sendFailed(" + msg + ")");
                    }

                    @Override
                    public void ack(MessageRequestHandle<HandleImpl, ByteBuffer> msg) {
                        PRRegressionTest.this.alice.logger.log("ack(" + msg + ") " + Thread.currentThread());
                        if (BogusApp.this.logger.level <= 500) {
                            PRRegressionTest.this.alice.logger.log("ack(" + msg + ")");
                        }
                    }
                }, null);
            }
            catch (NullPointerException npe) {
                this.logger.log("tl:" + this.tl + " " + this.dest);
                throw npe;
            }
        }

        protected byte[] generateMessage() {
            byte[] msg = new byte[this.rand.nextInt(31) + 1];
            this.rand.nextBytes(msg);
            return msg;
        }

        @Override
        public void storeCheckpoint(OutputBuffer buffer) throws IOException {
            if (this.logger.level <= 400) {
                this.logger.log("storeCheckpoint " + this.nextSendTime);
            }
            buffer.writeInt(31173);
            buffer.writeLong(this.nextSendTime);
            buffer.writeBoolean(this.dest != null);
            if (this.dest != null) {
                this.dest.serialize(buffer);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ObjectOutputStream(baos).writeObject(this.rand);
            byte[] bytes = baos.toByteArray();
            buffer.writeInt(bytes.length);
            buffer.write(bytes, 0, bytes.length);
            if (this.logger.level <= 300) {
                this.logger.log("storeCheckpoint:" + Arrays.toString(((SimpleOutputBuffer)buffer).getBytes()));
            }
        }

        @Override
        public boolean loadCheckpoint(InputBuffer buffer) throws IOException {
            if (buffer.readInt() != 31173) {
                throw new RuntimeException("invalid checkpoint");
            }
            this.nextSendTime = buffer.readLong();
            if (buffer.readBoolean()) {
                this.dest = new HandleSerializer().deserialize(buffer);
            }
            if (this.logger.level <= 400) {
                this.logger.log("loadCheckpoint " + this.nextSendTime);
            }
            byte[] bytes = new byte[buffer.readInt()];
            buffer.read(bytes);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                this.rand = (Random)new ObjectInputStream(bais).readObject();
            }
            catch (ClassNotFoundException cnfe) {
                IOException ioe = new IOException("Error reading random number from checkpoint");
                ioe.initCause(cnfe);
            }
            if (this.nextSendTime > 0L) {
                this.scheduleMessageToBeSent(this.nextSendTime, true);
            }
            return true;
        }

        @Override
        public void destroy() {
            throw new RuntimeException("implement");
        }

        @Override
        public void notifyCertificateAvailable(IdImpl id) {
            throw new RuntimeException("implement");
        }

        public void receive(HandleImpl source, boolean datagram, ByteBuffer msg) {
            throw new RuntimeException("implement");
        }

        public void sendComplete(long id) {
            throw new RuntimeException("implement");
        }

        @Override
        public void incomingSocket(P2PSocket<HandleImpl> s) throws IOException {
            throw new RuntimeException("implement");
        }

        @Override
        public void messageReceived(HandleImpl i, ByteBuffer m, Map<String, Object> options) throws IOException {
            if (this.logger.level <= 800) {
                this.logger.log("Message received: " + MathUtils.toBase64(m.array()));
            }
        }

        @Override
        public void getWitnesses(IdImpl subject, WitnessListener<HandleImpl, IdImpl> callback) {
            callback.notifyWitnessSet(subject, Collections.singletonList(PRRegressionTest.this.carol.localHandle));
        }

        @Override
        public void notifyStatusChange(IdImpl id, int newStatus) {
            if (this.logger.level <= 800) {
                this.logger.log("notifyStatusChange(" + id + "," + PeerReviewImpl.getStatusString(newStatus) + ")");
            }
            if (newStatus != 0) {
                this.logger.log("Failure, Node not trusted: " + id + " at " + this.player.localHandle);
                System.exit(1);
            }
            PRRegressionTest.this.addStatusNotification(this.player.localHandle, id, newStatus);
        }

        @Override
        public Collection<HandleImpl> getMyWitnessedNodes() {
            return this.player.witnessed;
        }

        @Override
        public PeerReviewCallback<HandleImpl, IdImpl> getReplayInstance(Verifier<HandleImpl> v) {
            BogusApp ret = new BogusApp(PRRegressionTest.this.playerTable.get(v.getLocalIdentifier()), v, v.getEnvironment());
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BogusTransport
    implements TransportLayer<HandleImpl, ByteBuffer> {
        public static Map<HandleImpl, BogusTransport> peerTable = new HashMap<HandleImpl, BogusTransport>();
        HandleImpl localIdentifier;
        Environment env;
        TransportLayerCallback<HandleImpl, ByteBuffer> callback;

        public BogusTransport(HandleImpl handle, X509Certificate cert, Environment env) {
            peerTable.put(handle, this);
            this.localIdentifier = handle;
            this.env = env;
        }

        @Override
        public void acceptMessages(boolean b) {
            throw new RuntimeException("implement");
        }

        @Override
        public void acceptSockets(boolean b) {
            throw new RuntimeException("implement");
        }

        @Override
        public HandleImpl getLocalIdentifier() {
            return this.localIdentifier;
        }

        @Override
        public SocketRequestHandle<HandleImpl> openSocket(HandleImpl i, SocketCallback<HandleImpl> deliverSocketToMe, Map<String, Object> options) {
            throw new RuntimeException("implement");
        }

        @Override
        public MessageRequestHandle<HandleImpl, ByteBuffer> sendMessage(HandleImpl i, ByteBuffer m, MessageCallback<HandleImpl, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
            peerTable.get(i).receiveMessage(this.localIdentifier, m);
            return null;
        }

        private void receiveMessage(final HandleImpl i, final ByteBuffer m) {
            this.env.getSelectorManager().invoke(new Runnable(){

                public void run() {
                    try {
                        BogusTransport.this.callback.messageReceived(i, m, null);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        System.exit(0);
                    }
                }
            });
        }

        @Override
        public void setCallback(TransportLayerCallback<HandleImpl, ByteBuffer> callback) {
            this.callback = callback;
        }

        @Override
        public void setErrorHandler(ErrorHandler<HandleImpl> handler) {
            throw new RuntimeException("implement");
        }

        @Override
        public void destroy() {
            throw new RuntimeException("implement");
        }
    }

    static class IdImpl
    implements RawSerializable {
        int id;

        public IdImpl(int id) {
            this.id = id;
        }

        public void serialize(OutputBuffer buf) throws IOException {
            buf.writeInt(this.id);
        }

        public static IdImpl build(InputBuffer buf) throws IOException {
            return new IdImpl(buf.readInt());
        }

        public String toString() {
            return "Id<" + this.id + ">";
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object o) {
            IdImpl that = (IdImpl)o;
            return this.id == that.id;
        }
    }

    static class HandleImpl
    implements RawSerializable {
        String name;
        IdImpl id;

        public HandleImpl(String s, IdImpl id) {
            this.name = s;
            this.id = id;
        }

        public void serialize(OutputBuffer buf) throws IOException {
            buf.writeUTF(this.name);
            this.id.serialize(buf);
        }

        public static HandleImpl build(InputBuffer buf) throws IOException {
            return new HandleImpl(buf.readUTF(), IdImpl.build(buf));
        }

        public String toString() {
            return "HandleImpl<" + this.name + ">";
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(Object o) {
            HandleImpl that = (HandleImpl)o;
            if (!this.id.equals(that.id)) {
                return false;
            }
            return this.name.equals(that.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IdSerializer
    implements Serializer<IdImpl> {
        IdSerializer() {
        }

        @Override
        public IdImpl deserialize(InputBuffer buf) throws IOException {
            return IdImpl.build(buf);
        }

        @Override
        public void serialize(IdImpl i, OutputBuffer buf) throws IOException {
            i.serialize(buf);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HandleSerializer
    implements Serializer<HandleImpl> {
        HandleSerializer() {
        }

        @Override
        public HandleImpl deserialize(InputBuffer buf) throws IOException {
            return HandleImpl.build(buf);
        }

        @Override
        public void serialize(HandleImpl i, OutputBuffer buf) throws IOException {
            i.serialize(buf);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IdExtractor
    implements IdentifierExtractor<HandleImpl, IdImpl> {
        IdExtractor() {
        }

        @Override
        public IdImpl extractIdentifier(HandleImpl h) {
            return h.id;
        }
    }
}

