/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.peerreview;

import java.net.InetAddress;
import org.mpisws.p2p.testing.transportlayer.peerreview.MyInetSocketAddress;
import org.mpisws.p2p.testing.transportlayer.peerreview.TestAuthenticatorStore;
import org.mpisws.p2p.testing.transportlayer.peerreview.TestPeerReview;
import org.mpisws.p2p.transport.peerreview.commitment.Authenticator;
import org.mpisws.p2p.transport.peerreview.commitment.AuthenticatorSerializerImpl;
import rice.environment.Environment;

public class AuthenticatorStoreTest {
    public static final int HASH_LEN = 20;
    public static final int SIGN_LEN = 28;

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        TestPeerReview pr = new TestPeerReview(env, new AuthenticatorSerializerImpl(20, 28));
        TestAuthenticatorStore store = new TestAuthenticatorStore(pr, false);
        MyInetSocketAddress id = new MyInetSocketAddress(InetAddress.getLocalHost(), 6789);
        byte[] h1 = new byte[20];
        h1[2] = 5;
        byte[] s1 = new byte[28];
        s1[2] = 17;
        Authenticator a1 = new Authenticator(42L, h1, s1);
        byte[] h2 = new byte[20];
        h2[2] = 5;
        byte[] s2 = new byte[28];
        s2[2] = 17;
        Authenticator a2 = new Authenticator(42L, h2, s2);
        byte[] h3 = new byte[20];
        h3[2] = 8;
        byte[] s3 = new byte[28];
        s3[2] = 17;
        Authenticator a3 = new Authenticator(42L, h3, s3);
        store.addAuthenticatorToMemory(id, new Authenticator(4L, h1, s1));
        store.addAuthenticatorToMemory(id, new Authenticator(7L, h1, s1));
        store.addAuthenticatorToMemory(id, new Authenticator(8L, h1, s1));
        store.addAuthenticatorToMemory(id, new Authenticator(9L, h1, s1));
        store.addAuthenticatorToMemory(id, new Authenticator(41L, h1, s1));
        store.addAuthenticatorToMemory(id, new Authenticator(43L, h1, s1));
        store.addAuthenticatorToMemory(id, new Authenticator(53L, h1, s1));
        store.addAuthenticatorToMemory(id, a1);
        store.addAuthenticatorToMemory(id, a2);
        boolean fail = true;
        try {
            store.addAuthenticatorToMemory(id, a3);
            fail = false;
        }
        catch (RuntimeException re) {
            fail = true;
        }
        if (!fail) {
            System.out.println("Allowed Duplicates, BAD!!!!");
            return;
        }
        store.flushAuthenticatorsFromMemory(id, 8L, 42L);
        if (store.findSubject(id).size() != 4) {
            System.out.println("flush failed! " + store.findSubject(id));
        }
        store.flushAuthenticatorsFromMemory(id, 43L, 43L);
        if (store.findSubject(id).size() != 3) {
            System.out.println("flush failed! " + store.findSubject(id));
        }
        System.out.println("success");
        env.destroy();
    }
}

