/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Map;
import org.mpisws.p2p.pki.x509.CAToolImpl;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.ssl.SSLTransportLayerImpl;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import rice.environment.Environment;

public class SSLTest {
    public static void main(String[] args) throws Exception {
        InetAddress addr = InetAddress.getLocalHost();
        Environment rootEnv = new Environment();
        SecureRandom sRandom = new SecureRandom();
        CAToolImpl caTool = CAToolImpl.getCATool("MyCA", "foo".toCharArray());
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGen.initialize(new RSAKeyGenParameterSpec(768, RSAKeyGenParameterSpec.F4), sRandom);
        CAToolImpl bogus = CAToolImpl.getCATool("Bogus", "bar".toCharArray());
        Environment aliceEnv = rootEnv.cloneEnvironment("alice");
        InetSocketAddress aliceAddr = new InetSocketAddress(addr, 9001);
        KeyPair alicePair = keyPairGen.generateKeyPair();
        X509Certificate aliceCert = caTool.sign("alice", alicePair.getPublic());
        KeyStore aliceStore = KeyStore.getInstance("UBER", "BC");
        aliceStore.load(null, null);
        aliceStore.setKeyEntry("private", alicePair.getPrivate(), "".toCharArray(), new Certificate[]{aliceCert});
        aliceStore.setCertificateEntry("cert", caTool.getCertificate());
        WireTransportLayerImpl aliceWire = new WireTransportLayerImpl(aliceAddr, aliceEnv, null);
        SSLTransportLayerImpl<InetSocketAddress, ByteBuffer> aliceSSL = new SSLTransportLayerImpl<InetSocketAddress, ByteBuffer>(aliceWire, aliceStore, aliceStore, aliceEnv);
        Environment bobEnv = rootEnv.cloneEnvironment("bob");
        InetSocketAddress bobAddr = new InetSocketAddress(addr, 9002);
        KeyPair bobPair = keyPairGen.generateKeyPair();
        X509Certificate bobCert = caTool.sign("bob", bobPair.getPublic());
        KeyStore bobStore = KeyStore.getInstance("UBER", "BC");
        bobStore.load(null, null);
        bobStore.setKeyEntry("private", bobPair.getPrivate(), "".toCharArray(), new Certificate[]{bobCert});
        bobStore.setCertificateEntry("cert", caTool.getCertificate());
        WireTransportLayerImpl bobWire = new WireTransportLayerImpl(bobAddr, bobEnv, null);
        SSLTransportLayerImpl<InetSocketAddress, ByteBuffer> bobSSL = new SSLTransportLayerImpl<InetSocketAddress, ByteBuffer>(bobWire, bobStore, bobStore, bobEnv);
        aliceSSL.setCallback(new TransportLayerCallback<InetSocketAddress, ByteBuffer>(){

            @Override
            public void incomingSocket(P2PSocket<InetSocketAddress> s) throws IOException {
                System.out.println("************* Alice: Incoming Socket " + s);
                s.register(true, false, new P2PSocketReceiver<InetSocketAddress>(){
                    ByteBuffer readMe = ByteBuffer.allocate(new String("foo").getBytes().length);

                    @Override
                    public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                        if (canRead) {
                            socket.read(this.readMe);
                            if (this.readMe.hasRemaining()) {
                                socket.register(true, false, this);
                            } else {
                                System.out.println("Alice read: " + new String(this.readMe.array()));
                            }
                        }
                    }

                    @Override
                    public void receiveException(P2PSocket<InetSocketAddress> socket, Exception ioe) {
                        System.out.println("alice: ex:" + ioe);
                    }
                });
            }

            @Override
            public void messageReceived(InetSocketAddress i, ByteBuffer m, Map<String, Object> options) throws IOException {
            }
        });
        bobSSL.openSocket(aliceAddr, new SocketCallback<InetSocketAddress>(){

            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> cancellable, P2PSocket<InetSocketAddress> sock) {
                System.out.println("*************** Bob: Opened Socket " + sock);
                sock.register(false, true, new P2PSocketReceiver<InetSocketAddress>(){
                    ByteBuffer writeMe = ByteBuffer.wrap(new String("foo").getBytes());

                    @Override
                    public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                        socket.write(this.writeMe);
                        if (this.writeMe.hasRemaining()) {
                            socket.register(false, true, this);
                        }
                        System.out.println("done writing");
                    }

                    @Override
                    public void receiveException(P2PSocket<InetSocketAddress> socket, Exception ioe) {
                        System.out.println("bob: ex:" + ioe);
                    }
                });
            }

            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> s, Exception ex) {
                System.out.println("bob2: ex:" + ex);
            }
        }, null);
    }
}

