/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mpisws.p2p.testing.transportlayer.MagicNumberTest;
import org.mpisws.p2p.testing.transportlayer.TLTest;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.liveness.LivenessTransportLayerImpl;
import org.mpisws.p2p.transport.liveness.PingListener;
import org.mpisws.p2p.transport.liveness.Pinger;
import org.mpisws.p2p.transport.multiaddress.MultiInetAddressTransportLayerImpl;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.proximity.MinRTTProximityProvider;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.SourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.SourceRouteTransportLayer;
import org.mpisws.p2p.transport.sourceroute.SourceRouteTransportLayerImpl;
import org.mpisws.p2p.transport.sourceroute.factory.MultiAddressSourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteStrategy;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import org.mpisws.p2p.transport.wire.magicnumber.MagicNumberTransportLayer;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.environment.params.Parameters;
import rice.selector.Timer;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRManagerTest
extends TLTest<MultiInetSocketAddress> {
    public static final byte[] GOOD_HDR = new byte[]{-34, -83, -66, -17};
    static TransportLayer dave;
    static ProximityProvider<SourceRoute<MultiInetSocketAddress>> bob_prox;
    static SourceRouteTransportLayer carol_tap;
    static TransportLayer carol;
    static SourceRouteFactory<MultiInetSocketAddress> srFactory;
    static Timer timer;
    static MultiInetSocketAddress alice_addr;
    static MultiInetSocketAddress bob_addr;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        srFactory = new MultiAddressSourceRouteFactory();
        TLTest.setUpBeforeClass();
        int startPort = 5009;
        logger = env.getLogManager().getLogger(MagicNumberTest.class, null);
        InetAddress addr = InetAddress.getLocalHost();
        Parameters p = env.getParameters();
        timer = env.getSelectorManager().getTimer();
        p.setInt("pastry_socket_scm_num_ping_tries", 2);
        p.setInt("pastry_socket_srm_default_rto", 400);
        p.setInt("pastry_socket_srm_rto_ubound", 500);
        alice = SRManagerTest.buildTL("alice", addr, startPort, env);
        bob = SRManagerTest.buildTL("bob", addr, startPort + 1, env);
        carol = SRManagerTest.buildTL("carol", addr, startPort + 2, env);
        dave = SRManagerTest.buildTL("dave", addr, startPort + 3, env);
    }

    private static TransportLayer buildTL(String name, InetAddress addr, int port, Environment env) throws IOException {
        Environment env_a = new Environment(env.getSelectorManager(), env.getProcessor(), env.getRandomSource(), env.getTimeSource(), ((CloneableLogManager)env.getLogManager()).clone(name), env.getParameters(), env.getExceptionStrategy());
        env.addDestructable(env_a);
        InetSocketAddress addr_a = new InetSocketAddress(addr, port);
        MultiInetAddressTransportLayerImpl myEpochLayer = new MultiInetAddressTransportLayerImpl(new MultiInetSocketAddress(addr_a), new MagicNumberTransportLayer<InetSocketAddress>(new WireTransportLayerImpl(addr_a, env_a, null), env_a, null, GOOD_HDR, 2000), env_a, null, null);
        final MultiInetSocketAddress myAddr = (MultiInetSocketAddress)myEpochLayer.getLocalIdentifier();
        if (name.equals("alice")) {
            alice_addr = myAddr;
        }
        if (name.equals("bob")) {
            bob_addr = myAddr;
        }
        SourceRouteTransportLayerImpl<MultiInetSocketAddress> srtl = new SourceRouteTransportLayerImpl<MultiInetSocketAddress>(srFactory, (TransportLayer)myEpochLayer, null, env_a, null){

            @Override
            public void incomingSocket(P2PSocket<MultiInetSocketAddress> socka) throws IOException {
                if (SRManagerTest.connectionAllowed(myAddr, socka.getIdentifier(), "socket")) {
                    super.incomingSocket(socka);
                }
            }

            @Override
            public void messageReceived(MultiInetSocketAddress i, ByteBuffer m, Map<String, Object> options) throws IOException {
                if (SRManagerTest.connectionAllowed(myAddr, i, "message")) {
                    super.messageReceived(i, m, options);
                }
            }
        };
        if (name.equals("carol")) {
            carol_tap = srtl;
        }
        TestLivenessTransportLayerImpl temp = new TestLivenessTransportLayerImpl((TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer>)srtl, env_a, null);
        MinRTTProximityProvider prox = new MinRTTProximityProvider(temp, env_a);
        if (name.equals("bob")) {
            bob_prox = prox;
        }
        return new SourceRouteManagerImpl<MultiInetSocketAddress>(srFactory, temp, temp, prox, env_a, new TestSRS((MultiInetSocketAddress)((SourceRoute)temp.getLocalIdentifier()).getLastHop()));
    }

    static boolean connectionAllowed(MultiInetSocketAddress a, MultiInetSocketAddress b, String context) {
        if (a.equals(alice_addr) && b.equals(bob_addr)) {
            return false;
        }
        return !b.equals(alice_addr) || !a.equals(bob_addr);
    }

    public static int getDelay(SourceRoute a, SourceRoute b) {
        if (b.getLastHop().equals(bob.getLocalIdentifier()) && b.getFirstHop().equals(alice.getLocalIdentifier())) {
            return 150;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProximity() throws Exception {
        final HashMap pingResponse = new HashMap();
        final Object lock = new Object();
        PingListener<MultiInetSocketAddress> pl = new PingListener<MultiInetSocketAddress>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pingResponse(MultiInetSocketAddress i, int rtt, Map<String, Object> options) {
                Object object = lock;
                synchronized (object) {
                    pingResponse.put(i, new Tupel(i, rtt));
                    lock.notify();
                }
            }

            @Override
            public void pingReceived(MultiInetSocketAddress i, Map<String, Object> options) {
            }
        };
        ((Pinger)((Object)bob)).addPingListener(pl);
        ((ProximityProvider)((Object)bob)).proximity(alice.getLocalIdentifier(), options);
        ((ProximityProvider)((Object)bob)).proximity(carol.getLocalIdentifier(), options);
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (!(env.getTimeSource().currentTimeMillis() >= timeout || pingResponse.containsKey((MultiInetSocketAddress)alice.getLocalIdentifier()) && pingResponse.containsKey((MultiInetSocketAddress)carol.getLocalIdentifier()))) {
                lock.wait(1000L);
            }
        }
        int aliceProx = ((ProximityProvider)((Object)bob)).proximity(alice.getLocalIdentifier(), options);
        int carolProx = ((ProximityProvider)((Object)bob)).proximity(carol.getLocalIdentifier(), options);
        Assert.assertTrue((String)("aliceProx:" + aliceProx + " carolProx:" + carolProx), (aliceProx > carolProx + 100 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiveness() throws Exception {
        LivenessProvider alice = (LivenessProvider)((Object)SRManagerTest.alice);
        MultiInetSocketAddress daveAddress = (MultiInetSocketAddress)dave.getLocalIdentifier();
        final ArrayList tupels = new ArrayList(3);
        final Object lock = new Object();
        alice.addLivenessListener(new LivenessListener<MultiInetSocketAddress>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void livenessChanged(MultiInetSocketAddress i, int val, Map<String, Object> options) {
                Object object = lock;
                synchronized (object) {
                    tupels.add(new Tupel(i, val));
                    lock.notify();
                }
            }
        });
        Assert.assertTrue((alice.getLiveness(daveAddress, null) == 2 ? 1 : 0) != 0);
        long timeout = env.getTimeSource().currentTimeMillis() + 4000L;
        Object object = lock;
        synchronized (object) {
            while (env.getTimeSource().currentTimeMillis() < timeout && tupels.isEmpty()) {
                lock.wait(1000L);
            }
        }
        int result = alice.getLiveness(daveAddress, null);
        Assert.assertTrue((String)("result = " + result), (result == 1 ? 1 : 0) != 0);
        Assert.assertTrue((tupels.size() == 1 ? 1 : 0) != 0);
        dave.destroy();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ie) {
            return;
        }
        Assert.assertTrue((boolean)alice.checkLiveness(daveAddress, null));
        timeout = env.getTimeSource().currentTimeMillis() + 5000L;
        Object object2 = lock;
        synchronized (object2) {
            while (env.getTimeSource().currentTimeMillis() < timeout && tupels.size() <= 2) {
                lock.wait(1000L);
            }
        }
        result = alice.getLiveness(daveAddress, null);
        Assert.assertTrue((String)("result = " + result), (result == 3 ? 1 : 0) != 0);
        Assert.assertTrue((tupels.size() == 3 ? 1 : 0) != 0);
    }

    @Override
    public MultiInetSocketAddress getBogusIdentifier(MultiInetSocketAddress local) throws IOException {
        return new MultiInetSocketAddress(new InetSocketAddress(InetAddress.getLocalHost(), 5007));
    }

    class Tupel {
        MultiInetSocketAddress sr;
        int val;

        public Tupel(MultiInetSocketAddress i, int val) {
            this.sr = i;
            this.val = val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestLivenessTransportLayerImpl
    extends LivenessTransportLayerImpl<SourceRoute<MultiInetSocketAddress>> {
        public TestLivenessTransportLayerImpl(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> tl, Environment env, ErrorHandler<SourceRoute<MultiInetSocketAddress>> errorHandler) {
            super(tl, env, errorHandler, 5000);
        }

        @Override
        public void pong(final SourceRoute<MultiInetSocketAddress> i, final long senderTime, final Map<String, Object> options) {
            this.timer.schedule(new TimerTask(){

                public void run() {
                    TestLivenessTransportLayerImpl.super.pong(i, senderTime, options);
                }
            }, SRManagerTest.getDelay((SourceRoute)this.getLocalIdentifier(), i));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestSRS
    implements SourceRouteStrategy<MultiInetSocketAddress> {
        MultiInetSocketAddress local;

        public TestSRS(MultiInetSocketAddress local) {
            this.local = local;
        }

        @Override
        public Collection<SourceRoute<MultiInetSocketAddress>> getSourceRoutes(MultiInetSocketAddress destination) {
            ArrayList<MultiInetSocketAddress> eList = new ArrayList<MultiInetSocketAddress>();
            eList.add((MultiInetSocketAddress)TLTest.alice.getLocalIdentifier());
            eList.add((MultiInetSocketAddress)TLTest.bob.getLocalIdentifier());
            eList.add((MultiInetSocketAddress)carol.getLocalIdentifier());
            eList.remove(this.local);
            eList.remove(destination);
            ArrayList<SourceRoute<MultiInetSocketAddress>> srList = new ArrayList<SourceRoute<MultiInetSocketAddress>>();
            ArrayList<MultiInetSocketAddress> path = new ArrayList<MultiInetSocketAddress>(2);
            path.add(this.local);
            path.add(destination);
            srList.add(srFactory.getSourceRoute((MultiInetSocketAddress)((Object)path)));
            for (MultiInetSocketAddress eAddr : eList) {
                path = new ArrayList(3);
                path.add(this.local);
                path.add(eAddr);
                path.add(destination);
                srList.add(srFactory.getSourceRoute((MultiInetSocketAddress)((Object)path)));
            }
            return srList;
        }
    }
}

