/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.bandwidthmeasure.BandwidthMeasuringTransportLayer;
import rice.environment.Environment;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.util.tuples.Tuple3;
import rice.pastry.PastryNode;
import rice.pastry.commonapi.PastryEndpoint;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.selector.TimerTask;
import rice.tutorial.transportlayer.BandwidthLimitingTransportLayer;

public class BandwidthMeasuringTLTest
implements Application {
    public void deliver(Id id, Message message) {
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public static void main(String[] args) throws Exception {
        int bindPort = 9001;
        Environment env = new Environment();
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindPort, env){

            @Override
            protected TransportLayer<InetSocketAddress, ByteBuffer> getWireTransportLayer(InetSocketAddress innermostAddress, PastryNode pn) throws IOException {
                TransportLayer<InetSocketAddress, ByteBuffer> wtl = super.getWireTransportLayer(innermostAddress, pn);
                BandwidthLimitingTransportLayer<InetSocketAddress> ret = new BandwidthLimitingTransportLayer<InetSocketAddress>(wtl, 40000, 1000, pn.getEnvironment());
                final BandwidthMeasuringTransportLayer<InetSocketAddress> ret2 = new BandwidthMeasuringTransportLayer<InetSocketAddress>(5000, ret, pn.getEnvironment());
                pn.getEnvironment().getSelectorManager().schedule(new TimerTask(){

                    public void run() {
                        Map map = ret2.getBandwidthUsed();
                        for (InetSocketAddress addr : map.keySet()) {
                            Tuple3<Integer, Integer, Boolean> t = map.get(addr);
                            System.out.println("Bandwidth for " + addr + " d:" + t.a() + " u:" + t.b() + " saturated:" + t.c());
                        }
                    }
                }, 3000L, 3000L);
                return ret2;
            }
        };
        PastryNode node1 = factory.newNode();
        BandwidthMeasuringTLTest app1 = new BandwidthMeasuringTLTest();
        PastryEndpoint ep1 = (PastryEndpoint)node1.buildEndpoint(app1, null);
        ep1.register();
        node1.boot((Object)null);
        PastryNode node2 = factory.newNode();
        BandwidthMeasuringTLTest app2 = new BandwidthMeasuringTLTest();
        PastryEndpoint ep2 = (PastryEndpoint)node2.buildEndpoint(app2, null);
        ep2.register();
        node2.boot(new InetSocketAddress(factory.getBindAddress(), bindPort));
        Thread.sleep(5000L);
        System.out.println("Spamming messages.");
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTime + 5000L) {
            for (int ctr = 0; ctr < 100; ++ctr) {
                ep1.route((Id)node2.getNodeId(), new MyMsg(), null);
            }
            Thread.sleep(10L);
        }
        System.out.println("Done spamming messages.");
    }

    static class MyMsg
    implements Message {
        MyMsg() {
        }

        public int getPriority() {
            return 0;
        }
    }
}

