/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.filetransfer;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.filetransfer.FileReceipt;
import org.mpisws.p2p.filetransfer.FileTransferCallback;
import org.mpisws.p2p.filetransfer.FileTransferImpl;
import org.mpisws.p2p.filetransfer.SimpleFileTransferListener;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessTransportLayerImpl;
import org.mpisws.p2p.transport.rc4.RC4TransportLayer;
import org.mpisws.p2p.transport.simpleidentity.InetSocketAddressSerializer;
import org.mpisws.p2p.transport.simpleidentity.SimpleIdentityTransportLayer;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.pastry.transport.SocketAdapter;

public class EncryptedFileTest {
    public static void main(String[] args) throws Exception {
        final Environment env = new Environment();
        InetAddress local = InetAddress.getLocalHost();
        final Logger logger = env.getLogManager().getLogger(EncryptedFileTest.class, null);
        DefaultErrorHandler<InetSocketAddress> errorHandler = new DefaultErrorHandler<InetSocketAddress>(logger);
        logger.log("Encrypted Test");
        InetSocketAddress addr1 = new InetSocketAddress(local, 9001);
        WireTransportLayerImpl wtl1 = new WireTransportLayerImpl(addr1, env, errorHandler);
        SimpleIdentityTransportLayer<InetSocketAddress, ByteBuffer> idtl1 = new SimpleIdentityTransportLayer<InetSocketAddress, ByteBuffer>(wtl1, new InetSocketAddressSerializer(), null, env, errorHandler);
        LivenessTransportLayerImpl<InetSocketAddress> ltl1 = new LivenessTransportLayerImpl<InetSocketAddress>(idtl1, env, errorHandler, 300000);
        ltl1.addLivenessListener(new LivenessListener<InetSocketAddress>(){

            @Override
            public void livenessChanged(InetSocketAddress i, int val, Map<String, Object> options) {
                logger.log("Node1: livenessChanged(" + i + "," + val + "," + options + ")");
            }
        });
        RC4TransportLayer<InetSocketAddress, ByteBuffer> etl1 = new RC4TransportLayer<InetSocketAddress, ByteBuffer>(ltl1, env, "badpassword", errorHandler);
        etl1.setCallback(new TransportLayerCallback<InetSocketAddress, ByteBuffer>(){

            @Override
            public void messageReceived(InetSocketAddress i, ByteBuffer m, Map<String, Object> options) throws IOException {
            }

            @Override
            public void incomingSocket(P2PSocket<InetSocketAddress> s) throws IOException {
                logger.log("incomingSocket(" + s + ")");
                SocketAdapter<InetSocketAddress> sock = new SocketAdapter<InetSocketAddress>(s, env);
                FileTransferImpl ft = new FileTransferImpl(sock, new FileTransferCallback(){

                    public void messageReceived(ByteBuffer bb) {
                    }

                    public void fileReceived(File f, ByteBuffer metadata) {
                        try {
                            String name = new SimpleInputBuffer(metadata).readUTF();
                            logger.log("file received " + f + " named:" + name + " size:" + f.length());
                        }
                        catch (IOException ioe) {
                            logger.logException("Error interpreting filename ", ioe);
                        }
                    }

                    public void receiveException(Exception ioe) {
                        logger.logException("Receiver FTC.receiveException()", ioe);
                    }
                }, env);
                ft.addListener(new SimpleFileTransferListener("Receiver"){

                    public void fileTransferred(FileReceipt receipt, long bytesTransferred, long total, boolean incoming) {
                        super.fileTransferred(receipt, bytesTransferred, total, incoming);
                    }
                });
            }
        });
        InetSocketAddress addr2 = new InetSocketAddress(local, 9002);
        WireTransportLayerImpl wtl2 = new WireTransportLayerImpl(addr2, env, errorHandler);
        SimpleIdentityTransportLayer<InetSocketAddress, ByteBuffer> idtl2 = new SimpleIdentityTransportLayer<InetSocketAddress, ByteBuffer>(wtl2, new InetSocketAddressSerializer(), null, env, errorHandler);
        LivenessTransportLayerImpl<InetSocketAddress> ltl2 = new LivenessTransportLayerImpl<InetSocketAddress>(idtl2, env, errorHandler, 300000);
        ltl2.addLivenessListener(new LivenessListener<InetSocketAddress>(){

            @Override
            public void livenessChanged(InetSocketAddress i, int val, Map<String, Object> options) {
                logger.log("Node2: livenessChanged(" + i + "," + val + "," + options + ")");
            }
        });
        ltl2.checkLiveness(addr1, null);
        RC4TransportLayer etl2 = new RC4TransportLayer(ltl2, env, "badpassword", errorHandler);
        etl2.openSocket(addr1, new SocketCallback<InetSocketAddress>(){

            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> cancellable, P2PSocket<InetSocketAddress> s) {
                logger.log("opened Socket " + s);
                SocketAdapter<InetSocketAddress> sock = new SocketAdapter<InetSocketAddress>(s, env);
                FileTransferImpl ft = new FileTransferImpl(sock, new FileTransferCallback(){

                    public void messageReceived(ByteBuffer bb) {
                    }

                    public void fileReceived(File f, ByteBuffer metadata) {
                    }

                    public void receiveException(Exception ioe) {
                        logger.logException("Sender FTC.receiveException()", ioe);
                    }
                }, env);
                ft.addListener(new SimpleFileTransferListener("Sender"){

                    public void fileTransferred(FileReceipt receipt, long bytesTransferred, long total, boolean incoming) {
                        super.fileTransferred(receipt, bytesTransferred, total, incoming);
                    }
                });
                try {
                    SimpleOutputBuffer sob = new SimpleOutputBuffer();
                    sob.writeUTF("foo");
                    ft.sendFile(new File("delme.txt"), sob.getByteBuffer(), (byte)0, new Continuation<FileReceipt, Exception>(){

                        @Override
                        public void receiveResult(FileReceipt result) {
                            System.out.println("Send success " + result);
                        }

                        @Override
                        public void receiveException(Exception exception) {
                            System.out.println("Send Failed");
                        }
                    });
                }
                catch (IOException ioe) {
                    logger.logException("Error sending file.", ioe);
                }
            }

            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> s, Exception ex) {
                logger.logException("receiveException(" + s + ")", ex);
            }
        }, null);
    }
}

