/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.pki.x509;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;
import org.mpisws.p2p.pki.x509.CATool;
import org.mpisws.p2p.pki.x509.X509SerializerImpl;
import rice.environment.Environment;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.p2p.util.tuples.Tuple;
import rice.pastry.Id;
import rice.pastry.standard.RandomNodeIdFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CAToolImpl
implements CATool {
    static SecureRandom random;
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA1withRSA";
    X509Certificate cert;
    KeyPair keyPair;
    public static final String CA_STORE_PRIVATE = "private";
    public static final String CA_STORE_PUBLIC = "public";
    public static final String CA_STORE_CERT = "cert";

    public CAToolImpl(X509Certificate cert, KeyPair caPair) {
        this.cert = cert;
        this.keyPair = caPair;
    }

    @Override
    public X509Certificate getCertificate() {
        return this.cert;
    }

    public static CAToolImpl getCATool(String CN, char[] pw) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, InvalidKeyException, IllegalStateException, SignatureException, InvalidAlgorithmParameterException {
        X509Certificate caCert;
        KeyPair caPair;
        File caStoreFile = new File(CN + "-store");
        if (caStoreFile.exists()) {
            KeyStore store = KeyStore.getInstance("UBER", "BC");
            try {
                store.load(new FileInputStream(caStoreFile), pw);
            }
            catch (EOFException eof) {
                throw new RuntimeException("Invalid password for " + caStoreFile);
            }
            PublicKey pub = (PublicKey)store.getKey(CA_STORE_PUBLIC, null);
            PrivateKey priv = (PrivateKey)store.getKey(CA_STORE_PRIVATE, null);
            caPair = new KeyPair(pub, priv);
            caCert = (X509Certificate)store.getCertificate(CA_STORE_CERT);
        } else {
            Date exp = new Date();
            exp.setYear(exp.getYear() + 10);
            Tuple<X509Certificate, KeyPair> t = CAToolImpl.generateNewCA(CN, exp);
            caCert = t.a();
            caPair = t.b();
            Certificate[] chain = new Certificate[]{caCert};
            System.out.println(caCert);
            KeyStore store = KeyStore.getInstance("UBER", "BC");
            store.load(null, null);
            store.setKeyEntry(CA_STORE_PRIVATE, caPair.getPrivate(), null, chain);
            store.setKeyEntry(CA_STORE_PUBLIC, caPair.getPublic(), null, null);
            store.setCertificateEntry(CA_STORE_CERT, caCert);
            store.store(new FileOutputStream(CN + "-store"), pw);
        }
        return new CAToolImpl(caCert, caPair);
    }

    public static Tuple<X509Certificate, KeyPair> generateNewCA(String CN, Date expiryDate) throws CertificateEncodingException, InvalidKeyException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGen.initialize(new RSAKeyGenParameterSpec(768, RSAKeyGenParameterSpec.F4), random);
        KeyPair caPair = keyPairGen.generateKeyPair();
        X509Certificate cert = CAToolImpl.generateNewCA(CN, new Date(), expiryDate, 1L, caPair, DEFAULT_SIGNATURE_ALGORITHM);
        return new Tuple<X509Certificate, KeyPair>(cert, caPair);
    }

    public static X509Certificate generateNewCA(String CN, Date startDate, Date expiryDate, long serialNumber, KeyPair keyPair, String signatureAlgorithm) throws CertificateEncodingException, InvalidKeyException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        X500Principal dnName = new X500Principal("CN=" + CN);
        certGen.setSerialNumber(BigInteger.valueOf(serialNumber));
        certGen.setIssuerDN(dnName);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(expiryDate);
        certGen.setSubjectDN(dnName);
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm(signatureAlgorithm);
        X509Certificate cert = certGen.generate(keyPair.getPrivate(), "BC");
        return cert;
    }

    @Override
    public X509Certificate sign(String CN, PublicKey key) throws CertificateParsingException, CertificateEncodingException, InvalidKeyException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        Date exp = new Date();
        exp.setYear(exp.getYear() + 1);
        return this.sign(CN, key, exp, System.currentTimeMillis());
    }

    public static X509Certificate sign(String CN, PublicKey publicKey, Date expiryDate, long serialNumber, X509Certificate caCert, KeyPair caPair) throws CertificateParsingException, CertificateEncodingException, InvalidKeyException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        X500Principal subjectName = new X500Principal("CN=" + CN);
        certGen.setSerialNumber(BigInteger.valueOf(serialNumber));
        certGen.setIssuerDN(caCert.getSubjectX500Principal());
        certGen.setNotBefore(new Date());
        certGen.setNotAfter(expiryDate);
        certGen.setSubjectDN(subjectName);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm(DEFAULT_SIGNATURE_ALGORITHM);
        certGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(caCert));
        certGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(publicKey));
        X509Certificate cert = certGen.generate(caPair.getPrivate(), "BC");
        return cert;
    }

    @Override
    public X509Certificate sign(String CN, PublicKey publicKey, Date expiryDate, long serialNumber) throws CertificateParsingException, CertificateEncodingException, InvalidKeyException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        return CAToolImpl.sign(CN, publicKey, expiryDate, serialNumber, this.cert, this.keyPair);
    }

    public static void main(String[] args) throws Exception {
        char[] pw = new char[]{};
        String caName = "MyCA";
        String CN = null;
        for (int c = 0; c < args.length; ++c) {
            if (args[c].equalsIgnoreCase("-p")) {
                pw = args[c + 1].toCharArray();
                continue;
            }
            if (args[c].equalsIgnoreCase("-ca")) {
                caName = args[c + 1];
                continue;
            }
            if (!args[c].equalsIgnoreCase("-cn")) continue;
            CN = args[c + 1];
        }
        if (CN == null) {
            Id id = new RandomNodeIdFactory(new Environment()).generateNodeId();
            CN = id.toStringFull();
        }
        CAToolImpl caTool = CAToolImpl.getCATool(caName, pw);
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGen.initialize(new RSAKeyGenParameterSpec(768, RSAKeyGenParameterSpec.F4), random);
        KeyPair pair = keyPairGen.generateKeyPair();
        X509Certificate cert = caTool.sign(CN, pair.getPublic());
        System.out.println("Cert Type:" + cert.getType() + " len:" + cert.getEncoded().length);
        X509SerializerImpl serializer = new X509SerializerImpl();
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        serializer.serialize(caTool.getCertificate(), (OutputBuffer)sob);
        SimpleInputBuffer sib = new SimpleInputBuffer(sob.getBytes());
        X509Certificate caCert = (X509Certificate)serializer.deserialize(sib);
        cert.verify(caCert.getPublicKey());
        System.out.println("cert verified.");
        System.out.println(caCert);
        System.out.println(cert);
        System.out.println(pair.getPublic().getFormat() + " " + pair.getPublic().getAlgorithm());
        System.out.println(pair.getPrivate().getFormat() + " " + pair.getPrivate().getAlgorithm());
        Signature signer = Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM, "BC");
        signer.initSign(pair.getPrivate());
        byte[] msg = new byte[400];
        random.nextBytes(msg);
        signer.update(msg);
        byte[] signature = signer.sign();
        System.out.println(signer);
        System.out.println("Signature length:" + signature.length);
        Signature verifier = Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM, "BC");
        verifier.initVerify(cert);
        verifier.update(msg);
        System.out.println("verified:" + verifier.verify(signature));
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(new RSAKeyGenParameterSpec(768, RSAKeyGenParameterSpec.F4), random);
        KeyPair bogusPair = kpg.generateKeyPair();
        try {
            cert.verify(bogusPair.getPublic());
            System.out.println("WARNING!  Bogus key verified!!!");
        }
        catch (InvalidKeyException se) {
            System.out.println("bogus didn't verify.");
        }
        Signature bogusVerifier = Signature.getInstance(DEFAULT_SIGNATURE_ALGORITHM, "BC");
        bogusVerifier.initVerify(bogusPair.getPublic());
        bogusVerifier.update(msg);
        System.out.println("bogus verify: " + bogusVerifier.verify(signature));
        verifier.update(msg);
        System.out.println("verified 2:" + verifier.verify(signature));
        msg[0] = (byte)(msg[0] + 1);
        verifier.update(msg);
        System.out.println("verified (should fail):" + verifier.verify(signature));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        random = new SecureRandom();
    }
}

