/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.rawserialization;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.rawserialization.MyApp;

public class DistTutorial {
    Vector apps = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistTutorial(int bindport, InetSocketAddress bootaddress, int numNodes, Environment env) throws Exception {
        PastryNode node;
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            NodeHandle bootHandle = factory.getNodeHandle(bootaddress);
            PastryNode pastryNode = node = ((PastryNodeFactory)factory).newNode(bootHandle);
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node " + node);
            MyApp app = new MyApp(node);
            this.apps.add(app);
        }
        env.getTimeSource().sleep(10000L);
        for (int i = 0; i < 10; ++i) {
            for (MyApp app : this.apps) {
                Id randId = nidFactory.generateNodeId();
                app.routeMyMsg(randId);
                env.getTimeSource().sleep(100L);
            }
        }
        env.getTimeSource().sleep(1000L);
        for (MyApp app : this.apps) {
            node = (PastryNode)app.getNode();
            LeafSet leafSet = node.getLeafSet();
            for (int i = -leafSet.ccwSize(); i <= leafSet.cwSize(); ++i) {
                if (i == 0) continue;
                NodeHandle nh = leafSet.get(i);
                app.routeMyMsgDirect(nh);
                env.getTimeSource().sleep(100L);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        env.getParameters().setString("nat_search_policy", "never");
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            int numNodes = Integer.parseInt(args[3]);
            DistTutorial dt = new DistTutorial(bindport, bootaddress, numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson4.DistTutorial localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }
}

