/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.lookup;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.NodeHandleSet;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.tutorial.lookup.LookupService;

public class LookupServiceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupServiceTest(int bindport, InetSocketAddress bootaddress, int numNodes, Environment env) throws Exception {
        ArrayList<LookupService> lookups = new ArrayList<LookupService>();
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            PastryNode node;
            NodeHandle bootHandle = factory.getNodeHandle(bootaddress);
            PastryNode pastryNode = node = ((PastryNodeFactory)factory).newNode(bootHandle);
            synchronized (pastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node " + node);
            LookupService ls = new LookupService(node);
            lookups.add(ls);
        }
        env.getTimeSource().sleep(10000L);
        for (LookupService ls : lookups) {
            final Id id = nidFactory.generateNodeId();
            System.out.println("Requesting id " + id);
            ls.requestNodeHandles(id, 3, new Continuation<NodeHandleSet, Exception>(){

                @Override
                public void receiveException(Exception exception) {
                    if (exception instanceof LookupService.NodeLookupTimeoutException) {
                        System.out.println("Request for " + id + " timed out");
                    } else {
                        System.out.println("Exception requesting " + id + ": " + exception.getMessage());
                        exception.printStackTrace();
                    }
                }

                @Override
                public void receiveResult(NodeHandleSet result) {
                    System.out.println("ReplicaSet for " + id + ": " + result);
                }
            });
        }
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        env.getParameters().setString("nat_search_policy", "never");
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            int numNodes = Integer.parseInt(args[3]);
            LookupServiceTest lt = new LookupServiceTest(bindport, bootaddress, numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lookup.LookupServiceTest localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.lookup.LookupServiceTest 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }
}

